#!/bin/bash

eth0_hwaddr="000102030405"
eth0_ip="192.168.100.100"
eth0_nm="255.255.255.0"
eth0_gw="192.168.100.1"


mkdir -p /mnt/mmcblk0p3
mount /dev/mmcblk0p3 /mnt/mmcblk0p3
mkdir -p /mnt/mmcblk0p3/log
mkdir -p /mnt/mmcblk0p3/tmp
#ln -s /mnt/mmcblk0p3/log /var/log 

if [ -f /mnt/syscfg/eth0_mac.conf ] ; then
    eth0_hwaddr=`cat /mnt/syscfg/eth0_mac.conf`
fi

if [ -f /mnt/usrcfg/mgmt.ip.conf ] ; then
    eth0_ip=`grep ip /mnt/usrcfg/mgmt.ip.conf | cut -d" " -f2`
    eth0_nm=`grep nm /mnt/usrcfg/mgmt.ip.conf | cut -d" " -f2`
    eth0_gw=`grep gw /mnt/usrcfg/mgmt.ip.conf | cut -d" " -f2`
fi

case "$1" in
  start)
    echo "Trango PXG2 Startup Code"
    echo 1 > /proc/sys/net/ipv4/ip_no_pmtu_disc
    echo 0 > /proc/sys/kernel/sysrq

    mkdir -p /mnt/rd
    chmod 777 /mnt/rd
    mount -t tmpfs -o size=512M tmpfs /mnt/rd

    mkdir -p /debugfs
    mount -t debugfs debugfs /debugfs
    cd /debugfs/omap_mux/

    #A_820_PS_CNTR- NOW eMMC_RST- Initialize as low- bring high to reset eMMC
    echo 0x07 > xdma_event_intr1
    echo 20 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio20/direction
    echo 0 > /sys/class/gpio/gpio20/value

    #B_820_PS_CNTR- NOW DSP0_INT - Redefine as input
    echo 0x07 > gpmc_ben0_cle
    echo 69 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio69/direction
    #echo 1 > /sys/class/gpio/gpio69/value

    #INTA interrupt signal from I/O expander - NO Change
    echo 0x37 > lcd_ac_bias_en
    echo 89 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio89/direction

    #INTB interrupt signal from I/O expander for 1+1 - NEW previously unused pin
    echo 0x37 > mcasp0_axr1
    echo 116 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio116/direction

    ## ETH0 INTF 0 = OBM. 1 = IBM - NOW uses GPIO0_22 old pin GPIO1_2 is now eMMC
    echo 0x17 > gpmc_ad8
    echo 22 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio22/direction
    echo 1 > /sys/class/gpio/gpio22/value

    ## ETH0 RST gpio2_4 - NO Change
    echo 0x17 > gpmc_wen
    echo 68 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio68/direction
    echo 1 > /sys/class/gpio/gpio68/value

    ## uart 3 1+1 - NO Change but now is used for ODU2 Telem
    echo 0x19 > ecap0_in_pwm0_out
    echo 0x29 > spi0_cs1

    ## TX uart2 - No Change - Used for Switch communication
    echo 0x19 > spi0_d0

    ## RX uart2- No Change - Used for Switch communication
    echo 0x29 > spi0_sclk

    ## uart 5 FPGA- NEW- Used the old GPIO2_14 and 15- Using mode 4
    echo 0x1c > lcd_data8
    echo 0x2c > lcd_data9

    ## USB RST gpio2_10 - NOT used any longer- Looks like was never used
    echo 0x2f > lcd_data4
    echo 74 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio74/direction
    echo 1 > /sys/class/gpio/gpio74/value

    ## mode pushbutton-sw - MODE_SW1 -GPIO2_22 NO Change
    echo 0x37 > lcd_vsync
    echo 86 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio86/direction

    ## mode pushbutton-A - MODE_SW2 -GPIO2_1 NO Change
    echo 0x37 > gpmc_clk
    echo 65 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio65/direction

    ## mode MODEM_HOST_INT-GPIO0_23 NO Change
    echo 0x37 > gpmc_ad9
    echo 23 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio23/direction

    ## mode MODEM_AIR LOSS GPIO0_27 NO Change
    echo 0x37 > gpmc_ad11
    echo 27 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio27/direction

    ## Vitess Reset this pin - GPIO2_2 - No change Rev1 - On Rev 2 Board not used
    echo 0x17 > gpmc_advn_ale
    /etc/init.d/check_switch_status.exp
#    echo 66 > /sys/class/gpio/export
#    echo "out" > /sys/class/gpio/gpio66/direction
#    echo 0 > /sys/class/gpio/gpio66/value
#    sleep 1
#    echo 1 > /sys/class/gpio/gpio66/value

    ## Volt-48 threshold interrupt - NOW using GPIO1_15 Was GPIO1_3 now eMMC
    echo 0x37 > gpmc_ad15
    echo 47 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio47/direction

    ## FPGA JTAG pin configuration - NO Change
    echo 0x37 > gpmc_csn3
    echo 0x0f > lcd_data11
    echo 0x0f > lcd_data14
    echo 0x0f > lcd_data0
    echo 0x0f > lcd_data1
    echo 0x0f > gpmc_ad14

    echo 64 > /sys/class/gpio/export
    echo 46 > /sys/class/gpio/export
    echo 81 > /sys/class/gpio/export
    echo 10 > /sys/class/gpio/export
    echo 70 > /sys/class/gpio/export
    echo 71 > /sys/class/gpio/export

    echo "out" > /sys/class/gpio/gpio64/direction
    echo 1 > /sys/class/gpio/gpio32/value

    echo "in" > /sys/class/gpio/gpio46/direction
    echo "in" > /sys/class/gpio/gpio81/direction
    echo "in" > /sys/class/gpio/gpio10/direction
    echo "in" > /sys/class/gpio/gpio70/direction
    echo "in" > /sys/class/gpio/gpio71/direction

    ## 1+1 Signaling thru GPIO3_15(I) and GPIO3_16(O)- NOW KAIN and KAOut
    ## Moved pins to GPIO3_19(I)-mcasp0_fsr and GPIO3_21(O)-mcasp0_ahclkx
    echo 0x37 > mcasp0_fsr
    echo 0x17 > mcasp0_ahclkx

    echo 117 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio117/direction
    echo 1 > /sys/class/gpio/gpio117/value

    echo 115 > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio115/direction

    ## Set up ODU 1 and 2 output/opmode controls - NEW
    ## Initialize to 0 for all (off)
    echo 0x17 > mcasp0_aclkx
    echo 0x17 > mcasp0fsk
    echo 0x17 > mcasp0_axr0
    echo 0x17 > mcasp0_ahclkr

    echo 110 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio110/direction
    echo 0 > /sys/class/gpio/gpio110/value

    echo 111 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio111/direction
    echo 0 > /sys/class/gpio/gpio111/value

    echo 112 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio112/direction
    echo 0 > /sys/class/gpio/gpio112/value

    echo 113 > /sys/class/gpio/export
    echo "out" > /sys/class/gpio/gpio113/direction
    echo 0 > /sys/class/gpio/gpio113/value

    ## Initialize SPI1 - Pins changed from previous system

    ifconfig eth0 $eth0_ip netmask $eth0_nm hw ether $eth0_hwaddr up
    sleep 2

    # Configure UART5 115200 N 8 1  -NEW
    stty -F /dev/ttyO5 115200 cs8 raw
    #stty -F /dev/ttyO5 57600 cs8 raw

    cd /root/drivers
    insmod memdrv.ko
    insmod glbmutex.ko
    insmod phyacc.ko
    insmod ipc.ko
    insmod irq.ko

    ## OBM eth0 clocking accuracy on speed 100Mbps
    cd /root/dbg
    ./mdio 0 18 f387
    ./mdio 0 1c 8e00

    ./gpio dat 2 0 in

    ifconfig eth1 up
    sleep 2
    ifconfig eth1 172.16.1.10 netmask 255.255.255.128

    /usr/sbin/atftpd --daemon --bind-address 172.16.1.10 /tftpboot
    service isc-dhcp-server start

    ## setup DNS mapping
    cp /etc/init.d/nameserver /etc/resolv.conf

    if [ -f /mnt/usrcfg/hostname ] ; then
      cp /mnt/usrcfg/hostname /etc/hostname
    fi

    ## Updating the application with latest version from /root/apps/
    cp /root/apps/snmpd /usr/sbin/snmpd
    cp /root/apps/zebra /usr/sbin/zebra
    cp /root/apps/lighttpd /usr/sbin/lighttpd
    cp /root/apps/php-cgi /usr/sbin/php-cgi

    #/usr/bin/ntp_time &
    sleep 20
    /usr/sbin/zebra.sh &

    /usr/sbin/crond
    ;;
  stop)
    sleep 2
    echo "Stopping Trango PXG2 services and cleaning up..."

    # Killing background processes started during 'start'
    for process in snmpd zebra lighttpd php-cgi syslogd atftpd; do
        if pgrep -x "$process" > /dev/null; then
            killall -9 $process
            echo "$process stopped."
        else
            echo "$process is not running."
        fi
    done

    if pgrep -x "dhcpd" > /dev/null; then
        service isc-dhcp-server stop
    else
        echo "ISC DHCP server is not running."
    fi

    # Unmount file systems and clean up directories
    if mountpoint -q /mnt/rd; then
        umount /mnt/rd
        echo "/mnt/rd unmounted."
    else
        echo "/mnt/rd is not mounted."
    fi

    if mountpoint -q /debugfs; then
        umount /debugfs
        echo "/debugfs unmounted."
    else
        echo "/debugfs is not mounted."
    fi

    # Unexport GPIOs
    for gpio in 10 20 22 23 27 46 47 64 65 66 68 69 70 71 74 81 86 89 110 111 112 113 115 116 117; do
        if [ -d /sys/class/gpio/gpio$gpio ]; then
            echo $gpio > /sys/class/gpio/unexport
            echo "GPIO $gpio unexported."
        else
            echo "GPIO $gpio is not exported."
        fi
    done

    echo "Trango PXG2 services stopped."
    ;;
  *)
    echo "Usage: /etc/init.d/trango_startup.sh {start|stop}"
    exit 1
    ;;
esac

exit 0
