#!/bin/sh
### BEGIN INIT INFO
# Provides:          bootmisc
# Required-Start:    $remote_fs
# Required-Stop:
# Should-Start:      udev
# Default-Start:     S
# Default-Stop:
# Short-Description: Miscellaneous things to be done during bootup.
# Description:       Some cleanup.  Note, it need to run after mountnfs-bootclean.sh.
### END INIT INFO

PATH=/sbin:/usr/sbin:/bin:/usr/bin
[ "$DELAYLOGIN" ] || DELAYLOGIN=yes
. /lib/init/vars.sh

do_start () {
	#
	# If login delaying is enabled then create the flag file
	# which prevents logins before startup is complete
	#
	case "$DELAYLOGIN" in
	  Y*|y*)
		echo "System bootup in progress - please wait" > /var/lib/initscripts/nologin
		;;
	esac

	# Create /var/run/utmp so we can login.
	: > /var/run/utmp
	if grep -q ^utmp: /etc/group
	then
		chmod 664 /var/run/utmp
		chgrp utmp /var/run/utmp
	fi

	# Set pseudo-terminal access permissions.
	if [ ! -e /dev/.udev ] && [ -c /dev/ttyp0 ]
	then
		chmod -f 666 /dev/tty[p-za-e][0-9a-f]
		chown -f root:tty /dev/tty[p-za-e][0-9a-f]
	fi

	# Mount /tmp as tmpfs if not already
	echo "Ensuring /tmp is mounted as tmpfs..."
	 mkdir -p /tmp
	chmod 1777 /tmp
	if ! mount | grep -q "on /tmp type tmpfs"; then
		mount -t tmpfs -o nosuid,nodev,size=60M tmpfs /tmp
	fi
	# Remove bootclean's flag files.
	# Don't run bootclean again after this!
	rm -f /tmp/.clean /var/run/.clean /var/lock/.clean
}

case "$1" in
  start|"")
	do_start
	;;
  restart|reload|force-reload)
	echo "Error: argument '$1' not supported" >&2
	exit 3
	;;
  stop)
	# No-op
	;;
  *)
	echo "Usage: bootmisc.sh [start|stop]" >&2
	exit 3
	;;
esac

:
