<script>

    let chartRSSI_MSE;

    <?php $raw_data = CustomDataRetrieval::getHistoricalValues($what, $when); ?>

    function createChartRSSI_MSE(idx) {
        return Highcharts.chart('js-highcharts-container-historical-' + idx, {
            tooltip: {
                split: false,
                shared: true,
                useHTML: true
            },
            chart: {
                type: 'spline'
            },
            xAxis: {
                type: 'datetime',
                title: {
                    text: 'Date'
                }
            },
            yAxis: {
                minPadding: 0.2,
                maxPadding: 0.2,
                title: {
                    text: 'RSSI/MSE',
                    margin: 80
                }
            },
            title: {
                text: 'RSSI/MSE'
            },
            series: [

                <?php if ($number_of_channels == 1): ?>
                {
                    name: 'RSSI',
                    color: '#0b0863',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'RSSI_1', 'rssi_mse_rules_1'); ?>]
                }, {
                    name: 'MSE',
                    color: '#ffa052',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'MSE_1', 'rssi_mse_rules_1'); ?>]
                }
                <?php else: ?>
                {
                    name: 'RSSI1',
                    color: '#0b0863',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'RSSI_1', 'rssi_mse_rules_1'); ?>]
                }, {
                    name: 'MSE1',
                    color: '#ffa052',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'MSE_1', 'rssi_mse_rules_1'); ?>]
                },
                {
                    name: 'RSSI2',
                    color: '#3c7320',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'RSSI_2', 'rssi_mse_rules_1'); ?>]
                }, {
                    name: 'MSE2',
                    color: '#560c88',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'MSE_2', 'rssi_mse_rules_1'); ?>]
                }
                <?php endif; ?>
            ]
        });
    }

    function doHistoricalPlotInit(idx) {
        chartRSSI_MSE = createChartRSSI_MSE(idx);
    }
</script>
