<script>

    let chartRFCapacity;

    <?php $raw_data = CustomDataRetrieval::getHistoricalValues($what, $when); ?>

    function createChartRFCapacity(idx) {
        return Highcharts.chart('js-highcharts-container-historical-' + idx, {
            tooltip: {
                split: false,
                shared: true,
                useHTML: true
            },
            chart: {
                type: 'spline'
            },
            xAxis: {
                type: 'datetime',
                title: {
                    text: 'Date'
                }
            },
            yAxis: {
                minPadding: 0.2,
                maxPadding: 0.2,
                title: {
                    text: 'RF Port Rate',
                    margin: 80
                }
            },
            title: {
                text: 'RF Port Rate'
            },
            series: [{
                name: 'IN (Mbps)',
                color: '#0b0863',
                data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'RFin'); ?>]
            }, {
                name: 'OUT (Mbps)',
                color: '#ffa052',
                data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'RFout'); ?>]
            }]
        });
    }

    function doHistoricalPlotInit(idx) {
        chartRFCapacity = createChartRFCapacity(idx);
    }
</script>
