<?php $raw_data = CustomDataRetrieval::getHistoricalValues($what, $when); ?>
<script>

    let chartModulation;

    let labelsY = <?php echo json_encode_replacement(CustomDataRetrieval::getModulationMappings()); ?>;
    labelsY.push(" ");
    labelsY.push("  ");
    labelsY.push("   ");
    labelsY.push("    ");
    labelsY.push("     ");

    function createChartModulation(idx) {
        return Highcharts.chart('js-highcharts-container-historical-' + idx, {
            tooltip: {
                split: false,
                shared: true,
                useHTML: true,
                formatter: function () {
                    let formatStr = "<b>Modulation</b><br>";
                    for (let i = 0; i < this.points.length; i++) {
                        let point = this.points[i];
                        let x = labelsY[point.y];
                        if (!x) {
                            x = 'N/A';
                        }
                        formatStr += '<span style="color:' + point.color + '">●</span> ' + point.series.name + ': ' + x +  '<br>';
                    }

                    return formatStr;
                },
            },
            chart: {
                type: 'spline'
            },
            xAxis: {
                type: 'datetime',
                title: {
                    text: 'Date'
                }
            },
            yAxis: {
                minPadding: 0.2,
                maxPadding: 0.2,
                title: {
                    text: 'Modulation',
                    margin: 80
                },
                labels: {
                    formatter: function () {
                        let x = labelsY[this.value];
                        if (!x) {
                            return 'N/A';
                        }
                        return x;
                    }
                },
                tickInterval: 1
            },
            title: {
                text: 'Modulation'
            },
            series: [
                <?php if ($number_of_channels == 1): ?>
                {
                    name: 'RX',
                    color: '#0b0863',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'ModRX_1', 'modulation_rules_1'); ?>]
                }, {
                    name: 'TX',
                    color: '#ffa052',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'ModTX_1', 'modulation_rules_1'); ?>]
                }
                <?php else: ?>
                {
                    name: 'RX1',
                    color: '#0b0863',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'ModRX_1', 'modulation_rules_1'); ?>]
                }, {
                    name: 'TX1',
                    color: '#ffa052',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'ModTX_1', 'modulation_rules_1'); ?>]
                },
                {
                    name: 'RX2',
                    color: '#3c7320',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'ModRX_2', 'modulation_rules_1'); ?>]
                }, {
                    name: 'TX2',
                    color: '#560c88',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'ModTX_2', 'modulation_rules_1'); ?>]
                }
                <?php endif; ?>
            ]
        });
    }

    function doHistoricalPlotInit(idx) {
        chartModulation = createChartModulation(idx);
    }
</script>
