<?php $raw_data = CustomDataRetrieval::getHistoricalValues($what, $when); ?>
<script>

    let chartErrors;

    function createChartErrors(idx) {
        return Highcharts.chart('js-highcharts-container-historical-' + idx, {
            tooltip: {
                split: false,
                shared: true,
                useHTML: true
            },
            chart: {
                type: 'spline'
            },
            xAxis: {
                type: 'datetime',
                title: {
                    text: 'Date'
                }
            },
            yAxis: {
                minPadding: 0.2,
                maxPadding: 0.2,
                title: {
                    text: 'Errors',
                    margin: 80
                }
            },
            title: {
                text: 'Errors'
            },
            series: [
                {
                    name: 'Egress Drops',
                    color: '#0b0863',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'TXpktdrops', 'delta_rules_1'); ?>]
                },
                {
                    name: 'Ingress Drops',
                    color: '#ffa052',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'Ingress', 'delta_rules_1'); ?>]
                },
                {
                    name: 'CRC',
                    color: '#a6192f',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'CRC', 'delta_rules_1'); ?>]
                },
                <?php if ($number_of_channels == 1): ?>
                {
                    name: 'RX FEC',
                    color: '#5955e6',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'RXFECerr_1', 'delta_rules_1'); ?>]
                }
                <?php else: ?>
                {
                    name: 'RX1 FEC',
                    color: '#5955e6',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'RXFECerr_1', 'delta_rules_1'); ?>]
                }, {
                    name: 'RX2 FEC',
                    color: '#1a7d08',
                    data: [<?php echo CustomDataRetrieval::extractFromRawDataForHighCharts($raw_data, 'RXFECerr_2', 'delta_rules_1'); ?>]
                }
                <?php endif; ?>
            ]
        });
    }

    function doHistoricalPlotInit(idx) {
        chartErrors = createChartErrors(idx);
    }
</script>

<strong>
    Error counts in the given interval
</strong>
<table>
    <tr>
        <td>Egress Drops</td>
        <td><?php echo CustomDataRetrieval::getFirstLastDifference($raw_data, 'TXpktdrops'); ?></td>
    </tr>
    <tr>
        <td>Ingress Drops</td>
        <td><?php echo CustomDataRetrieval::getFirstLastDifference($raw_data, 'Ingress'); ?></td>
    </tr>
    <tr>
        <td>CRC</td>
        <td><?php echo CustomDataRetrieval::getFirstLastDifference($raw_data, 'CRC'); ?></td>
    </tr>
    <?php if ($number_of_channels == 1): ?>
        <tr>
            <td>RX FEC Errors&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
            <td><?php echo CustomDataRetrieval::getFirstLastDifference($raw_data, 'RXFECerr_1'); ?></td>
        </tr>
    <?php else: ?>
        <tr>
            <td>RX1 FEC Errors</td>
            <td><?php echo CustomDataRetrieval::getFirstLastDifference($raw_data, 'RXFECerr_1'); ?></td>
        </tr>
        <tr>
            <td>RX2 FEC Errors&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
            <td><?php echo CustomDataRetrieval::getFirstLastDifference($raw_data, 'RXFECerr_2'); ?></td>
        </tr>
    <?php endif; ?>
</table>
