<div style="margin-top: 10px; padding: 10px;">
    <table style="width:100%;">
        <tr>
            <td width="50%">
                <div id="js-highcharts-container-live-traffic"></div>
            </td>
            <td width="50%">
                <div id="js-highcharts-container-live-RSSIMSE"></div>
            </td>
        </tr>
    </table>
</div>

<script>
    var urlServiceLiveRSSIMSE = window.location.origin + '/services/charts.live_rssimse.php';
    var pollingLiveRSSIMSEInSeconds = 20;
    var chartLiveRSSIMSE;
    var dataLiveRSSIMSE = [];

    function createChartLiveRSSIMSE() {
        return Highcharts.chart('js-highcharts-container-live-RSSIMSE', {
            chart: {
                type: 'spline'
            },
            tooltip: {
                split: false,
                shared: true,
                useHTML: true
            },
            xAxis: {
                title: {
                    text: "Time",
                    style: {
                        fontSize:"16px"
                    }
                }
            },
            yAxis: {
                minPadding: 0.2,
                maxPadding: 0.2,
                title: {
                    text: 'RSSI (dBm) / MSE (dB)',
                    margin: 10,
                    style: {
                        fontSize:"16px"
                    }
                }
            },
            title: {
                text: 'Live RSSI/MSE',
                style: {
                    fontSize:"22px"
                }
            },
            <?php $number_of_channels = $capabilities['channels']; if ($number_of_channels > 1): ?>
                series: [{
                    name: 'RSSI1',
                    color: '#0b0863'
                }, {
                    name: 'MSE1',
                    color: '#3796de'
                }, {
                    name: 'RSSI2',
                    color: '#ffa052'
                }, {
                    name: 'MSE2',
                    color: '#d9e314'
                }],
            <?php else: ?>
                series: [{
                    name: 'RSSI',
                    color: '#0b0863'
                }, {
                    name: 'MSE',
                    color: '#ffa052'
                }],
            <?php endif; ?>
            data: {
                csvURL: urlServiceLiveRSSIMSE,
                enablePolling: true,
                dataRefreshRate: pollingLiveRSSIMSEInSeconds,
                beforeParse: function (csv) {
                    return CSVInjectLimitEntriesLiveRSSIMSE(csv, 90);
                }
            }
        });
    }

    function CSVInjectLimitEntriesLiveRSSIMSE(originalCSV, limit) {
        if (dataLiveRSSIMSE.length == 0) {
            let aux = originalCSV.trim().split("\r\n");
            dataLiveRSSIMSE = [];
            dataLiveRSSIMSE.push(aux[1]);
            return originalCSV;
        }
        let tmp = originalCSV.trim().split("\r\n");
        let header = tmp[0];

        // Remove header if more than an element
        if (dataLiveRSSIMSE.length > 1) {
            dataLiveRSSIMSE.shift();
        }

        // Too many items? Remove the oldest
        dataLiveRSSIMSE.push(tmp[1]);
        if (dataLiveRSSIMSE.length > limit) {
            dataLiveRSSIMSE.shift();
        }

        // Re-attach header
        dataLiveRSSIMSE.unshift(header);
        return dataLiveRSSIMSE.join("\r\n");
    }

    // Create the chart
    chartLiveRSSIMSE = createChartLiveRSSIMSE();
</script>

<script>
    var urlServiceLiveTraffic = window.location.origin + '/services/charts.live_traffic.php';
    var pollingLiveTrafficInSeconds = 20;
    var chartLiveTraffic;
    var dataLiveTraffic = [];

    function createChartLiveTraffic() {
        return Highcharts.chart('js-highcharts-container-live-traffic', {
            chart: {
                type: 'spline'
            },
            tooltip: {
                split: false,
                shared: true,
                useHTML: true
            },
            xAxis: {
                title: {
                    text: "Time",
                    style: {
                        fontSize:"16px"
                    }
                }
            },
            yAxis: {
                minPadding: 0.2,
                maxPadding: 0.2,
                title: {
                    text: 'Port Rate (Mbps)',
                    margin: 10,
                    style: {
                        fontSize:"16px"
                    }
                }
            },
            title: {
                text: 'Live Traffic',
                style: {
                    fontSize:"22px"
                }
            },
            series: [{
                name: 'IN',
                color: '#00c735'
            }, {
                name: 'OUT',
                color: '#948494'
            }],
            data: {
                csvURL: urlServiceLiveTraffic,
                enablePolling: true,
                dataRefreshRate: pollingLiveTrafficInSeconds,
                beforeParse: function (csv) {
                    return CSVInjectLimitEntriesLiveTraffic(csv, 90);
                }
            }
        });
    }

    function CSVInjectLimitEntriesLiveTraffic(originalCSV, limit) {
        if (dataLiveTraffic.length == 0) {
            let aux = originalCSV.trim().split("\r\n");
            dataLiveTraffic = [];
            dataLiveTraffic.push(aux[1]);
            return originalCSV;
        }
        let tmp = originalCSV.trim().split("\r\n");
        let header = tmp[0];

        // Remove header if more than an element
        if (dataLiveTraffic.length > 1) {
            dataLiveTraffic.shift();
        }

        // Too many items? Remove the oldest
        dataLiveTraffic.push(tmp[1]);
        if (dataLiveTraffic.length > limit) {
            dataLiveTraffic.shift();
        }

        // Re-attach header
        dataLiveTraffic.unshift(header);
        return dataLiveTraffic.join("\r\n");
    }

    // Create the chart
    chartLiveTraffic = createChartLiveTraffic();
</script>