<?php
// @used
flush();

include 'common.php';

  import_page_header();
  display_logo_banner();
  echo '<body class="snmpnav" onload="getRemoteLocalStatistics()">';
  echo '<div id="loading">
  <img id="loading-image" src="images/loading.gif" alt="Loading..." /></div>';

  display_test_menu_advanced();
  display_view_config_menu('snmp_info.config');

  display_content_table_no_border();
  echo '<tr height="10">';

  display_none_shaded_row();
  display_subtitle("ADVANCED > SNMP");
  enclose_content_table_row();
  echo '<tr height="10"></tr>';

  display_none_shaded_row();
  display_center_parameter_name("SNMP Daemon:");
  display_left_enable($snmpd_oid);
  echo '<td bgcolor=#f2f2f2 width="50%" rowspan="5"></td>';
  enclose_content_table_row();

  display_none_shaded_row();
  display_center_parameter_name("SNMPD version:");
  display_text_left($snmpd_ver_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_center_parameter_name("Trap Hierarchy:");
  display_left_enable($snmptrap_hierarchy_oid);
  enclose_content_table_row();

  if($v3_en == 0)
    $ret = snmpget($localhost, $read_str, $snmpd_ver_oid);
  else
    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $snmpd_ver_oid);
  $snmpdver = preg_replace("/(INTEGER:)/", "", $ret);

  display_none_shaded_row();
  echo '<td colspan="3">----------------------------------------------------------------------</td>';
  enclose_content_table_row();

  if($snmpdver == 0 || $snmpdver == 2)
  {
    display_none_shaded_row();
    display_center_parameter_name("SNMP v2c read-string:");
    display_text_left($read_str_oid);
    enclose_content_table_row();

    display_none_shaded_row();
    display_center_parameter_name("SNMP v2c write-string:");
    display_text_left($write_str_oid);
    enclose_content_table_row();
  
    display_none_shaded_row();
    display_center_parameter_name("SNMP v2c trap-string:");
    display_text_left($trap_str_oid);
    enclose_content_table_row();

    display_none_shaded_row();
    echo '<td colspan="3">----------------------------------------------------------------------</td>';
    enclose_content_table_row();
  }
  else
  {
    display_none_shaded_row();
    display_center_parameter_name("SNMP v3 username:");
    display_text_left($snmpd_user_oid);
    enclose_content_table_row(); 

    display_none_shaded_row();
    display_center_parameter_name("SNMP v3 auth algorithm:");
    display_text_only("MD5", $left);
    enclose_content_table_row();

    display_none_shaded_row();
    display_center_parameter_name("SNMP v3 auth password:");
    display_text_left($snmpd_authpass_oid);
    enclose_content_table_row();

    display_none_shaded_row();
    display_center_parameter_name("SNMP v3 priv algorithm:");
    display_text_only("DES", $left);
    enclose_content_table_row();

    display_none_shaded_row();
    display_center_parameter_name("SNMP v3 priv password:");
    display_text_left($snmpd_privpass_oid);
    enclose_content_table_row();

    display_none_shaded_row();
    echo '<td colspan="3">----------------------------------------------------------------------</td>';
    enclose_content_table_row();
  }

  enclose_content_table();
  
  display_content_table_no_border();
  display_none_shaded_row();
  echo '<td width="24%" bgcolor="f2f2f2" nowrap="nowrap"> <div id="left-title"></div> </td>';
  echo '<td bgcolor="#f2f2f2" width="20%"> <div align="left" ><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#000000><b>Enable</b></font></div> </td>';
  echo '<td bgcolor="#f2f2f2"> <div align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#000000><b>IP Address</b></font></div> </td>
          <td bgcolor="#f2f2f2"></td>';
  enclose_content_table_row();

  display_none_shaded_row();
  display_center_parameter_name("Trap Manager 1 IP:");
  display_on_off($trap1_enable_oid, $left);
  display_text_left($snmptrap_ip1_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_center_parameter_name("Trap Manager 2 IP:");
  display_on_off($trap2_enable_oid, $left);
  display_text_left($snmptrap_ip2_oid);
  enclose_content_table_row();

  display_block_row();
  enclose_content_table();

  display_footer();
?>
<script language="javascript" type="text/javascript">
     $(window).load(function() {
     $('#loading').hide();
  });
</script>
<script language="javascript" type="text/javascript">
     window.onbeforeunload = function() {
     $('#loading').show();
  };
</script>
