<?php
  require_once 'phplot.php';
  require_once 'FFT.class.php';

  set_time_limit(180);  
  $file = '/tmp/snapshot.txt';

  $data = array();
  $amp = array();
  $count = 0;

  //Define the object
  $plot = new PHPlot(900,600);
  $plot->SetDataType('data-data');
  $plot->SetPlotType('lines');
  $plot->SetPlotAreaWorld(NULL, NULL , NULL, NULL);

    //$names = array('RSSI');
    //Turn off X axis ticks and labels because they get in the way:
    //$plot->SetXTickLabelPos('none');
    $plot->SetXTickPos('plotdown');
    $plot->SetDrawXGrid('True');
    //$plot->SetYTickLabelPos('none');
    $plot->SetDataColors(array('blue'));
    //$plot->SetLegend($names);
    $plot->SetTitle('Wideband Snapshot - Spectrum');
    $plot->SetYTitle('PSD (1 div = 10dB)');
    $plot->SetXTitle('Frequency(1 div = 100MHz)');
    $plot->SetBackgroundColor('snow');

    $fp = fopen($file, 'r');
    while($info = fscanf($fp, "%d %d\n"))
    {
      list($i, $q) = $info;
      //$i = $i/100;
      //$q = $q/100;
      $amp[$count++] = sqrt(pow($i,2) + pow($q,2));
      //array_push($data, array('', $count++, $amp));
    }
    fclose($fp);

  $N = $count/2048;
  $fft = new FFT(2048);
  for($i=0; $i<2048; $i++)
    $val[$i] = 0;

  for($i=0; $i<$N; $i++)
  {
    $count = 0;
    $values = array_slice($amp, ($i*2048), ((1+$i)*2048)-1);
    $w = $fft->fft($values);
    $absfft = $fft->getAbsFFT($w);

    for($j=0;$j<2048;$j++)
    {
      //$val[$j] += $absfft[$j]/20;
      $val[$j] += $absfft[$j];
      //array_push($data, array('', $count, $val));
      $count++;
    }
  }

  $count = 0;
  for($i=1024;$i<2048;$i++)
  {
      //$psd = $val[$i]/$N - 120;
      $psd = (20*log($val[$i]/$N)) - 300;
      array_push($data, array('', ($count/2)-500, $psd));
      $count++;
  }

  for($i=1;$i<1024;$i++)
  {
      //$psd = $val[$i]/$N - 120;
      $psd = (20*log($val[$i]/$N)) - 300;
      array_push($data, array('', ($count/2)-500, $psd));
      $count++;
  }

  /*$w = $fft->fft($amp);
  $absfft = $fft->getAbsFFT($w);

  $f_val = 0;

  $count = 0;
  for($i=8192;$i<16384;$i++)
  {
      $val = -120 + $absfft[$i]/256;
      array_push($data, array('', $count, $val));
      $count++;
  }

  for($i=1;$i<8192;$i++)
  {
      $val = -120 + $absfft[$i]/256;
      array_push($data, array('', $count, $val));
      $count++;
  }*/

  $plot->SetDataValues($data);
  $plot->TuneYAutoRange(0,'T',0.05);
  $plot->SetPrecisionY(2);
  $plot->SetPrecisionX(0);
  //$plot->TuneXAutoRange(0,'T',0.05);

  $plot->DrawGraph();

?>
