<?php
// @used
  global $ntpdnsip_oid, $ntpserverip_oid, $ntpservername_oid, $ntptimezone_oid, $ntpupdate_oid;
  flush();

include 'common.php';

import_page_header();
echo '<meta http-equiv="refresh" content="300;url=../general_info.php">';
display_logo_banner();
echo '<body class="generalnav" onload="getRemoteLocalStatistics()">';
echo '<div id="loading">
  <img id="loading-image" src="../images/loading.gif" alt="Loading..." /></div>';

display_test_menu_basic(4);
display_view_config_menu('general_info');

display_content_table_no_border();
echo '<tr height="10">';
echo '<form name="general" method="post" action="'.$_SERVER['PHP_SELF'].'" onsubmit="show_save()">';

display_none_shaded_row();
display_subtitle("LINK > GENERAL SETUP");
echo '<td width="30%" rowspan="14" bgcolor=#f2f2f2></td>';
enclose_content_table_row();

echo '<tr height="10"></tr>';

display_none_shaded_row();
display_parameter_name_width("Link Position:", "10%");
echo '<td bgcolor=#f2f2f2><div id="left-text">';
echo '<select id="LinkPosition" name="LinkPosition" width="30">';
echo '<option id="LinkPosition_0" value="0"> Local </option>
           <option id="LinkPosition_1" value="1"> Remote </option>
  	</select>';

display_speed_result($link_position_oid, "LinkPosition");
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("GPS Enable:", "10%");
display_radio_on_off_left("GPSEnable", $gps_enable_oid);
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Latitude(N/S dd mm ss.s):", "10%");
set_radio_param($gps_lat_oid, "GPSFirst", $str_val, $left);
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Longitude(E/W ddd mm ss.s):", "10%");
set_radio_param($gps_long_oid, "GPSSecond", $str_val, $left);
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Unit ID:", "10%");
set_radio_param($remark_oid, "SysRemark", $str_val, $left);
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Front Panel Light:", "10%");
display_radio_on_off_left("PanelLED", $panel_led_oid);
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("NTP Enable:", "10%");
display_radio_on_off_left("NTPEnable", $ntpenable_oid);
enclose_content_table_row();

if ($v3_en == 0) {
    $ret = snmpget($localhost, $read_str, $ntpenable_oid);
} else {
    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $ntpenable_oid);
}
$ret = preg_replace("/(INTEGER: )/", "", $ret);
$ntp_en = trim($ret, "\"");

if ($ntp_en == 1) {
    $oids = [
      $ntpdnsip_oid,
      $ntpserverip_oid,
      $ntpservername_oid,
      $ntptimezone_oid
    ];
    $ntpCurrentValues = getSnmpBulkResult($oids);
    
    display_none_shaded_row();
    display_parameter_name_width("DNS IP:", "10%");
    set_radio_param($ntpdnsip_oid, "NTPDNSIp", $ip_val, $left);
    echo '<td bgcolor=#f2f2f2 rowspan="3"></td>';
    enclose_content_table_row();

    display_none_shaded_row();
    display_parameter_name_width("NTP Server IP:", "10%");
    set_radio_param($ntpserverip_oid, "NTPServerIp", $ip_val, $left);
    enclose_content_table_row();

    display_none_shaded_row();
    display_parameter_name_width("NTP Server Name:", "10%");
    set_radio_param($ntpservername_oid, "NTPServerName", $str_val, $left);
    enclose_content_table_row();

    display_none_shaded_row();
    display_parameter_name_width("NTP Time Zone:", "10%");
    set_radio_param($ntptimezone_oid, "Timezone", $int_val, $left);
    enclose_content_table_row();
    // check ntp changes and triggers ntp update
  

  $currentNTPDNSIp = $ntpCurrentValues[0];
  $currentNTPServerIp = $ntpCurrentValues[1];
  $currentNTPServerName = $ntpCurrentValues[2];
  $currentTimezone = $ntpCurrentValues[3];

  // Check each POST value against the current SNMP value
  if (
    (isset($_POST['NTPDNSIp']) && $_POST['NTPDNSIp'] !== null && $_POST['NTPDNSIp'] !== $currentNTPDNSIp) ||
    (isset($_POST['NTPServerIp']) && $_POST['NTPServerIp'] !== null && $_POST['NTPServerIp'] !== $currentNTPServerIp) ||
    (isset($_POST['NTPServerName']) && $_POST['NTPServerName'] !== null && $_POST['NTPServerName'] !== $currentNTPServerName) ||
    (isset($_POST['Timezone']) && $_POST['Timezone'] !== null && $_POST['Timezone'] !== $currentTimezone)
  ) {
    $set = setSnmp($ntpupdate_oid, "i", 1, 60000000, 5);
  }
  
  
} else {
    display_none_shaded_row();
    display_parameter_name_width("Date-Time(yy mm dd hr min):", "10%");
    set_radio_param($datetime_oid, "SysDateTime", $str_val, $left);
    enclose_content_table_row();
}

display_block_row();
enclose_content_table();

display_content_table_no_border();
echo '<tr><td colspan="18" height="25">
        <div align="center"> <input type ="submit" name="radio_submit" class="submit_button"
        value="Apply Changes" onclick="return confirmdate()"> </div></td>';
echo '</form>';
echo '<td>';
echo '<form method="post" name="config_save" action="submit_option.php?name='.$_SERVER["PHP_SELF"].'&option=4&oid='.$config_option_oid.'"> ';
echo '<div align="center">
         <input type ="submit" name="save_submit" class="submit_button" value="Save Changes" onclick="return confirmChanges()"> </div>
         </div>
        </form>';
echo '</td>';
/*echo '<td>';
echo '<form action="../general_info.php"> ';
echo '<div align="center">
            <input style="white-space:normal;" type="submit" class="submit_button" value="View Mode">
                    </div>
         </form>';
echo '</td>';*/
echo '<p>';
echo '<div id="input-text">';

$config_info = "/mnt/usrcfg/config.bin";
enclose_content_table_row();
enclose_content_table();

display_content_table_no_border();
echo '<tr height="10"></tr>';

display_none_shaded_row();
if ($ntp_en == 0) {
    display_note_section("<strong>For Date-Time setting, yy: 0-99, mm: 1-12, dd: 1-31, hr: 0-23, min: 0-59</strong>");
} else {
    display_note_section("<strong>Time Zone: Enter offset to GMT.<br>For e.g. 8 for 'GMT-08:00' hrs, -5 for 'GMT+05:00' hrs</strong>");
}
enclose_content_table_row();

display_none_shaded_row();
display_note_section("<strong>Important: The display will revert back to View Mode after 5 mins of inactivity.</strong>");
enclose_content_table_row();

display_footer();

?>

<script language="JavaScript">
    function confirmdate() {
        var ans = true;

        var ret_date = (document.general.SysDateTime.value == document.general.SysDateTime.defaultValue) ? false : true;

        if (ret_date == true) {
            ans = confirm("To apply date and time settings, you should submit, then save changes and reboot.");
        } else
            return true;

        if (ans)
            return true;
        else {
            alert("Please refresh the page to see the correct settings!");
            return false;
        }
    }
</script>
<script language="javascript" type="text/javascript">
    $(window).load(function () {
        $('#loading').hide();
    });
</script>
<script language="javascript" type="text/javascript">
    window.onbeforeunload = function () {
        $('#loading').show();
    };
</script>
