<?php
// @used

flush();

include 'common.php';

import_page_header();
echo '<meta http-equiv="refresh" content="300;url=../radio_info.php">';
display_logo_banner();
echo '<body class="linknav" onload="getRemoteLocalStatistics()">';

display_test_menu_basic(1);
display_view_config_menu('radio_info');

$bandwidth_values = CustomDataRetrieval::getChannelBandwidthMappings();

if ($v3_en == 1) {
    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $link_lock_oid);
    $llink = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_link_oid);
    $rlink = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_config_oid);
    $rconfig = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $omu_model_oid);
    $ret = preg_replace("/(STRING: )/", "", $ret);
    $omu_id = trim($ret, "\"");

} else {
    $ret = snmpget($localhost, $read_str, $link_lock_oid);
    $llink = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmpget($localhost, $read_str, $remote_link_oid);
    $rlink = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmpget($localhost, $read_str, $remote_config_oid);
    $rconfig = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmpget($localhost, $read_str, $omu_model_oid);
    $ret = preg_replace("/(STRING: )/", "", $ret);
    $omu_id = trim($ret, "\"");

}

if ((strcmp($omu_id, "SP24-SI") == 0) || (strcmp($omu_id, "SP24-XI") == 0) || (strcmp($omu_id, "SP24-XD") == 0)) {
    $model_flag = 0;
} else {
    if ((strcmp($omu_id, "SP24-SI-N") == 0) || (strcmp($omu_id, "SP24-XI-N") == 0) || (strcmp($omu_id, "SP24-XD-N") == 0)) {
        $model_flag = 1;
    }
}

display_content_table_no_border();
echo '<tr height="10"></tr>';
display_none_shaded_row();
display_note_section("<strong>Important: This page will reload itself when new settings are applied.</strong>");
enclose_content_table_row();
enclose_content_table();

display_content_table_no_border();
echo '<tr height="10">';

display_none_shaded_row();
display_subtitle("LINK > LINK SETUP");
enclose_content_table_row();
echo '<tr height="10">';

echo '<form name="linksetup" method="post" action="submit_cgi.php" onsubmit="show_save()">';

display_none_shaded_row();
display_subtitle("RF LINK");

enclose_content_table_row();

display_none_shaded_row();
echo '<td nowrap="nowrap" width="35%" bgcolor=#f2f2f2 align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#00478F>RF1</td>';

display_page_subtitle("");

echo '<td width="30%"></td>';
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Channel Bandwidth:", "10%");
echo '<td bgcolor=#f2f2f2><div id="left-text">';
echo '<select id="Bandwidth" name="Bandwidth" width="30">';
foreach ($bandwidth_values as $bv_key => $bv_value) {
    echo '<option id="Bandwidth1_'.$bv_key.'" value="'.$bv_key.'">'.$bv_value.'</option>';
}
echo '</select>';

display_speed_result_cgi($speed1_chwidth_oid, "Bandwidth1");

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Max Modulation:", "10%");
echo '<td bgcolor="#f2f2f2"> <div id="left-text">
         <select id="Modulation_Max" name="Modulation_Max">
           <option id="Modulation_Max_0" value="0">QPSK</option>
           <option id="Modulation_Max_1" value="1">QAM16</option>
           <option id="Modulation_Max_2" value="2">QAM32</option>
           <option id="Modulation_Max_3" value="3">QAM64</option>
           <option id="Modulation_Max_4" value="4">QAM128</option>
           <option id="Modulation_Max_5" value="5">QAM256</option>
           <option id="Modulation_Max_6" value="6">QAM512</option>
           <option id="Modulation_Max_7" value="7">QAM1024</option>
	   <option id="Modulation_Max_8" value="8">QAM2048</option>
	   <option id="Modulation_Max_9" value="9">QAM4096</option>
           <option id="Modulation_Max_10" value="10">QAM8K</option>
           <option id="Modulation_Max_11" value="11">QAM16K</option>
           </select></div>';
display_speed_result_cgi($speed1_mod_max_oid, "Modulation_Max");

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Min Modulation:", "10%");
echo '<td bgcolor="#f2f2f2"> <div id="left-text"> 
         <select id="Modulation_Min" name="Modulation_Min">
           <option id="Modulation_Min_0" value="0">QPSK</option>
           <option id="Modulation_Min_1" value="1">QAM16</option>
           <option id="Modulation_Min_2" value="2">QAM32</option>
           <option id="Modulation_Min_3" value="3">QAM64</option>
           <option id="Modulation_Min_4" value="4">QAM128</option>
           <option id="Modulation_Min_5" value="5">QAM256</option>
   	   <option id="Modulation_Min_6" value="6">QAM512</option>
	   <option id="Modulation_Min_7" value="7">QAM1024</option>
	   <option id="Modulation_Min_8" value="8">QAM2048</option>
	   <option id="Modulation_Min_9" value="9">QAM4096</option>
           <option id="Modulation_Min_10" value="10">QAM8K</option>
           <option id="Modulation_Min_11" value="11">QAM16K</option>
          </select></div>';

display_speed_result_cgi($speed1_mod_min_oid, "Modulation_Min");

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Tx Frequency(MHz):", "20%");
set_radio_param_cgi($txfreq1_oid, "TxFrequency", $float_val, $left);

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("T/R Spacing(MHz):");
set_radio_param_cgi($odu1_duplex_oid, "FreqDuplex", $float_val, $left);

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Rx Frequency(MHz):", "10%");
display_text_position($rxfreq1_oid, $left);

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Tx Power(dBm):");
if ($v3_en == 0) {
    $atpc = snmpget($localhost, $read_str, $atpc_oid);
} else {
    $atpc = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $atpc_oid);
}
$atpc = preg_replace("/(INTEGER: )/", "", $atpc);
$atpc = trim($atpc, "\"");
if ($atpc == 0) {
    set_radio_param_cgi($power1_oid, "TxPower", $float_val, $left);
} else {
    display_text_position($power1_oid, $left);
}

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Radio Power:", "10%");
display_radio_on_off_left_cgi("LOdupower", $odupower1_oid);

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Transmitter:", "10%");
display_radio_on_off_left_cgi("LOpmode", $opmode1_oid);

enclose_content_table_row();

display_block_row();

display_none_shaded_row();
//echo '<td bgcolor=#f2f2f2></td>';
echo '<td nowrap="nowrap" width="35%" bgcolor=#f2f2f2 align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#00478F>RF2</td>';
display_page_subtitle("");

echo '<td width="30%"></td>';
enclose_content_table_row();


display_none_shaded_row();
display_parameter_name_width("Channel Bandwidth:", "10%");
echo '<td bgcolor=#f2f2f2><div id="left-text">';
echo '<select id="Bandwidth" name="Bandwidth" width="30">';

foreach ($bandwidth_values as $bv_key => $bv_value) {
    echo '<option id="Bandwidth2_'.$bv_key.'" value="'.$bv_key.'">'.$bv_value.'</option>';
}
echo '</select>';

display_speed_result_cgi($speed2_chwidth_oid, "Bandwidth2");

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Max Modulation:", "10%");
echo '<td bgcolor="#f2f2f2"> <div id="left-text">
         <select id="Modulation_Max" name="Modulation_Max">
           <option id="Modulation_Max2_0" value="0">QPSK</option>
           <option id="Modulation_Max2_1" value="1">QAM16</option>
           <option id="Modulation_Max2_2" value="2">QAM32</option>
           <option id="Modulation_Max2_3" value="3">QAM64</option>
           <option id="Modulation_Max2_4" value="4">QAM128</option>
           <option id="Modulation_Max2_5" value="5">QAM256</option>
           <option id="Modulation_Max2_6" value="6">QAM512</option>
           <option id="Modulation_Max2_7" value="7">QAM1024</option>
	   <option id="Modulation_Max2_8" value="8">QAM2048</option>
	   <option id="Modulation_Max2_9" value="9">QAM4096</option>
           <option id="Modulation_Max2_10" value="10">QAM8K</option>
           <option id="Modulation_Max2_11" value="11">QAM16K</option>
           </select></div>';
display_speed_result_cgi($speed2_mod_max_oid, "Modulation_Max2");

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Min Modulation:", "10%");
echo '<td bgcolor="#f2f2f2"> <div id="left-text"> 
         <select id="Modulation_Min" name="Modulation_Min">
           <option id="Modulation_Min2_0" value="0">QPSK</option>
           <option id="Modulation_Min2_1" value="1">QAM16</option>
           <option id="Modulation_Min2_2" value="2">QAM32</option>
           <option id="Modulation_Min2_3" value="3">QAM64</option>
           <option id="Modulation_Min2_4" value="4">QAM128</option>
           <option id="Modulation_Min2_5" value="5">QAM256</option>
   	   <option id="Modulation_Min2_6" value="6">QAM512</option>
	   <option id="Modulation_Min2_7" value="7">QAM1024</option>
	   <option id="Modulation_Min2_8" value="8">QAM2048</option>
	   <option id="Modulation_Min2_9" value="9">QAM4096</option>
           <option id="Modulation_Min2_10" value="10">QAM8K</option>
           <option id="Modulation_Min2_11" value="11">QAM16K</option>
          </select></div>';

display_speed_result_cgi($speed2_mod_min_oid, "Modulation_Min2");

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Tx Frequency(MHz):", "20%");
set_radio_param_cgi($txfreq2_oid, "TxFrequency", $float_val, $left);

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("T/R Spacing(MHz):");
set_radio_param_cgi($odu2_duplex_oid, "FreqDuplex", $float_val, $left);

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Rx Frequency(MHz):", "10%");
display_text_position($rxfreq2_oid, $left);

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Tx Power(dBm):");
if ($v3_en == 0) {
    $atpc = snmpget($localhost, $read_str, $atpc2_oid);
} else {
    $atpc = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $atpc2_oid);
}
$atpc = preg_replace("/(INTEGER: )/", "", $atpc);
$atpc = trim($atpc, "\"");
if ($atpc == 0) {
    set_radio_param_cgi($power2_oid, "TxPower", $float_val, $left);
} else {
    display_text_position($power2_oid, $left);
}

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Radio Power:", "10%");
display_radio_on_off_left_cgi("LOdupower2", $odupower2_oid);

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name_width("Transmitter:", "10%");
display_radio_on_off_left_cgi("LOpmode2", $opmode2_oid);

enclose_content_table_row();

display_block_row();
enclose_content_table();

display_content_table_no_border();
echo '<tr><td colspan="18" height="25"><div align="center">';
if ($model_flag == 0) {
    echo '<input type ="submit" name="link_submit" class="submit_button"
        value="Apply Changes" onclick="return checkBWFreq(0)"> </div></td>';
} elseif ($model_flag == 1) {
    echo '<input type ="submit" name="link_submit" class="submit_button"
        value="Apply Changes" onclick="return checkBWFreq(1)"> </div></td>';
}
echo '</form>';
echo '<td>';
echo '<form method="post" name="config_save" action="submit_option.php?name='.$_SERVER["PHP_SELF"].'&option=4&oid='.$config_option_oid.'"> ';
echo '<div align="center">
         <input type ="submit" name="save_submit" class="submit_button" value="Save Changes" onclick="return confirmChanges()"> </div>
         </div>
        </form>';
echo '</td>';
echo '<td>';
echo '<form method="post" name="reboot" action="submit_option.php?name=upgrade.php&option=1&oid='.$reboot_oid.'"> ';
echo '<div align="center">';
echo '<input type ="submit" name="reboot_submit" class="submit_button" style="box-shadow:1px 1px 1px 0px #ff0000;" value="Reboot" onClick="return confirmReboot()"></div>';
echo '</form></td>';

echo '<td>';
echo '<form method="post" name="help" target="_blank" action="freq_limits.php">';
echo '<div align="center">
              <input type ="submit" name="help_submit" class="submit_button" value="Help"></div>
             </form>';
echo '</td>';

echo '<p>';
echo '<div id="input-text">';

$config_info = "/mnt/usrcfg/config.bin";
enclose_content_table_row();
enclose_content_table();

display_content_table_no_border();
echo '<tr height="10"></tr>';

/*display_none_shaded_row();
display_note_section("<strong>Important: Please refresh the page after changing settings to see the correct values.</strong>");
enclose_content_table_row();

echo '<tr height="10"></tr>';*/
display_none_shaded_row();
display_note_section("<strong>The display will revert back to View Mode after 5 mins of inactivity.</strong>");
enclose_content_table_row();

display_footer();

?>

<script src="jquerymin.js"></script>
<script language="JavaScript">
    function confirmOpmode() {
        return confirm("Turning OFF Opmode will break the RF link on the remote end, proceed?");
    }

    $(document).ready(function () {
        $('#Bandwidth').change(function () {
            if (document.linksetup.RemoteConfig[0].checked) {
                document.getElementById("FreqDuplex").disabled = true;
                document.getElementById("TxFrequency").disabled = true;
                //alert("If remote config is enabled, ");
            }
        });
        $('#Modulation_Min').change(function () {
            if (document.linksetup.RemoteConfig[0].checked) {
                document.getElementById("FreqDuplex").disabled = true;
                document.getElementById("TxFrequency").disabled = true;
                //alert("If remote config is enabled, ");
            }
        });
        $('#Modulation_Max').change(function () {
            if (document.linksetup.RemoteConfig[0].checked) {
                document.getElementById("FreqDuplex").disabled = true;
                document.getElementById("TxFrequency").disabled = true;
                //alert("If remote config is enabled, ");
            }
        });
        $('#TxFrequency').change(function () {
            if (document.linksetup.RemoteConfig[0].checked) {
                document.getElementById("Bandwidth").disabled = true;
                document.getElementById("Modulation_Max").disabled = true;
                document.getElementById("Modulation_Min").disabled = true;
                document.getElementById("FreqDuplex").disabled = true;
                //alert("If remote config is enabled, ");
            }
        });
        $('#FreqDuplex').change(function () {
            if (document.linksetup.RemoteConfig[0].checked) {
                document.getElementById("Bandwidth").disabled = true;
                document.getElementById("Modulation_Max").disabled = true;
                document.getElementById("Modulation_Min").disabled = true;
                document.getElementById("TxFrequency").disabled = true;
                //alert("If remote config is enabled, ");
            }
        });
    });

</script>
<script language="JavaScript">
    function checkBWFreq(x) {
        var bw = document.getElementById("Bandwidth");
        var bw_val = bw.value;
        var freq = document.getElementById("TxFrequency");
        var freq_val = freq.value;
        var duplex = document.getElementById("FreqDuplex");
        var duplex_val = duplex.value;

        if (x == 0) {

            if (bw_val == 0) {
                if ((freq_val < 24055) || (freq_val > 24245)) {
                    alert("Invalid frequency for bandwidth 10MHz! Frequency limits are 24055 to 24245MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
                if ((duplex_val < 100) || (duplex_val > 130)) {
                    alert("Invalid T/R spacing for BW 10MHz. Valid T/R spacings are 100/120/130 MHz.");
                    location.reload();
                    return false;
                }
            } else if (bw_val == 1) {
                if ((freq_val < 24065) || (freq_val > 24235)) {
                    alert("Invalid frequency for bandwidth 30MHz! Frequency limits are 24065 to 24235MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
                if ((duplex_val < 100) || (duplex_val > 130)) {
                    alert("Invalid T/R spacing for BW 30MHz. Valid T/R spacings are 100/120/130 MHz.");
                    location.reload();
                    return false;
                }

            } else if (bw_val == 2) {
                if ((freq_val < 24085) || (freq_val > 24215)) {
                    alert("Invalid frequency for bandwidth 60MHz! Frequency limits are 24085 to 24215MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
                if ((duplex_val < 100) || (duplex_val > 130)) {
                    alert("Invalid T/R spacing for BW 60MHz. Valid T/R spacings are 100/120/130 MHz.");
                    location.reload();
                    return false;
                }

            } else if (bw_val == 3) {
                if ((freq_val < 24088) || (freq_val > 24212)) {
                    alert("Invalid frequency for bandwidth 75MHz! Frequency limits are 24088 to 24212MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
                if ((duplex_val < 100) || (duplex_val > 120)) {
                    alert("Invalid T/R spacing for BW 75MHz. Valid T/R spacings are 100/120 MHz.");
                    location.reload();
                    return false;
                }

            } else if (bw_val == 4) {
                if ((freq_val < 24100) || (freq_val > 24200)) {
                    alert("Invalid frequency for bandwidth 100MHz! Frequency limits are 24100 to 24200MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
                if ((duplex_val != 100)) {
                    alert("Invalid T/R spacing for BW 100MHz. Valid T/R spacing is 100 MHz.");
                    location.reload();
                    return false;
                }

            } else if ((bw_val == 5) || (bw_val == 6) || (bw_val == 7)) {
                if ((freq_val < 24110) || (freq_val > 24190)) {
                    alert("Invalid frequency for bandwidth 120MHz! Frequency limits are 24110 to 24190MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
                if ((duplex_val != 100)) {
                    alert("Invalid T/R spacing for BW 120MHz. Valid T/R spacing is 100 MHz.");
                    location.reload();
                    return false;
                }

            }

        } else {

            if (bw_val == 0) {
                if ((freq_val < 24005) || (freq_val > 24245)) {
                    alert("Invalid frequency for bandwidth 10MHz! Frequency limits are 24005 to 24245MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
            } else if (bw_val == 1) {
                if ((freq_val < 24015) || (freq_val > 24235)) {
                    alert("Invalid frequency for bandwidth 30MHz! Frequency limits are 24015 to 24235MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
            } else if (bw_val == 2) {
                if ((freq_val < 24030) || (freq_val > 24220)) {
                    alert("Invalid frequency for bandwidth 60MHz! Frequency limits are 24030 to 24220MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
            } else if (bw_val == 3) {
                if ((freq_val < 24040) || (freq_val > 24210)) {
                    alert("Invalid frequency for bandwidth 75MHz! Frequency limits are 24040 to 24210MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
            } else if (bw_val == 4) {
                if ((freq_val < 24050) || (freq_val > 24200)) {
                    alert("Invalid frequency for bandwidth 100MHz! Frequency limits are 24050 to 24200MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
            } else if ((bw_val == 5) || (bw_val == 6) || (bw_val == 7)) {
                if ((freq_val < 24060) || (freq_val > 24190)) {
                    alert("Invalid frequency for bandwidth 120MHz! Frequency limits are 24060 to 24190MHz. Click 'Help' for more information.");
                    location.reload();
                    return false;
                }
            }

            if ((duplex_val < 100) || (duplex_val > 130)) {
                alert("Invalid T/R spacing. Valid T/R spacing values are 100/120/130 MHz.");
                location.reload();
                return false;
            }

        }

        var ans = confirm("Changing settings may take around 30-45 seconds. Continue?");
        if (ans == true)
            return true;
        else {
            location.reload();
            return false;
        }
    }
</script>
