<?php
// @used
flush();
include 'common.php';

  if($v3_en == 1)
  {
	$ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $link_lock_oid);
  	$llink = preg_replace("/(INTEGER:)/", "", $ret);

  	$ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_link_oid);
  	$rlink = preg_replace("/(INTEGER:)/", "", $ret);   

  	$ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_config_oid);
  	$rconfig = preg_replace("/(INTEGER:)/", "", $ret);   
  }
  else
  {
  	$ret = snmpget($localhost, $read_str, $link_lock_oid);
  	$llink = preg_replace("/(INTEGER:)/", "", $ret);

  	$ret = snmpget($localhost, $read_str, $remote_link_oid);
  	$rlink = preg_replace("/(INTEGER:)/", "", $ret);   

  	$ret = snmpget($localhost, $read_str, $remote_config_oid);
  	$rconfig = preg_replace("/(INTEGER:)/", "", $ret);   
  }

  import_page_header();
  display_logo_banner();
  echo '<body class="upgradenav" onload="getRemoteLocalStatistics()">';
  echo '<div id="loading">
  <img id="loading-image" src="../images/loading.gif" alt="Loading..." /></div>';

  display_test_menu_advanced();
  display_view_config_menu(0, ['view' => true]);
  
  display_content_table_no_border();
  echo '<tr height="10"></tr>';  

  display_none_shaded_row();
  display_subtitle("ADVANCED > FPGA UPGRADE");
  enclose_content_table_row();  
  echo '<tr height="10">';

  display_content_table_no_border();
  display_none_shaded_row();
  display_subtitle("FPGA VERSIONS");
  enclose_content_table_row();

  display_block_row();

  display_none_shaded_row();
  echo '<td colspan="2"><div id="left-text"> Set current FPGA as a stable version</div></td>';
  echo '<form method="post" action="fpga_upgrade_option.php?name=fpga_upgrade.php&oid=' . $fpga_stable_oid . '">';
  echo '<td><div align="left" id="left-text"> <input type ="submit" name="auto_config_submit" class="submit_button" value="Set"></div></td>';
  echo '</form></tr>';

  display_none_shaded_row();
  display_parameter_name("Current version:");
  display_fpga_version(0);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Previous version:");
  display_fpga_version(1);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Stable version:");
  display_fpga_version(2);
  enclose_content_table_row();

  display_block_row();

  display_none_shaded_row();
  display_subtitle("FPGA UPGRADE");
  enclose_content_table_row();

  display_block_row();
  echo '<form method="post" name="upload_local" id="upload_local" action="fpga_upload_file.php" enctype="multipart/form-data">';
  display_none_shaded_row();
  echo '<td bgcolor=#f2f2f2 colspan="2"><input type="file" name="file" id="file" accept=".tar.gz" onchange="validateFileSelection(this)"></td>';
  echo '<td><div align="center"><input type="submit" class="submit_button" name="submit" value="Load" onClick="return confirmImport()"></div></td>';
  echo '<td ><div id="left-text"> Load FPGA file from local machine to radio.</div></td>';
  enclose_content_table_row();
    echo '</form>';
    echo '<script>
        function validateFileSelection(input) {
    const selectedFile = input.files[0];
    if (selectedFile) {
        const fileName = selectedFile.name;
        const pattern = /^PXG2_fpga_v.*\.tar\.gz$/; // Regular expression pattern
        if (!pattern.test(fileName)) {
            alert("Please select a file with the name pattern PXG2_fpga_v*.tar.gz.");
            input.value = ""; // Clear the selection
        }
    }
}

    </script>';

  if(file_exists('/tmp/fpga_upload_flag.txt'))
  {
    display_none_shaded_row();

    $files = glob("/tmp/PXG2_fpga_v*.tar.gz");
    $fw = strstr($files[0], "PXG2_fpga_v");

    echo '<td colspan="4"><div id="left-text" style="color:#2F712F; font-size:14px;"><b>';
    echo 'New FPGA file ' . $fw . ' loaded on the radio.</b>';
    echo '</td>';
    enclose_content_table_row();
  }

  echo '<form method="post" name="upgrade" action="fpga_upgrade_option.php?name=fpga_upgrade.php&oid=' . $fpga_upgrade_oid . '"> ';
  display_none_shaded_row();
  display_parameter_name("FPGA version:");
  echo '<td width="100" bgcolor="f2f2f2"> <div id="left-text"">
        <select name="upgrade" id="upgrade">
           <option id="upgrade_1" value="0">New</option>
           <option id="upgrade_2" value="1">Previous</option>
           <option id="upgrade_3" value="2">Stable</option>';
  echo '</select>';
  display_selection_result($fpga_upgrade_oid, "UpgradeOption");
  echo '</td>';

  echo '<td height="25">
        <div align="center"> <input type ="submit" name="radio_submit" class="submit_button" value="Select"> </div></td>';
  echo '<td><div id="left-text"> Select FPGA version to upgrade/downgrade.</div></td>';
  echo '</tr></form>';
		
  if(file_exists('/mnt/usrcfg/fpga_upgrade.txt'))
  {
    display_none_shaded_row();
    echo '<td colspan="2"><div id="left-text" style="color:#2F712F; font-size:14px;"><b>';
    echo 'Radio ready to upgrade the FPGA.</b>';
    echo '</td>';
    echo '<td></td><td><form method="post" name="upgrade_cancel" action="submit_option.php?name=fpga_upgrade.php&option=3&oid=' . $fpga_upgrade_oid . '"> ';
    echo '<div align="center">
          <input type ="submit" name="cancel_upgrade" class="submit_button" value="Cancel upgrade" onClick="return confirmUpgradeCancel()"></div>
          </form></td></tr>';
  }

  display_block_row();

  display_none_shaded_row();
  echo '<td colspan="2"><div id="left-text">Upgrade local side FPGA</div></td>';
  echo '<td>';
  //echo '<form method="post" name="reboot" action="submit_option.php?name=fpga_upgrade.php&option=1&oid=' . $fpga_flash_oid . '"> ';
  echo '<div align="center">';
  echo '<input id="upgrade_button" type ="submit" name="reboot_submit" class="submit_button" style="box-shadow:1px 1px 1px 0px #ff0000;" value="Upgrade" onClick="return confirmUpgrade(event)"></div>';
  //echo '</form>
  echo '</td></tr>';
	
  display_block_row();
  enclose_content_table();
  display_content_table_no_border();
  display_none_shaded_row();
  display_note_section("<strong>Important: To upgrade FPGA, make sure to load the FPGA file on the radio first.</strong>");
  enclose_content_table();
	
	display_content_table_no_border();
	echo '<tr height="10">';
	echo '<tr>';
	display_subtitle("FPGA Upgrade Status");
	echo '</tr>';
	
	echo '<tr> <td height="320" align="left">
        <textarea id="myTextarea" readonly rows="30" cols="70">';
	
	echo '</textarea></td>';
	enclose_content_table_row();
	enclose_content_table();
  
  display_footer();
?>
<script language="JavaScript">
let refreshStatus = false;
function confirmImport(){
  return confirm("System will import new FPGA file from local machine. Would you like to continue?");
}
function confirmUpgrade(event){
    event.preventDefault();
    let result = confirm("System will upgrade FPGA. It can takes more than 8 minutes. Would you like to continue?");
    if (result) {
        $("#myTextarea").val("");
        refreshStatus = true;
        refreshTextarea();
        upgradeFPGA();
    }
}
function refreshTextarea() {
    // Use AJAX to fetch updated content from the PHP script
    let urlRefreshService = window.location.origin + '/services/fpga_upgrade_status.php';
    $.ajax({
        url: urlRefreshService, // Your PHP script URL
        method: "GET",
        dataType: "html",
        data: { action: "refresh" },
        success: function(response) {
            let textarea = $("#myTextarea");
            textarea.val(response);
            // Scroll to the bottom of the <textarea>
            textarea.scrollTop(textarea[0].scrollHeight);
            if(refreshStatus){
                setTimeout(refreshTextarea, 5000);
            }
        }
    });
}

function upgradeFPGA() {
    jQuery("#upgrade_button").attr("disabled", "disabled");
    
    $.ajax({
        type: "POST",
        url: "submit_option.php?name=fpga_upgrade.php&option=1&dontForward=True&oid=<?php echo $fpga_flash_oid; ?>",
        data: {action: "upgrade"},
        success: function(data) {
            alert('FPGA Upgrade is completed. Please check the status');
        },
        error: function() {
            alert('Error! An error occurred while processing your request.');
        },
        complete: function() {
            $("#upgrade_button").removeAttr("disabled");
            refreshStatus = false;
            location.reload();
        }
    });
}

refreshTextarea();

</script>
<script language="javascript" type="text/javascript">
     $(window).load(function() {
     $('#loading').hide();
  });
</script>
<script language="javascript" type="text/javascript">
     window.onbeforeunload = function() {
     $('#loading').show();
  };
</script>
