<?php
require_once(__DIR__.'/../oid.php');
require_once(dirname(__FILE__).'/../v2-2021/true.common.php');

// @TODO remove the includes once fully refactored (if ever)
require_once(dirname(__FILE__).'/../v2-2021/oid.php');
require_once(dirname(__FILE__).'/../v2-2021/ui.php');
require_once(dirname(__FILE__).'/../v2-2021/data-retrieval.php');
require_once(dirname(__FILE__).'/../v2-2021/hardware.php');
require_once(dirname(__FILE__).'/../v2-2021/capabilities.php');
require_once(dirname(__FILE__).'/../v2-2021/misc.php');

set_time_limit(60);
	
$localhost = "localhost";
$remotehost = "localhost";
$read_str = "";
$write_str = "";
$int_val = 1;
$float_val = 2;
$str_val = 3;
$ip_val = 4;

$left=0;
$center=1;
$v3_en = 0;

$sec_level 	= "authPriv";
$v3_en = 0;
$handle = fopen("/etc/snmp/snmpd.conf", "r");
if(file_exists("/mnt/usrcfg/snmpv3_en"))
{
    $v3_en = 1;
    $info = fscanf($handle, "%s %s\n");
    $info = fscanf($handle, "%s %s\n");
    $info = fscanf($handle, "%s %s %s %s %s %s\n");
    list($cmd, $user, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass) = $info;
}
else{
    $info = fscanf($handle, "%s\t%s\n");
    $info = fscanf($handle, "%s\t%s\n");
    $info = fscanf($handle, "%s\t%s\n");
    list ($name, $read_str) = $info;
    $info = fscanf($handle, "%s\t%s\n");
    list ($name, $write_str) = $info;
}
fclose($handle);

function getSnmpResult($oid)
{
    global $user, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $sec_level ;
    global $read_str, $v3_en, $localhost;
    if($v3_en){
        return snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $oid);
    }
    else
    {
        return snmpget($localhost, $read_str, $oid);
    }
}
function getSnmpBulkResult($oids)
{
    global $user, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $sec_level;
    global $read_str, $write_str, $v3_en, $localhost;
    if ($v3_en) {
        $result = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $oids);
    } else {
        $result = snmpget($localhost, $read_str, $oids);
    }
    // Parse and modify each return value
    $parsedResult = [];
    foreach ($result as $value) {
        $clearedValue = CustomDataRetrieval::clearSNMPString($value);
        $clearedValue = trim($clearedValue, "\"");
        $clearedValue = trim($clearedValue);
        $parsedResult[] = $clearedValue;
    }
    
    return $parsedResult;
}

function setSnmp($oid, $dataType, $value, $timeout, $retries)
{
    global $user, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $sec_level ;
    global $write_str, $v3_en, $localhost;
    
    if($v3_en){
        return snmp3_set($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $oid, $dataType, $value, 4500000, 0);
    }
    else
    {
        return snmpset($localhost, $write_str, $oid, $dataType, $value, $timeout, $retries);
    }
}


$remark_str = getSnmpResult( $remark_oid);
$remark_str = preg_replace("/(STRING: )/", "", $remark_str);
$remark_str = trim($remark_str, "\"");

/*$remain = getSnmpResult( $reload_remain_oid);
$remain = preg_replace("/(INTEGER: )/", "", $remain);
$remain = trim($remain, "\"");*/

$write_str = getSnmpResult( $write_str_oid);
$write_str = preg_replace("/(STRING: )/", "", $write_str);
$write_str = trim($write_str, "\"");

$ret = getSnmpResult( $omu_project_oid);
$sysconfig = preg_replace("/(INTEGER:)/", "", $ret);
  
function checkSubcsriptionLicenseMode() {
  $filePath = '/mnt/syscfg/license_mode';
  
  // Check if file exists
  if (file_exists($filePath)) {
    // Read file contents
    $fileContents = file_get_contents($filePath);
    
    // Trim whitespace from the beginning and end of the file contents
    $trimmedContents = trim($fileContents);
    
    // Check if the contents are "1"
    if ($trimmedContents === "1") {
      return 2;   // mode 1
    }
    else if ($trimmedContents === "0") {
      return 1;  //mode 0
    }
    else {
      return 0; // none
    }
  } else {
    // File doesn't exist
    return 0;  //none
  }
}
$isSubscriptonLicenseEnabled = checkSubcsriptionLicenseMode();
date_default_timezone_set(CustomHardware::getSystemTimezone());

function import_page_header()
{
  global $remark_str;            
                
  echo '<head>
        <title>' . $remark_str . '</title>
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <meta name="keywords" content="" />
        <meta name="description" content="" />
        <link href="default.css" rel="stylesheet" type="text/css" />
	<link href="style.css" rel="stylesheet" type="text/css" />
        <link href="form.css" rel="stylesheet" type="text/css" />
        <link href="body.css" rel="stylesheet" type="text/css" />
	<link href="styles.css" rel="stylesheet" type="text/css" />	
	<link href="dropdown.css" rel="stylesheet" type="text/css" />	
	<link href="grid.css" rel="stylesheet" type="text/css" />	
        <link rel="shortcut icon" href="../images/favicon.ico" />
	<link href="/css/dashboard.css" rel="stylesheet" type="text/css">
	<script src="jquery.js"></script>
        <style type="text/css">
                select {height:18;}
        </style>
	<script language="JavaScript">
		function confirmSurvey() 
		{
			
  			var retval = confirm("The link will be broken for the amount of time the survey is being run. The survey duration can range from 40 secs to 25 mins. Do not close the window or navigate while the survey is being executed. Do you want to continue ?");
			if(retval == true){
					document.getElementById(\'hidden\').style.display = \'block\';
					return true;
			}
			else
					return false;
		}
		</script>
		<style type="text/css">
         .inputtext { height: 16px;width: 105px; }
         .inputtext_long { height: 18px;width: 205px; }
				.input {height: 16px;}
				.input-port{ height: 16px;width: 50px; }
				.hidden{ display: none; }
        </style>
        </head>';
}

function display_logo_banner()
{
  global $localhost, $read_str, $remotehost, $remark_str, $loopback, $ip_oid, $sysconfig;

  //$str = 'snmpwalk -v 2c -c ' . $read_str . ' localhost .1.3.6.1.4.1.5454.1.80.1.5.6.0';
  //exec($str);

  echo '<div class="grid"><div class="whole">';
  echo '<table background="../images/blue-abstract.jpg" width="100%" height="100%"  border="0" cellspacing="0" cellpadding="0" align="center">';

  echo '<tr><td height="100">';

  echo '<table height="100%" width="80%" border="0" bordercolor="#f2f2f2" cellspacing="0" cellpadding="0" align="center">
	<tr height="10"></tr>
        <tr><td height="60" width="40%" rowspan="2"><img src="../images/logo_white.png" border="0"></td>';
  /*echo '<td height="40" valign="bottom"><div id = "right-title"> ';
  if ($remain != 0){
    echo '<font color=#e51b24 >System reboot in less than ' . $remain . ' minutes</font>';
  }
  echo ' </div></td> </tr>';*/

  $ip = getSnmpResult( $ip_oid);
  $ip = preg_replace("/(IpAddress:)/", "", $ip);
  $ip_trimed = trim($ip, "\"");

  echo '<td valign="center"><div id="main-title-odd">';   //start
  echo $remark_str . ' (' . $ip_trimed . ')';
  echo ' </div></td><td width="1%"></td></tr>';

    echo '<tr>';
    echo '<td align="right">';
    echo '<div id="js-combined-rl-stats"></div>';
    echo '</td>';
    echo '</tr>';

  echo '<tr height="2"></tr>';
  
  echo '</table>';
  echo '</td> </tr>';
  echo '</body>';
}

function display_content_table_no_border()
{
  echo '<div style="vertical-align:bottom"><table style="width: 625px; vertical-align: bottom;" 
		border="0" cellpadding="3" cellspacing="0" >';
}

function enclose_content_table_row()
{
  echo '</tr>';
}

function enclose_content_table()
{
  echo '</div></table></div>';
}

function display_block_column()
{
  echo '<td width="15" bgcolor="#f2f2f2"> </tdi>';
}

function display_block_row()
{
  echo '<tr height="10"><td> </td></tr>';
}


function display_test_menu_basic($val)
{
  global $sysconfig, $isSubscriptonLicenseEnabled;

  echo '<tr><td>';
  echo '<table align="center" valign="top" border="0" bgcolor="#f2f2f2" width="80%" height="100%" cellspacing="0" cellpadding="0">';

  echo '<tr height="10" bgcolor=#ffffff><td style="border-bottom: solid 3px #555;"> &nbsp;';
  echo '<img alt="logo" src="/services/get.device-logo.php"></td>';


  echo '<td align="left" colspan="2" style="border-bottom: solid 3px #555;">';


  echo '<div class="dropdown">
        <button class="dropbtn-active">Link</button>
        <div class="dropdown-content">
          <a href="link_setup.php">Link</a>
          <a href="mgmt.php">Management</a>
          <a href="eth_setting.php">Ports</a>
          <a href="sys_general.php">General</a>
        </div></div>';
  echo '<div class="dropdown">
        <button class="dropbtn">Diagnostics</button>
        <div class="dropdown-content">
          <a href="syslog.php">Syslog</a>
        </div></div>';
  echo '<div class="dropdown">
        <button class="dropbtn">Advanced</button>
        <div class="dropdown-content">
          <a href="threshold.php">Threshold</a>
          <a href="atpc.php">ATPC</a>
          <a href="snmp.php">SNMP</a>
          <a href="license.php">License Keys</a>';
  if ($isSubscriptonLicenseEnabled) echo '<a href="subscription.php">License Subscription</a>';
  if(($sysconfig == 3) || ($sysconfig == 4))
    echo '<a href="mimo.php">MIMO</a>';
  echo '<a href="ftp.php">FTP/Config File Mgmt</a>
          <a href="upgrade.php">Software Upgrade</a>
          <a href="switch_upgrade.php">Switch Software Mgmt</a>
          <a href="fpga_upgrade.php">FPGA Mgmt</a>
          <a href="password.php">Password</a>
        </div></div>';

  echo '</td>';
  
  
  echo '<td style="border-bottom: solid 3px #555;width: 40px;"><input type="image" src="../images/reload.png" onclick="window.location.href = window.location.href;"></td>';
  echo '<td style="border-bottom: solid 3px #555;width: 40px;"><a href="../dashboard.php"><img title="Home" src="../images/home.gif" /></a></td></tr>';

  echo '<tr><td colspan="2" height="10"></td></tr>';
}

function display_test_menu_status()
{
  echo '<tr><td>';
  echo '<table align="center" valign="top" border="0" bgcolor="#f2f2f2" width="80%" height="100%" cellspacing="0" cellpadding="0">';

  echo '<tr height="10"><td style="border-bottom: solid 3px #555;"> &nbsp;<img alt="logo" src="/services/get.device-logo.php"></td>';

  echo '<td align="center" colspan="2">';
  echo '<div id="cssmenu">
  <ul>
   <li><a href="link_setup.php">Link</a></li>';
   echo '<li><a href="loopback.php">Diagnostics</a></li>
   <li><a href="threshold.php">Advanced</a></li>	
  </ul></div>';
  echo '</td>
  <td style="border-bottom: solid 3px #555;width: 40px;"><input type="image" src="../images/reload.png" onclick="window.location.href = window.location.href;"></td>
	<td style="border-bottom: solid 3px #555;width: 40px;"><a href="../dashboard.php"><img title="Home" src="../images/home.gif" /></a></td></tr>';

  echo '<tr><td colspan="2" height="10"></td></tr>';
}

function display_test_menu_statistics()
{
  echo '<tr><td>';
  echo '<table align="center" valign="top" border="0" bgcolor="#f2f2f2" width="80%" height="100%" cellspacing="0" cellpadding="0">';

  echo '<tr height="10"><td style="border-bottom: solid 3px #555;"> &nbsp;<img alt="logo" src="/services/get.device-logo.php"></td>';
  echo '<td align="center" colspan="2">';
  echo '<div id="cssmenu">
  <ul>
   <li><a href="link_setup.php">Link</a></li>';
   echo '<li><a href="loopback.php">Diagnostics</a></li>
   <li><a href="threshold.php">Advanced</a></li>
  </ul></div>';
  echo '</td>
  <td style="border-bottom: solid 3px #555;width: 40px;"><input type="image" src="../images/reload.png" onclick="window.location.href = window.location.href;"></td>
	<td style="border-bottom: solid 3px #555;width: 40px;"><a href="../dashboard.php"><img title="Home" src="../images/home.gif" /></a></td></tr>';

  echo '<tr><td colspan="2" height="10"></td></tr>';
}

function display_test_menu_diagnostics()
{
  global $sysconfig, $isSubscriptonLicenseEnabled;
  echo '<tr><td>';
  echo '<table align="center" valign="top" border="0" bgcolor="#f2f2f2" width="80%" height="100%" cellspacing="0" cellpadding="0">';

  echo '<tr height="10" bgcolor=#ffffff><td style="border-bottom: solid 3px #555;"> &nbsp;';
  echo '<img alt="logo" src="/services/get.device-logo.php"></td>';

  echo '<td align="left" colspan="2" style="border-bottom: solid 3px #555;">';


  echo '<div class="dropdown">
        <button class="dropbtn">Link</button>
        <div class="dropdown-content">
          <a href="link_setup.php">Link</a>
          <a href="mgmt.php">Management</a>
          <a href="eth_setting.php">Ports</a>
          <a href="sys_general.php">General</a>
        </div></div>';
  echo '<div class="dropdown">
        <button class="dropbtn-active">Diagnostics</button>
        <div class="dropdown-content">
          <a href="syslog.php">Syslog</a>
        </div></div>';
  echo '<div class="dropdown">
        <button class="dropbtn">Advanced</button>
        <div class="dropdown-content">
          <a href="threshold.php">Threshold</a>
          <a href="atpc.php">ATPC</a>
          <a href="snmp.php">SNMP</a>
           <a href="license.php">License Keys</a>';
  if ($isSubscriptonLicenseEnabled) echo '<a href="subscription.php">License Subscription</a>';
  if(($sysconfig == 3) || ($sysconfig == 4))
    echo '<a href="mimo.php">MIMO</a>';
  echo '<a href="ftp.php">FTP/Config File Mgmt</a>
          <a href="upgrade.php">Software Upgrade</a>
          <a href="switch_upgrade.php">Switch Software Mgmt</a>
          <a href="fpga_upgrade.php">FPGA Mgmt</a>
          <a href="password.php">Password</a>
        </div></div>';

  echo '</td>
  <td style="border-bottom: solid 3px #555;width: 40px;"><input type="image" src="../images/reload.png" onclick="window.location.href = window.location.href;"></td>
	<td style="border-bottom: solid 3px #555;width: 40px;"><a href="../dashboard.php"><img title="Home" src="../images/home.gif" /></a></td></tr>';

  echo '<tr><td colspan="2" height="10"></td></tr>';
}

function display_test_menu_advanced()
{
  global $sysconfig, $isSubscriptonLicenseEnabled;
  echo '<tr><td>';
  echo '<table align="center" valign="top" border="0" bgcolor="#f2f2f2" width="80%" height="100%" cellspacing="0" cellpadding="0">';

  echo '<tr height="10" bgcolor=#ffffff><td style="border-bottom: solid 3px #555;"> &nbsp;';
  echo '<img alt="logo" src="/services/get.device-logo.php"></td>';

  echo '<td align="left" colspan="2" style="border-bottom: solid 3px #555;">';


  echo '<div class="dropdown">
        <button class="dropbtn">Link</button>
        <div class="dropdown-content">
          <a href="link_setup.php">Link</a>
          <a href="mgmt.php">Management</a>
          <a href="eth_setting.php">Ports</a>
          <a href="sys_general.php">General</a>
        </div></div>';
  echo '<div class="dropdown">
        <button class="dropbtn">Diagnostics</button>
        <div class="dropdown-content">
          <a href="syslog.php">Syslog</a>
        </div></div>';
  echo '<div class="dropdown">
        <button class="dropbtn-active">Advanced</button>
        <div class="dropdown-content">
          <a href="threshold.php">Threshold</a>
          <a href="atpc.php">ATPC</a>
          <a href="snmp.php">SNMP</a>
           <a href="license.php">License Keys</a>';
          if ($isSubscriptonLicenseEnabled) echo '<a href="subscription.php">License Subscription</a>';
  if(($sysconfig == 3) || ($sysconfig == 4))
    echo '<a href="mimo.php">MIMO</a>';
  echo '<a href="ftp.php">FTP/Config File Mgmt</a>
          <a href="upgrade.php">Software Upgrade</a>
          <a href="switch_upgrade.php">Switch Software Mgmt</a>
          <a href="fpga_upgrade.php">FPGA Mgmt</a>
          <a href="password.php">Password</a>
        </div></div>';

  echo '</td>
  <td style="border-bottom: solid 3px #555;width: 40px;"><input type="image" src="../images/reload.png" onclick="window.location.href = window.location.href;"></td>
	<td style="border-bottom: solid 3px #555;width: 40px;"><a href="../dashboard.php"><img title="Home" src="../images/home.gif" /></a></td></tr>';

  echo '<tr><td colspan="2" height="10"></td></tr>';
}

function display_main_content()
{
  echo '<td valign="top" align="center">
        <table width="100%" border="0" bgcolor=#e6e6e6 align="center" cellspacing="0" cellpadding="0">
        <tr height="10"><td></td></tr>
        </tr>
        </table>';
        
  echo '<table width="85%" border="0" align="center">
        <tr height="15"><td></td></tr>
        </tr>
        </table>';
}

function display_list_basic($val) // to be removed
{
echo '<tr><td>';
	  
echo '<table width="100%" height="100%" border="0" align="center">
      <tr><td height="15%"></td></tr>';
       /*<td valign="top" align="center" height="150" width="130">
      
         <div class="right-block">
    	  <ul id="nav">
	     <li class="link"><a href="link_setup.php"> Link </a></li>
	     <li class="mgmt"><a href="mgmt.php"> Management </a></li>
             <li class="eth"><a href="eth_setting.php"> Ports </a></li>
	     <li class="sysgeneral"><a href="sys_general.php">General</a></li>
	  </ul>
         </div>
       </td>*/
		 
  echo '<tr><td valign="top" height="5%">';
  if($val == 1)
    echo '<form action="../radio_info.php"> ';
  elseif($val == 2)
    echo '<form action="../eth_info.php"> ';
  elseif($val == 3)
    echo '<form action="../general_info.php"> ';

  echo '<div align="center">
              <input style="white-space:normal;" type="submit" class="submit_button" value="View Mode">
                      </div>
           </form>';
  echo '</td>
      </tr>';

  echo '<tr><td valign="top">';
  echo '<form> ';
  echo '<div align="center">
              <input style="white-space:normal;background:#555;color:#fff" type="submit" class="submit_button" value="Config Mode" disabled="disabled">
                      </div>
           </form>';
  echo '</td>
      </tr>';
echo '</table></td>';
echo '<td valign="top" align="left">';
}

function display_list_status()
{
	global $config_option_oid, $reboot_oid;
echo '<tr><td>';

echo '<table width="100%" height="100%" border="0" align="center">
      <tr>
       <td valign="top" align="center" height="150" width="130">
      
         <div class="right-block">
    	  <ul id="nav">
     	   <li class="version"><a href="version.php">Version</a></li>
     	   <li class="status"><a href="link_status.php">Link Status</a></li> 
	  </ul>
         </div>
       </td>
      </tr>';

  echo '<tr><td valign="top">';
  echo '<form action="../radio_info.php"> ';
  echo '<div align="center">
        <input style="white-space:normal;" type="submit" class="submit_button" value="View Mode">
        </div>
        </form>';
  echo '</td></tr>';
  
  echo '<p>';
  echo '<div id="input-text">';

  $config_info = "/mnt/usrcfg/config.bin";
echo    '</td>
         </tr> 
         </table>	
         </td>';

echo '<td style="display: flex; flex-direction: column;" valign="top" align="center">';
}

function display_list_statistics()
{
	global $config_option_oid, $reboot_oid;
echo '<tr><td>';
	  
echo '<table width="100%" height="100%" border="0" align="center">
      <tr>
       <td valign="top" align="center" height="150">
        <div class="right-block">
    	  <ul id="nav">
             <li class="ethstatus"><a href="port_stat.php">Eth Stats</a></li>
			 <li class="ethcounter"><a href="qos_rf_stat.php">QoS/RF Stats</a></li>
 	  	  </ul>
         </div>
       </td>
      </tr>';

  echo '<tr><td valign="top">';
  echo '<form action="../radio_info.php"> ';
  echo '<div align="center">
        <input style="white-space:normal;" type="submit" class="submit_button" value="View Mode">
        </div>
        </form>';
  echo '</td></tr>';

  echo '<p>';
  echo '<div id="input-text">';

  $config_info = "/mnt/usrcfg/config.bin";
echo    '</td>
         </tr> 
         </table>	
         </td>';

echo '<td style="display: flex; flex-direction: column;" valign="top" align="center">';
}



function display_list_diagnostics()
{
  echo '<tr><td>';

  echo '<table width="100%" height="100%" border="0" align="center">
      <tr><td height="15%"></td></tr>';

  echo '<tr><td valign="top" height="5%">';
  echo '<form action="../syslog.php"> ';
  echo '<div align="center">
              <input style="white-space:normal;" type="submit" class="submit_button" value="View Mode">
                      </div>
           </form>';
  echo '</td></tr>';
  echo '<tr><td valign="top">';
  echo '<form> ';
  echo '<div align="center">
              <input style="white-space:normal;background:#555;color:#fff;" type="submit" class="submit_button" value="Config Mode" disabled="disabled">
                      </div>
           </form>';
  echo '</td></tr>';
  echo '</table>	
         </td>';

echo '<td valign="top" align="left">';
}

function display_list_survey()
{
	global $config_option_oid, $reboot_oid;
echo '<tr><td>';

echo '<table width="100%" height="100%" border="0" align="center">
      <tr>
       <td valign="top" align="center" height="200">
        <div class="right-block">
    	  <ul id="nav">
<!--		      <li class="survey"><a href="survey.php">Survey</a></li> -->
			  <li class="rssi"><a href="rssi_monitor.php">Plots</a></li>
 	  	  </ul>
         </div>
       </td>
      </tr>';

  echo '<tr><td valign="top">';
  echo '<form action="../radio_info.php"> ';
  echo '<div align="center">
        <input style="white-space:normal;" type="submit" class="submit_button" value="View Mode">
        </div>
        </form>';
  echo '</td></tr>';

  echo '<p>';
  echo '<div id="input-text">';

  $config_info = "/mnt/usrcfg/config.bin";
echo    '</td>
         </tr> 
         </table>	
         </td>';

echo '<td style="display: flex; flex-direction: column;" valign="top" align="center">';
}

function display_local_remote_option($title, $local_page, $remote_page)
{
  echo '<td valign="top">
        <table width="85%" border="1" align="center">
        <tr height="20"><td></td></tr>
        <tr>
        <td width="10"> </td>
        <td width="60%"> <div id="left-heading">' .$title . '</div> </td>
        <td align="right"> <p>
        </td>
        </tr>
        </table>';
}

function display_page_subtitle($title)
{
  echo '<td nowrap="nowrap" bgcolor=#f2f2f2 align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#00478F><b>' . $title . '</b></font></td>';
  //echo '<fieldset>
  //      <legend>' . $title . '</legend>';
}

function enclose_page_subtitle()
{
  echo '</fieldset>';
}

function display_subtitle($title)
{
  echo '<td nowrap="nowrap" bgcolor=#f2f2f2 align="left" colspan="2"><font face="Verdana, sans-serif" size="2" color=#00478F><b>' . $title . '</b></font></td>';
}

function display_title($title)
{
  echo '<td nowrap="nowrap" align="left" colspan="2"><font face="Calibri" size="4" color=#000000><b>' . $title . '</b></font></td>';
}

function display_none_shaded_row()
{
  echo '<tr height="25">';
}

function display_shaded_row()
{
  echo '<tr height="21" bgcolor="#FFFFFF">';
}

function display_center_parameter_name($name)
{
  echo '<td width="20%" bgcolor="f2f2f2" nowrap="nowrap"> <div id = "left-title">' . $name . '</div> </td>';
  //display_block_column();  
}

function display_note_section($text)
{
  echo '<td><div id="left-text"> ' . $text . ' </div></td>';		
  /*echo '<td valign="top" bgcolor="#f2f2f2">
        <table width="100%" border="0" align="center">
        <tr height="5"><td></td></tr>
        <tr> <td><div id="left-text"> ' .$text . ' </div></td> </tr>
        </table></td>';*/
}

function display_parameter_name_width($name, $width)
{
  echo '<td nowrap="nowrap" bgcolor=#f2f2f2 align="left" style="width:' . $width .';" > <div id = "left-title">' . $name . '</div> </td>';
}

function display_parameter_name($name, $elementId="")
{
  echo '<td width="20%" bgcolor="#f2f2f2" nowrap="nowrap"> <div id = "left-title">' . $name . '</div> </td>';
}

function display_tdm_port_name($name)
{
  echo '<td width=20%> <div id = "center-title">' . $name . '</div> </td>';
}

function display_tdm_port_name_small($name)
{
  echo '<td width=12%> <div id = "center-title">' . $name . '</div> </td>';
}

function display_center_label($name)
{
  echo '<td bgcolor=#f2f2f2> <div id = "center-title">' . $name . '</div> </td>';
}

function display_left_label($name)
{
  echo '<td bgcolor="#f2f2f2"><div id = "left-title">' . $name . '</div></td>';
}
function display_right_label($name)
{
  echo '<td bgcolor="#f2f2f2"> <div id = "right-title">' . $name . '</div> </td>';
}

function display_simple_text_left_width($text)              
{                                                      
  echo '<td width="38%"> <div id="left-text">' . $text . '</div></td>';
}

function display_simple_text_left($text)                               
{                                                                      
  echo '<td> <div id="left-text">' . $text . '</div></td>';            
}                                                                      

function display_simple_text($text)                               
{                                                                      
  echo '<td bgcolor="#f2f2f2"> <div id="input-text"><font size="2">' . $text . '</font></div></td>';            
}                                                                      
       
function display_capacity()
{
  global $localhost, $read_str, $speed_mod_max_oid;	

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  
  $trimed = trim($ret, "\"");
  
  echo '<td width="20%" bgcolor="#f2f2f2" nowrap="nowrap"> <div id="left-text">';
  if($trimed == 0)
	    echo 137.00;
  else if($trimed == 1)
        echo 207.00;
  else if($trimed == 2)
	    echo 276.00;
  else if($trimed == 3)
	    echo 343.00;
  else if($trimed == 4)
	    echo 419.00;
  else if($trimed == 5)
	    echo 488.00;
  else if($trimed == 6)
	    echo 572.00;
  else if($trimed == 7)
	    echo 631.00;		
  else 
	    echo 716.00;	
  
  echo '</div></td>';
}
       
function display_select_enable_option($setting, $oid)
{
  global $localhost, $read_str;

  echo '<td align="left"> <div id="input-text">';
  echo '<select name="' . $setting . '">';
  echo '<option id="' . $setting . '_0" value="0">Disable</option>';
  echo '<option id="' . $setting . '_1" value="1">Enable</option>';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");
  $str = sprintf('document.getElementById("$setting_%d").selected=true;', $trimed);

  echo '<script language = "JavaScript">';
  echo $str;
  echo '</script>';
  echo '</td>';
}

function display_select_duplex_option($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td> <div id="input-text">';
  echo '<select name="' . $setting . '">';
  echo '<option id="' . $setting . '_0" value="0">Half</option>';
  echo '<option id="' . $setting . '_1" value="1">Full</option>';
  echo '</select>';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($_POST[$setting] != NULL) {
    if ( $_POST[$setting] != $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0); 
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){  
        echo '<script language = "JavaScript">';
        echo 'alert(\'Setting Error:  ' . $setting . ' \');';
        echo '</script>';
      }
    }
  }

  $result = sprintf('document.getElementById("%s_%d").selected=true;', $setting, $trimed);
  echo '<script language = "JavaScript">';
  echo $result;
  echo '</script>';
  echo '</td>';
}

function display_select_speed_option($setting, $oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';
  echo '<select name="' . $setting . '">';
  echo '<option id="' . $setting . '_10" value="10">10</option>';
  echo '<option id="' . $setting . '_100" value="100">100</option>';
  echo '<option id="' . $setting . '_1000" value="1000">1000</option>';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");
  $str = sprintf('document.getElementById("$setting_%d").selected=true;', $trimed);

  echo '<script language = "JavaScript">';
  echo $str;
  echo '</script>';
  echo '</td>';
}

function display_select_priority_option($setting, $oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';
  echo '<select name="' . $setting . '">';
  echo '<option id="' . $setting . '_0" value="0">0</option>';
  echo '<option id="' . $setting . '_1" value="1">1</option>';
  echo '<option id="' . $setting . '_2" value="2">2</option>';
  echo '<option id="' . $setting . '_3" value="3">3</option>';
  echo '<option id="' . $setting . '_4" value="4">4</option>';
  echo '<option id="' . $setting . '_5" value="5">5</option>';
  echo '<option id="' . $setting . '_6" value="6">6</option>';
  echo '<option id="' . $setting . '_7" value="7">7</option>';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");
  $str = sprintf('document.getElementById("$setting_%d").selected=true;', $trimed);

  echo '<script language = "JavaScript">';
  echo $str;
  echo '</script>';
  echo '</td>';
}

function display_iduled($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td>  <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($_POST[$setting] != NULL) {
    if ( $_POST[$setting] !=  $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0); 
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){  
        echo '<script language = "JavaScript">';
        echo 'alert(\'Setting Error:  ' . $setting . ' \');';
        echo '</script>';
      }
    }
  }

  if ($trimed == 1){
    echo '<input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED> TDM status </input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"> RSSI </input>';
  }
  else {
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"> TDM Status </input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED> RSSI </input>';
  }
  echo '</td>';
}

function display_radio_failover_mode($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td>  <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($_POST[$setting] != NULL) {
    if ( $_POST[$setting] !=  $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0); 
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){  
        echo '<script language = "JavaScript">';
        echo 'alert(\'Setting Error:  ' . $setting . ' \');';
        echo '</script>';
      }
    }
  }
  
  if ($trimed == 2){
    echo '<div align="left">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable_on" value="2" CHECKED> ON (port on)</input>';
    echo '<input type="radio" name="' .  $setting . '" id="' . $setting . '_enable_off" value="1"> ON (port off)</input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"> OFF </input>';
  }
  else if ($trimed == 1){
    echo '<div align="left">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable_on" value="2"> ON (port on)</input>';
    echo '<input type="radio" name="' .  $setting . '" id="' . $setting . '_enable_off" value="1" CHECKED> ON (port off)</input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_off" value="0"> OFF </input>';
  }
  else {
    echo '<div align="left">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable_on" value="2"> ON (port on)</input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_enable_off" value="1"> ON (port off)</input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED> OFF </input>';
  }
  echo '</td>';
}

function display_radio_on_off_left($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td bgcolor="#f2f2f2">  <div id="left-text"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if (isset($_POST[$setting]) && $_POST[$setting] != NULL) {
    if ( $_POST[$setting] !=  $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0);
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");
      
      if ($set != 1) {
        $filename = "/tmp/snmp.error";
        $handle = fopen($filename, "r");
        $error_code = fread($handle, filesize($filename));
        unlink($filename);
        echo '<script language = "JavaScript">';
        echo 'alert("' . $error_code . ' Parameter: ' . $setting . '");';
        echo '</script>';
      }
      
      // If SNMP set fails, read error from /tmp/snmp.error if available
      if ($set != 1) {
        $filename = "/tmp/snmp.error";
        if (file_exists($filename)) {
          $filesize = filesize($filename);
          if ($filesize > 0) {
            $handle = fopen($filename, "r");
            $error_code = fread($handle, $filesize);
            fclose($handle);
          } else {
            // If file is empty, provide a default error message
            $error_code = "No error message (file was empty).";
          }
          unlink($filename);
        } else {
          // Fallback if file doesn't exist
          $error_code = "Unknown SNMP error (/tmp/snmp.error not found).";
        }
        
        echo '<script language="JavaScript">';
        echo 'alert("' . addslashes($error_code) . ' Parameter: ' . addslashes($setting) . '");';
        echo '</script>';
      }
      
      
      
    }
  }
  if ($trimed == 1){
    echo '<div align="left" class="radio">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED><label for="' . $setting . '_enable">On </label></input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"><label for="' . $setting . '_disable">Off </label></input>';
  }
  else {
    echo '<div align="left" class="radio">
          <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"><label for="' . $setting . '_enable">On </label></input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED><label for="' . $setting . '_disable">Off </label></input>';
  }
  echo '</td>';
}
  
  function display_radio_on_off_left_submit($setting, $oid)
  {
    global $localhost, $read_str, $write_str;
    
    echo '<td bgcolor="#f2f2f2">  <div id="left-text"><font size="2">';
    
    $ret = getSnmpResult($oid);
    $ret = preg_replace("/(INTEGER:)/", "", $ret);
    $trimed = trim($ret, "\"");
    
    if (isset($_POST[$setting]) && $_POST[$setting] != NULL) {
      if ($_POST[$setting] != $trimed) {
        $set = setSnmp($oid, "i", $_POST[$setting], 60000000, 0);
        $ret = getSnmpResult($oid);
        $ret = preg_replace("/(INTEGER:)/", "", $ret);
        $trimed = trim($ret, "\"");
        
        if ($set != 1) {
          $filename = "/tmp/snmp.error";
          $handle = fopen($filename, "r");
          $error_code = fread($handle, filesize($filename));
          
          unlink($filename);
          
          echo '<script language = "JavaScript">';
          echo 'alert("' . $error_code . ' Parameter: ' . $setting . '");';
          echo '</script>';
          
        }
      }
    }
    
    echo '<div align="left" class="radio">';
    if ($trimed == 1) {
      echo '<input type="radio" name="' . $setting . '" id="' . $setting . '_enable" value="1" CHECKED onclick="this.form.submit();"><label for="' . $setting . '_enable">On </label>';
      echo '<input type="radio" name="' . $setting . '" id="' . $setting . '_disable" value="0" onclick="this.form.submit();"><label for="' . $setting . '_disable">Off </label>';
    } else {
      echo '<input type="radio" name="' . $setting . '" id="' . $setting . '_enable" value="1" onclick="this.form.submit();"><label for="' . $setting . '_enable">On </label>';
      echo '<input type="radio" name="' . $setting . '" id="' . $setting . '_disable" value="0" CHECKED onclick="this.form.submit();"><label for="' . $setting . '_disable">Off </label>';
    }
    echo '</div>';
    echo '</td>';
  }

function display_radio_polarization_left($setting, $oid)
{
    echo '<td bgcolor="#f2f2f2" width="40%">  <div id="left-text"><font size="2">';
    
    $ret = getSnmpResult( $oid);
    $ret = preg_replace("/(INTEGER:)/", "", $ret);
    $trimed = trim($ret, "\"");
    
    if (isset($_POST[$setting]) && $_POST[$setting] != NULL) {
        if ( $_POST[$setting] !=  $trimed) {
            $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0);
            $ret = getSnmpResult( $oid);
            $ret = preg_replace("/(INTEGER:)/", "", $ret);
            $trimed = trim($ret, "\"");
            
            if ($set != 1){
                echo '<script language = "JavaScript">';
                echo 'alert(\'Setting Error:  ' . $setting . ' \');';
                echo '</script>';
            }
        }
    }
    if ($trimed == 1){
        echo '<div align="left" class="radio"> <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED><label for="' . $setting . '_enable">Horizontal </label></input>';
        echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"><label for="' . $setting . '_disable">Vertical </label></input>';
    }
    else {
        echo '<div align="left" class="radio"> <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"><label for="' . $setting . '_enable">Horizontal </label></input>';
        echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED><label for="' . $setting . '_disable">Vertical </label></input>';
    }
    echo '</td>';
}
  function display_radio_polarization_left_submit($setting, $oid)
  {
    echo '<td bgcolor="#f2f2f2" width="40%">  <div id="left-text"><font size="2">';
    
    $ret = getSnmpResult( $oid);
    $ret = preg_replace("/(INTEGER:)/", "", $ret);
    $trimed = trim($ret, "\"");
    
    if (isset($_POST[$setting]) && $_POST[$setting] != NULL) {
      if ( $_POST[$setting] !=  $trimed) {
        $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0);
        $ret = getSnmpResult( $oid);
        $ret = preg_replace("/(INTEGER:)/", "", $ret);
        $trimed = trim($ret, "\"");
        
        if ($set != 1) {
          $filename = "/tmp/snmp.error";
          $handle = fopen($filename, "r");
          $error_code = fread($handle, filesize($filename));
          
          unlink($filename);
          
          echo '<script language = "JavaScript">';
          echo 'alert("' . $error_code . ' Parameter: ' . $setting . '");';
          echo '</script>';
        }
      }
    }
    if ($trimed == 1){
      echo '<div align="left" class="radio"> <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED onclick="alertPolarization();this.form.submit();"><label for="' . $setting . '_enable">Horizontal </label></input>';
      echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" onclick="alertPolarization();this.form.submit();"><label for="' . $setting . '_disable">Vertical </label></input>';
    }
    else {
      echo '<div align="left" class="radio"> <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1" onclick="alertPolarization();this.form.submit();"><label for="' . $setting . '_enable">Horizontal </label></input>';
      echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED onclick="alertPolarization();this.form.submit();"><label for="' . $setting . '_disable">Vertical </label></input>';
    }
    echo '</td>';
    
  }

function display_radio_on_off_left_cgi($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td bgcolor="#f2f2f2">  <div id="left-text"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($trimed == 1){
      echo '<div align="left" class="radio">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED><label for="' . $setting . '_enable">On </label></input>';
      echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"><label for="' . $setting . '_disable">Off </label></input>';
  }
  else {
      echo '<div align="left" class="radio">
          <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"><label for="' . $setting . '_enable">On </label></input>';
      echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED><label for="' . $setting . '_disable">Off </label></input>';
  }
  echo '</td>';
}

function display_radio_snmpdver_left($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td bgcolor="#f2f2f2">  <div id="left-text"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if (isset($_POST[$setting]) && $_POST[$setting] != NULL) {
    if ( $_POST[$setting] !=  $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$setting], 50000000, 0); 
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){  
        echo '<script language = "JavaScript">';
        echo 'alert(\'Setting Error:  ' . $setting . ' \');';
        echo '</script>';
      }
    }
  }
  if ($trimed == 1 || $trimed == 3){
    echo '<div align="left" class="radio">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED><label for="' . $setting . '_enable"> v3 </label></input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"><label for="' . $setting . '_disable"> v2c </label></input>';
  }
  else {
    echo '<div align="left" class="radio">
          <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"><label for="' . $setting . '_enable">v3 </label></input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED><label for="' . $setting . '_disable">v2c </label></input>';
  }
  echo '</td>';
}

function display_radio_ibm_port($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td bgcolor="#f2f2f2">  <div id="left-text"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($_POST[$setting] != NULL) {
    if ( $_POST[$setting] !=  $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0); 
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){  
        echo '<script language = "JavaScript">';
        echo 'alert(\'Setting Error:  ' . $setting . ' \');';
        echo '</script>';
      }
    }
  }
  if ($trimed == 1){
    echo '<div align="left">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED> GE1 </input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="2"> GE2 </input>';
  }
  else {
    echo '<div align="left">
          <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"> GE1 </input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="2" CHECKED> GE2 </input>';
  }
  echo '</td>';
}

function display_radio_disable_enable_left($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td>  <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($_POST[$setting] != NULL) {
    if ( $_POST[$setting] !=  $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0);
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){
        echo '<script language = "JavaScript">';
        echo 'alert(\'Setting Error:  ' . $setting . ' \');';
        echo '</script>';
      }
    }
  }

  if ($trimed == 1){
    echo '<div align="left">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED> Enable </input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"> Disable </input>';
  }
  else {
    echo '<div align="left">
          <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"> Enable </input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED> Disable </input>';
  }
  echo '</td>';
}

function display_radio_add_remove_left($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td>  <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0);
  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($_POST[$setting] != NULL) {
    if ($set != 1){  
      $filename = "/tmp/snmp.error";
      $handle = fopen($filename, "r");
      $error_code = fread($handle, filesize($filename));

      unlink($filename);

      echo '<script language = "JavaScript">';
      echo 'alert(\'' . $param . ' ' . $error_code . ' \');';
      echo '</script>';
    }
  }

  if ($trimed == 1){
    echo '<div align="left">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED> Add </input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"> Remove </input>';
  }
  else {
    echo '<div align="left">
          <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"> Add </input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED> Remove </input>';
  }

  echo '</td>';
}


function display_radio_on_off($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td bgcolor="#f2f2f2">  <div id="input-text" class="radio"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($_POST[$setting] != NULL) {
    if ( $_POST[$setting] !=  $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$setting], 60000000, 0); 
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){  
        echo '<script language = "JavaScript">';
        echo 'alert(\'Setting Error:  ' . $setting . ' \');';
        echo '</script>';
      }
    }
  }

  if ($trimed == 1){
    echo '<input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED><label for="' . $setting . '_enable"> On </label></input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"><label for="' . $setting . '_disable"> Off </label></input>';
  }
  else {
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"><label for="' . $setting . '_enable"> On </label></input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED><label for="' . $setting . '_disable"> Off </label></input>';
  }
  echo '</font></div></td>';
}

function display_submit_button($value)
{
  echo '<td height="25">
        <div align="center"> <input type ="submit" name="radio_submit" class="submit_button"
        value="' . $value . '"> </div></td>';
}

function display_submit_button_app($value, $oid)
{
  echo '<tr><td colspan="10" height=30">
        <div align="center"> <input type ="submit" name="radio_submit" class="submit_button"
        value="' . $value . '"> </div></td></tr>';
}


function display_two_submit_button($name1, $name2)
{
  echo '<table width="85%" border="0" align="center">
        <tr height="35" align="center">
          <div align="center"> 
          <td><input type ="submit" name="radio_submit" class="submit_button" value="' . $name1 . '"> </td>
          <td><input type ="submit" name="radio_submit" class="submit_button" value="' . $name2 . '"> </td>
          </div>
        </tr>';
  echo '</table>';
}

function display_table_submit_button($value)
{
  echo '<table width="85%" border="0" align="center">
        <tr height="35" align="center"><td>
          <input type ="submit" name="radio_submit" class="submit_button" value="' . $value . '"> </td>
        </tr>';
  echo '</table>';
}

function display_eth_duplex($oid)
{
  global $localhost, $read_str;

  echo '<td bgcolor="#f2f2f2"><div id="input-text"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1) 
    echo "Full";
  else
    echo "Half";

  echo '</div> </td>';
}

function display_eth_port_name($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1) 
    echo "GE 1";
  else if ($ret == 2) 
    echo "GE 2";
  else if ($ret == 3) 
    echo "GE 3";
  else if ($ret == 4) 
    echo "GE 4";
  else
    echo "N/A";

  echo '</div> </td>';
}

function display_speed_modulation($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
 
  if ($ret == 0)
    echo "QPSK";
  else if ($ret == 1)
    echo "QAM16";
  else if ($ret == 2)
    echo "QAM32";
  else if ($ret == 3)
    echo "QAM64";
  else if ($ret == 4)
    echo "QAM128";
  else if ($ret == 5)
    echo "QAM256";
  else
    echo "N/A";

  echo '</div> </td>';
}

function display_tdm_coding($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 0)
    echo "AMI";
  else if ($ret == 1)
    echo "B8ZS";
  else if ($ret == 2)
    echo "HDB3";
  else
    echo "N/A";

  echo '</div> </td>';
}

function display_tdm_mode($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 0)
    echo "T1";
  else if ($ret == 1)
    echo "E1";
  else if ($ret == 2)
    echo "Eth only";
  else 
    echo "N/A";

  echo '</div> </td>';
}

function display_protection($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 2)
    echo "Protection";
  else 
    echo "Working";

  echo '</div> </td>';
}

function display_datapattern($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1)
    echo "Internal";
  else if ($ret == 0)
    echo "External";
  else 
    echo "N/A";

  echo '</div> </td>';
}

function display_fanctrl_status($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1)
    echo "Fan On";
  else 
    echo "Fans Off";

  echo '</div> </td>';
}

function display_refresh_status($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1)
    echo "Enable";
  else 
    echo "Disable";

  echo '</div> </td>';
}

function display_on_off($oid, $position)
{
  global $localhost, $read_str;

  if ($position == 0)
    echo '<td bgcolor="#f2f2f2"> <div id="left-text"><font size="2">';
  else if ($position == 1)
    echo '<td bgcolor="#f2f2f2"> <div id="input-text"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1)
    echo "On";
  else if ($ret == 0)
    echo "Off";
  else 
    echo "RPS-Off";

  echo '</div> </td>';
}

function display_tdm_on_off($oid, $position)
{
  global $localhost, $read_str;
  
  if ($position == 0)
    echo '<td> <div id="left-text">';
  else if ($position == 1)
    echo '<td> <div id="input-text">';
              
  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
                  
  if ($ret == 0)
    echo "ON";
  else if ($ret == 1)
    echo "OFF";
  else
    echo "RPS-OFF";
                                   
  echo '</div> </td>';
}

function display_left_enable($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1)
    echo "Enabled";
  else
    echo "Disabled";

  echo '</div> </td>';
}

function display_enable($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1)
    echo "Enabled";
  else
    echo "Disabled";

  echo '</div> </td>';
}

function display_sync_text($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  if ($ret == 1)
    echo "Synchronized";
  else
    echo "Not synchronized";

  echo '</div> </td>';
}

/*function display_system_uptime()
{
  global $localhost, $read_str;

  echo '<td> <div id="left-text">';

  system("uptime");
  
  echo '</div></td>';
}*/

function display_date()
{
  echo '<td bgcolor=#f2f2f2 nowrap="nowrap"> <div id="left-text">';
  //echo date("Y-m-d");
  system("date > date.txt");
  echo file_get_contents("date.txt");
  /*$file = fopen("date.txt","r");
  $str = fgets($file);
  fclose($file);
  $char = preg_split('/ /', $str);
  echo $char[0] . ' ' . $char[1] . ' ' . $char[2] . ' ' . $char[5] . ' ' . $char[3];*/
  system("rm date.txt");
  echo '</td>';
}

function display_system_uptime()
{
  global $localhost, $read_str;

  echo '<td bgcolor="#f2f2f2"> <div id="left-text">';

  file_put_contents("time.txt",exec("uptime"));
  $time = file_get_contents("time.txt");
  $str = strstr($time, "up");
  $i = 0;
  while($str[$i] != ',')
  {
    echo $str[$i];
    $i++;
  }
  system("rm time.txt");
  /*$file = fopen("time.txt", "r");
  fgetc($file);
  $ch = fgetc($file);
  while($ch != ','){
  	echo $ch; 
	$ch = fgetc($file);
  } 
  fclose($file);*/
  echo '</div></td>';
}

function display_left_text($oid)
{
  global $localhost, $read_str, $freq_license_oid, $encrypt_key_oid, $enc_license_enable_oid, 
  	 $ce_license_oid, $dual_license_oid;

  echo '<td bgcolor="#f2f2f2"> <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $ret = preg_replace("/(IpAddress:)/", "", $ret);
  $ret = preg_replace("/(STRING: )/", "", $ret);
  $ret = preg_replace("/(Counter32: )/", "", $ret);
  $ret = preg_replace("/(Timeticks: )/", "", $ret);

  $trimed = trim($ret, "\"");

  if ( strcmp($oid, $freq_license_oid) == 0) {
    if ($trimed == 5){
      echo 'Speed 300 license enabled';
    }
	else if($trimed == 6)
	  echo 'Speed 400 license enabled';
	else if($trimed == 7)
	  echo 'Maximum capacity license enabled';
    else {
      echo 'No License enabled';
    }
  }
  else if(strcmp($oid, $encrypt_key_oid) == 0)
  {
    $i = 0;
    while($i < strlen($trimed))
    {
      echo '*';
      $i++;
    }
  }
  else if(strcmp($oid, $enc_license_enable_oid) == 0){
        if($trimed == 0)
          echo 'No encryption license enabled';
        else if($trimed == 1)
          echo 'Enryption license enabled';
  }
  else if(strcmp($oid, $ce_license_oid) == 0){
        if($trimed == 0)
          echo 'No CE service license enabled';
        else if($trimed == 1)
          echo 'CE service license enabled';
  }
  else if(strcmp($oid, $dual_license_oid) == 0){
        if($trimed == 0)
          echo 'No Dual core license enabled';
        else if($trimed == 1)
          echo 'Dual core license enabled';
        else if($trimed == 2)
          echo 'Not applicable in license server mode';
  }
  else {
    echo $trimed;
  }

  echo '</div></td>';
}

function display_left_enc_license($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  $trimed = trim($ret, "\"");

  if ($trimed  == 1){
    echo 'Standard encryption';
  }
  else {
    echo 'Suite-B encryption';
  }

  //echo '</div></td>';
}

function display_uptime_text($oid)
{
  global $localhost, $read_str;

  echo '<td> <div id="left-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(Timeticks: )/", "", $ret);
  $ret = preg_replace("[()]", "", $ret);       
  $ret = preg_replace("([0-9]{3})", "", $ret);             

  $trimed = trim($ret, "\"");
  echo $trimed;

  echo '</div></td>';
}

function display_text_only($text, $position)
{
  global $localhost, $read_str;

  if ($position == 0)
    echo '<td bgcolor="#f2f2f2"> <div id="left-text"><font size="2">';
  else if ($position == 1)
    echo '<td bgcolor="#f2f2f2"> <div id="input-text"><font size="2">';

  echo $text;

  echo '</font></div></td>';
}

function display_text($oid)
{
  echo '<td width="20%" bgcolor="#f2f2f2" nowrap="nowrap"><div id="input-text"><font size="2">';

  $ret = getSnmpResult($oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $ret = preg_replace("/(IpAddress:)/", "", $ret);
  $ret = preg_replace("/(STRING: )/", "", $ret);
  $ret = preg_replace("/(Counter32: )/", "", $ret);
  $ret = preg_replace("/(Counter64: )/", "", $ret);

  $trimed = trim($ret, "\"");
  echo $trimed;

  echo '</font></div></td>';
}

function display_text_position($oid, $position)
{
  if($position == 1)
    echo '<td width="20%" bgcolor="#f2f2f2" nowrap="nowrap"> <div id="input-text"><font size="2">';
  else
    echo '<td width="20%" bgcolor="#f2f2f2" nowrap="nowrap"> <div id="left-text"><font size="2">';
	
  $ret = getSnmpResult($oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $ret = preg_replace("/(IpAddress:)/", "", $ret);
  $ret = preg_replace("/(STRING: )/", "", $ret);
  $ret = preg_replace("/(Counter32: )/", "", $ret);
  $ret = preg_replace("/(Counter64: )/", "", $ret);

  $trimed = trim($ret, "\"");
  echo $trimed;
  return $trimed;
  //echo '</div></td>';
}
function display_text_center($oid)
{
  global $localhost, $read_str, $rx_oid, $remote_rx_oid, $hc_stat_oid, $local_link, $loopback, $link_lock_oid, $remote_link_oid, $pla_status_oid, $acs_status_oid;
	
  echo '<td bgcolor="#f2f2f2"> <div id="input-text"><font size="2">';

  $ret = getSnmpResult( $link_lock_oid);
  $local_link = preg_replace("/(INTEGER:)/", "", $ret);
  
  $ret = getSnmpResult( $remote_link_oid);
  $remote_link = preg_replace("/(INTEGER:)/", "", $ret);

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $ret = preg_replace("/(IpAddress:)/", "", $ret);
  $ret = preg_replace("/(STRING: )/", "", $ret);
  $ret = preg_replace("/(Counter32: )/", "", $ret);
  $ret = preg_replace("/(Timeticks: )/", "", $ret);

  $trimed = trim($ret, "\"");
  
  if(strcmp($oid, $rx_oid) == 0){
	if (($local_link == 1) || ($loopback != 0)){
	  if($trimed == 0)
	    echo 'QPSK';
	  else if($trimed == 1)
	    echo '8PSK';
	  else if($trimed == 2)
	    echo 'QAM16';
	  else if($trimed == 3)
	    echo 'QAM32';
	  else if($trimed == 4)
	    echo 'QAM64';
	  else if($trimed == 5)
	    echo 'QAM128';
	  else if($trimed == 6)
	    echo 'QAM256';
	  else if($trimed == 7)
	    echo 'QAM512';		
	  else if($trimed == 8)
	    echo 'QAM1024';	
	  else
	    echo '<font face="Trebuchet MS, Arial, Helvetica" size="2">N/A</font>';	
    }
    else {
      echo '<font face="Trebuchet MS, Arial, Helvetica" size="2">N/A</font>';
    }
  }
  else if(strcmp($oid, $remote_rx_oid) == 0){
	if ($remote_link == 1){

     if ($loopback != 0){                                                
        echo '<font face="Trebuchet MS, Arial, Helvetica" size="2">N/A</font>';
     }                                                          
     else {
	  if($trimed == 0)
	    echo 'QPSK';
	  else if($trimed == 1)
	    echo '8PSK';
	  else if($trimed == 2)
	    echo 'QAM16';
	  else if($trimed == 3)
	    echo 'QAM32';
	  else if($trimed == 4)
	    echo 'QAM64';
	  else if($trimed == 5)
	    echo 'QAM128';
	  else if($trimed == 6)
	    echo 'QAM256';
	  else if($trimed == 7)
	    echo 'QAM512';		
	  else if($trimed == 8)
	    echo 'QAM1024';
	  else
	    echo '<font face="Trebuchet MS, Arial, Helvetica" size="2">N/A</font>';	
	 }
    }
    else {
      echo '<font face="Trebuchet MS, Arial, Helvetica" size="2">N/A</font>';
    }
  }
  else if(strcmp($oid, $hc_stat_oid) == 0){
        if($trimed == 0)
          echo 'Off';
        else
          echo 'On';
  }
  else if(strcmp($oid, $pla_status_oid) == 0){
	   if($trimed == 0)
	   	 echo 'Off';
	   else	if($trimed == 1)
	     echo 'On';
	   else if($trimed == 2)
	     echo 'On'; 	  
  }
  else if(strcmp($oid, $acs_status_oid) == 0){
	    if($trimed == 0)
		  echo 'Off';
		else if($trimed == 1)
		  echo 'On-ready';
		else if($trimed == 2)    
		  echo 'On-downshifted';
		else
		  echo 'N/A';  
  }
  else {
    echo $trimed;
  }
  echo '</td>';
}

function display_text_left($oid)
{
  global $localhost, $read_str, $speed_mod_oid, $failover_oid, $ibm_port_oid, $loopback_oid, $loglevel_oid, $reload_remain_oid, $profile_in_use_oid, $hc_enable_oid, $freq_license_oid, $speedlicense_oid, $acs_bw_oid, $read_str_oid, $write_str_oid, $trap_str_oid, $link_position_oid, $speed_r_mod_min_oid, $speed_r_mod_max_oid, $speed_r_chwidth_oid, $remote_ibm_port_oid, $remote_ibm_tag_oid, $remote_ibm_en_oid, $sysconfig_oid, $ibm_port_primary_oid, $ibm_port_backup_oid, $data_port_primary_oid, $data_port_backup_oid, $data_port_current_oid;

  echo '<td bgcolor="#f2f2f2"> <div id="left-text"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $ret = preg_replace("/(IpAddress:)/", "", $ret);
  $ret = preg_replace("/(STRING: )/", "", $ret);
  $ret = preg_replace("/(Counter32: )/", "", $ret);
  $ret = preg_replace("/(Timeticks: )/", "", $ret);

  $trimed = trim($ret, "\"");

  if ( strcmp($oid, $profile_in_use_oid) == 0){
    if ($trimed == 0){
      echo 'No custom profile in use';
    }
    else {
      echo 'Custom profile in use';
    }
  }
  else if ( strcmp($oid, $failover_oid) == 0){
    if ($trimed == 0){
      echo 'Off'; 
    }
    else if ($trimed == 1){
      echo 'On with port Off';
    }
    else if ($trimed == 2){
      echo 'On with port On';
    }
  }
  else if ( strcmp($oid, $ibm_port_oid) == 0 || strcmp($oid, $ibm_port_primary_oid) == 0 || strcmp($oid, $ibm_port_backup_oid) == 0 || strcmp($oid, $data_port_primary_oid) == 0 || strcmp($oid, $data_port_backup_oid) == 0 || strcmp($oid, $data_port_current_oid) == 0){
    if ($trimed == 1){  
      echo 'GE1';                  
    }                                                        
    else if ($trimed == 2){
      echo 'GE2';           
    }                      
    else if ($trimed == 3){
      echo 'GE3';
    }                           
    else {                      
      echo 'GE4';                                                                           
    }                                          
  }         
  else if ( strcmp($oid, $loglevel_oid) == 0){
    if ($trimed == 1){  
      echo 'Set';                  
    }                                                        
    else if ($trimed == 3){  
      echo 'Set, Event';           
    }                      
    else {
      echo 'Set, Event, Stat';           
    }
  }         
  else if ( strcmp($oid, $reload_remain_oid) == 0){
    if ($trimed == 0){  
      echo 'Disabled';                  
    }                                                        
    else {
      echo $trimed . ' minutes remains';           
    }
  }
  else if((strcmp($oid, $hc_enable_oid) == 0) || (strcmp($oid, $remote_ibm_en_oid) == 0) || (strcmp($oid, $remote_ibm_tag_oid) == 0)){
        if($trimed == 0)
          echo 'Off';
        else
          echo 'On';
  }
  else if(strcmp($oid, $freq_license_oid) == 0){
	  if($trimed == 1)
	    echo '1000.00 Mbps';
	  else if($trimed == 2)
	    echo 'Maximum capacity';
    else if($trimed == 3)
      echo 'Not applicable in license server mode';
	  else
	    echo 'No license enabled';
  }
  else if(strcmp($oid, $speedlicense_oid) == 0){
	  if($trimed == 4)
	    echo 'Capacity 200 Mbps enabled';
	  else if($trimed == 5)
	    echo 'Capacity 300 Mbps enabled';
	  else if($trimed == 6)
	    echo 'Capacity 400 Mbps enabled';
	  else if($trimed == 7)
	    echo 'Max capacity enabled';
  }
  /*else if((strcmp($oid, $write_str_oid) == 0) || (strcmp($oid, $read_str_oid) == 0) || (strcmp($oid, $trap_str_oid) == 0))
  {
    $i=0;
    while($i < strlen($trimed)){
      echo '*';
      $i++;
    }
  }*/
  else if(strcmp($oid, $link_position_oid) == 0)
  {
	  if($trimed == 0)
	    echo 'Local';
	  else
	    echo 'Remote';
  }
  else if((strcmp($oid, $speed_r_mod_min_oid) == 0) || (strcmp($oid, $speed_r_mod_max_oid) == 0))
  {
	  if($trimed == 0)
	    echo 'QPSK';
	  else if($trimed == 1)
	    echo 'QAM16';
	  else if($trimed == 2)
	    echo 'QAM32';
	  else if($trimed == 3)
	    echo 'QAM64';
	  else if($trimed == 4)
	    echo 'QAM128';
	  else if($trimed == 5)
	    echo 'QAM256';
	  else if($trimed == 6)
	    echo 'QAM512';
	  else if($trimed == 7)
	    echo 'QAM1024';
	  else if($trimed == 8)
	    echo 'QAM2048';
	  else if($trimed == 9)
	    echo 'QAM4096';
	  else
	    echo 'QPSK';
  }
  else if(strcmp($oid, $speed_r_chwidth_oid) == 0)
  {
	  if($trimed == 0)
	    echo '10 MHz';
	  else if($trimed == 1)
	    echo '30 MHz';
	  else if($trimed == 2)
	    echo '60 MHz';
	  else if($trimed == 3)
	    echo '75 MHz';
	  else if($trimed == 4)
	    echo '100 MHz';
	  else if($trimed == 5)
	    echo '120 MHz';
	  else if($trimed == 6)
	    echo '75a120 MHz';
	  else if($trimed == 7)
	    echo '120a75 MHz';
	  else
	    echo '10 MHz';
  }
  else if ( strcmp($oid, $remote_ibm_port_oid) == 0){
    if ($trimed == 1){  
      echo 'P1';                  
    }                                                        
    else if ($trimed == 2){
      echo 'P2';           
    }                      
    else if ($trimed == 3){
      echo 'P3';
    }                           
    else {                      
      echo 'P4';                                                                           
    }                                          
  }         
  else {
    echo $trimed;
  }

  echo '</div></td>';
}

function display_eth_status_image($oid)
{
  global $localhost, $read_str;

  echo '<td bgcolor="#f2f2f2"><div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  $trimed = trim($ret, "\"");

  if ($trimed == 1) {
    //echo '<img src="../images/green_circle.png">';
	echo '<font face="Trebuchet MS, Arial, Helvetica" size="2" color="green">On';
  }
  else {
    //echo '<img src="../images/red_circle.png">';
	echo '<font face="Trebuchet MS, Arial, Helvetica" size="2" color="#000000">Off';
  }
  echo '</div></td>';
}


function display_status_image($oid)
{
  global $localhost, $read_str;

  echo '<td bgcolor="#f2f2f2"><div id="input-text">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  $trimed = trim($ret, "\"");

  if ($trimed == 1) {
    //echo '<img src="../images/green_circle.png">';
	echo '<font face="Trebuchet MS, Arial, Helvetica" size="2" color="green">Locked';
  }
  else if ($trimed == 2) {
    //echo '<img src="../images/grey_circle.png">';
	echo '<font face="Trebuchet MS, Arial, Helvetica" size="2" color="#000000">Unlocked';
  }
  else {
    //echo '<img src="../images/red_circle.png">';
	echo '<font face="Trebuchet MS, Arial, Helvetica" size="2" color="#000000">Unlocked';
  }
  echo '</div></td>';
}

function display_inverted_status_image($oid, $stat_oid)
{
  global $localhost, $read_str;

  echo '<td><div id="input-text">';

  $stat = getSnmpResult( $stat_oid);
  $stat = preg_replace("/(INTEGER:)/", "", $stat);
  $stat = trim($stat, "\"");

  /*  stat is inverted status */
  if ($stat == 0){

    $ret = getSnmpResult( $oid);
    $ret = preg_replace("/(INTEGER:)/", "", $ret);

    $trimed = trim($ret, "\"");

    if ($trimed == 0) {
      echo '<img src="../images/green_circle.png">';
    }
    else {
      echo '<img src="../images/red_circle.png">';
    }
  }
  else {
    echo '<img src="../images/grey_circle.png">';
  }

  echo '</div></td>';
}

function display_tdm_status_image($oid, $stat_oid)
{
  global $localhost, $read_str;

  echo '<td><div id="input-text">';

  $stat = getSnmpResult( $stat_oid);
  $stat = preg_replace("/(INTEGER:)/", "", $stat);
  $stat = trim($stat, "\"");

  /*  stat is inverted status */
  if ($stat == 0){
    $ret = getSnmpResult( $oid);
    $ret = preg_replace("/(INTEGER:)/", "", $ret);

    $trimed = trim($ret, "\"");

    if ($trimed == 1) {
      echo '<img src="../images/green_circle.png">';
    }
    else if ($trimed == 2) {
      echo '<img src="../images/grey_circle.png">';
    }
    else {
      echo '<img src="../images/red_circle.png">';
    }
  }
  else {
    echo '<img src="../images/grey_circle.png">';
  }
  echo '</div></td>';
}

function display_footer()
{
  echo '</td>
        </tr>
        </table>
        </div>
        </td> </tr>';
   /*echo '<script type="text/javascript" src="//assets.zendesk.com/external/zenbox/v2.4/zenbox.js"></script>                
        <style type="text/css" media="screen, projection">                                                            
          @import url(//assets.zendesk.com/external/zenbox/v2.4/zenbox.css);
        </style>                                                        
        <script type="text/javascript">                                            
        if (typeof(Zenbox) !== "undefined") {                      
          Zenbox.init({                                                                            
            dropboxID:   "20083187",                        
            url:         "https://trango.zendesk.com",                             
            tabID:       "support",                                                                                  
            tabColor:    "BBBBBB",                                                                             
            tabPosition: "Left"                                              
          });                                                    
        }                                                                                                           
        </script>';*/
   echo '</table></div></div></body>
        </html>';
}

function set_remark_param($oid, $param)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(STRING: )/", "", $ret);

  $trimed = trim($ret, "\"");

  if ($_POST[$param] != NULL) {
    if (strcmp($_POST[$param], $trimed) != 0) {
      $set = setSnmp( $oid, "s", $_POST[$param], 60000000, 0);
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(STRING: )/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){  
        echo '<script language = "JavaScript">';
        echo 'alert(\'Setting Error:  ' . $param . ' \');';
        echo '</script>';
      }
    }
  }

  echo '<td height="25" align="left"><input type="text" name="' . $param . '" size="25"  value="'
        . $trimed . '"></div></td>';
}

function set_license_param($oid, $param)
{
  global $localhost, $read_str, $write_str;

  if ($_POST[$param] != NULL) {
    $set = setSnmp( $oid, "s", $_POST[$param], 60000000, 0);
    $ret = getSnmpResult( $oid);
    $ret = preg_replace("/(STRING: )/", "", $ret);
    $trimed = trim($ret, "\"");
  
    if ($set != 1){  
      echo '<script language = "JavaScript">';
      echo 'alert(\'Setting Error:  ' . $param . ' \');';
      echo '</script>';
    }
  }

  echo '<td height="25" align="left"><input type="text" name="' . $param . '" size="25"></div></td>';
}

function set_ce_param($oid, $param)
{
  global $localhost, $read_str, $write_str, $ce_license_set_oid, $ce_license_oid;

  if (isset($_POST[$param]) && $_POST[$param] != NULL) {
    $set = setSnmp( $ce_license_set_oid, "s", $_POST[$param], 60000000, 0);
    $ret = getSnmpResult( $ce_license_oid);
    $ret = preg_replace("/(INTEGER: )/", "", $ret);
    $trimed = trim($ret, "\"");

    if ($ret != 1){
      echo '<script language = "JavaScript">';
      echo 'alert(\'Setting Error:  ' . $param . ' \');';
      echo '</script>';
    }
  }

  echo '<td height="25" align="left" bgcolor="#f2f2f2"><input type="password" name="' . $param . '" id="' . $param . '" size="25"></div></td>';


  //echo 'td height="25" align="left"><input class="inputtext" type="text" name="' . $param . '" size="25"  value="' . $trimed . '"></div></td>';
}


function set_dual_param($oid, $param)
{
  global $localhost, $read_str, $write_str, $dual_license_set_oid, $dual_license_oid;

  if (isset($_POST[$param]) && $_POST[$param] != NULL) {
    $set = setSnmp( $dual_license_set_oid, "s", $_POST[$param], 60000000, 0);
    $ret = getSnmpResult( $dual_license_oid);
    $ret = preg_replace("/(INTEGER: )/", "", $ret);
    $trimed = trim($ret, "\"");

    if ($ret != 1){
      echo '<script language = "JavaScript">';
      echo 'alert(\'Setting Error:  ' . $param . ' \');';
      echo '</script>';
    }
  }

  echo '<td height="25" align="left" bgcolor="#f2f2f2"><input type="password" name="' . $param . '" id="' . $param . '" size="25"></div></td>';
  //echo 'td height="25" align="left"><input class="inputtext" type="text" name="' . $param . '" size="25"  value="' . $trimed . '"></div></td>';
}


function set_enckey_param($oid, $param)
{
  global $localhost, $read_str, $write_str;

  if (isset($_POST[$param]) && $_POST[$param] != NULL) {
    $set = setSnmp( $oid, "s", $_POST[$param], 60000000, 0);
    $ret = getSnmpResult( $oid);
    $ret = preg_replace("/(STRING: )/", "", $ret);
    $trimed = trim($ret, "\"");
  
    if ($set != 1){  
      echo '<script language = "JavaScript">';
      echo 'alert(\'Setting Error:  ' . $param . ' \');';
      echo '</script>';
    }
  }

  echo '<td height="25" align="left" bgcolor="#f2f2f2"><input type="password" name="' . $param . '" id="' . $param . '" size="25"></div></td>';
  //echo 'td height="25" align="left"><input class="inputtext" type="text" name="' . $param . '" size="25"  value="' . $trimed . '"></div></td>';
}
  function set_server_check_param($oid, $param) {
    if (isset($_POST[$param]) && $_POST[$param] !== NULL) {
      $ret = setSnmp($oid, "i", 0, 60000000, 0);
      $ret = preg_replace("/(INTEGER: )/", "", $ret);
      $trimed = trim($ret, "\"");
     
      if ($ret) {
        echo '<script language="JavaScript">';
        echo 'alert(\'Server check is successful.\');';
        echo '</script>';
      } else {
        echo '<script language="JavaScript">';
        echo 'alert(\'Server check is failed\');';
        echo '</script>';
       
      }
    }
  }
  
  function set_freq_license_param($param1, $param2)
{
  global $localhost, $read_str, $write_str, $freq_license1_set_oid, $freq_license2_set_oid, $freq_license_oid;

  if (isset($_POST[$param2]) && $_POST[$param2] != NULL) {
    if ($_POST[$param1] ==  1){
      $set = setSnmp( $freq_license1_set_oid, "s", $_POST[$param2], 60000000, 0);
      $ret = getSnmpResult( $freq_license_oid);
    }
    else if($_POST[$param1] == 2){
      $set = setSnmp( $freq_license2_set_oid, "s", $_POST[$param2], 60000000, 0);
      $ret = getSnmpResult( $freq_license_oid);
    }
    /*else{
   	  $set = setSnmp( $freq_license3_set_oid, "s", $_POST[$param2], 60000000, 0);
      $ret = getSnmpResult( $freq_license_oid);
	}*/
    $ret = preg_replace("/(INTEGER: )/", "", $ret);
    $ret = preg_replace("/(STRING: )/", "", $ret);
    $trimed = trim($ret, "\"");

    if ($set != 1){
      echo '<script language = "JavaScript">';
      echo 'alert(\'Setting Error:  ' . $param2 . $ret . ' \');';
      echo '</script>';
    }
  }

  $ret = getSnmpResult( $freq_license_oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  echo '&nbsp;&nbsp;<input type="text" name="' . $param2 . '" size="25"></div>';

  $result = sprintf('document.getElementById("%s_%d").selected=true;', $param1, $trimed);
  echo '<script language = "JavaScript">';
  echo $result;
  echo '</script>';

}

function set_enc_license_param($param1, $param2)
{
  global $localhost, $read_str, $write_str, $enc_license1_set_oid, $enc_license2_set_oid, $enc_license_oid;

  if ($_POST[$param2] != NULL) {
    if ($_POST[$param1] ==  1){
      $set = setSnmp( $enc_license1_set_oid, "s", $_POST[$param2], 60000000, 0);
      $ret = getSnmpResult( $enc_license_oid);
    }
    else {
      $set = setSnmp( $enc_license2_set_oid, "s", $_POST[$param2], 60000000, 0);
      $ret = getSnmpResult( $enc_license_oid);
    }

    $ret = preg_replace("/(INTEGER: )/", "", $ret);
    $ret = preg_replace("/(STRING: )/", "", $ret);
    $trimed = trim($ret, "\"");

    if ($set != 1){
      echo '<script language = "JavaScript">';
      echo 'alert(\'Setting Error:  ' . $param2 . $ret . ' \');';
      echo '</script>';
    }
  }

  $ret = getSnmpResult( $enc_license_oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  echo '<input type="text" name="' . $param2 . '" size="25"></div>';

  $result = sprintf('document.getElementById("%s_%d").selected=true;', $param1, $trimed);
  echo '<script language = "JavaScript">';
  echo $result;
  echo '</script>';

}

function set_radio_param_force($oid, $param, $val_type, $comments)
{
  global $localhost, $read_str, $write_str, $diagnostic_oid;

  if (strcmp($_POST[$param], 0) != 0) {

    switch($val_type)
    {
      case 1:
      {
		if(strcmp($oid, $diagnostic_oid) == 0){
          if($_POST[$param] == 1){
            $set = setSnmp( $oid, "i", $_POST[$param] + 2, 60000000, 0);
          }
          else if($_POST[$param] == 2){
           $set = setSnmp( $oid, "i", $_POST[$param] + 1, 60000000, 0);
          }
          else
            $set = setSnmp( $oid, "i", $_POST[$param], 60000000, 0);
        }
        else  
          $set = setSnmp( $oid, "i", $_POST[$param], 60000000, 0);
        $ret = getSnmpResult( $oid);
        $ret = preg_replace("/(INTEGER:)/", "", $ret);
        $trimed = trim($ret, "\"");
      }
      break;

      case 2:
      {
        $set = setSnmp( $oid, "F", $_POST[$param], 60000000, 0);
        $ret = getSnmpResult( $oid);
        $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
        $trimed = trim($ret, "\"");
      }
      break;
    }
  }

  echo '<td height="25" align="center" bgcolor="#f2f2f2"><input type="text" id="' . $param . '" name="' . $param . '" size="8"  value="'
        . $_POST[$param] . '"></div></td>';

  echo '<td bgcolor="#f2f2f2"><div id="left-title">' . $comments . '</div></td>';
}

function display_selection_result($oid, $param)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if (isset($_POST[$param])  && $_POST[$param] != NULL) {
    if ( $_POST[$param] != $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$param], 60000000, 0); 
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");

      if ($set != 1){  
        $filename = "/tmp/snmp.error";
        $handle = fopen($filename, "r");
        $error_code = fread($handle, filesize($filename));

        unlink($filename);

        echo '<script language = "JavaScript">';
        echo 'alert(\'' . $param . ' ' . $error_code . ' \');';
        echo '</script>';
      }
    }
  }

  $result = sprintf('document.getElementById("%s_%d").selected=true;', $param, $trimed);
  
  echo '<script language = "JavaScript">';
  echo $result;
  echo '</script>';
}
  
  function display_selection_result_port_backup($oid, $param)
  {
    
    if (isset($_POST[$param])  && $_POST[$param] != NULL) {
        $set = setSnmp( $oid, "i", $_POST[$param], 60000000, 0);
        $ret = getSnmpResult( $oid);
        $ret = preg_replace("/(INTEGER:)/", "", $ret);
        $trimed = trim($ret, "\"");
      
        if ($set != 1){
          $filename = "/tmp/snmp.error";
          
          // Check if the file exists
          if (file_exists($filename)) {
            $handle = fopen($filename, "r");
            $error_code = fread($handle, filesize($filename));
            fclose($handle); // Close the file handle
            
            unlink($filename);
            
            if (isset($error_code) && !empty($error_code)) {
              echo '<script language = "JavaScript">';
              echo 'alert(\' Check the Management/Data Port parameters. Please check syslog for further details\');';
              echo '</script>';
            }
          }
        }
      
    }
    else{
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");
    }
    
    $result = sprintf('document.getElementById("%s_%d").selected=true;', $param, $trimed);
    
    echo '<script language = "JavaScript">';
    echo $result;
    echo '</script>';
  }

function display_selection_result_cgi($oid, $param)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  $result = sprintf('document.getElementById("%s_%d").selected=true;', $param, $trimed);
  
  echo '<script language = "JavaScript">';
  echo $result;
  echo '</script>';
}


function display_speed_result($oid, $param)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if (isset($_POST[$param]) && $_POST[$param] != NULL) {
    //if ( $_POST[$param] != $trimed) {
      $set = setSnmp( $oid, "i", $_POST[$param], 60000000, 0); 
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $trimed = trim($ret, "\"");
    
    if ($set != 1) {
      $filename = "/tmp/snmp.error";
      $handle = fopen($filename, "r");
      $error_code = fread($handle, filesize($filename));
      
      unlink($filename);
      
      echo '<script language = "JavaScript">';
      echo 'alert("' . $error_code . ' Parameter: ' . $param . '");';
      echo '</script>';
    }
    //}
  }

  $result = sprintf('document.getElementById("%s_%d").selected=true;', $param, $trimed);
  
  echo '<script language = "JavaScript">';
  echo $result;
  echo '</script>';
}

function display_speed_result_cgi($oid, $param)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  $result = sprintf('document.getElementById("%s_%d").selected=true;', $param, $trimed);
  
  echo '<script language = "JavaScript">';
  echo $result;
  echo '</script>';
}


function display_checkbox_result($oid, $param)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");
  
  //if ($_POST[$param] != NULL) {
  
    $array = $_POST[$param];
    $how_many = count($array);                                      
    $set = 0;
    
    for ( $i=0; $i < $how_many; $i++){
      if ($array[$i] == 0) {
        $set = 0;
        //break;
      }
      else  if (($array[$i] & 0x01)  == 0x01) {
        $set = $set | 0x01;
      }
      else if (($array[$i] & 0x02)  == 0x02) {
        $set = $set | 0x02;
      }
      else if (($array[$i] & 0x04)  == 0x04) {
        $set = $set | 0x04;
      }
      else if (($array[$i] & 0x08)  == 0x08) {
        $set = $set | 0x08;
      }
      else if (($array[$i] & 0x10)  == 0x10) {
        $set = $set | 0x10;
      }
	  else if (($array[$i] & 0x20)  == 0x20) {
        $set = $set | 0x20;
      }
      else if (($array[$i] & 0x40)  == 0x40) {
        $set = $set | 0x40;
      }
    }
    
    if (($how_many != 0) && ($set != $trimed)){
      $set = setSnmp( $oid, "i", $set, 60000000, 0);
    }  
  //}
  
  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");
  
  echo '<script language = "JavaScript">';
  if ($trimed == 0) {
    $result0 = sprintf('document.getElementById("%s0").checked=true;', $param);
    echo $result0;
  }
  if (($trimed & 0x01)  == 0x01) {
    $result1 = sprintf('document.getElementById("%s1").checked=true;', $param);
    echo $result1;
  }
  if (($trimed & 0x02)  == 0x02) {
    $result2 = sprintf('document.getElementById("%s2").checked=true;', $param);
    echo $result2;
  }
  if (($trimed & 0x04)  == 0x04) {
    $result3 = sprintf('document.getElementById("%s4").checked=true;', $param);
    echo $result3;
  }
  if (($trimed & 0x08)  == 0x08) {
    $result4 = sprintf('document.getElementById("%s8").checked=true;', $param);
    echo $result4;
  }
  if (($trimed & 0x10)  == 0x10) { 
    $result5 = sprintf('document.getElementById("%s16").checked=true;', $param);
    echo $result5;
  }
  if (($trimed & 0x20)  == 0x20) {
    $result6 = sprintf('document.getElementById("%s32").checked=true;', $param);
    echo $result6;
  }
  if (($trimed & 0x40)  == 0x40) {
    $result7 = sprintf('document.getElementById("%s64").checked=true;', $param);
    echo $result7;
  }
  echo '</script>';
}

function set_radio_param_small($oid, $param, $val_type, $position)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $ret = preg_replace("/(IpAddress:)/", "", $ret);
  $ret = preg_replace("/(STRING: )/", "", $ret);

  $trimed = trim($ret, "\"");

  if ($_POST[$param] != NULL) {

    if (strcmp($_POST[$param], $trimed) != 0) {
      switch($val_type)
      {
        case 1:
        {
          $set = setSnmp( $oid, "i", $_POST[$param], 60000000, 0); 
          $ret = getSnmpResult( $oid);
          $ret = preg_replace("/(INTEGER:)/", "", $ret);
          $trimed = trim($ret, "\"");
        }
        break;

        case 2:
        {
          $set = setSnmp( $oid, "F", $_POST[$param], 60000000, 0);
          $ret = getSnmpResult( $oid);
          $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
          $trimed = trim($ret, "\"");
        }
        break;

        case 3:
        {
          $new_str = ltrim($_POST[$param]);
          $set = setSnmp( $oid, "s", $new_str, 60000000, 0);
          $ret = getSnmpResult( $oid);
          $ret = preg_replace("/(IpAddress:)/", "", $ret);
          $ret = preg_replace("/(STRING: )/", "", $ret);
          $trimed = trim($ret, "\"");
        }
        break;

        case 4:
        {
          $new_str = ltrim($_POST[$param]);
          $set = setSnmp( $oid, "a", $new_str, 60000000, 0);
          $ret = getSnmpResult( $oid);
          $ret = preg_replace("/(IpAddress:)/", "", $ret);
          $trimed = trim($ret, "\"");
        }
        break;
      }

      if ($set != 1){                 
        $filename = "/tmp/snmp.error";
        $handle = fopen($filename, "r");
        $error_code = fread($handle, filesize($filename));
             
        unlink($filename);

        echo '<script language = "JavaScript">';
        echo 'alert(\'' . $param . ' ' . $error_code . ' \');';   
        echo '</script>';                                 
      }          
    }
  }

  if ($position == 0)
    echo '<td height="10" align="left" bgcolor="#f2f2f2">';
  else if ($position == 1)
    echo '<td height="10" align="center" bgcolor="#f2f2f2">';

  echo '<input type="text" class="input" name="' . $param . '" size="3"  value="'
        . $trimed . '"></div></td>';
}

function set_snmp_string($param1, $param2)
{
  global $localhost, $read_str, $write_str, $read_str_oid, $write_str_oid, $trap_str_oid;

  if (isset($_POST[$param2]) && $_POST[$param2] != NULL)
  {
    $new_str = ltrim($_POST[$param2]);
    if ($_POST[$param1] == 1)
    {
      $ret = getSnmpResult( $write_str_oid);
      $ret = preg_replace("/(STRING: )/", "", $ret);
      $trimed1 = trim($ret, "\"");
      $ret = getSnmpResult( $trap_str_oid);
      $ret = preg_replace("/(STRING: )/", "", $ret);
      $trimed2 = trim($ret, "\"");
      if((strcmp($trimed1, $new_str) == 0) || (strcmp($trimed2, $new_str) == 0)){
        echo '<script language = "JavaScript">';
        echo 'alert(\'SNMP community strings cannot have the same value! \');';
        echo '</script>';
      }
      else
        $set = setSnmp( $read_str_oid, "s", $new_str, 60000000, 0);
    }
    else if ($_POST[$param1] == 2)
    {
      $ret = getSnmpResult( $read_str_oid);
      $ret = preg_replace("/(STRING: )/", "", $ret);
      $trimed1 = trim($ret, "\"");
      $ret = getSnmpResult( $trap_str_oid);
      $ret = preg_replace("/(STRING: )/", "", $ret);
      $trimed2 = trim($ret, "\"");
      if((strcmp($trimed1, $new_str) == 0) || (strcmp($trimed2, $new_str) == 0)){
        echo '<script language = "JavaScript">';
        echo 'alert(\'SNMP community strings cannot have the same value! \');';
        echo '</script>';
      }
      else
        $set = setSnmp( $write_str_oid, "s", $new_str, 60000000, 0);
    }
    else if ($_POST[$param1] == 3)
    {
      $ret = getSnmpResult( $write_str_oid);
      $ret = preg_replace("/(STRING: )/", "", $ret);
      $trimed1 = trim($ret, "\"");
      $ret = getSnmpResult( $read_str_oid);
      $ret = preg_replace("/(STRING: )/", "", $ret);
      $trimed2 = trim($ret, "\"");
      if((strcmp($trimed1, $new_str) == 0) || (strcmp($trimed2, $new_str) == 0)){
        echo '<script language = "JavaScript">';
        echo 'alert(\'SNMP community strings cannot have the same value! \');';
        echo '</script>';
      }
      else
        $set = setSnmp( $trap_str_oid, "s", $new_str, 60000000, 0);
    }
  }
  echo '<td width="60%" align="left" bgcolor="#f2f2f2">';
  echo '<input type="text" id="' . $param2 . '" name="' . $param2 . '" size="25"></div></td>';
}

function set_snmp_auth($param1, $param2)
{
  global $localhost, $read_str, $write_str, $snmpd_user_oid, $snmpd_authpass_oid, $snmpd_privpass_oid;

  if ($_POST[$param2] != NULL)
  {
    $new_str = ltrim($_POST[$param2]);
    if ($_POST[$param1] == 1)
    {
      $set = setSnmp( $snmpd_user_oid, "s", $new_str, 60000000, 0);
    }
    else if ($_POST[$param1] == 2)
    {
      $set = setSnmp( $snmpd_authpass_oid, "s", $new_str, 60000000, 0);
    }
    else if ($_POST[$param1] == 3)
    {
      $set = setSnmp( $snmpd_privpass_oid, "s", $new_str, 60000000, 0);
    }
  }
  echo '<td width="60%" align="left" bgcolor="#f2f2f2">';
  echo '<input type="text" id="' . $param2 . '" name="' . $param2 . '" size="25"></div></td>';
}


function set_radio_param($oid, $param, $val_type, $position, $class="inputtext", $title="")
{
    global $localhost, $read_str, $write_str, $read_str_oid, $write_str_oid, $ftp_passwd_oid, $ftp_server_oid, $ftp_username_oid, $licenseServerPassword_oid;

    if (class_exists('CustomDataRetrieval')) {
        $trimed = CustomDataRetrieval::pullSysOID($oid);
    } else {
        $ret = getSnmpResult( $oid);
        $ret = preg_replace("/(INTEGER:)/", "", $ret);
        $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
        $ret = preg_replace("/(IpAddress:)/", "", $ret);
        $ret = preg_replace("/(STRING: )/", "", $ret);
        $trimed = trim($ret, "\"");
    }

    if (isset($_POST[$param]) && $_POST[$param] != null) {

        if ((strcmp($_POST[$param], $trimed) != 0) || (strcmp($oid, $ftp_server_oid) == 0) || (strcmp($oid, $ftp_username_oid) == 0) || (strcmp($oid, $ftp_passwd_oid) == 0)) {
            switch ($val_type) {
                case 1:
                    $set = setSnmp( $oid, "i", $_POST[$param], 60000000, 5);
                    break;
                case 2:
                    $set = setSnmp( $oid, "F", $_POST[$param], 60000000, 5);
                    break;
                case 3:
                    $new_str = ltrim($_POST[$param]);
                    if (strcmp($oid, $read_str_oid) == 0) {
                        $ret = getSnmpResult( $write_str_oid);
                        $ret = preg_replace("/(STRING: )/", "", $ret);
                        $trimed = trim($ret, "\"");
                        if (strcmp($trimed, $new_str) == 0) {
                            echo '<script language = "JavaScript">';
                            echo 'alert(\'SNMP read-string and SNMP write-string cannot have the same value! \');';
                            echo '</script>';
                        } else {
                            $set = setSnmp( $oid, "s", $new_str, 60000000, 5);
                        }
                    } else {
                        if (strcmp($oid, $write_str_oid) == 0) {
                            $ret = getSnmpResult( $read_str_oid);
                            $ret = preg_replace("/(STRING: )/", "", $ret);
                            $trimed = trim($ret, "\"");
                            if (strcmp($trimed, $new_str) == 0) {
                                echo '<script language = "JavaScript">';
                                echo 'alert(\'SNMP write-string and SNMP read-string cannot have the same value! \');';
                                echo '</script>';
                            } else {
                                $set = setSnmp( $oid, "s", $new_str, 60000000, 5);
                            }
                        } else {
                            $set = setSnmp( $oid, "s", $new_str, 60000000, 5);
                        }
                    }

                    break;

                case 4:
                    $new_str = ltrim($_POST[$param]);
                    $set = setSnmp( $oid, "a", $new_str, 60000000, 5);
                    break;
            }

            if ($set != 1) {
                $filename = "/tmp/snmp.error";
                $handle = fopen($filename, "r");
                $error_code = fread($handle, filesize($filename));

                unlink($filename);
              
                echo '<script language = "JavaScript">';
              echo 'alert("' . $error_code . ' Parameter: ' . $param . '");';
              echo '</script>';
              
            }
        }

        // Retake the value
        if (class_exists('CustomDataRetrieval')) {
            $trimed = CustomDataRetrieval::pullSysOID($oid);
        } else {
            $ret = getSnmpResult( $oid);
            $ret = preg_replace("/(INTEGER:)/", "", $ret);
            $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
            $ret = preg_replace("/(IpAddress:)/", "", $ret);
            $ret = preg_replace("/(STRING: )/", "", $ret);
            $trimed = trim($ret, "\"");
        }
    }

    if (strcmp($oid, $ftp_passwd_oid) == 0 || strcmp($oid, $licenseServerPassword_oid) == 0) {
        if ($position == 0) {
            echo '<td height="25" align="left" bgcolor="#f2f2f2">';
        } else {
            if ($position == 1) {
                echo '<td height="25" align="center" bgcolor="#f2f2f2">';
            }
        }

        if (($val_type == 3) || ($val_type == 4)) {
            echo '<input class="'.$class.'" type="password" id="'.$param.'" name="'.$param.'" size="14">';
        } else {
            echo '<input class="'.$class.'" type="password" id="'.$param.'" name="'.$param.'" size="8">';
        }
    } else {
        if ($position == 0) {
            echo '<td height="25" align="left" bgcolor="#f2f2f2">';
        } else {
            if ($position == 1) {
                echo '<td height="25" align="center" bgcolor="#f2f2f2">';
            }
        }

        if (($val_type == 3) || ($val_type == 4)) {
            echo '<input class="'.$class.'" type="text" id="'.$param.'" name="'.$param.'" size="14"  value="'.$trimed.'" title="'.$title.'">';
        } else {
            echo '<input class="'.$class.'" type="text" id="'.$param.'" name="'.$param.'" size="8"  value="'.$trimed.'" title="'.$title.'">';
        }
    }
}
function set_snmp_param($param,$oid, $val_type, $new_value = null)
  {
    global $read_str_oid, $write_str_oid;
    
    if (class_exists('CustomDataRetrieval')) {
      $trimed = CustomDataRetrieval::pullSysOID($oid);
    } else {
      $ret = getSnmpResult( $oid);
      $ret = preg_replace("/(INTEGER:)/", "", $ret);
      $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
      $ret = preg_replace("/(IpAddress:)/", "", $ret);
      $ret = preg_replace("/(STRING: )/", "", $ret);
      $trimed = trim($ret, "\"");
    }
    
    if (isset($_POST[$param]) && $_POST[$param] != null) {
      if ($new_value == null){
        $new_value = $_POST[$param];
      }
      if (strcmp($new_value, $trimed) != 0) {
        switch ($val_type) {
          case 1:
            $set = setSnmp( $oid, "i", $new_value, 60000000, 5);
            break;
          case 2:
            $set = setSnmp( $oid, "F", $new_value, 60000000, 5);
            break;
          case 3:
            $new_str = ltrim($new_value);
            if (strcmp($oid, $read_str_oid) == 0) {
              $ret = getSnmpResult( $write_str_oid);
              $ret = preg_replace("/(STRING: )/", "", $ret);
              $trimed = trim($ret, "\"");
              if (strcmp($trimed, $new_str) == 0) {
                echo '<script language = "JavaScript">';
                echo 'alert(\'SNMP read-string and SNMP write-string cannot have the same value! \');';
                echo '</script>';
              } else {
                $set = setSnmp( $oid, "s", $new_str, 60000000, 5);
              }
            } else {
              if (strcmp($oid, $write_str_oid) == 0) {
                $ret = getSnmpResult( $read_str_oid);
                $ret = preg_replace("/(STRING: )/", "", $ret);
                $trimed = trim($ret, "\"");
                if (strcmp($trimed, $new_str) == 0) {
                  echo '<script language = "JavaScript">';
                  echo 'alert(\'SNMP write-string and SNMP read-string cannot have the same value! \');';
                  echo '</script>';
                } else {
                  $set = setSnmp( $oid, "s", $new_str, 60000000, 5);
                }
              } else {
                $set = setSnmp( $oid, "s", $new_str, 60000000, 5);
              }
            }
            
            break;
          
          case 4:
            $new_str = ltrim($new_value);
            $set = setSnmp( $oid, "a", $new_str, 60000000, 5);
            break;
        }
        
        if ($set != 1) {
          $filename = "/tmp/snmp.error";
          $handle = fopen($filename, "r");
          $error_code = fread($handle, filesize($filename));
          unlink($filename);
          echo '<script language = "JavaScript">';
          echo 'alert("' . $error_code . ' Parameter: ' . $param . '");';
          echo '</script>';
          
        }
      }
    }
  }

function set_radio_param_cgi($oid, $param, $val_type, $position)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $ret = preg_replace("/(IpAddress:)/", "", $ret);
  $ret = preg_replace("/(STRING: )/", "", $ret);

  $trimed = trim($ret, "\"");
	
  if ($position == 0)
     echo '<td height="25" align="left" bgcolor="#f2f2f2">';
  else if ($position == 1)
     echo '<td height="25" align="center" bgcolor="#f2f2f2">';

  if (($val_type == 3) || ($val_type == 4)){ 
     echo '<input class="inputtext" type="text" id="' . $param . '" name="' . $param . '" size="14"  value="'
        . $trimed . '">';
  }
  else {
     echo '<input class="inputtext" type="text" id="' . $param . '" name="' . $param . '" size="8"  value="'
        . $trimed . '">';
  }
}

function set_radio_param_remote_ip($oid, $param, $val_type, $position)
{
  global $localhost, $read_str, $write_str, $read_str_oid, $write_str_oid;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(IpAddress:)/", "", $ret);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);

  $trimed = trim($ret, "\"");

  if ($position == 0)
     echo '<td height="25" align="left" bgcolor="#f2f2f2">';
  else if ($position == 1)
     echo '<td height="25" align="center" bgcolor="#f2f2f2">';

  if (($val_type == 3) || ($val_type == 4)){ 
     echo '<input class="inputtext" type="text" id="' . $param . '" name="' . $param . '" size="14"  value="'
        . $trimed . '">';
  }
  else {
     echo '<input class="inputtext" type="text" id="' . $param . '" name="' . $param . '" size="8"  value="'
        . $trimed . '">';
  }
}

function display_ibm_remote_en_tag($setting, $oid)
{
  global $localhost, $read_str, $write_str;

  echo '<td bgcolor="#f2f2f2">  <div id="left-text"><font size="2">';

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($trimed == 1){
    echo '<div align="left" class="radio">
          <input type="radio" name="' .  $setting . '" id="' . $setting . '_enable" value="1" CHECKED><label for="' . $setting . '_enable">On </label></input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0"><label for="' . $setting . '_disable">Off </input>';
  }
  else {
    echo '<div align="left" class="radio">
          <input type="radio" name="'  . $setting . '" id="' . $setting . '_enable" value="1"><label for="' . $setting . '_enable">On </label></input>';
    echo '<input type="radio" name="'  . $setting . '" id="' . $setting . '_disable" value="0" CHECKED><label for="' . $setting . '_disable">Off </label></input>';
  }
  echo '</td>';
}

function display_ibm_port_remote($oid, $param)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");

  $result = sprintf('document.getElementById("%s_%d").selected=true;', $param, $trimed);
  
  echo '<script language = "JavaScript">';
  echo $result;
  echo '</script>';
}

function set_radio_param_snmp($oid, $param, $val_type, $position)
{
  global $localhost, $read_str, $write_str, $read_str_oid, $write_str_oid;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(STRING: )/", "", $ret);
  $trimed = trim($ret, "\"");

  if ($_POST[$param] != NULL) {

    if (strcmp($_POST[$param], $trimed) != 0) {
      switch($val_type)
      {
        case 3:
        {
          $new_str = ltrim($_POST[$param]);
		  if(strcmp($oid, $read_str_oid) == 0){
                $ret = getSnmpResult( $write_str_oid);
                $ret = preg_replace("/(STRING: )/", "", $ret);
                $trimed = trim($ret, "\"");
                if(strcmp($trimed, $new_str) == 0){
                        echo '<script language = "JavaScript">';
                        echo 'alert(\'SNMP read-string and SNMP write-string cannot have the same value! \');';
                        echo '</script>';
                }
                else
                  $set = setSnmp( $oid, "s", $new_str, 60000000, 0);
          }
          else if(strcmp($oid, $write_str_oid) == 0){
               $ret = getSnmpResult( $read_str_oid);
               $ret = preg_replace("/(STRING: )/", "", $ret);
               $trimed = trim($ret, "\"");
               if(strcmp($trimed, $new_str) == 0){
                        echo '<script language = "JavaScript">';
                        echo 'alert(\'SNMP write-string and SNMP read-string cannot have the same value! \');';
                        echo '</script>';
               }
               else
                 $set = setSnmp( $oid, "s", $new_str, 60000000, 0);
          }
          else
            $set = setSnmp( $oid, "s", $new_str, 60000000, 0);
          $ret = getSnmpResult( $oid);
          $ret = preg_replace("/(STRING: )/", "", $ret);
          $trimed = trim($ret, "\"");
        }
        break;
      }

      if ($set != 1){                 
        $filename = "/tmp/snmp.error";
        $handle = fopen($filename, "r");
        $error_code = fread($handle, filesize($filename));
             
        unlink($filename);

        echo '<script language = "JavaScript">';
        echo 'alert(\'' . $param . ' ' . $error_code . ' \');';   
        echo '</script>';                                 
      }          
    }
  }

  if ($position == 0)
    echo '<td height="25" align="left" bgcolor="#f2f2f2">';
  else if ($position == 1)
    echo '<td height="25" align="center" bgcolor="#f2f2f2">';


  if (($val_type == 3) || ($val_type == 4)){ 
    echo '<input class="inputtext" type="password" name="' . $param . '" size="14"  value="'
        . $trimed . '">';
    //echo '</div></td>';
  }
  else {
    echo '<input class="inputtext" type="password" name="' . $param . '" size="8"  value="'
        . $trimed . '">';
    //echo '</div></td>';
  }
}

function set_param($oid, $param, $val_type, $position)
{
  global $localhost, $read_str, $write_str;

  $ret = getSnmpResult( $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  
  $trimed = trim($ret, "\"");

  if (isset($_POST[$param]) && $_POST[$param] != NULL) {

    if (strcmp($_POST[$param], $trimed) != 0) {
		$set = setSnmp( $oid, "i", $_POST[$param], 60000000, 0); 
        $ret = getSnmpResult( $oid);
        $ret = preg_replace("/(INTEGER:)/", "", $ret);
        $trimed = trim($ret, "\"");
	
	    if ($set != 1){                 
          $filename = "/tmp/snmp.error";
          $handle = fopen($filename, "r");
          $error_code = fread($handle, filesize($filename));
             
          unlink($filename);

          echo '<script language = "JavaScript">';
          echo 'alert(\'' . $param . ' ' . $error_code . ' \');';   
          echo '</script>';                                 
        } 
	}
  }
  if ($position == 0)
    echo '<td height="25" align="left" bgcolor="#f2f2f2">';
  else if ($position == 1)
    echo '<td height="25" align="center" bgcolor="#f2f2f2">';
  echo '<input class="input-port" type="text" name="' . $param . '" size="8"  value="'
        . $trimed . '">';
}
  function set_config($oid, $setting) {
    if (isset($_POST[$setting]) && $_POST[$setting] != NULL) {
      $url = "/settings/submit_option.php?name=/settings/link_setup.php&option=4&oid=" . urlencode($oid);
      
      // Use JavaScript to redirect
      echo '<script language="JavaScript">';
      echo 'window.location.href="' . $url . '";';
      echo '</script>';
    }
  }

//function set_config($oid, $setting)
//  {
//    if (isset($_POST[$setting]) && $_POST[$setting] != NULL) {
//        $str = sprintf('Location:%s', "/settings/submit_option.php?name=/settings/link_setup.php&option=4&oid=$oid");
////      echo '<script language = "JavaScript">';
////          echo 'alert(\'Setting Error:  ' . $str . ' \');';
////          echo '</script>';
//      //  header($str);
//      echo '<script language="javascript">';
//      echo 'window.location.href='.$str.';';
//      echo '</script>';
////        $set = setSnmp( $oid, "i", $setting_value, 50000000, 0);
////        usleep(3000000);
////        if ($set != 1){
////          echo '<script language = "JavaScript">';
////          echo 'alert(\'Setting Error:  ' . $setting . ' \');';
////          echo '</script>';
////        }
//    }
//  }
function display_firmware_version($opt)
{
  echo '<td><div id="left-text">';
  $fw = "";
  if($opt == 0)
  {
    $files = glob("/mnt/usrcfg/bank/current/*.tar.gz");
    if(isset($files[0])){
	    $fw = strstr($files[0], "v");
	    $fw = chop($fw,".tar.gz");
    }
    
  }
  elseif($opt == 1)
  {
    $files = glob("/mnt/usrcfg/bank/previous/*.tar.gz");
    if(isset($files[0])) {
      $fw = strstr($files[0], "_v");
      $fw = strstr($fw, "v");
      $fw = chop($fw, ".tar.gz");
    }
  }
  else
  {
    $files = glob("/mnt/usrcfg/bank/stable/*.tar.gz");
    if(isset($files[0])) {
        $fw = strstr($files[0], "v");
        $fw = chop($fw,".tar.gz");
    }
  }

  echo $fw;
  echo '</div></td>';
}
  function display_switch_firmware_version($opt)
  {
    echo '<td><div id="left-text">';
    $fw = "";
    
    if ($opt == 0) {
      $files = glob("/mnt/usrcfg/switch_bank/current/*.tar.gz");
    } elseif ($opt == 1) {
      $files = glob("/mnt/usrcfg/switch_bank/previous/*.tar.gz");
    } else {
      $files = glob("/mnt/usrcfg/switch_bank/stable/*.tar.gz");
    }
    
    if (isset($files[0])) {
      $filename = basename($files[0]);         // get only the file name
      $fw = strstr($filename, "v");            // extract from 'v...'
      $fw = str_replace(".tar.gz", "", $fw);   // remove .tar.gz
    }
    
    echo htmlspecialchars($fw);  // safer output
    echo '</div></td>';
  }

	function display_fpga_version($opt)
	{
		echo '<td><div id="left-text">';
		
		if ($opt == 0) {
			$files = glob("/mnt/usrcfg/fpga_bank/current/*.tar.gz");
		} elseif ($opt == 1) {
			$files = glob("/mnt/usrcfg/fpga_bank/previous/*.tar.gz");
		} else {
			$files = glob("/mnt/usrcfg/fpga_bank/stable/*.tar.gz");
		}
		
		// Check if files were found
		if (!empty($files)) {
			// Extract the firmware version using a regular expression
			$fw = reset($files); // Get the first file in the array
			if (preg_match('/v\d+(\.\d+)*(_v\d+(\.\d+)*)?/', $fw, $matches)) {
				$fw = $matches[0];
			} else {
				$fw = ''; // Set to an empty string if no version is found
			}
		} else {
			$fw = ''; // Set to an empty string if no files were found
		}
		
		echo $fw;
		echo '</div></td>';
	}


?>
<script language="JavaScript">
function confirmUpgradeCancel()
{
  return confirm("System upgrade will be cancelled, do you want to continue?");
}
function confirmReboot() {
  return confirm("This will reboot the system. Continue? If so, please close the web browser immediately after");
}
function confirmRemoteReboot() 
{
  return confirm("Remote side will be rebooted, do you want to continue? If so, please close the web browser for remote side.");
}

function confirmChanges() 
{
  return confirm("Config Saved Successfully");
}
function confirmRemoteChanges() 
{
  return confirm("This will save configuration on remote side radio. Continue?");
}
function log() 
{
  return confirm("A file syslog.txt has been created in /tmp folder. Please follow the tftp instructions to download the file.");
}
function confirmSave() 
{
  return confirm("All system status saved.");
}
function show_save()
{
	alert("New settings will be applied. To make changes permanent, please save changes.");
}

function getRemoteLocalStatistics() {
    $("#js-combined-rl-stats").load("/services/current-local-remote-stats.php");
	<?php if(isset($v3_en) && $v3_en): ?>
    setTimeout(getRemoteLocalStatistics, 10000);
	<?php else: ?>
    setTimeout(getRemoteLocalStatistics, 2500);
	<?php endif; ?>
}
</script>
