<?php
$show_bad_header_js = false;
require_once(__DIR__.'/../config.php');

// Get input
$allowed_when = array(
    'last-day',
    'last-week',
    'last-30-days',
);
$allowed_what = array(
    'rf-capacity',
    'rssi-mse',
    'modulation',
    'errors-packet-drops',
);
$when = isset($_GET['when']) ? $_GET['when'] : '';
$what = isset($_GET['what']) ? $_GET['what'] : '';
$idx = intval(isset($_GET['idx']) ? $_GET['idx'] : 1);

// Validate input
$is_valid = false;
if (in_array($when, $allowed_when) && in_array($what, $allowed_what)) {
    // All is ok
    $is_valid = true;
}
if (!$is_valid) {
    // Error on validation ... trigger error
    echo 'Invalid time interval and/or type. Please refresh the page and retry!';
}
?>

<div style="margin-top: 10px; padding: 10px;">
    <table style="width:100%;">
        <tr>
            <td width="100%">
                <div id="js-highcharts-container-historical-<?php echo $idx; ?>">

                </div>
            </td>
        </tr>
    </table>
</div>

<?php if ($is_valid): ?>
    <?php $number_of_channels = $capabilities['channels']; ?>
    <?php require_once(__DIR__.'/../views/plots/historical/'.$what.'.php'); ?>
<?php endif; ?>

<script>
    function refreshHistoricalPlots(idx) {
        <?php if ($is_valid): ?>
        doHistoricalPlotInit(idx);
        <?php endif; ?>
    }
</script>