<?php
// @used
  global $rx1_retransmission_oid, $sysconfig_oid;
  flush();

$do_not_include_common = true;
require_once("./config.php");

require_once("common.php") ;

if ($v3_en == 1) {
    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $link_lock_oid);
    $local_link = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_link_oid);
    $remote_link = preg_replace("/(INTEGER:)/", "", $ret);
} else {
    $ret = snmpget($localhost, $read_str, $link_lock_oid);
    $local_link = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmpget($localhost, $read_str, $remote_link_oid);
    $remote_link = preg_replace("/(INTEGER:)/", "", $ret);
}

$odu1_is_powered = false;
$odu2_is_powered = false;
$odu1_model_name = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu1_model);
$odu2_model_name = "N/A";
$odu1_is_detected = true;
$odu2_is_detected = true;
$rfmCount =	CustomDataRetrieval::getRFMCount();
$sysconfig = CustomDataRetrieval::pullSysOID($sysconfig_oid);
$is_rf2_virtual = ($rfmCount == 2) && ($sysconfig == 6 || $sysconfig == 7);  // 2+0 sp, half xpic sp
  
$odu1_is_powered = CustomDataRetrieval::pullSysODUIsPowered(1);
if ($is_rf2_virtual){
  $odu2_is_powered = $odu1_is_powered;
  $odu2_model_name = $odu1_model_name;
}
else if ($rfmCount == 2){
  $odu2_is_powered = CustomDataRetrieval::pullSysODUIsPowered(2);
  $odu2_model_name = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu2_model);
}
else{
  $odu2_is_powered = false;
}

if (!$odu1_is_powered || empty($odu1_model_name) || $odu1_model_name === "N/A" ) {
  $odu1_is_detected = false;
}

if($is_rf2_virtual){
  $odu2_is_detected = $odu1_is_detected;
}
else if ($rfmCount == 2 && (!$odu2_is_powered || empty($odu2_model_name) || $odu2_model_name === "N/A")){
  $odu2_is_detected = false;
}

import_page_header();
display_logo_banner();
echo '<body class="linknav" onload="getRemoteLocalStatistics()">';
echo '<div id="loading">
  <img id="loading-image" src="images/loading.gif" alt="Loading..." /></div>';

display_test_menu_basic(1);
display_view_config_menu('radio_info.config');

display_content_table_no_border();
echo '<tr height="10">';
display_none_shaded_row();
display_subtitle("LINK > LINK INFO");
enclose_content_table_row();
echo '<tr height="10">';
enclose_content_table();

display_content_table_no_border();
echo '<tr height="5"></tr><tr height="5"><td colspan="3"><div id="menu-border"></div></td></tr><tr height="5"></tr>';

display_none_shaded_row();
display_subtitle("RF LINK CONFIGURATION");
echo '<td width="30%" bgcolor=#f2f2f2></td>';
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Sysconfig:");
display_text_left($sysconfig_oid);
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Channel BW:");
// display_text_left($speed1_chwidth_oid);
$channel_bandwidth_code = CustomDataRetrieval::pullSysChannelBandwidth();
?>
<td bgcolor="#f2f2f2" width="20%" nowrap="nowrap"> <div id="left-text"><font size="2"><?php echo CustomDataRetrieval::getChannelBandwidthTextFromCode($channel_bandwidth_code); ?></font></div></td>
<?php

enclose_content_table_row();

$modulation_min_max = CustomDataRetrieval::getModemModulationMinMax(1, false);

display_none_shaded_row();
display_parameter_name("Min Modulation:");

?>
<td bgcolor="#f2f2f2" width="20%" nowrap="nowrap"> <div id="left-text"><font size="2"><?php echo $modulation_min_max[0]; ?></font></div></td>
<?php

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Max Modulation:");
?>
<td bgcolor="#f2f2f2" width="20%" nowrap="nowrap"> <div id="left-text"><font size="2"><?php echo $modulation_min_max[1]; ?></font></div></td>
<?php
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Retransmission:");
display_on_off($rx1_retransmission_oid, 0);
enclose_content_table_row();


display_none_shaded_row();
display_subtitle("");
echo '<td width="30%" bgcolor=#f2f2f2></td>';
enclose_content_table_row();

display_none_shaded_row();
echo '<td nowrap="nowrap" width="35%" bgcolor=#f2f2f2 align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#00478F>RF1</td>';
display_page_subtitle("Local Side");
display_page_subtitle("Remote Side");
enclose_content_table_row();

// NEW

if (($local_link == 1) && ($remote_link == 1)) {
    $reply_remote_link = exec("/var/www/cgi-bin/rflink.cgi 1");
} else {
    $reply_remote_link = '<br><br><b>No remote link!</b><br>';
}
$reply_remote_link = str_replace('</br>', '<br>', $reply_remote_link);
$reply_remote_link = explode('<br>', $reply_remote_link);

display_none_shaded_row();

display_parameter_name("Radio Power:");
($odu1_is_powered && $odu1_is_detected)?display_left_label("On"):display_left_label("Off");
display_parameter_name(isset($reply_remote_link[7]) ? ($reply_remote_link[7] ? "On" : "Off"): '');
enclose_content_table_row();

display_parameter_name("Model:");
($odu1_is_powered && $odu1_is_detected)?display_text_left(OID_Mappings::$odu1_model):display_left_label("-");
display_parameter_name(isset($reply_remote_link[6]) ? $reply_remote_link[6] : '');
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("T/R Spacing(MHz):");
($odu1_is_powered && $odu1_is_detected)?display_parameter_name(CustomDataRetrieval::pullSysODU1Duplex()):display_left_label("-");
display_parameter_name(isset($reply_remote_link[5]) ? $reply_remote_link[5] : '');
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Tx Frequency(MHz):");
($odu1_is_powered && $odu1_is_detected)?display_parameter_name(CustomDataRetrieval::pullSysODU1TXFrequency()):display_left_label("-");
display_parameter_name(isset($reply_remote_link[0]) ? $reply_remote_link[0] : '');
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Rx Frequency(MHz):");
($odu1_is_powered && $odu1_is_detected)?display_parameter_name(CustomDataRetrieval::pullSysODU1RXFrequency()):display_left_label("-");
display_parameter_name(isset($reply_remote_link[1]) ? $reply_remote_link[1] : '');
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Tx Power(dBm):");
($odu1_is_powered && $odu1_is_detected)?display_parameter_name(CustomDataRetrieval::pullSysODU1TXPower()):display_left_label("-");
display_parameter_name(isset($reply_remote_link[2]) ? $reply_remote_link[2] : '');
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Transmitter:");
($odu1_is_powered && $odu1_is_detected)?display_parameter_name((CustomDataRetrieval::pullSysODURFModuleIsOn(1) == 0) ? 'Off' : 'On'):display_left_label("-");
display_parameter_name(isset($reply_remote_link[3]) ? $reply_remote_link[3] : '');
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Polarization:");
($odu1_is_powered && $odu1_is_detected)?display_parameter_name(CustomUI::formatModemPolarizationForAll(CustomDataRetrieval::pullSysModemPolarization(1))):display_left_label("-");
display_parameter_name(isset($reply_remote_link[4]) ? ((intval($reply_remote_link[4]) == 1 || intval($reply_remote_link[4]) == 3) ? 'Horizontal' : 'Vertical') : '');

enclose_content_table_row();

display_none_shaded_row();
enclose_content_table_row();

if ($rfmCount == 2){
	display_none_shaded_row();
	echo '<td nowrap="nowrap" width="35%" bgcolor=#f2f2f2 align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#00478F>RF2</td>';
	display_page_subtitle("Local Side");
	display_page_subtitle("Remote Side");
	enclose_content_table_row();
  
  display_parameter_name("Radio Power:");
  if ($is_rf2_virtual) {
    ($odu1_is_powered && $odu1_is_detected)?display_left_label("On"):display_left_label("Off");
  }
  else{
    ($odu2_is_powered && $odu2_is_detected)?display_left_label("On"):display_left_label("Off");
  }
  display_parameter_name(isset($reply_remote_link[15]) ? ($reply_remote_link[15]?"On":"Off") : '');
  enclose_content_table_row();
  
  display_none_shaded_row();
  display_parameter_name("Model:");
  if ($is_rf2_virtual) {
    ($odu1_is_powered && $odu1_is_detected)?display_text_left(OID_Mappings::$odu1_model):display_left_label("-");
  }
  else{
    ($odu2_is_powered && $odu2_is_detected)?display_text_left(OID_Mappings::$odu2_model):display_left_label("-");
  }
  display_parameter_name(isset($reply_remote_link[14]) ? $reply_remote_link[14] : '');
  enclose_content_table_row();
  
  display_none_shaded_row();
  display_parameter_name("T/R Spacing(MHz):");
  ($odu2_is_powered && $odu2_is_detected)?display_parameter_name(CustomDataRetrieval::pullSysODU2Duplex()):display_left_label("-");
  display_parameter_name(isset($reply_remote_link[13]) ? $reply_remote_link[13] : '');
  enclose_content_table_row();
  
	display_none_shaded_row();
	display_parameter_name("Tx Frequency(MHz):");
  ($odu2_is_powered && $odu2_is_detected)?display_parameter_name(CustomDataRetrieval::pullSysODU2TXFrequency()):display_left_label("-");
	display_parameter_name(isset($reply_remote_link[8]) ? $reply_remote_link[8] : '');
	enclose_content_table_row();
	
	display_none_shaded_row();
	display_parameter_name("Rx Frequency(MHz):");
  ($odu2_is_powered && $odu2_is_detected)?display_parameter_name(CustomDataRetrieval::pullSysODU2RXFrequency()):display_left_label("-");
	display_parameter_name(isset($reply_remote_link[9]) ? $reply_remote_link[9] : '');
	enclose_content_table_row();
	
	display_none_shaded_row();
	display_parameter_name("Tx Power(dBm):");
  ($odu2_is_powered && $odu2_is_detected)?display_parameter_name(CustomDataRetrieval::pullSysODU2TXPower()):display_left_label("-");
	display_parameter_name(isset($reply_remote_link[10]) ? $reply_remote_link[10] : '');
	enclose_content_table_row();
	
	display_none_shaded_row();
	display_parameter_name("Transmitter:");
  ($odu2_is_powered && $odu2_is_detected)?display_parameter_name((CustomDataRetrieval::pullSysODURFModuleIsOn(2) == 0) ? 'Off' : 'On'):display_left_label("-");
	display_parameter_name(isset($reply_remote_link[11]) ? $reply_remote_link[11] : '');
	enclose_content_table_row();
	
	display_none_shaded_row();
	display_parameter_name("Polarization:");
  ($odu2_is_powered && $odu2_is_detected)?display_parameter_name(CustomUI::formatModemPolarizationForAll(CustomDataRetrieval::pullSysModemPolarization(2))):display_left_label("-");
  display_parameter_name(isset($reply_remote_link[12]) ? ((intval($reply_remote_link[12]) == 1 || intval($reply_remote_link[12]) == 3) ? 'Horizontal' : 'Vertical') : '');
	enclose_content_table_row();
	
	display_none_shaded_row();
	enclose_content_table_row();
}

// OLD


enclose_content_table();
display_footer();
?>

<script language="javascript" type="text/javascript">
    $(window).load(function () {
        $('#loading').hide();
    });
</script>
<script language="javascript" type="text/javascript">
    window.onbeforeunload = function () {
        $('#loading').show();
    };
</script>
