<?php
// @used
flush();

include 'common.php';

if ($v3_en == 1) {
    $model = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $omu_model_oid);
    $model = preg_replace('/(STRING: )/', "", $model);
    $model = trim($model, "\"");

    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $link_lock_oid);
    $local_link = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_link_oid);
    $remote_link = preg_replace("/(INTEGER:)/", "", $ret);

    /*if(($local_link == 1) && ($remote_link == 1))
    {
          $set = snmp3_set($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_req_oid, "i", 5, 5000000, 0);
          usleep(1000000);
    }*/
} else {
    $model = snmpget($localhost, $read_str, $omu_model_oid);
    $model = preg_replace('/(STRING: )/', "", $model);
    $model = trim($model, "\"");

    $ret = snmpget($localhost, $read_str, $link_lock_oid);
    $local_link = preg_replace("/(INTEGER:)/", "", $ret);

    $ret = snmpget($localhost, $read_str, $remote_link_oid);
    $remote_link = preg_replace("/(INTEGER:)/", "", $ret);

    /*if(($local_link == 1) && ($remote_link == 1))
    {
          $set = snmpset($localhost, $write_str, $remote_req_oid, "i", 5, 5000000, 0);
          usleep(1000000);
    }*/
}

import_page_header();
display_logo_banner();
echo '<body class="statusnav" onload="getRemoteLocalStatistics()">';
echo '<div id="loading">
  <img id="loading-image" src="images/loading.gif" alt="Loading..." /></div>';

display_test_menu_status(3);
display_list_status();

display_content_table_no_border();
echo '<tr height="10">';

display_none_shaded_row();
display_subtitle("SYSTEM > LINK STATUS");
//echo '<td width="30%"></td>';
enclose_content_table_row();

display_none_shaded_row();
echo '<td width="40%"></td>';
display_page_subtitle("Local Side");
display_page_subtitle("Remote Side");
echo '<td width="20%"></td>';
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("RF1 Link History:");
display_parameter_name(CustomDataRetrieval::pullSysLinkHistory(1));

echo '<td rowspan="15"><div class="data-cgi">';

if (($local_link == 1) && ($remote_link == 1)) {
    echo exec("/var/www/cgi-bin/rflink.cgi 5");
} else {
    echo '<b>No remote link!</b>';
}
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("RF2 Link History:");
display_parameter_name(CustomDataRetrieval::pullSysLinkHistory(2));

enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("RF1 LDPC Decoder Stress:");
display_parameter_name(CustomDataRetrieval::pullSysLDPCStressDecoder(1));
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("RF2 LDPC Decoder Stress:");
display_parameter_name(CustomDataRetrieval::pullSysLDPCStressDecoder(2));
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("HC Enable:");
display_text_left($hc_enable_oid);
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("L2 Flow Count:");
display_parameter_name(CustomDataRetrieval::pullLXFlowCount(2));
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("L3 Flow Count:");
display_parameter_name(CustomDataRetrieval::pullLXFlowCount(3));
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Net Compression %:");
display_parameter_name(CustomDataRetrieval::pullSysNetCompression());
enclose_content_table_row();

display_none_shaded_row();
display_parameter_name("Current Tx Capacity (Mbps): ");
display_parameter_name(CustomDataRetrieval::pullSysTXCurrentCapacity());
enclose_content_table_row();

if (strstr($model, "SP24-S") == null) {
    display_none_shaded_row();
    display_parameter_name("PLA Tx State: ");
    display_text_left($pla_txstatus_oid);
    enclose_content_table_row();

    display_none_shaded_row();
    display_parameter_name("PLA Rx State: ");
    display_text_left($pla_rxstatus_oid);
    enclose_content_table_row();

    display_none_shaded_row();
    display_parameter_name("XPIC Enable: ");
    display_parameter_name(CustomDataRetrieval::pullSysXPICEnabled(false));
    enclose_content_table_row();

    display_none_shaded_row();
    display_parameter_name("XPIC Preamble: ");
    display_text_left($xpic_hv_oid);
    enclose_content_table_row();

    display_none_shaded_row();
    display_parameter_name("Modem 1 XPD: ");
    display_parameter_name(CustomDataRetrieval::pullSysModemXPD(1));
    enclose_content_table_row();

    display_none_shaded_row();
    display_parameter_name("Modem 2 XPD: ");
    display_parameter_name(CustomDataRetrieval::pullSysModemXPD(2));
    enclose_content_table_row();
}

enclose_content_table();

display_footer();
?>
<script language="javascript" type="text/javascript">
    $(window).load(function () {
        $('#loading').hide();
    });
</script>
<script language="javascript" type="text/javascript">
    window.onbeforeunload = function () {
        $('#loading').show();
    };
</script>
