/*
 Highstock JS v9.1.0 (2021-05-03)

 Advanced Highcharts Stock tools

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock-tools",["highcharts","highcharts/modules/stock"],function(v){a(v);a.Highcharts=v;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function v(d,a,u,y){d.hasOwnProperty(a)||(d[a]=y.apply(null,u))}a=a?a._modules:{};v(a,"Extensions/Annotations/Mixins/EventEmitterMixin.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],
function(d,a){var g=a.addEvent,y=a.fireEvent,q=a.objectEach,l=a.pick,c=a.removeEvent;return{addEvents:function(){var c=this,e=function(e){g(e,d.isTouchDevice?"touchstart":"mousedown",function(e){c.onMouseDown(e)},{passive:!1})};e(this.graphic.element);(c.labels||[]).forEach(function(c){c.options.useHTML&&c.graphic.text&&e(c.graphic.text.element)});q(c.options.events,function(e,p){var m=function(m){"click"===p&&c.cancelClick||e.call(c,c.chart.pointer.normalize(m),c.target)};if(-1===(c.nonDOMEvents||
[]).indexOf(p))c.graphic.on(p,m);else g(c,p,m,{passive:!1})});if(c.options.draggable&&(g(c,"drag",c.onDrag),!c.graphic.renderer.styledMode)){var p={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[c.options.draggable]};c.graphic.css(p);(c.labels||[]).forEach(function(e){e.options.useHTML&&e.graphic.text&&e.graphic.text.css(p)})}c.isUpdating||y(c,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(c){var e=
this,p=e.chart.pointer;c.preventDefault&&c.preventDefault();if(2!==c.button){c=p.normalize(c);var r=c.chartX;var h=c.chartY;e.cancelClick=!1;e.chart.hasDraggedAnnotation=!0;e.removeDrag=g(d.doc,d.isTouchDevice?"touchmove":"mousemove",function(c){e.hasDragged=!0;c=p.normalize(c);c.prevChartX=r;c.prevChartY=h;y(e,"drag",c);r=c.chartX;h=c.chartY},d.isTouchDevice?{passive:!1}:void 0);e.removeMouseUp=g(d.doc,d.isTouchDevice?"touchend":"mouseup",function(c){e.cancelClick=e.hasDragged;e.hasDragged=!1;e.chart.hasDraggedAnnotation=
!1;y(l(e.target,e),"afterUpdate");e.onMouseUp(c)},d.isTouchDevice?{passive:!1}:void 0)}},onMouseUp:function(c){var e=this.chart;c=this.target||this;var p=e.options.annotations;e=e.annotations.indexOf(c);this.removeDocEvents();p[e]=c.options},onDrag:function(c){if(this.chart.isInsidePlot(c.chartX-this.chart.plotLeft,c.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var e=this.mouseMoveToTranslation(c);"x"===this.options.draggable&&(e.y=0);"y"===this.options.draggable&&(e.x=0);this.points.length?this.translate(e.x,
e.y):(this.shapes.forEach(function(c){c.translate(e.x,e.y)}),this.labels.forEach(function(c){c.translate(e.x,e.y)}));this.redraw(!1)}},mouseMoveToRadians:function(c,e,p){var d=c.prevChartY-p,h=c.prevChartX-e;p=c.chartY-p;c=c.chartX-e;this.chart.inverted&&(e=h,h=d,d=e,e=c,c=p,p=e);return Math.atan2(p,c)-Math.atan2(d,h)},mouseMoveToTranslation:function(c){var e=c.chartX-c.prevChartX;c=c.chartY-c.prevChartY;if(this.chart.inverted){var p=c;c=e;e=p}return{x:e,y:c}},mouseMoveToScale:function(c,e,p){e=(c.chartX-
e||1)/(c.prevChartX-e||1);c=(c.chartY-p||1)/(c.prevChartY-p||1);this.chart.inverted&&(p=c,c=e,e=p);return{x:e,y:c}},destroy:function(){this.removeDocEvents();c(this);this.hcEvents=null}}});v(a,"Extensions/Annotations/ControlPoint.js",[a["Core/Utilities.js"],a["Extensions/Annotations/Mixins/EventEmitterMixin.js"]],function(d,a){var g=d.merge,y=d.pick;return function(){function d(d,c,C,e){this.addEvents=a.addEvents;this.graphic=void 0;this.mouseMoveToRadians=a.mouseMoveToRadians;this.mouseMoveToScale=
a.mouseMoveToScale;this.mouseMoveToTranslation=a.mouseMoveToTranslation;this.onDrag=a.onDrag;this.onMouseDown=a.onMouseDown;this.onMouseUp=a.onMouseUp;this.removeDocEvents=a.removeDocEvents;this.nonDOMEvents=["drag"];this.chart=d;this.target=c;this.options=C;this.index=y(C.index,e)}d.prototype.setVisibility=function(d){this.graphic.attr("visibility",d?"visible":"hidden");this.options.visible=d};d.prototype.render=function(){var d=this.chart,c=this.options;this.graphic=d.renderer.symbol(c.symbol,0,
0,c.width,c.height).add(d.controlPointsGroup).css(c.style);this.setVisibility(c.visible);this.addEvents()};d.prototype.redraw=function(d){this.graphic[d?"animate":"attr"](this.options.positioner.call(this,this.target))};d.prototype.destroy=function(){a.destroy.call(this);this.graphic&&(this.graphic=this.graphic.destroy());this.options=this.target=this.chart=null};d.prototype.update=function(d){var c=this.chart,a=this.target,e=this.index;d=g(!0,this.options,d);this.destroy();this.constructor(c,a,d,
e);this.render(c.controlPointsGroup);this.redraw()};return d}()});v(a,"Extensions/Annotations/MockPoint.js",[a["Core/Series/Series.js"],a["Core/Utilities.js"],a["Core/Axis/Axis.js"]],function(d,a,u){var g=a.defined,q=a.fireEvent;return function(){function a(c,a,e){this.y=this.x=this.plotY=this.plotX=this.isInside=void 0;this.mock=!0;this.series={visible:!0,chart:c,getPlotBox:d.prototype.getPlotBox};this.target=a||null;this.options=e;this.applyOptions(this.getOptions())}a.fromPoint=function(c){return new a(c.series.chart,
null,{x:c.x,y:c.y,xAxis:c.series.xAxis,yAxis:c.series.yAxis})};a.pointToPixels=function(c,d){var e=c.series,p=e.chart,a=c.plotX,h=c.plotY;p.inverted&&(c.mock?(a=c.plotY,h=c.plotX):(a=p.plotWidth-c.plotY,h=p.plotHeight-c.plotX));e&&!d&&(c=e.getPlotBox(),a+=c.translateX,h+=c.translateY);return{x:a,y:h}};a.pointToOptions=function(c){return{x:c.x,y:c.y,xAxis:c.series.xAxis,yAxis:c.series.yAxis}};a.prototype.hasDynamicOptions=function(){return"function"===typeof this.options};a.prototype.getOptions=function(){return this.hasDynamicOptions()?
this.options(this.target):this.options};a.prototype.applyOptions=function(c){this.command=c.command;this.setAxis(c,"x");this.setAxis(c,"y");this.refresh()};a.prototype.setAxis=function(c,d){d+="Axis";c=c[d];var e=this.series.chart;this.series[d]=c instanceof u?c:g(c)?e[d][c]||e.get(c):null};a.prototype.toAnchor=function(){var c=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&(c[0]=this.plotY,c[1]=this.plotX);return c};a.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}};
a.prototype.isInsidePlot=function(){var c=this.plotX,d=this.plotY,e=this.series.xAxis,p=this.series.yAxis,a={x:c,y:d,isInsidePlot:!0};e&&(a.isInsidePlot=g(c)&&0<=c&&c<=e.len);p&&(a.isInsidePlot=a.isInsidePlot&&g(d)&&0<=d&&d<=p.len);q(this.series.chart,"afterIsInsidePlot",a);return a.isInsidePlot};a.prototype.refresh=function(){var c=this.series,d=c.xAxis;c=c.yAxis;var e=this.getOptions();d?(this.x=e.x,this.plotX=d.toPixels(e.x,!0)):(this.x=null,this.plotX=e.x);c?(this.y=e.y,this.plotY=c.toPixels(e.y,
!0)):(this.y=null,this.plotY=e.y);this.isInside=this.isInsidePlot()};a.prototype.translate=function(c,d,e,a){this.hasDynamicOptions()||(this.plotX+=e,this.plotY+=a,this.refreshOptions())};a.prototype.scale=function(c,d,e,a){if(!this.hasDynamicOptions()){var p=this.plotY*a;this.plotX=(1-e)*c+this.plotX*e;this.plotY=(1-a)*d+p;this.refreshOptions()}};a.prototype.rotate=function(c,d,e){if(!this.hasDynamicOptions()){var a=Math.cos(e);e=Math.sin(e);var r=this.plotX,h=this.plotY;r-=c;h-=d;this.plotX=r*a-
h*e+c;this.plotY=r*e+h*a+d;this.refreshOptions()}};a.prototype.refreshOptions=function(){var c=this.series,d=c.xAxis;c=c.yAxis;this.x=this.options.x=d?this.options.x=d.toValue(this.plotX,!0):this.plotX;this.y=this.options.y=c?c.toValue(this.plotY,!0):this.plotY};return a}()});v(a,"Extensions/Annotations/Mixins/ControllableMixin.js",[a["Extensions/Annotations/ControlPoint.js"],a["Extensions/Annotations/MockPoint.js"],a["Core/Tooltip.js"],a["Core/Utilities.js"]],function(d,a,u,y){var g=y.isObject,l=
y.isString,c=y.merge,C=y.splat;return{init:function(c,d,a){this.annotation=c;this.chart=c.chart;this.options=d;this.points=[];this.controlPoints=[];this.index=a;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var c=this.options;return c.points||c.point&&C(c.point)},attrsFromOptions:function(c){var d=this.constructor.attrsMap,e={},a,m=this.chart.styledMode;for(a in c){var t=d[a];!t||m&&-1!==["fill","stroke","stroke-width"].indexOf(t)||
(e[t]=c[a])}return e},anchor:function(d){var e=d.series.getPlotBox(),a=d.series.chart,h=d.mock?d.toAnchor():u.prototype.getAnchor.call({chart:d.series.chart},d);h={x:h[0]+(this.options.x||0),y:h[1]+(this.options.y||0),height:h[2]||0,width:h[3]||0};return{relativePosition:h,absolutePosition:c(h,{x:h.x+(d.mock?e.translateX:a.plotLeft),y:h.y+(d.mock?e.translateY:a.plotTop)})}},point:function(c,d){if(c&&c.series)return c;d&&null!==d.series||(g(c)?d=new a(this.chart,this,c):l(c)?d=this.chart.get(c)||null:
"function"===typeof c&&(d=c.call(d,this),d=d.series?d:new a(this.chart,this,c)));return d},linkPoints:function(){var c=this.getPointsOptions(),d=this.points,a=c&&c.length||0,h;for(h=0;h<a;h++){var m=this.point(c[h],d[h]);if(!m){d.length=0;return}m.mock&&m.refresh();d[h]=m}return d},addControlPoints:function(){var a=this.options.controlPoints;(a||[]).forEach(function(e,r){e=c(this.options.controlPointOptions,e);e.index||(e.index=r);a[r]=e;this.controlPoints.push(new d(this.chart,this,e))},this)},shouldBeDrawn:function(){return!!this.points.length},
render:function(c){this.controlPoints.forEach(function(c){c.render()})},redraw:function(c){this.controlPoints.forEach(function(d){d.redraw(c)})},transform:function(c,d,a,h,m){if(this.chart.inverted){var e=d;d=a;a=e}this.points.forEach(function(e,k){this.transformPoint(c,d,a,h,m,k)},this)},transformPoint:function(c,d,r,h,m,t){var e=this.points[t];e.mock||(e=this.points[t]=a.fromPoint(e));e[c](d,r,h,m)},translate:function(c,d){this.transform("translate",null,null,c,d)},translatePoint:function(c,d,a){this.transformPoint("translate",
null,null,c,d,a)},translateShape:function(c,d){var a=this.annotation.chart,e=this.annotation.userOptions,m=a.annotations.indexOf(this.annotation);a=a.options.annotations[m];this.translatePoint(c,d,0);a[this.collection][this.index].point=this.options.point;e[this.collection][this.index].point=this.options.point},rotate:function(c,d,a){this.transform("rotate",c,d,a)},scale:function(c,d,a,h){this.transform("scale",c,d,a,h)},setControlPointsVisibility:function(c){this.controlPoints.forEach(function(d){d.setVisibility(c)})},
destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());this.controlPoints.forEach(function(c){c.destroy()});this.options=this.controlPoints=this.points=this.chart=null;this.annotation&&(this.annotation=null)},update:function(d){var a=this.annotation;d=c(!0,this.options,d);var e=this.graphic.parentGroup;this.destroy();this.constructor(a,d,this.index);this.render(e);this.redraw()}}});v(a,"Extensions/Annotations/Mixins/MarkerMixin.js",
[a["Core/Chart/Chart.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(d,a,u){function g(c){return function(d){this.attr(c,"url(#"+d+")")}}var q=u.addEvent,l=u.defined,c=u.merge,C=u.uniqueKey,e={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},
children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};a.prototype.addMarker=function(d,a){var e={attributes:{id:d}},m={stroke:a.color||"none",fill:a.color||"rgba(0, 0, 0, 0.75)"};e.children=a.children&&a.children.map(function(d){return c(m,d)});a=c(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},a,e);a=this.definition(a);a.id=d;return a};a={markerEndSetter:g("marker-end"),markerStartSetter:g("marker-start"),setItemMarkers:function(d){var a=
d.options,e=d.chart,m=e.options.defs,t=a.fill,p=l(t)&&"none"!==t?t:a.stroke;["markerStart","markerEnd"].forEach(function(k){var b=a[k],f;if(b){for(f in m){var n=m[f];if((b===(n.attributes&&n.attributes.id)||b===n.id)&&"marker"===n.tagName){var x=n;break}}x&&(b=d[k]=e.renderer.addMarker((a.id||C())+"-"+b,c(x,{color:p})),d.attr(k,b.getAttribute("id")))}})}};q(d,"afterGetContainer",function(){this.options.defs=c(e,this.options.defs||{})});return a});v(a,"Extensions/Annotations/Controllables/ControllablePath.js",
[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Core/Globals.js"],a["Extensions/Annotations/Mixins/MarkerMixin.js"],a["Core/Utilities.js"]],function(d,a,u,y){var g=y.extend,l="rgba(192,192,192,"+(a.svg?.0001:.002)+")";return function(){function c(c,a,p){this.addControlPoints=d.addControlPoints;this.anchor=d.anchor;this.attr=d.attr;this.attrsFromOptions=d.attrsFromOptions;this.destroy=d.destroy;this.getPointsOptions=d.getPointsOptions;this.init=d.init;this.linkPoints=d.linkPoints;this.point=
d.point;this.rotate=d.rotate;this.scale=d.scale;this.setControlPointsVisibility=d.setControlPointsVisibility;this.setMarkers=u.setItemMarkers;this.transform=d.transform;this.transformPoint=d.transformPoint;this.translate=d.translate;this.translatePoint=d.translatePoint;this.translateShape=d.translateShape;this.update=d.update;this.type="path";this.init(c,a,p);this.collection="shapes"}c.prototype.toD=function(){var c=this.options.d;if(c)return"function"===typeof c?c.call(this):c;c=this.points;var d=
c.length,a=d,l=c[0],h=a&&this.anchor(l).absolutePosition,m=0,t=[];if(h)for(t.push(["M",h.x,h.y]);++m<d&&a;)l=c[m],a=l.command||"L",h=this.anchor(l).absolutePosition,"M"===a?t.push([a,h.x,h.y]):"L"===a?t.push([a,h.x,h.y]):"Z"===a&&t.push([a]),a=l.series.visible;return a?this.chart.renderer.crispLine(t,this.graphic.strokeWidth()):null};c.prototype.shouldBeDrawn=function(){return d.shouldBeDrawn.call(this)||!!this.options.d};c.prototype.render=function(c){var a=this.options,p=this.attrsFromOptions(a);
this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(p).add(c);a.className&&this.graphic.addClass(a.className);this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(c);this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:l,fill:l,"stroke-width":this.graphic.strokeWidth()+2*a.snap});d.render.call(this);g(this.graphic,{markerStartSetter:u.markerStartSetter,markerEndSetter:u.markerEndSetter});
this.setMarkers(this)};c.prototype.redraw=function(c){var a=this.toD(),l=c?"animate":"attr";a?(this.graphic[l]({d:a}),this.tracker[l]({d:a})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));this.graphic.placed=this.tracker.placed=!!a;d.redraw.call(this,c)};c.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"};return c}()});v(a,"Extensions/Annotations/Controllables/ControllableRect.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],
a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Core/Utilities.js"]],function(d,a,u){var g=u.merge;return function(){function q(a,c,g){this.addControlPoints=d.addControlPoints;this.anchor=d.anchor;this.attr=d.attr;this.attrsFromOptions=d.attrsFromOptions;this.destroy=d.destroy;this.getPointsOptions=d.getPointsOptions;this.init=d.init;this.linkPoints=d.linkPoints;this.point=d.point;this.rotate=d.rotate;this.scale=d.scale;this.setControlPointsVisibility=d.setControlPointsVisibility;
this.shouldBeDrawn=d.shouldBeDrawn;this.transform=d.transform;this.transformPoint=d.transformPoint;this.translatePoint=d.translatePoint;this.translateShape=d.translateShape;this.update=d.update;this.type="rect";this.translate=d.translateShape;this.init(a,c,g);this.collection="shapes"}q.prototype.render=function(a){var c=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(c).add(a);d.render.call(this)};q.prototype.redraw=function(a){var c=this.anchor(this.points[0]).absolutePosition;
if(c)this.graphic[a?"animate":"attr"]({x:c.x,y:c.y,width:this.options.width,height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!c;d.redraw.call(this,a)};q.attrsMap=g(a.attrsMap,{width:"width",height:"height"});return q}()});v(a,"Extensions/Annotations/Controllables/ControllableCircle.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Core/Utilities.js"]],function(d,a,u){var g=u.merge;return function(){function q(a,
c,g){this.addControlPoints=d.addControlPoints;this.anchor=d.anchor;this.attr=d.attr;this.attrsFromOptions=d.attrsFromOptions;this.destroy=d.destroy;this.getPointsOptions=d.getPointsOptions;this.init=d.init;this.linkPoints=d.linkPoints;this.point=d.point;this.rotate=d.rotate;this.scale=d.scale;this.setControlPointsVisibility=d.setControlPointsVisibility;this.shouldBeDrawn=d.shouldBeDrawn;this.transform=d.transform;this.transformPoint=d.transformPoint;this.translatePoint=d.translatePoint;this.translateShape=
d.translateShape;this.update=d.update;this.type="circle";this.translate=d.translateShape;this.init(a,c,g);this.collection="shapes"}q.prototype.render=function(a){var c=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(c).add(a);d.render.call(this)};q.prototype.redraw=function(a){var c=this.anchor(this.points[0]).absolutePosition;if(c)this.graphic[a?"animate":"attr"]({x:c.x,y:c.y,r:this.options.r});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=
!!c;d.redraw.call(this,a)};q.prototype.setRadius=function(a){this.options.r=a};q.attrsMap=g(a.attrsMap,{r:"r"});return q}()});v(a,"Extensions/Annotations/Controllables/ControllableLabel.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Core/FormatUtilities.js"],a["Extensions/Annotations/MockPoint.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Tooltip.js"],a["Core/Utilities.js"]],function(a,g,u,y,q,l){var c=g.format,d=l.extend,e=l.isNumber,p=l.pick;g=function(){function e(c,d,e){this.addControlPoints=
a.addControlPoints;this.attr=a.attr;this.attrsFromOptions=a.attrsFromOptions;this.destroy=a.destroy;this.getPointsOptions=a.getPointsOptions;this.init=a.init;this.linkPoints=a.linkPoints;this.point=a.point;this.rotate=a.rotate;this.scale=a.scale;this.setControlPointsVisibility=a.setControlPointsVisibility;this.shouldBeDrawn=a.shouldBeDrawn;this.transform=a.transform;this.transformPoint=a.transformPoint;this.translateShape=a.translateShape;this.update=a.update;this.init(c,d,e);this.collection="labels"}
e.alignedPosition=function(c,a){var d=c.align,e=c.verticalAlign,k=(a.x||0)+(c.x||0),b=(a.y||0)+(c.y||0),f,n;"right"===d?f=1:"center"===d&&(f=2);f&&(k+=(a.width-(c.width||0))/f);"bottom"===e?n=1:"middle"===e&&(n=2);n&&(b+=(a.height-(c.height||0))/n);return{x:Math.round(k),y:Math.round(b)}};e.justifiedOptions=function(c,a,d,e){var k=d.align,b=d.verticalAlign,f=a.box?0:a.padding||0,n=a.getBBox();a={align:k,verticalAlign:b,x:d.x,y:d.y,width:a.width,height:a.height};d=(e.x||0)-c.plotLeft;var x=(e.y||0)-
c.plotTop;e=d+f;0>e&&("right"===k?a.align="left":a.x=(a.x||0)-e);e=d+n.width-f;e>c.plotWidth&&("left"===k?a.align="right":a.x=(a.x||0)+c.plotWidth-e);e=x+f;0>e&&("bottom"===b?a.verticalAlign="top":a.y=(a.y||0)-e);e=x+n.height-f;e>c.plotHeight&&("top"===b?a.verticalAlign="bottom":a.y=(a.y||0)+c.plotHeight-e);return a};e.prototype.translatePoint=function(c,d){a.translatePoint.call(this,c,d,0)};e.prototype.translate=function(c,a){var d=this.annotation.chart,e=this.annotation.userOptions,k=d.annotations.indexOf(this.annotation);
k=d.options.annotations[k];d.inverted&&(d=c,c=a,a=d);this.options.x+=c;this.options.y+=a;k[this.collection][this.index].x=this.options.x;k[this.collection][this.index].y=this.options.y;e[this.collection][this.index].x=this.options.x;e[this.collection][this.index].y=this.options.y};e.prototype.render=function(c){var d=this.options,h=this.attrsFromOptions(d),g=d.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,d.shape,null,null,d.useHTML,null,"annotation-label").attr(h).add(c);this.annotation.chart.styledMode||
("contrast"===g.color&&(g.color=this.annotation.chart.renderer.getContrast(-1<e.shapesWithoutBackground.indexOf(d.shape)?"#FFFFFF":d.backgroundColor)),this.graphic.css(d.style).shadow(d.shadow));d.className&&this.graphic.addClass(d.className);this.graphic.labelrank=d.labelrank;a.render.call(this)};e.prototype.redraw=function(d){var e=this.options,h=this.text||e.format||e.text,g=this.graphic,k=this.points[0];g.attr({text:h?c(h,k.getLabelConfig(),this.annotation.chart):e.formatter.call(k,this)});e=
this.anchor(k);(h=this.position(e))?(g.alignAttr=h,h.anchorX=e.absolutePosition.x,h.anchorY=e.absolutePosition.y,g[d?"animate":"attr"](h)):g.attr({x:0,y:-9999});g.placed=!!h;a.redraw.call(this,d)};e.prototype.anchor=function(c){var d=a.anchor.apply(this,arguments),e=this.options.x||0,h=this.options.y||0;d.absolutePosition.x-=e;d.absolutePosition.y-=h;d.relativePosition.x-=e;d.relativePosition.y-=h;return d};e.prototype.position=function(c){var a=this.graphic,h=this.annotation.chart,g=this.points[0],
k=this.options,b=c.absolutePosition,f=c.relativePosition,n=g.series.visible&&u.prototype.isInsidePlot.call(g);c=a.width;c=void 0===c?0:c;var x=a.height;x=void 0===x?0:x;if(n){if(k.distance)var A=q.prototype.getPosition.call({chart:h,distance:p(k.distance,16)},c,x,{plotX:f.x,plotY:f.y,negative:g.negative,ttBelow:g.ttBelow,h:f.height||f.width});else k.positioner?A=k.positioner.call(this):(g={x:b.x,y:b.y,width:0,height:0},A=e.alignedPosition(d(k,{width:c,height:x}),g),"justify"===this.options.overflow&&
(A=e.alignedPosition(e.justifiedOptions(h,a,k,A),g)));k.crop&&(a=A.x-h.plotLeft,k=A.y-h.plotTop,n=h.isInsidePlot(a,k)&&h.isInsidePlot(a+c,k+x))}return n?A:null};e.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};e.shapesWithoutBackground=["connector"];return e}();y.prototype.symbols.connector=function(c,a,d,g,l){var k=l&&l.anchorX;l=l&&l.anchorY;var b=d/2;if(e(k)&&e(l)){var f=[["M",k,l]];var n=a-l;0>n&&(n=-g-n);n<
d&&(b=k<c+d/2?n:d-n);l>a+g?f.push(["L",c+b,a+g]):l<a?f.push(["L",c+b,a]):k<c?f.push(["L",c,a+g/2]):k>c+d&&f.push(["L",c+d,a+g/2])}return f||[]};return g});v(a,"Extensions/Annotations/Controllables/ControllableImage.js",[a["Extensions/Annotations/Controllables/ControllableLabel.js"],a["Extensions/Annotations/Mixins/ControllableMixin.js"]],function(a,g){return function(){function d(a,d,l){this.addControlPoints=g.addControlPoints;this.anchor=g.anchor;this.attr=g.attr;this.attrsFromOptions=g.attrsFromOptions;
this.destroy=g.destroy;this.getPointsOptions=g.getPointsOptions;this.init=g.init;this.linkPoints=g.linkPoints;this.point=g.point;this.rotate=g.rotate;this.scale=g.scale;this.setControlPointsVisibility=g.setControlPointsVisibility;this.shouldBeDrawn=g.shouldBeDrawn;this.transform=g.transform;this.transformPoint=g.transformPoint;this.translatePoint=g.translatePoint;this.translateShape=g.translateShape;this.update=g.update;this.type="image";this.translate=g.translateShape;this.init(a,d,l);this.collection=
"shapes"}d.prototype.render=function(a){var d=this.attrsFromOptions(this.options),l=this.options;this.graphic=this.annotation.chart.renderer.image(l.src,0,-9E9,l.width,l.height).attr(d).add(a);this.graphic.width=l.width;this.graphic.height=l.height;g.render.call(this)};d.prototype.redraw=function(d){var q=this.anchor(this.points[0]);if(q=a.prototype.position.call(this,q))this.graphic[d?"animate":"attr"]({x:q.x,y:q.y});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!q;g.redraw.call(this,
d)};d.attrsMap={width:"width",height:"height",zIndex:"zIndex"};return d}()});v(a,"Extensions/Annotations/Annotations.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Chart/Chart.js"],a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Extensions/Annotations/Controllables/ControllableRect.js"],a["Extensions/Annotations/Controllables/ControllableCircle.js"],a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Extensions/Annotations/Controllables/ControllableImage.js"],a["Extensions/Annotations/Controllables/ControllableLabel.js"],
a["Extensions/Annotations/ControlPoint.js"],a["Extensions/Annotations/Mixins/EventEmitterMixin.js"],a["Core/Globals.js"],a["Extensions/Annotations/MockPoint.js"],a["Core/Pointer.js"],a["Core/Utilities.js"],a["Core/Color/Palette.js"]],function(a,g,u,y,q,l,c,C,e,p,r,h,m,t,v){var d=a.getDeferredAnimation;a=g.prototype;var b=t.addEvent,f=t.defined,n=t.destroyObjectProperties,x=t.erase,A=t.extend,D=t.find,w=t.fireEvent,z=t.merge,B=t.pick,G=t.splat;t=t.wrap;var E=function(){function b(b,a){this.annotation=
void 0;this.coll="annotations";this.shapesGroup=this.labelsGroup=this.labelCollector=this.group=this.graphic=this.animationConfig=this.collection=void 0;this.chart=b;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=z(this.defaultOptions,a);this.userOptions=a;a=this.getLabelsAndShapesOptions(this.options,a);this.options.labels=a.labels;this.options.shapes=a.shapes;this.init(b,this.options)}b.prototype.init=function(){var b=this.chart,a=this.options.animation;
this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.setLabelCollector();this.animationConfig=d(b,a)};b.prototype.getLabelsAndShapesOptions=function(b,a){var c={};["labels","shapes"].forEach(function(f){b[f]&&(c[f]=G(a[f]).map(function(a,c){return z(b[f][c],a)}))});return c};b.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(b,a){b=this.initShape(b,a);z(!0,this.options.shapes[a],b.options)},this)};b.prototype.addLabels=function(){(this.options.labels||
[]).forEach(function(b,a){b=this.initLabel(b,a);z(!0,this.options.labels[a],b.options)},this)};b.prototype.addClipPaths=function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))};b.prototype.setClipAxes=function(){var b=this.chart.xAxis,a=this.chart.yAxis,c=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(c,f){return[b[f&&f.point&&f.point.xAxis]||c[0],a[f&&f.point&&f.point.yAxis]||c[1]]},[]);this.clipXAxis=
c[0];this.clipYAxis=c[1]};b.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}};b.prototype.setLabelCollector=function(){var b=this;b.labelCollector=function(){return b.labels.reduce(function(b,a){a.options.allowOverlap||b.push(a.graphic);return b},[])};b.chart.labelCollectors.push(b.labelCollector)};b.prototype.setOptions=function(b){this.options=z(this.defaultOptions,b)};b.prototype.redraw=
function(b){this.linkPoints();this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());this.redrawItems(this.shapes,b);this.redrawItems(this.labels,b);u.redraw.call(this,b)};b.prototype.redrawItems=function(b,a){for(var c=b.length;c--;)this.redrawItem(b[c],a)};b.prototype.renderItems=function(b){for(var a=b.length;a--;)this.renderItem(b[a])};b.prototype.render=function(){var b=this.chart.renderer;this.graphic=b.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,
visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=b.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip);this.labelsGroup=b.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.addClipPaths();this.clipRect&&this.graphic.clip(this.clipRect);this.renderItems(this.shapes);this.renderItems(this.labels);this.addEvents();u.render.call(this)};b.prototype.setVisibility=function(b){var a=this.options;b=B(b,!a.visible);this.graphic.attr("visibility",
b?"visible":"hidden");b||this.setControlPointsVisibility(!1);a.visible=b};b.prototype.setControlPointsVisibility=function(b){var a=function(a){a.setControlPointsVisibility(b)};u.setControlPointsVisibility.call(this,b);this.shapes.forEach(a);this.labels.forEach(a)};b.prototype.destroy=function(){var b=this.chart,a=function(b){b.destroy()};this.labels.forEach(a);this.shapes.forEach(a);this.clipYAxis=this.clipXAxis=null;x(b.labelCollectors,this.labelCollector);p.destroy.call(this);u.destroy.call(this);
n(this,b)};b.prototype.remove=function(){return this.chart.removeAnnotation(this)};b.prototype.update=function(b,a){var c=this.chart,f=this.getLabelsAndShapesOptions(this.userOptions,b),d=c.annotations.indexOf(this);b=z(!0,this.userOptions,b);b.labels=f.labels;b.shapes=f.shapes;this.destroy();this.constructor(c,b);c.options.annotations[d]=b;this.isUpdating=!0;B(a,!0)&&c.redraw();w(this,"afterUpdate");this.isUpdating=!1};b.prototype.initShape=function(a,c){a=z(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},
a);c=new b.shapesMap[a.type](this,a,c);c.itemType="shape";this.shapes.push(c);return c};b.prototype.initLabel=function(b,a){b=z(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},b);a=new C(this,b,a);a.itemType="label";this.labels.push(a);return a};b.prototype.redrawItem=function(b,a){b.linkPoints();b.shouldBeDrawn()?(b.graphic||this.renderItem(b),b.redraw(B(a,!0)&&b.graphic.placed),b.points.length&&this.adjustVisibility(b)):this.destroyItem(b)};b.prototype.adjustVisibility=
function(b){var a=!1,c=b.graphic;b.points.forEach(function(b){!1!==b.series.visible&&!1!==b.visible&&(a=!0)});a?"hidden"===c.visibility&&c.show():c.hide()};b.prototype.destroyItem=function(b){x(this[b.itemType+"s"],b);b.destroy()};b.prototype.renderItem=function(b){b.render("label"===b.itemType?this.labelsGroup:this.shapesGroup)};b.ControlPoint=e;b.MockPoint=h;b.shapesMap={rect:y,circle:q,path:l,image:c};b.types={};return b}();z(!0,E.prototype,u,p,z(E.prototype,{nonDOMEvents:["add","afterUpdate",
"drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:v.neutralColor100,borderRadius:3,borderWidth:1,className:"",crop:!1,formatter:function(){return f(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",
strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:v.neutralColor100,"stroke-width":2,fill:v.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));r.extendAnnotation=function(b,a,c,f){a=a||E;A(b.prototype,z(a.prototype,c));b.prototype.defaultOptions=z(b.prototype.defaultOptions,f||{})};A(a,{initAnnotation:function(b){b=new (E.types[b.type]||E)(this,b);this.annotations.push(b);return b},addAnnotation:function(b,a){b=this.initAnnotation(b);
this.options.annotations.push(b.options);B(a,!0)&&(b.redraw(),b.graphic.attr({opacity:1}));return b},removeAnnotation:function(b){var a=this.annotations,c="annotations"===b.coll?b:D(a,function(a){return a.options.id===b});c&&(w(c,"remove"),x(this.options.annotations,c.options),x(a,c),c.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);this.annotations.forEach(function(b){b.redraw();b.graphic.animate({opacity:1},b.animationConfig)})}});a.collectionsWithUpdate.push("annotations");
a.collectionsWithInit.annotations=[a.addAnnotation];b(g,"afterInit",function(){this.annotations=[];this.options.annotations||(this.options.annotations=[])});a.callbacks.push(function(a){a.plotBoxClip=this.renderer.clipRect(this.plotBox);a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(b,c){if(!a.annotations.some(function(a){return a.options===b})){var f=a.initAnnotation(b);a.options.annotations[c]=f.options}});a.drawAnnotations();
b(a,"redraw",a.drawAnnotations);b(a,"destroy",function(){a.plotBoxClip.destroy();a.controlPointsGroup.destroy()});b(a,"exportData",function(b){var c=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,f=!b.dataRows[1].xValues,d=a.options.lang&&a.options.lang.exportData&&a.options.lang.exportData.annotationHeader,n=function(b){if(c){var a=c(b);if(!1!==a)return a}a=d+" "+b;return f?{columnTitle:a,topLevelColumnTitle:a}:a},e=b.dataRows[0].length,k=a.options.exporting&&a.options.exporting.csv&&
a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.itemDelimiter,z=a.options.exporting&&a.options.exporting.csv&&a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.join;a.annotations.forEach(function(a){a.options.labelOptions.includeInDataExport&&a.labels.forEach(function(a){if(a.options.text){var c=a.options.text;a.points.forEach(function(a){var f=a.x,d=a.series.xAxis?a.series.xAxis.options.index:-1,n=!1;if(-1===d){a=b.dataRows[0].length;for(var w=Array(a),
B=0;B<a;++B)w[B]="";w.push(c);w.xValues=[];w.xValues[d]=f;b.dataRows.push(w);n=!0}n||b.dataRows.forEach(function(b,a){!n&&b.xValues&&void 0!==d&&f===b.xValues[d]&&(z&&b.length>e?b[b.length-1]+=k+c:b.push(c),n=!0)});if(!n){a=b.dataRows[0].length;w=Array(a);for(B=0;B<a;++B)w[B]="";w[0]=f;w.push(c);w.xValues=[];void 0!==d&&(w.xValues[d]=f);b.dataRows.push(w)}})}})});var w=0;b.dataRows.forEach(function(b){w=Math.max(w,b.length)});for(var B=w-b.dataRows[0].length,x=0;x<B;x++){var g=n(x+1);f?(b.dataRows[0].push(g.topLevelColumnTitle),
b.dataRows[1].push(g.columnTitle)):b.dataRows[0].push(g)}})});t(m.prototype,"onContainerMouseDown",function(b){this.chart.hasDraggedAnnotation||b.apply(this,Array.prototype.slice.call(arguments,1))});return r.Annotation=E});v(a,"Mixins/Navigation.js",[],function(){return{initUpdate:function(a){a.navigation||(a.navigation={updates:[],update:function(a,d){this.updates.forEach(function(g){g.update.call(g.context,a,d)})}})},addUpdate:function(a,g){g.navigation||this.initUpdate(g);g.navigation.updates.push({update:a,
context:g})}}});v(a,"Extensions/Annotations/NavigationBindings.js",[a["Extensions/Annotations/Annotations.js"],a["Core/Chart/Chart.js"],a["Mixins/Navigation.js"],a["Core/FormatUtilities.js"],a["Core/Globals.js"],a["Core/Options.js"],a["Core/Utilities.js"]],function(a,g,u,y,q,l,c){function d(a){var c=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click;b(!0,a.prototype.defaultOptions.events,{click:function(b){var a=this,f=a.chart.navigationBindings,d=f.activeAnnotation;c&&c.call(a,
b);d!==a?(f.deselectAnnotation(),f.activeAnnotation=a,a.setControlPointsVisibility(!0),h(f,"showPopup",{annotation:a,formType:"annotation-toolbar",options:f.annotationToFields(a),onSubmit:function(b){var c={};"remove"===b.actionType?(f.activeAnnotation=!1,f.chart.removeAnnotation(a)):(f.fieldsToOptions(b.fields,c),f.deselectAnnotation(),b=c.typeOptions,"measure"===a.options.type&&(b.crosshairY.enabled=0!==b.crosshairY.strokeWidth,b.crosshairX.enabled=0!==b.crosshairX.strokeWidth),a.update(c))}})):
h(f,"closePopup");b.activeAnnotation=!0}})}var e=y.format;y=l.setOptions;var p=c.addEvent,r=c.attr,h=c.fireEvent,m=c.isArray,t=c.isFunction,v=c.isNumber,k=c.isObject,b=c.merge,f=c.objectEach,n=c.pick,x=q.doc,A=q.win,D=function(){function a(b,a){this.selectedButton=this.boundClassNames=void 0;this.chart=b;this.options=a;this.eventsToUnbind=[];this.container=x.getElementsByClassName(this.options.bindingsClassName||"")}a.prototype.initEvents=function(){var b=this,a=b.chart,c=b.container,d=b.options;
b.boundClassNames={};f(d.bindings||{},function(a){b.boundClassNames[a.className]=a});[].forEach.call(c,function(a){b.eventsToUnbind.push(p(a,"click",function(c){var f=b.getButtonEvents(a,c);f&&-1===f.button.className.indexOf("highcharts-disabled-btn")&&b.bindingsButtonClick(f.button,f.events,c)}))});f(d.events||{},function(a,c){t(a)&&b.eventsToUnbind.push(p(b,c,a,{passive:!1}))});b.eventsToUnbind.push(p(a.container,"click",function(c){!a.cancelClick&&a.isInsidePlot(c.chartX-a.plotLeft,c.chartY-a.plotTop,
{visiblePlotOnly:!0})&&b.bindingsChartClick(this,c)}));b.eventsToUnbind.push(p(a.container,q.isTouchDevice?"touchmove":"mousemove",function(a){b.bindingsContainerMouseMove(this,a)},q.isTouchDevice?{passive:!1}:void 0))};a.prototype.initUpdate=function(){var b=this;u.addUpdate(function(a){b.update(a)},this.chart)};a.prototype.bindingsButtonClick=function(b,a,c){var f=this.chart;this.selectedButtonElement&&(h(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&
"annotations"===this.currentUserDetails.coll&&f.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));this.selectedButton=a;this.selectedButtonElement=b;h(this,"selectButton",{button:b});a.init&&a.init.call(this,b,c);(a.start||a.steps)&&f.renderer.boxWrapper.addClass("highcharts-draw-mode")};a.prototype.bindingsChartClick=function(b,a){b=this.chart;var c=this.selectedButton;b=b.renderer.boxWrapper;var f;if(f=this.activeAnnotation&&!a.activeAnnotation&&a.target.parentNode){a:{f=
a.target;var d=A.Element.prototype,n=d.matches||d.msMatchesSelector||d.webkitMatchesSelector,e=null;if(d.closest)e=d.closest.call(f,".highcharts-popup");else{do{if(n.call(f,".highcharts-popup"))break a;f=f.parentElement||f.parentNode}while(null!==f&&1===f.nodeType)}f=e}f=!f}f&&h(this,"closePopup");c&&c.start&&(this.nextEvent?(this.nextEvent(a,this.currentUserDetails),this.steps&&(this.stepIndex++,c.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=c.steps[this.stepIndex]:(h(this,"deselectButton",
{button:this.selectedButtonElement}),b.removeClass("highcharts-draw-mode"),c.end&&c.end.call(this,a,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=c.start.call(this,a))&&c.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=c.steps[this.stepIndex]):(h(this,"deselectButton",{button:this.selectedButtonElement}),b.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,c.end&&c.end.call(this,
a,this.currentUserDetails)))};a.prototype.bindingsContainerMouseMove=function(b,a){this.mouseMoveEvent&&this.mouseMoveEvent(a,this.currentUserDetails)};a.prototype.fieldsToOptions=function(b,a){f(b,function(b,c){var f=parseFloat(b),d=c.split("."),e=a,k=d.length-1;!v(f)||b.match(/px/g)||c.match(/format/g)||(b=f);""!==b&&"undefined"!==b&&d.forEach(function(a,c){var f=n(d[c+1],"");k===c?e[a]=b:(e[a]||(e[a]=f.match(/\d/g)?[]:{}),e=e[a])})});return a};a.prototype.deselectAnnotation=function(){this.activeAnnotation&&
(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)};a.prototype.annotationToFields=function(b){function c(a,d,n,w){if(n&&a&&-1===A.indexOf(d)&&(0<=(n.indexOf&&n.indexOf(d))||n[d]||!0===n))if(m(a))w[d]=[],a.forEach(function(b,a){k(b)?(w[d][a]={},f(b,function(b,f){c(b,f,x[d],w[d][a])})):c(b,0,x[d],w[d])});else if(k(a)){var g={};m(w)?(w.push(g),g[d]={},g=g[d]):w[d]=g;f(a,function(b,a){c(b,a,0===d?n:x[d],g)})}else"format"===d?w[d]=[e(a,b.labels[0].points[0]).toString(),"text"]:
m(w)?w.push([a,z(a)]):w[d]=[a,z(a)]}var d=b.options,w=a.annotationsEditable,x=w.nestedOptions,z=this.utils.getFieldType,g=n(d.type,d.shapes&&d.shapes[0]&&d.shapes[0].type,d.labels&&d.labels[0]&&d.labels[0].itemType,"label"),A=a.annotationsNonEditable[d.langKey]||[],h={langKey:d.langKey,type:g};f(d,function(b,a){"typeOptions"===a?(h[a]={},f(d[a],function(b,f){c(b,f,x,h[a],!0)})):c(b,a,w[g],h)});return h};a.prototype.getClickedClassNames=function(b,a){var c=a.target;a=[];for(var f;c&&((f=r(c,"class"))&&
(a=a.concat(f.split(" ").map(function(b){return[b,c]}))),c=c.parentNode,c!==b););return a};a.prototype.getButtonEvents=function(b,a){var c=this,f;this.getClickedClassNames(b,a).forEach(function(b){c.boundClassNames[b[0]]&&!f&&(f={events:c.boundClassNames[b[0]],button:b[1]})});return f};a.prototype.update=function(a){this.options=b(!0,this.options,a);this.removeEvents();this.initEvents()};a.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(b){b()})};a.prototype.destroy=function(){this.removeEvents()};
a.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],
crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]};a.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]};return a}();D.prototype.utils={getFieldType:function(b){return{string:"text",number:"number","boolean":"checkbox"}[typeof b]},
updateRectSize:function(b,a){var c=a.chart,f=a.options.typeOptions,d=c.pointer.getCoordinates(b);b=c.navigationBindings.utils.getAssignedAxis(d.xAxis);d=c.navigationBindings.utils.getAssignedAxis(d.yAxis);b&&d&&(b=b.value-f.point.x,f=f.point.y-d.value,a.update({typeOptions:{background:{width:c.inverted?f:b,height:c.inverted?b:f}}}))},getAssignedAxis:function(b){return b.filter(function(b){var a=b.axis.min,c=b.axis.max,f=n(b.axis.minPointOffset,0);return v(a)&&v(c)&&b.value>=a-f&&b.value<=c+f&&!b.axis.options.isInternal})[0]}};
g.prototype.initNavigationBindings=function(){var b=this.options;b&&b.navigation&&b.navigation.bindings&&(this.navigationBindings=new D(this,b.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())};p(g,"load",function(){this.initNavigationBindings()});p(g,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});p(D,"deselectButton",function(){this.selectedButtonElement=null});p(a,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});
q.Annotation&&(d(a),f(a.types,function(b){d(b)}));y({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",
style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(c.xAxis);c=this.utils.getAssignedAxis(c.yAxis);var f=this.chart.options.navigation;if(a&&c)return this.chart.addAnnotation(b({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",
point:{x:a.value,y:c.value,xAxis:a.axis.options.index,yAxis:c.axis.options.index},r:5}]},f.annotationsOptions,f.bindings.circleAnnotation.annotationsOptions))},steps:[function(b,a){var c=a.options.shapes[0].point,f=this.chart.inverted;if(v(c.xAxis)&&v(c.yAxis)){var d=this.chart.xAxis[c.xAxis].toPixels(c.x);c=this.chart.yAxis[c.yAxis].toPixels(c.y);d=Math.max(Math.sqrt(Math.pow(f?c-b.chartX:d-b.chartX,2)+Math.pow(f?d-b.chartY:c-b.chartY,2)),5)}a.update({shapes:[{r:d}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",
start:function(a){a=this.chart.pointer.getCoordinates(a);var c=this.utils.getAssignedAxis(a.xAxis),f=this.utils.getAssignedAxis(a.yAxis);if(c&&f){a=c.value;var d=f.value;c=c.axis.options.index;f=f.axis.options.index;var n=this.chart.options.navigation;return this.chart.addAnnotation(b({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:c,yAxis:f,x:a,y:d},{xAxis:c,yAxis:f,x:a,y:d},{xAxis:c,yAxis:f,x:a,y:d},{xAxis:c,yAxis:f,x:a,y:d}]}]},n.annotationsOptions,n.bindings.rectangleAnnotation.annotationsOptions))}},
steps:[function(b,a){var c=a.options.shapes[0].points,f=this.chart.pointer.getCoordinates(b);b=this.utils.getAssignedAxis(f.xAxis);f=this.utils.getAssignedAxis(f.yAxis);b&&f&&(b=b.value,f=f.value,c[1].x=b,c[2].x=b,c[2].y=f,c[3].y=f,a.update({shapes:[{points:c}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(c.xAxis);c=this.utils.getAssignedAxis(c.yAxis);var f=this.chart.options.navigation;if(a&&
c)return this.chart.addAnnotation(b({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,x:a.value,y:c.value},overflow:"none",crop:!0}]},f.annotationsOptions,f.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});p(q.Chart,"render",function(){var b=this,a=b.navigationBindings;if(b&&a){var c=!1;b.series.forEach(function(b){!b.options.isInternal&&b.visible&&(c=!0)});
f(a.boundClassNames,function(a,f){b.navigationBindings&&b.navigationBindings.container&&b.navigationBindings.container[0]&&(f=b.navigationBindings.container[0].querySelectorAll("."+f))&&("normal"===a.noDataState?f.forEach(function(b){-1!==b.className.indexOf("highcharts-disabled-btn")&&b.classList.remove("highcharts-disabled-btn")}):c?f.forEach(function(b){-1!==b.className.indexOf("highcharts-disabled-btn")&&b.classList.remove("highcharts-disabled-btn")}):f.forEach(function(b){-1===b.className.indexOf("highcharts-disabled-btn")&&
(b.className+=" highcharts-disabled-btn")}))})}});p(D,"closePopup",function(){this.deselectAnnotation()});return D});v(a,"Stock/StockToolsBindings.js",[a["Core/Globals.js"],a["Extensions/Annotations/NavigationBindings.js"],a["Core/Options.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"],a["Core/Color/Palette.js"]],function(a,g,u,v,q,l){var c=u.getOptions;u=u.setOptions;var d=q.correctFloat,e=q.defined,p=q.extend,r=q.fireEvent,h=q.isNumber,m=q.merge,t=q.pick,y=q.uniqueKey,k=g.prototype.utils;
k.addFlagFromForm=function(b){return function(a){var c=this,f=c.chart,d=f.stockTools,e=k.getFieldType;a=k.attractToPoint(a,f);if(a){var g={type:"flags",onSeries:a.series.id,shape:b,data:[{x:a.x,y:a.y}],xAxis:a.xAxis,yAxis:a.yAxis,point:{events:{click:function(){var b=this,a=b.options;r(c,"showPopup",{point:b,formType:"annotation-toolbar",options:{langKey:"flags",type:"flags",title:[a.title,e(a.title)],name:[a.name,e(a.name)]},onSubmit:function(a){"remove"===a.actionType?b.remove():b.update(c.fieldsToOptions(a.fields,
{}))}})}}}};d&&d.guiEnabled||f.addSeries(g);r(c,"showPopup",{formType:"flag",options:{langKey:"flags",type:"flags",title:["A",e("A")],name:["Flag A",e("Flag A")]},onSubmit:function(b){c.fieldsToOptions(b.fields,g.data[0]);f.addSeries(g)}})}}};k.manageIndicators=function(b){var a=this.chart,d={linkedTo:b.linkedTo,type:b.type},k="ad cmf klinger mfi obv vbp vwap".split(" "),g="ad atr cci cmf disparityindex cmo dmi macd mfi roc rsi ao aroon aroonoscillator trix apo dpo ppo natr obv williamsr stochastic slowstochastic linearRegression linearRegressionSlope linearRegressionIntercept linearRegressionAngle klinger".split(" ");
if("edit"===b.actionType)this.fieldsToOptions(b.fields,d),(b=a.get(b.seriesId))&&b.update(d,!1);else if("remove"===b.actionType){if(b=a.get(b.seriesId)){var h=b.yAxis;b.linkedSeries&&b.linkedSeries.forEach(function(b){b.remove(!1)});b.remove(!1);0<=g.indexOf(b.type)&&(d=h.options.height,h.remove(!1),this.resizeYAxes(d))}}else{d.id=y();this.fieldsToOptions(b.fields,d);h=a.get(d.linkedTo);var l=c().plotOptions;"undefined"!==typeof h&&h instanceof v&&"sum"===h.getDGApproximation()&&!e(l&&l[d.type]&&
l.dataGrouping&&l.dataGrouping.approximation)&&(d.dataGrouping={approximation:"sum"});0<=g.indexOf(b.type)?(h=a.addAxis({id:y(),offset:0,opposite:!0,title:{text:""},tickPixelInterval:40,showLastLabel:!1,labels:{align:"left",y:-2}},!1,!1),d.yAxis=h.options.id,this.resizeYAxes()):d.yAxis=a.get(b.linkedTo).options.yAxis;0<=k.indexOf(b.type)&&(d.params.volumeSeriesID=a.series.filter(function(b){return"column"===b.options.type})[0].options.id);a.addSeries(d,!1)}r(this,"deselectButton",{button:this.selectedButtonElement});
a.redraw()};k.updateHeight=function(b,a){(b=this.utils.getAssignedAxis(this.chart.pointer.getCoordinates(b).yAxis))&&a.update({typeOptions:{height:b.value-a.options.typeOptions.points[1].y}})};k.attractToPoint=function(b,a){b=a.pointer.getCoordinates(b);var c=Number.MAX_VALUE,f;if(a.navigationBindings){var d=a.navigationBindings.utils.getAssignedAxis(b.xAxis);var e=a.navigationBindings.utils.getAssignedAxis(b.yAxis)}if(d&&e){var k=d.value;a=e.value;e.axis.series.forEach(function(b){b.points&&b.points.forEach(function(b){b&&
c>Math.abs(b.x-k)&&(c=Math.abs(b.x-k),f=b)})});if(f&&f.x&&f.y)return{x:f.x,y:f.y,below:a<f.y,series:f.series,xAxis:f.series.xAxis.options.index||0,yAxis:f.series.yAxis.options.index||0}}};k.isNotNavigatorYAxis=function(b){return"highcharts-navigator-yaxis"!==b.userOptions.className};k.isPriceIndicatorEnabled=function(b){return b.some(function(b){return b.lastVisiblePrice||b.lastPrice})};k.updateNthPoint=function(b){return function(a,c){var f=c.options.typeOptions;a=this.chart.pointer.getCoordinates(a);
var d=this.utils.getAssignedAxis(a.xAxis),e=this.utils.getAssignedAxis(a.yAxis);d&&e&&(f.points.forEach(function(a,c){c>=b&&(a.x=d.value,a.y=e.value)}),c.update({typeOptions:{points:f.points}}))}};p(g.prototype,{getYAxisPositions:function(b,a,c,k){function f(b){return e(b)&&!h(b)&&b.match("%")}var n=0,g,x;k&&(x=d(parseFloat(k)/100));return{positions:b.map(function(e,k){var l=d(f(e.options.height)?parseFloat(e.options.height)/100:e.height/a);e=d(f(e.options.top)?parseFloat(e.options.top)/100:(e.top-
e.chart.plotTop)/a);x?e<=n?n=d(Math.max(n,(e||0)+(l||0))):(e=d(e-x),n=d(n+l)):(h(l)||(l=b[k-1].series.every(function(b){return b.is("sma")})?g:c/100),h(e)||(e=n),g=l,n=d(Math.max(n,(e||0)+(l||0))));return{height:100*l,top:100*e}}),allAxesHeight:n}},getYAxisResizers:function(b){var a=[];b.forEach(function(c,f){c=b[f+1];a[f]=c?{enabled:!0,controlledAxis:{next:[t(c.options.id,c.options.index)]}}:{enabled:!1}});return a},resizeYAxes:function(b){var a=this.chart,c=a.yAxis.filter(k.isNotNavigatorYAxis);
a=this.getYAxisPositions(c,a.plotHeight,20,b);var e=a.positions,g=a.allAxesHeight,h=this.getYAxisResizers(c);!b&&g<=d(1)?e[e.length-1]={height:20,top:d(100*g-20)}:e.forEach(function(b){b.height=b.height/(100*g)*100;b.top=b.top/(100*g)*100});e.forEach(function(b,a){c[a].update({height:b.height+"%",top:b.top+"%",resize:h[a],offset:0},!1)})},recalculateYAxisPositions:function(b,a,c,e){b.forEach(function(f,n){n=b[n-1];f.top=n?d(n.height+n.top):0;c&&(f.height=d(f.height+e*a))});return b}});q={segment:{className:"highcharts-segment",
start:function(b){var a=this.chart.pointer.getCoordinates(b);b=this.utils.getAssignedAxis(a.xAxis);a=this.utils.getAssignedAxis(a.yAxis);var c=this.chart.options.navigation;if(b&&a)return b=m({langKey:"segment",type:"crookedLine",typeOptions:{xAxis:b.axis.options.index,yAxis:a.axis.options.index,points:[{x:b.value,y:a.value},{x:b.value,y:a.value}]}},c.annotationsOptions,c.bindings.segment.annotationsOptions),this.chart.addAnnotation(b)},steps:[k.updateNthPoint(1)]},arrowSegment:{className:"highcharts-arrow-segment",
start:function(b){var a=this.chart.pointer.getCoordinates(b);b=this.utils.getAssignedAxis(a.xAxis);a=this.utils.getAssignedAxis(a.yAxis);var c=this.chart.options.navigation;if(b&&a)return b=m({langKey:"arrowSegment",type:"crookedLine",typeOptions:{line:{markerEnd:"arrow"},xAxis:b.axis.options.index,yAxis:a.axis.options.index,points:[{x:b.value,y:a.value},{x:b.value,y:a.value}]}},c.annotationsOptions,c.bindings.arrowSegment.annotationsOptions),this.chart.addAnnotation(b)},steps:[k.updateNthPoint(1)]},
ray:{className:"highcharts-ray",start:function(b){var a=this.chart.pointer.getCoordinates(b);b=this.utils.getAssignedAxis(a.xAxis);a=this.utils.getAssignedAxis(a.yAxis);var c=this.chart.options.navigation;if(b&&a)return b=m({langKey:"ray",type:"infinityLine",typeOptions:{type:"ray",xAxis:b.axis.options.index,yAxis:a.axis.options.index,points:[{x:b.value,y:a.value},{x:b.value,y:a.value}]}},c.annotationsOptions,c.bindings.ray.annotationsOptions),this.chart.addAnnotation(b)},steps:[k.updateNthPoint(1)]},
arrowRay:{className:"highcharts-arrow-ray",start:function(b){var a=this.chart.pointer.getCoordinates(b);b=this.utils.getAssignedAxis(a.xAxis);a=this.utils.getAssignedAxis(a.yAxis);var c=this.chart.options.navigation;if(b&&a)return b=m({langKey:"arrowRay",type:"infinityLine",typeOptions:{type:"ray",line:{markerEnd:"arrow"},xAxis:b.axis.options.index,yAxis:a.axis.options.index,points:[{x:b.value,y:a.value},{x:b.value,y:a.value}]}},c.annotationsOptions,c.bindings.arrowRay.annotationsOptions),this.chart.addAnnotation(b)},
steps:[k.updateNthPoint(1)]},infinityLine:{className:"highcharts-infinity-line",start:function(b){var a=this.chart.pointer.getCoordinates(b);b=this.utils.getAssignedAxis(a.xAxis);a=this.utils.getAssignedAxis(a.yAxis);var c=this.chart.options.navigation;if(b&&a)return b=m({langKey:"infinityLine",type:"infinityLine",typeOptions:{type:"line",xAxis:b.axis.options.index,yAxis:a.axis.options.index,points:[{x:b.value,y:a.value},{x:b.value,y:a.value}]}},c.annotationsOptions,c.bindings.infinityLine.annotationsOptions),
this.chart.addAnnotation(b)},steps:[k.updateNthPoint(1)]},arrowInfinityLine:{className:"highcharts-arrow-infinity-line",start:function(b){var a=this.chart.pointer.getCoordinates(b);b=this.utils.getAssignedAxis(a.xAxis);a=this.utils.getAssignedAxis(a.yAxis);var c=this.chart.options.navigation;if(b&&a)return b=m({langKey:"arrowInfinityLine",type:"infinityLine",typeOptions:{type:"line",line:{markerEnd:"arrow"},xAxis:b.axis.options.index,yAxis:a.axis.options.index,points:[{x:b.value,y:a.value},{x:b.value,
y:a.value}]}},c.annotationsOptions,c.bindings.arrowInfinityLine.annotationsOptions),this.chart.addAnnotation(b)},steps:[k.updateNthPoint(1)]},horizontalLine:{className:"highcharts-horizontal-line",start:function(b){var a=this.chart.pointer.getCoordinates(b);b=this.utils.getAssignedAxis(a.xAxis);a=this.utils.getAssignedAxis(a.yAxis);var c=this.chart.options.navigation;b&&a&&(b=m({langKey:"horizontalLine",type:"infinityLine",draggable:"y",typeOptions:{type:"horizontalLine",xAxis:b.axis.options.index,
yAxis:a.axis.options.index,points:[{x:b.value,y:a.value}]}},c.annotationsOptions,c.bindings.horizontalLine.annotationsOptions),this.chart.addAnnotation(b))}},verticalLine:{className:"highcharts-vertical-line",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);var c=this.chart.options.navigation;a&&b&&(a=m({langKey:"verticalLine",type:"infinityLine",draggable:"x",typeOptions:{type:"verticalLine",xAxis:a.axis.options.index,
yAxis:b.axis.options.index,points:[{x:a.value,y:b.value}]}},c.annotationsOptions,c.bindings.verticalLine.annotationsOptions),this.chart.addAnnotation(a))}},crooked3:{className:"highcharts-crooked3",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=a.value,d=b.value,e=this.chart.options.navigation;a=m({langKey:"crooked3",type:"crookedLine",typeOptions:{xAxis:a.axis.options.index,yAxis:b.axis.options.index,
points:[{x:c,y:d},{x:c,y:d},{x:c,y:d}]}},e.annotationsOptions,e.bindings.crooked3.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateNthPoint(1),k.updateNthPoint(2)]},crooked5:{className:"highcharts-crooked5",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=a.value,d=b.value,e=this.chart.options.navigation;a=m({langKey:"crookedLine",type:"crookedLine",typeOptions:{xAxis:a.axis.options.index,
yAxis:b.axis.options.index,points:[{x:c,y:d},{x:c,y:d},{x:c,y:d},{x:c,y:d},{x:c,y:d}]}},e.annotationsOptions,e.bindings.crooked5.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateNthPoint(1),k.updateNthPoint(2),k.updateNthPoint(3),k.updateNthPoint(4)]},elliott3:{className:"highcharts-elliott3",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=a.value,d=b.value,e=this.chart.options.navigation;
a=m({langKey:"elliott3",type:"elliottWave",typeOptions:{xAxis:a.axis.options.index,yAxis:b.axis.options.index,points:[{x:c,y:d},{x:c,y:d},{x:c,y:d},{x:c,y:d}]},labelOptions:{style:{color:l.neutralColor60}}},e.annotationsOptions,e.bindings.elliott3.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateNthPoint(1),k.updateNthPoint(2),k.updateNthPoint(3)]},elliott5:{className:"highcharts-elliott5",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);
b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=a.value,d=b.value,e=this.chart.options.navigation;a=m({langKey:"elliott5",type:"elliottWave",typeOptions:{xAxis:a.axis.options.index,yAxis:b.axis.options.index,points:[{x:c,y:d},{x:c,y:d},{x:c,y:d},{x:c,y:d},{x:c,y:d},{x:c,y:d}]},labelOptions:{style:{color:l.neutralColor60}}},e.annotationsOptions,e.bindings.elliott5.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateNthPoint(1),k.updateNthPoint(2),k.updateNthPoint(3),k.updateNthPoint(4),
k.updateNthPoint(5)]},measureX:{className:"highcharts-measure-x",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=this.chart.options.navigation;a=m({langKey:"measure",type:"measure",typeOptions:{selectType:"x",xAxis:a.axis.options.index,yAxis:b.axis.options.index,point:{x:a.value,y:b.value},crosshairX:{strokeWidth:1,stroke:l.neutralColor100},crosshairY:{enabled:!1,strokeWidth:0,stroke:l.neutralColor100},
background:{width:0,height:0,strokeWidth:0,stroke:l.backgroundColor}},labelOptions:{style:{color:l.neutralColor60}}},c.annotationsOptions,c.bindings.measureX.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateRectSize]},measureY:{className:"highcharts-measure-y",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=this.chart.options.navigation;a=m({langKey:"measure",type:"measure",
typeOptions:{selectType:"y",xAxis:a.axis.options.index,yAxis:b.axis.options.index,point:{x:a.value,y:b.value},crosshairX:{enabled:!1,strokeWidth:0,stroke:l.neutralColor100},crosshairY:{strokeWidth:1,stroke:l.neutralColor100},background:{width:0,height:0,strokeWidth:0,stroke:l.backgroundColor}},labelOptions:{style:{color:l.neutralColor60}}},c.annotationsOptions,c.bindings.measureY.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateRectSize]},measureXY:{className:"highcharts-measure-xy",
start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=this.chart.options.navigation;a=m({langKey:"measure",type:"measure",typeOptions:{selectType:"xy",xAxis:a.axis.options.index,yAxis:b.axis.options.index,point:{x:a.value,y:b.value},background:{width:0,height:0,strokeWidth:10},crosshairX:{strokeWidth:1,stroke:l.neutralColor100},crosshairY:{strokeWidth:1,stroke:l.neutralColor100}},labelOptions:{style:{color:l.neutralColor60}}},
c.annotationsOptions,c.bindings.measureXY.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateRectSize]},fibonacci:{className:"highcharts-fibonacci",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=a.value,d=b.value,e=this.chart.options.navigation;a=m({langKey:"fibonacci",type:"fibonacci",typeOptions:{xAxis:a.axis.options.index,yAxis:b.axis.options.index,points:[{x:c,y:d},{x:c,
y:d}]},labelOptions:{style:{color:l.neutralColor60}}},e.annotationsOptions,e.bindings.fibonacci.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateNthPoint(1),k.updateHeight]},parallelChannel:{className:"highcharts-parallel-channel",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=a.value,d=b.value,e=this.chart.options.navigation;a=m({langKey:"parallelChannel",type:"tunnel",
typeOptions:{xAxis:a.axis.options.index,yAxis:b.axis.options.index,points:[{x:c,y:d},{x:c,y:d}]}},e.annotationsOptions,e.bindings.parallelChannel.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateNthPoint(1),k.updateHeight]},pitchfork:{className:"highcharts-pitchfork",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);if(a&&b){var c=a.value,d=b.value,e=this.chart.options.navigation;a=m({langKey:"pitchfork",
type:"pitchfork",typeOptions:{xAxis:a.axis.options.index,yAxis:b.axis.options.index,points:[{x:a.value,y:b.value,controlPoint:{style:{fill:l.negativeColor}}},{x:c,y:d},{x:c,y:d}],innerBackground:{fill:"rgba(100, 170, 255, 0.8)"}},shapeOptions:{strokeWidth:2}},e.annotationsOptions,e.bindings.pitchfork.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[k.updateNthPoint(1),k.updateNthPoint(2)]},verticalCounter:{className:"highcharts-vertical-counter",start:function(a){a=k.attractToPoint(a,
this.chart);var b=this.chart.options.navigation;a&&(this.verticalCounter=this.verticalCounter||0,a=m({langKey:"verticalCounter",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40,text:this.verticalCounter.toString()}},labelOptions:{style:{color:l.neutralColor60,fontSize:"11px"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},b.annotationsOptions,b.bindings.verticalCounter.annotationsOptions),a=this.chart.addAnnotation(a),this.verticalCounter++,
a.options.events.click.call(a,{}))}},verticalLabel:{className:"highcharts-vertical-label",start:function(a){a=k.attractToPoint(a,this.chart);var b=this.chart.options.navigation;a&&(a=m({langKey:"verticalLabel",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40}},labelOptions:{style:{color:l.neutralColor60,fontSize:"11px"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},b.annotationsOptions,b.bindings.verticalLabel.annotationsOptions),
a=this.chart.addAnnotation(a),a.options.events.click.call(a,{}))}},verticalArrow:{className:"highcharts-vertical-arrow",start:function(a){a=k.attractToPoint(a,this.chart);var b=this.chart.options.navigation;a&&(a=m({langKey:"verticalArrow",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40,format:" "},connector:{fill:"none",stroke:a.below?l.negativeColor:l.positiveColor}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},b.annotationsOptions,
b.bindings.verticalArrow.annotationsOptions),a=this.chart.addAnnotation(a),a.options.events.click.call(a,{}))}},flagCirclepin:{className:"highcharts-flag-circlepin",start:k.addFlagFromForm("circlepin")},flagDiamondpin:{className:"highcharts-flag-diamondpin",start:k.addFlagFromForm("flag")},flagSquarepin:{className:"highcharts-flag-squarepin",start:k.addFlagFromForm("squarepin")},flagSimplepin:{className:"highcharts-flag-simplepin",start:k.addFlagFromForm("nopin")},zoomX:{className:"highcharts-zoom-x",
init:function(a){this.chart.update({chart:{zoomType:"x"}});r(this,"deselectButton",{button:a})}},zoomY:{className:"highcharts-zoom-y",init:function(a){this.chart.update({chart:{zoomType:"y"}});r(this,"deselectButton",{button:a})}},zoomXY:{className:"highcharts-zoom-xy",init:function(a){this.chart.update({chart:{zoomType:"xy"}});r(this,"deselectButton",{button:a})}},seriesTypeLine:{className:"highcharts-series-type-line",init:function(a){this.chart.series[0].update({type:"line",useOhlcData:!0});r(this,
"deselectButton",{button:a})}},seriesTypeOhlc:{className:"highcharts-series-type-ohlc",init:function(a){this.chart.series[0].update({type:"ohlc"});r(this,"deselectButton",{button:a})}},seriesTypeCandlestick:{className:"highcharts-series-type-candlestick",init:function(a){this.chart.series[0].update({type:"candlestick"});r(this,"deselectButton",{button:a})}},fullScreen:{className:"highcharts-full-screen",noDataState:"normal",init:function(a){this.chart.fullscreen.toggle();r(this,"deselectButton",{button:a})}},
currentPriceIndicator:{className:"highcharts-current-price-indicator",init:function(a){var b=this.chart,c=b.series,d=b.stockTools,e=k.isPriceIndicatorEnabled(b.series);d&&d.guiEnabled&&(c.forEach(function(a){a.update({lastPrice:{enabled:!e},lastVisiblePrice:{enabled:!e,label:{enabled:!0}}},!1)}),b.redraw());r(this,"deselectButton",{button:a})}},indicators:{className:"highcharts-indicators",init:function(){var a=this;r(a,"showPopup",{formType:"indicators",options:{},onSubmit:function(b){a.utils.manageIndicators.call(a,
b)}})}},toggleAnnotations:{className:"highcharts-toggle-annotations",init:function(a){var b=this.chart,c=b.stockTools,d=c.getIconsURL();this.toggledAnnotations=!this.toggledAnnotations;(b.annotations||[]).forEach(function(a){a.setVisibility(!this.toggledAnnotations)},this);c&&c.guiEnabled&&(a.firstChild.style["background-image"]=this.toggledAnnotations?'url("'+d+'annotations-hidden.svg")':'url("'+d+'annotations-visible.svg")');r(this,"deselectButton",{button:a})}},saveChart:{className:"highcharts-save-chart",
noDataState:"normal",init:function(b){var c=this.chart,d=[],e=[],g=[],h=[];c.annotations.forEach(function(a,b){d[b]=a.userOptions});c.series.forEach(function(a){a.is("sma")?e.push(a.userOptions):"flags"===a.type&&g.push(a.userOptions)});c.yAxis.forEach(function(a){k.isNotNavigatorYAxis(a)&&h.push(a.options)});a.win.localStorage.setItem("highcharts-chart",JSON.stringify({annotations:d,indicators:e,flags:g,yAxes:h}));r(this,"deselectButton",{button:b})}}};u({navigation:{bindings:q}});g.prototype.utils=
m(k,g.prototype.utils)});v(a,"Stock/StockToolsGui.js",[a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Extensions/Annotations/NavigationBindings.js"],a["Core/Options.js"],a["Core/Utilities.js"]],function(a,g,u,v,q){v=v.setOptions;var d=q.addEvent,c=q.createElement,y=q.css,e=q.extend,p=q.fireEvent,r=q.getStyle,h=q.isArray,m=q.merge,t=q.pick;v({lang:{stockTools:{gui:{simpleShapes:"Simple shapes",lines:"Lines",crookedLines:"Crooked lines",measure:"Measure",advanced:"Advanced",toggleAnnotations:"Toggle annotations",
verticalLabels:"Vertical labels",flags:"Flags",zoomChange:"Zoom change",typeChange:"Type change",saveChart:"Save chart",indicators:"Indicators",currentPriceIndicator:"Current Price Indicators",zoomX:"Zoom X",zoomY:"Zoom Y",zoomXY:"Zooom XY",fullScreen:"Fullscreen",typeOHLC:"OHLC",typeLine:"Line",typeCandlestick:"Candlestick",circle:"Circle",label:"Label",rectangle:"Rectangle",flagCirclepin:"Flag circle",flagDiamondpin:"Flag diamond",flagSquarepin:"Flag square",flagSimplepin:"Flag simple",measureXY:"Measure XY",
measureX:"Measure X",measureY:"Measure Y",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowLine:"Arrow line",horizontalLine:"Horizontal line",verticalLine:"Vertical line",infinityLine:"Infinity line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",pitchfork:"Pitchfork",parallelChannel:"Parallel channel"}},
navigation:{popup:{circle:"Circle",rectangle:"Rectangle",label:"Label",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowLine:"Arrow line",horizontalLine:"Horizontal line",verticalLine:"Vertical line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",
infinityLine:"Infinity line",measure:"Measure",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",flags:"Flags",addButton:"add",saveButton:"save",editButton:"edit",removeButton:"remove",series:"Series",volume:"Volume",connector:"Connector",innerBackground:"Inner background",outerBackground:"Outer background",crosshairX:"Crosshair X",crosshairY:"Crosshair Y",tunnel:"Tunnel",background:"Background",index:"Index",period:"Period",standardDeviation:"Standard deviation",periodTenkan:"Tenkan period",
periodSenkouSpanB:"Senkou Span B period",periodATR:"ATR period",multiplierATR:"ATR multiplier",shortPeriod:"Short period",longPeriod:"Long period",signalPeriod:"Signal period",decimals:"Decimals",algorithm:"Algorithm",topBand:"Top band",bottomBand:"Bottom band",initialAccelerationFactor:"Initial acceleration factor",maxAccelerationFactor:"Max acceleration factor",increment:"Increment",multiplier:"Multiplier",ranges:"Ranges",highIndex:"High index",lowIndex:"Low index",deviation:"Deviation",xAxisUnit:"x-axis unit",
factor:"Factor",fastAvgPeriod:"Fast average period",slowAvgPeriod:"Slow average period",average:"Average"}}},stockTools:{gui:{enabled:!0,className:"highcharts-bindings-wrapper",toolbarClassName:"stocktools-toolbar",buttons:"indicators separator simpleShapes lines crookedLines measure advanced toggleAnnotations separator verticalLabels flags separator zoomChange fullScreen typeChange separator currentPriceIndicator saveChart".split(" "),definitions:{separator:{symbol:"separator.svg"},simpleShapes:{items:["label",
"circle","rectangle"],circle:{symbol:"circle.svg"},rectangle:{symbol:"rectangle.svg"},label:{symbol:"label.svg"}},flags:{items:["flagCirclepin","flagDiamondpin","flagSquarepin","flagSimplepin"],flagSimplepin:{symbol:"flag-basic.svg"},flagDiamondpin:{symbol:"flag-diamond.svg"},flagSquarepin:{symbol:"flag-trapeze.svg"},flagCirclepin:{symbol:"flag-elipse.svg"}},lines:{items:"segment arrowSegment ray arrowRay line arrowLine horizontalLine verticalLine".split(" "),segment:{symbol:"segment.svg"},arrowSegment:{symbol:"arrow-segment.svg"},
ray:{symbol:"ray.svg"},arrowRay:{symbol:"arrow-ray.svg"},line:{symbol:"line.svg"},arrowLine:{symbol:"arrow-line.svg"},verticalLine:{symbol:"vertical-line.svg"},horizontalLine:{symbol:"horizontal-line.svg"}},crookedLines:{items:["elliott3","elliott5","crooked3","crooked5"],crooked3:{symbol:"crooked-3.svg"},crooked5:{symbol:"crooked-5.svg"},elliott3:{symbol:"elliott-3.svg"},elliott5:{symbol:"elliott-5.svg"}},verticalLabels:{items:["verticalCounter","verticalLabel","verticalArrow"],verticalCounter:{symbol:"vertical-counter.svg"},
verticalLabel:{symbol:"vertical-label.svg"},verticalArrow:{symbol:"vertical-arrow.svg"}},advanced:{items:["fibonacci","pitchfork","parallelChannel"],pitchfork:{symbol:"pitchfork.svg"},fibonacci:{symbol:"fibonacci.svg"},parallelChannel:{symbol:"parallel-channel.svg"}},measure:{items:["measureXY","measureX","measureY"],measureX:{symbol:"measure-x.svg"},measureY:{symbol:"measure-y.svg"},measureXY:{symbol:"measure-xy.svg"}},toggleAnnotations:{symbol:"annotations-visible.svg"},currentPriceIndicator:{symbol:"current-price-show.svg"},
indicators:{symbol:"indicators.svg"},zoomChange:{items:["zoomX","zoomY","zoomXY"],zoomX:{symbol:"zoom-x.svg"},zoomY:{symbol:"zoom-y.svg"},zoomXY:{symbol:"zoom-xy.svg"}},typeChange:{items:["typeOHLC","typeLine","typeCandlestick"],typeOHLC:{symbol:"series-ohlc.svg"},typeLine:{symbol:"series-line.svg"},typeCandlestick:{symbol:"series-candlestick.svg"}},fullScreen:{symbol:"fullscreen.svg"},saveChart:{symbol:"save-chart.svg"}}}}});d(a,"afterGetContainer",function(){this.setStockTools()});d(a,"getMargins",
function(){var a=this.stockTools&&this.stockTools.listWrapper;(a=a&&(a.startWidth+r(a,"padding-left")+r(a,"padding-right")||a.offsetWidth))&&a<this.plotWidth&&(this.plotLeft+=a,this.spacing[3]+=a)},{order:0});["beforeRender","beforeRedraw"].forEach(function(c){d(a,c,function(){if(this.stockTools){var a=this.options.chart,c=this.stockTools.listWrapper;c=c&&(c.startWidth+r(c,"padding-left")+r(c,"padding-right")||c.offsetWidth);var d=!1;c&&c<this.plotWidth?(a=t(a.spacingLeft,a.spacing&&a.spacing[3],
0)+c,d=a-this.spacingBox.x,this.spacingBox.x=a,this.spacingBox.width-=d,d=!0):0===c&&(d=!0);c!==this.stockTools.prevOffsetWidth&&(this.stockTools.prevOffsetWidth=c,d&&(this.isDirtyLegend=!0))}})});d(a,"destroy",function(){this.stockTools&&this.stockTools.destroy()});d(a,"redraw",function(){this.stockTools&&this.stockTools.guiEnabled&&this.stockTools.redraw()});var F=function(){function a(a,c,d){this.wrapper=this.toolbar=this.submenu=this.showhideBtn=this.listWrapper=this.arrowWrapper=this.arrowUp=
this.arrowDown=void 0;this.chart=d;this.options=a;this.lang=c;this.iconsURL=this.getIconsURL();this.guiEnabled=a.enabled;this.visible=t(a.visible,!0);this.placed=t(a.placed,!1);this.eventsToUnbind=[];this.guiEnabled&&(this.createHTML(),this.init(),this.showHideNavigatorion());p(this,"afterInit")}a.prototype.init=function(){var a=this,c=this.lang,e=this.options,g=this.toolbar,k=a.addSubmenu,l=e.definitions,p=g.childNodes,m;e.buttons.forEach(function(b){m=a.addButton(g,l,b,c);a.eventsToUnbind.push(d(m.buttonWrapper,
"click",function(){a.eraseActiveButtons(p,m.buttonWrapper)}));h(l[b].items)&&k.call(a,m,l[b])})};a.prototype.addSubmenu=function(a,e){var b=this,f=a.submenuArrow,g=a.buttonWrapper,k=r(g,"width"),h=this.wrapper,l=this.listWrapper,p=this.toolbar.childNodes,m=0,q;this.submenu=q=c("ul",{className:"highcharts-submenu-wrapper"},null,g);this.addSubmenuItems(g,e);b.eventsToUnbind.push(d(f,"click",function(a){a.stopPropagation();b.eraseActiveButtons(p,g);0<=g.className.indexOf("highcharts-current")?(l.style.width=
l.startWidth+"px",g.classList.remove("highcharts-current"),q.style.display="none"):(q.style.display="block",m=q.offsetHeight-g.offsetHeight-3,q.offsetHeight+g.offsetTop>h.offsetHeight&&g.offsetTop>m||(m=0),y(q,{top:-m+"px",left:k+3+"px"}),g.className+=" highcharts-current",l.startWidth=h.offsetWidth,l.style.width=l.startWidth+r(l,"padding-left")+q.offsetWidth+3+"px")}))};a.prototype.addSubmenuItems=function(a,c){var b=this,e=this.submenu,f=this.lang,g=this.listWrapper,k;c.items.forEach(function(h){k=
b.addButton(e,c,h,f);b.eventsToUnbind.push(d(k.mainButton,"click",function(){b.switchSymbol(this,a,!0);g.style.width=g.startWidth+"px";e.style.display="none"}))});var h=e.querySelectorAll("li > .highcharts-menu-item-btn")[0];b.switchSymbol(h,!1)};a.prototype.eraseActiveButtons=function(a,c,d){[].forEach.call(a,function(a){a!==c&&(a.classList.remove("highcharts-current"),a.classList.remove("highcharts-active"),d=a.querySelectorAll(".highcharts-submenu-wrapper"),0<d.length&&(d[0].style.display="none"))})};
a.prototype.addButton=function(b,d,e,g){void 0===g&&(g={});d=d[e];var f=d.items,k=d.className||"";e=c("li",{className:t(a.prototype.classMapping[e],"")+" "+k,title:g[e]||e},null,b);b=c("span",{className:"highcharts-menu-item-btn"},null,e);if(f&&f.length){var h=c("span",{className:"highcharts-submenu-item-arrow highcharts-arrow-right"},null,e);h.style["background-image"]="url("+this.iconsURL+"arrow-bottom.svg)"}else b.style["background-image"]="url("+this.iconsURL+d.symbol+")";return{buttonWrapper:e,
mainButton:b,submenuArrow:h}};a.prototype.addNavigation=function(){var a=this.wrapper;this.arrowWrapper=c("div",{className:"highcharts-arrow-wrapper"});this.arrowUp=c("div",{className:"highcharts-arrow-up"},null,this.arrowWrapper);this.arrowUp.style["background-image"]="url("+this.iconsURL+"arrow-right.svg)";this.arrowDown=c("div",{className:"highcharts-arrow-down"},null,this.arrowWrapper);this.arrowDown.style["background-image"]="url("+this.iconsURL+"arrow-right.svg)";a.insertBefore(this.arrowWrapper,
a.childNodes[0]);this.scrollButtons()};a.prototype.scrollButtons=function(){var a=0,c=this.wrapper,e=this.toolbar,g=.1*c.offsetHeight;this.eventsToUnbind.push(d(this.arrowUp,"click",function(){0<a&&(a-=g,e.style["margin-top"]=-a+"px")}));this.eventsToUnbind.push(d(this.arrowDown,"click",function(){c.offsetHeight+a<=e.offsetHeight+g&&(a+=g,e.style["margin-top"]=-a+"px")}))};a.prototype.createHTML=function(){var a=this.chart,d=this.options,e=a.container;a=a.options.navigation;this.wrapper=a=c("div",
{className:"highcharts-stocktools-wrapper "+d.className+" "+(a&&a.bindingsClassName)});e.parentNode.insertBefore(a,e);this.toolbar=e=c("ul",{className:"highcharts-stocktools-toolbar "+d.toolbarClassName});this.listWrapper=d=c("div",{className:"highcharts-menu-wrapper"});a.insertBefore(d,a.childNodes[0]);d.insertBefore(e,d.childNodes[0]);this.showHideToolbar();this.addNavigation()};a.prototype.showHideNavigatorion=function(){this.visible&&this.toolbar.offsetHeight>this.wrapper.offsetHeight-50?this.arrowWrapper.style.display=
"block":(this.toolbar.style.marginTop="0px",this.arrowWrapper.style.display="none")};a.prototype.showHideToolbar=function(){var a=this.chart,e=this.wrapper,g=this.listWrapper,k=this.submenu,h=this.visible,l;this.showhideBtn=l=c("div",{className:"highcharts-toggle-toolbar highcharts-arrow-left"},null,e);l.style["background-image"]="url("+this.iconsURL+"arrow-right.svg)";h?(e.style.height="100%",l.style.top=r(g,"padding-top")+"px",l.style.left=e.offsetWidth+r(g,"padding-left")+"px"):(k&&(k.style.display=
"none"),l.style.left="0px",this.visible=h=!1,g.classList.add("highcharts-hide"),l.classList.toggle("highcharts-arrow-right"),e.style.height=l.offsetHeight+"px");this.eventsToUnbind.push(d(l,"click",function(){a.update({stockTools:{gui:{visible:!h,placed:!0}}})}))};a.prototype.switchSymbol=function(a,c){var b=a.parentNode,d=b.classList.value;b=b.parentNode.parentNode;-1<d.indexOf("highcharts-disabled-btn")||(b.className="",d&&b.classList.add(d.trim()),b.querySelectorAll(".highcharts-menu-item-btn")[0].style["background-image"]=
a.style["background-image"],c&&this.selectButton(b))};a.prototype.selectButton=function(a){0<=a.className.indexOf("highcharts-active")?a.classList.remove("highcharts-active"):a.classList.add("highcharts-active")};a.prototype.unselectAllButtons=function(a){var b=a.parentNode.querySelectorAll(".highcharts-active");[].forEach.call(b,function(b){b!==a&&b.classList.remove("highcharts-active")})};a.prototype.update=function(a){m(!0,this.chart.options.stockTools,a);this.destroy();this.chart.setStockTools(a);
this.chart.navigationBindings&&this.chart.navigationBindings.update()};a.prototype.destroy=function(){var a=this.wrapper,c=a&&a.parentNode;this.eventsToUnbind.forEach(function(a){a()});c&&c.removeChild(a);this.chart.isDirtyBox=!0;this.chart.redraw()};a.prototype.redraw=function(){this.showHideNavigatorion()};a.prototype.getIconsURL=function(){return this.chart.options.navigation.iconsURL||this.options.iconsURL||"https://code.highcharts.com/9.1.0/gfx/stock-icons/"};return a}();F.prototype.classMapping=
{circle:"highcharts-circle-annotation",rectangle:"highcharts-rectangle-annotation",label:"highcharts-label-annotation",segment:"highcharts-segment",arrowSegment:"highcharts-arrow-segment",ray:"highcharts-ray",arrowRay:"highcharts-arrow-ray",line:"highcharts-infinity-line",arrowLine:"highcharts-arrow-infinity-line",verticalLine:"highcharts-vertical-line",horizontalLine:"highcharts-horizontal-line",crooked3:"highcharts-crooked3",crooked5:"highcharts-crooked5",elliott3:"highcharts-elliott3",elliott5:"highcharts-elliott5",
pitchfork:"highcharts-pitchfork",fibonacci:"highcharts-fibonacci",parallelChannel:"highcharts-parallel-channel",measureX:"highcharts-measure-x",measureY:"highcharts-measure-y",measureXY:"highcharts-measure-xy",verticalCounter:"highcharts-vertical-counter",verticalLabel:"highcharts-vertical-label",verticalArrow:"highcharts-vertical-arrow",currentPriceIndicator:"highcharts-current-price-indicator",indicators:"highcharts-indicators",flagCirclepin:"highcharts-flag-circlepin",flagDiamondpin:"highcharts-flag-diamondpin",
flagSquarepin:"highcharts-flag-squarepin",flagSimplepin:"highcharts-flag-simplepin",zoomX:"highcharts-zoom-x",zoomY:"highcharts-zoom-y",zoomXY:"highcharts-zoom-xy",typeLine:"highcharts-series-type-line",typeOHLC:"highcharts-series-type-ohlc",typeCandlestick:"highcharts-series-type-candlestick",fullScreen:"highcharts-full-screen",toggleAnnotations:"highcharts-toggle-annotations",saveChart:"highcharts-save-chart",separator:"highcharts-separator"};e(a.prototype,{setStockTools:function(a){var b=this.options,
c=b.lang;a=m(b.stockTools&&b.stockTools.gui,a&&a.gui);this.stockTools=new F(a,c.stockTools&&c.stockTools.gui,this);this.stockTools.guiEnabled&&(this.isDirtyBox=!0)}});d(u,"selectButton",function(a){var b=a.button,c=this.chart.stockTools;c&&c.guiEnabled&&(c.unselectAllButtons(a.button),0<=b.parentNode.className.indexOf("highcharts-submenu-wrapper")&&(b=b.parentNode.parentNode),c.selectButton(b))});d(u,"deselectButton",function(a){a=a.button;var b=this.chart.stockTools;b&&b.guiEnabled&&(0<=a.parentNode.className.indexOf("highcharts-submenu-wrapper")&&
(a=a.parentNode.parentNode),b.selectButton(a))});d(g.Chart,"render",function(){var a=this.stockTools,b=a&&a.toolbar&&a.toolbar.querySelector(".highcharts-current-price-indicator");a&&this.navigationBindings&&this.options.series&&b&&(this.navigationBindings.constructor.prototype.utils.isPriceIndicatorEnabled(this.series)?b.firstChild.style["background-image"]='url("'+a.getIconsURL()+'current-price-hide.svg")':b.firstChild.style["background-image"]='url("'+a.getIconsURL()+'current-price-show.svg")')});
g.Toolbar=F;return g.Toolbar});v(a,"masters/modules/stock-tools.src.js",[],function(){})});
//# sourceMappingURL=stock-tools.js.map