/*
 Highcharts JS v9.1.0 (2021-05-03)

 Annotations module

 (c) 2009-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/modules/annotations-advanced",["highcharts"],function(t){d(t);d.Highcharts=t;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function t(g,d,m,n){g.hasOwnProperty(d)||(g[d]=n.apply(null,m))}d=d?d._modules:{};t(d,"Extensions/Annotations/Mixins/EventEmitterMixin.js",[d["Core/Globals.js"],d["Core/Utilities.js"]],function(g,d){var h=
d.addEvent,n=d.fireEvent,k=d.objectEach,p=d.pick,e=d.removeEvent;return{addEvents:function(){var b=this,a=function(c){h(c,g.isTouchDevice?"touchstart":"mousedown",function(c){b.onMouseDown(c)},{passive:!1})};a(this.graphic.element);(b.labels||[]).forEach(function(c){c.options.useHTML&&c.graphic.text&&a(c.graphic.text.element)});k(b.options.events,function(c,a){var f=function(f){"click"===a&&b.cancelClick||c.call(b,b.chart.pointer.normalize(f),b.target)};if(-1===(b.nonDOMEvents||[]).indexOf(a))b.graphic.on(a,
f);else h(b,a,f,{passive:!1})});if(b.options.draggable&&(h(b,"drag",b.onDrag),!b.graphic.renderer.styledMode)){var c={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[b.options.draggable]};b.graphic.css(c);(b.labels||[]).forEach(function(a){a.options.useHTML&&a.graphic.text&&a.graphic.text.css(c)})}b.isUpdating||n(b,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(b){var a=this,
c=a.chart.pointer;b.preventDefault&&b.preventDefault();if(2!==b.button){b=c.normalize(b);var f=b.chartX;var l=b.chartY;a.cancelClick=!1;a.chart.hasDraggedAnnotation=!0;a.removeDrag=h(g.doc,g.isTouchDevice?"touchmove":"mousemove",function(b){a.hasDragged=!0;b=c.normalize(b);b.prevChartX=f;b.prevChartY=l;n(a,"drag",b);f=b.chartX;l=b.chartY},g.isTouchDevice?{passive:!1}:void 0);a.removeMouseUp=h(g.doc,g.isTouchDevice?"touchend":"mouseup",function(c){a.cancelClick=a.hasDragged;a.hasDragged=!1;a.chart.hasDraggedAnnotation=
!1;n(p(a.target,a),"afterUpdate");a.onMouseUp(c)},g.isTouchDevice?{passive:!1}:void 0)}},onMouseUp:function(b){var a=this.chart;b=this.target||this;var c=a.options.annotations;a=a.annotations.indexOf(b);this.removeDocEvents();c[a]=b.options},onDrag:function(b){if(this.chart.isInsidePlot(b.chartX-this.chart.plotLeft,b.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var a=this.mouseMoveToTranslation(b);"x"===this.options.draggable&&(a.y=0);"y"===this.options.draggable&&(a.x=0);this.points.length?this.translate(a.x,
a.y):(this.shapes.forEach(function(c){c.translate(a.x,a.y)}),this.labels.forEach(function(c){c.translate(a.x,a.y)}));this.redraw(!1)}},mouseMoveToRadians:function(b,a,c){var f=b.prevChartY-c,l=b.prevChartX-a;c=b.chartY-c;b=b.chartX-a;this.chart.inverted&&(a=l,l=f,f=a,a=b,b=c,c=a);return Math.atan2(c,b)-Math.atan2(f,l)},mouseMoveToTranslation:function(b){var a=b.chartX-b.prevChartX;b=b.chartY-b.prevChartY;if(this.chart.inverted){var c=b;b=a;a=c}return{x:a,y:b}},mouseMoveToScale:function(b,a,c){a=(b.chartX-
a||1)/(b.prevChartX-a||1);b=(b.chartY-c||1)/(b.prevChartY-c||1);this.chart.inverted&&(c=b,b=a,a=c);return{x:a,y:b}},destroy:function(){this.removeDocEvents();e(this);this.hcEvents=null}}});t(d,"Extensions/Annotations/ControlPoint.js",[d["Core/Utilities.js"],d["Extensions/Annotations/Mixins/EventEmitterMixin.js"]],function(g,d){var h=g.merge,n=g.pick;return function(){function g(g,e,b,a){this.addEvents=d.addEvents;this.graphic=void 0;this.mouseMoveToRadians=d.mouseMoveToRadians;this.mouseMoveToScale=
d.mouseMoveToScale;this.mouseMoveToTranslation=d.mouseMoveToTranslation;this.onDrag=d.onDrag;this.onMouseDown=d.onMouseDown;this.onMouseUp=d.onMouseUp;this.removeDocEvents=d.removeDocEvents;this.nonDOMEvents=["drag"];this.chart=g;this.target=e;this.options=b;this.index=n(b.index,a)}g.prototype.setVisibility=function(g){this.graphic.attr("visibility",g?"visible":"hidden");this.options.visible=g};g.prototype.render=function(){var g=this.chart,e=this.options;this.graphic=g.renderer.symbol(e.symbol,0,
0,e.width,e.height).add(g.controlPointsGroup).css(e.style);this.setVisibility(e.visible);this.addEvents()};g.prototype.redraw=function(g){this.graphic[g?"animate":"attr"](this.options.positioner.call(this,this.target))};g.prototype.destroy=function(){d.destroy.call(this);this.graphic&&(this.graphic=this.graphic.destroy());this.options=this.target=this.chart=null};g.prototype.update=function(g){var e=this.chart,b=this.target,a=this.index;g=h(!0,this.options,g);this.destroy();this.constructor(e,b,g,
a);this.render(e.controlPointsGroup);this.redraw()};return g}()});t(d,"Extensions/Annotations/MockPoint.js",[d["Core/Series/Series.js"],d["Core/Utilities.js"],d["Core/Axis/Axis.js"]],function(g,d,m){var h=d.defined,k=d.fireEvent;return function(){function d(e,b,a){this.y=this.x=this.plotY=this.plotX=this.isInside=void 0;this.mock=!0;this.series={visible:!0,chart:e,getPlotBox:g.prototype.getPlotBox};this.target=b||null;this.options=a;this.applyOptions(this.getOptions())}d.fromPoint=function(e){return new d(e.series.chart,
null,{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis})};d.pointToPixels=function(e,b){var a=e.series,c=a.chart,f=e.plotX,l=e.plotY;c.inverted&&(e.mock?(f=e.plotY,l=e.plotX):(f=c.plotWidth-e.plotY,l=c.plotHeight-e.plotX));a&&!b&&(e=a.getPlotBox(),f+=e.translateX,l+=e.translateY);return{x:f,y:l}};d.pointToOptions=function(e){return{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis}};d.prototype.hasDynamicOptions=function(){return"function"===typeof this.options};d.prototype.getOptions=function(){return this.hasDynamicOptions()?
this.options(this.target):this.options};d.prototype.applyOptions=function(e){this.command=e.command;this.setAxis(e,"x");this.setAxis(e,"y");this.refresh()};d.prototype.setAxis=function(e,b){b+="Axis";e=e[b];var a=this.series.chart;this.series[b]=e instanceof m?e:h(e)?a[b][e]||a.get(e):null};d.prototype.toAnchor=function(){var e=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&(e[0]=this.plotY,e[1]=this.plotX);return e};d.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}};
d.prototype.isInsidePlot=function(){var e=this.plotX,b=this.plotY,a=this.series.xAxis,c=this.series.yAxis,f={x:e,y:b,isInsidePlot:!0};a&&(f.isInsidePlot=h(e)&&0<=e&&e<=a.len);c&&(f.isInsidePlot=f.isInsidePlot&&h(b)&&0<=b&&b<=c.len);k(this.series.chart,"afterIsInsidePlot",f);return f.isInsidePlot};d.prototype.refresh=function(){var e=this.series,b=e.xAxis;e=e.yAxis;var a=this.getOptions();b?(this.x=a.x,this.plotX=b.toPixels(a.x,!0)):(this.x=null,this.plotX=a.x);e?(this.y=a.y,this.plotY=e.toPixels(a.y,
!0)):(this.y=null,this.plotY=a.y);this.isInside=this.isInsidePlot()};d.prototype.translate=function(e,b,a,c){this.hasDynamicOptions()||(this.plotX+=a,this.plotY+=c,this.refreshOptions())};d.prototype.scale=function(e,b,a,c){if(!this.hasDynamicOptions()){var f=this.plotY*c;this.plotX=(1-a)*e+this.plotX*a;this.plotY=(1-c)*b+f;this.refreshOptions()}};d.prototype.rotate=function(e,b,a){if(!this.hasDynamicOptions()){var c=Math.cos(a);a=Math.sin(a);var f=this.plotX,l=this.plotY;f-=e;l-=b;this.plotX=f*c-
l*a+e;this.plotY=f*a+l*c+b;this.refreshOptions()}};d.prototype.refreshOptions=function(){var e=this.series,b=e.xAxis;e=e.yAxis;this.x=this.options.x=b?this.options.x=b.toValue(this.plotX,!0):this.plotX;this.y=this.options.y=e?e.toValue(this.plotY,!0):this.plotY};return d}()});t(d,"Extensions/Annotations/Mixins/ControllableMixin.js",[d["Extensions/Annotations/ControlPoint.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Tooltip.js"],d["Core/Utilities.js"]],function(g,d,m,n){var h=n.isObject,p=
n.isString,e=n.merge,b=n.splat;return{init:function(a,c,f){this.annotation=a;this.chart=a.chart;this.options=c;this.points=[];this.controlPoints=[];this.index=f;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var a=this.options;return a.points||a.point&&b(a.point)},attrsFromOptions:function(a){var c=this.constructor.attrsMap,f={},b,q=this.chart.styledMode;for(b in a){var e=c[b];!e||q&&-1!==["fill","stroke","stroke-width"].indexOf(e)||
(f[e]=a[b])}return f},anchor:function(a){var c=a.series.getPlotBox(),f=a.series.chart,b=a.mock?a.toAnchor():m.prototype.getAnchor.call({chart:a.series.chart},a);b={x:b[0]+(this.options.x||0),y:b[1]+(this.options.y||0),height:b[2]||0,width:b[3]||0};return{relativePosition:b,absolutePosition:e(b,{x:b.x+(a.mock?c.translateX:f.plotLeft),y:b.y+(a.mock?c.translateY:f.plotTop)})}},point:function(a,c){if(a&&a.series)return a;c&&null!==c.series||(h(a)?c=new d(this.chart,this,a):p(a)?c=this.chart.get(a)||null:
"function"===typeof a&&(c=a.call(c,this),c=c.series?c:new d(this.chart,this,a)));return c},linkPoints:function(){var a=this.getPointsOptions(),c=this.points,f=a&&a.length||0,b;for(b=0;b<f;b++){var q=this.point(a[b],c[b]);if(!q){c.length=0;return}q.mock&&q.refresh();c[b]=q}return c},addControlPoints:function(){var a=this.options.controlPoints;(a||[]).forEach(function(c,f){c=e(this.options.controlPointOptions,c);c.index||(c.index=f);a[f]=c;this.controlPoints.push(new g(this.chart,this,c))},this)},shouldBeDrawn:function(){return!!this.points.length},
render:function(a){this.controlPoints.forEach(function(c){c.render()})},redraw:function(a){this.controlPoints.forEach(function(c){c.redraw(a)})},transform:function(a,c,f,b,q){if(this.chart.inverted){var l=c;c=f;f=l}this.points.forEach(function(l,e){this.transformPoint(a,c,f,b,q,e)},this)},transformPoint:function(a,c,b,l,q,e){var f=this.points[e];f.mock||(f=this.points[e]=d.fromPoint(f));f[a](c,b,l,q)},translate:function(a,c){this.transform("translate",null,null,a,c)},translatePoint:function(a,c,f){this.transformPoint("translate",
null,null,a,c,f)},translateShape:function(a,c){var f=this.annotation.chart,b=this.annotation.userOptions,q=f.annotations.indexOf(this.annotation);f=f.options.annotations[q];this.translatePoint(a,c,0);f[this.collection][this.index].point=this.options.point;b[this.collection][this.index].point=this.options.point},rotate:function(a,c,b){this.transform("rotate",a,c,b)},scale:function(a,c,b,l){this.transform("scale",a,c,b,l)},setControlPointsVisibility:function(a){this.controlPoints.forEach(function(c){c.setVisibility(a)})},
destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());this.controlPoints.forEach(function(a){a.destroy()});this.options=this.controlPoints=this.points=this.chart=null;this.annotation&&(this.annotation=null)},update:function(a){var c=this.annotation;a=e(!0,this.options,a);var b=this.graphic.parentGroup;this.destroy();this.constructor(c,a,this.index);this.render(b);this.redraw()}}});t(d,"Extensions/Annotations/Mixins/MarkerMixin.js",
[d["Core/Chart/Chart.js"],d["Core/Renderer/SVG/SVGRenderer.js"],d["Core/Utilities.js"]],function(g,d,m){function h(c){return function(a){this.attr(c,"url(#"+a+")")}}var k=m.addEvent,p=m.defined,e=m.merge,b=m.uniqueKey,a={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},
children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};d.prototype.addMarker=function(c,a){var b={attributes:{id:c}},f={stroke:a.color||"none",fill:a.color||"rgba(0, 0, 0, 0.75)"};b.children=a.children&&a.children.map(function(a){return e(f,a)});a=e(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},a,b);a=this.definition(a);a.id=c;return a};d={markerEndSetter:h("marker-end"),markerStartSetter:h("marker-start"),setItemMarkers:function(a){var c=
a.options,l=a.chart,q=l.options.defs,g=c.fill,d=p(g)&&"none"!==g?g:c.stroke;["markerStart","markerEnd"].forEach(function(f){var g=c[f],w;if(g){for(w in q){var B=q[w];if((g===(B.attributes&&B.attributes.id)||g===B.id)&&"marker"===B.tagName){var v=B;break}}v&&(g=a[f]=l.renderer.addMarker((c.id||b())+"-"+g,e(v,{color:d})),a.attr(f,g.getAttribute("id")))}})}};k(g,"afterGetContainer",function(){this.options.defs=e(a,this.options.defs||{})});return d});t(d,"Extensions/Annotations/Controllables/ControllablePath.js",
[d["Extensions/Annotations/Mixins/ControllableMixin.js"],d["Core/Globals.js"],d["Extensions/Annotations/Mixins/MarkerMixin.js"],d["Core/Utilities.js"]],function(g,d,m,n){var h=n.extend,p="rgba(192,192,192,"+(d.svg?.0001:.002)+")";return function(){function e(b,a,c){this.addControlPoints=g.addControlPoints;this.anchor=g.anchor;this.attr=g.attr;this.attrsFromOptions=g.attrsFromOptions;this.destroy=g.destroy;this.getPointsOptions=g.getPointsOptions;this.init=g.init;this.linkPoints=g.linkPoints;this.point=
g.point;this.rotate=g.rotate;this.scale=g.scale;this.setControlPointsVisibility=g.setControlPointsVisibility;this.setMarkers=m.setItemMarkers;this.transform=g.transform;this.transformPoint=g.transformPoint;this.translate=g.translate;this.translatePoint=g.translatePoint;this.translateShape=g.translateShape;this.update=g.update;this.type="path";this.init(b,a,c);this.collection="shapes"}e.prototype.toD=function(){var b=this.options.d;if(b)return"function"===typeof b?b.call(this):b;b=this.points;var a=
b.length,c=a,f=b[0],l=c&&this.anchor(f).absolutePosition,q=0,e=[];if(l)for(e.push(["M",l.x,l.y]);++q<a&&c;)f=b[q],c=f.command||"L",l=this.anchor(f).absolutePosition,"M"===c?e.push([c,l.x,l.y]):"L"===c?e.push([c,l.x,l.y]):"Z"===c&&e.push([c]),c=f.series.visible;return c?this.chart.renderer.crispLine(e,this.graphic.strokeWidth()):null};e.prototype.shouldBeDrawn=function(){return g.shouldBeDrawn.call(this)||!!this.options.d};e.prototype.render=function(b){var a=this.options,c=this.attrsFromOptions(a);
this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(c).add(b);a.className&&this.graphic.addClass(a.className);this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(b);this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:p,fill:p,"stroke-width":this.graphic.strokeWidth()+2*a.snap});g.render.call(this);h(this.graphic,{markerStartSetter:m.markerStartSetter,markerEndSetter:m.markerEndSetter});
this.setMarkers(this)};e.prototype.redraw=function(b){var a=this.toD(),c=b?"animate":"attr";a?(this.graphic[c]({d:a}),this.tracker[c]({d:a})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));this.graphic.placed=this.tracker.placed=!!a;g.redraw.call(this,b)};e.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"};return e}()});t(d,"Extensions/Annotations/Controllables/ControllableRect.js",[d["Extensions/Annotations/Mixins/ControllableMixin.js"],
d["Extensions/Annotations/Controllables/ControllablePath.js"],d["Core/Utilities.js"]],function(g,d,m){var h=m.merge;return function(){function k(d,e,b){this.addControlPoints=g.addControlPoints;this.anchor=g.anchor;this.attr=g.attr;this.attrsFromOptions=g.attrsFromOptions;this.destroy=g.destroy;this.getPointsOptions=g.getPointsOptions;this.init=g.init;this.linkPoints=g.linkPoints;this.point=g.point;this.rotate=g.rotate;this.scale=g.scale;this.setControlPointsVisibility=g.setControlPointsVisibility;
this.shouldBeDrawn=g.shouldBeDrawn;this.transform=g.transform;this.transformPoint=g.transformPoint;this.translatePoint=g.translatePoint;this.translateShape=g.translateShape;this.update=g.update;this.type="rect";this.translate=g.translateShape;this.init(d,e,b);this.collection="shapes"}k.prototype.render=function(d){var e=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(e).add(d);g.render.call(this)};k.prototype.redraw=function(d){var e=this.anchor(this.points[0]).absolutePosition;
if(e)this.graphic[d?"animate":"attr"]({x:e.x,y:e.y,width:this.options.width,height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!e;g.redraw.call(this,d)};k.attrsMap=h(d.attrsMap,{width:"width",height:"height"});return k}()});t(d,"Extensions/Annotations/Controllables/ControllableCircle.js",[d["Extensions/Annotations/Mixins/ControllableMixin.js"],d["Extensions/Annotations/Controllables/ControllablePath.js"],d["Core/Utilities.js"]],function(g,d,m){var h=m.merge;return function(){function k(d,
e,b){this.addControlPoints=g.addControlPoints;this.anchor=g.anchor;this.attr=g.attr;this.attrsFromOptions=g.attrsFromOptions;this.destroy=g.destroy;this.getPointsOptions=g.getPointsOptions;this.init=g.init;this.linkPoints=g.linkPoints;this.point=g.point;this.rotate=g.rotate;this.scale=g.scale;this.setControlPointsVisibility=g.setControlPointsVisibility;this.shouldBeDrawn=g.shouldBeDrawn;this.transform=g.transform;this.transformPoint=g.transformPoint;this.translatePoint=g.translatePoint;this.translateShape=
g.translateShape;this.update=g.update;this.type="circle";this.translate=g.translateShape;this.init(d,e,b);this.collection="shapes"}k.prototype.render=function(d){var e=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(e).add(d);g.render.call(this)};k.prototype.redraw=function(d){var e=this.anchor(this.points[0]).absolutePosition;if(e)this.graphic[d?"animate":"attr"]({x:e.x,y:e.y,r:this.options.r});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=
!!e;g.redraw.call(this,d)};k.prototype.setRadius=function(d){this.options.r=d};k.attrsMap=h(d.attrsMap,{r:"r"});return k}()});t(d,"Extensions/Annotations/Controllables/ControllableLabel.js",[d["Extensions/Annotations/Mixins/ControllableMixin.js"],d["Core/FormatUtilities.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Renderer/SVG/SVGRenderer.js"],d["Core/Tooltip.js"],d["Core/Utilities.js"]],function(d,h,m,n,k,p){var e=h.format,b=p.extend,a=p.isNumber,c=p.pick;h=function(){function a(a,c,b){this.addControlPoints=
d.addControlPoints;this.attr=d.attr;this.attrsFromOptions=d.attrsFromOptions;this.destroy=d.destroy;this.getPointsOptions=d.getPointsOptions;this.init=d.init;this.linkPoints=d.linkPoints;this.point=d.point;this.rotate=d.rotate;this.scale=d.scale;this.setControlPointsVisibility=d.setControlPointsVisibility;this.shouldBeDrawn=d.shouldBeDrawn;this.transform=d.transform;this.transformPoint=d.transformPoint;this.translateShape=d.translateShape;this.update=d.update;this.init(a,c,b);this.collection="labels"}
a.alignedPosition=function(a,c){var b=a.align,f=a.verticalAlign,l=(c.x||0)+(a.x||0),q=(c.y||0)+(a.y||0),d,e;"right"===b?d=1:"center"===b&&(d=2);d&&(l+=(c.width-(a.width||0))/d);"bottom"===f?e=1:"middle"===f&&(e=2);e&&(q+=(c.height-(a.height||0))/e);return{x:Math.round(l),y:Math.round(q)}};a.justifiedOptions=function(a,c,b,f){var l=b.align,d=b.verticalAlign,e=c.box?0:c.padding||0,q=c.getBBox();c={align:l,verticalAlign:d,x:b.x,y:b.y,width:c.width,height:c.height};b=(f.x||0)-a.plotLeft;var g=(f.y||0)-
a.plotTop;f=b+e;0>f&&("right"===l?c.align="left":c.x=(c.x||0)-f);f=b+q.width-e;f>a.plotWidth&&("left"===l?c.align="right":c.x=(c.x||0)+a.plotWidth-f);f=g+e;0>f&&("bottom"===d?c.verticalAlign="top":c.y=(c.y||0)-f);f=g+q.height-e;f>a.plotHeight&&("top"===d?c.verticalAlign="bottom":c.y=(c.y||0)+a.plotHeight-f);return c};a.prototype.translatePoint=function(a,c){d.translatePoint.call(this,a,c,0)};a.prototype.translate=function(a,c){var b=this.annotation.chart,f=this.annotation.userOptions,l=b.annotations.indexOf(this.annotation);
l=b.options.annotations[l];b.inverted&&(b=a,a=c,c=b);this.options.x+=a;this.options.y+=c;l[this.collection][this.index].x=this.options.x;l[this.collection][this.index].y=this.options.y;f[this.collection][this.index].x=this.options.x;f[this.collection][this.index].y=this.options.y};a.prototype.render=function(c){var b=this.options,f=this.attrsFromOptions(b),l=b.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,b.shape,null,null,b.useHTML,null,"annotation-label").attr(f).add(c);this.annotation.chart.styledMode||
("contrast"===l.color&&(l.color=this.annotation.chart.renderer.getContrast(-1<a.shapesWithoutBackground.indexOf(b.shape)?"#FFFFFF":b.backgroundColor)),this.graphic.css(b.style).shadow(b.shadow));b.className&&this.graphic.addClass(b.className);this.graphic.labelrank=b.labelrank;d.render.call(this)};a.prototype.redraw=function(a){var c=this.options,b=this.text||c.format||c.text,f=this.graphic,l=this.points[0];f.attr({text:b?e(b,l.getLabelConfig(),this.annotation.chart):c.formatter.call(l,this)});c=
this.anchor(l);(b=this.position(c))?(f.alignAttr=b,b.anchorX=c.absolutePosition.x,b.anchorY=c.absolutePosition.y,f[a?"animate":"attr"](b)):f.attr({x:0,y:-9999});f.placed=!!b;d.redraw.call(this,a)};a.prototype.anchor=function(a){var c=d.anchor.apply(this,arguments),b=this.options.x||0,f=this.options.y||0;c.absolutePosition.x-=b;c.absolutePosition.y-=f;c.relativePosition.x-=b;c.relativePosition.y-=f;return c};a.prototype.position=function(f){var l=this.graphic,d=this.annotation.chart,e=this.points[0],
g=this.options,h=f.absolutePosition,p=f.relativePosition,n=e.series.visible&&m.prototype.isInsidePlot.call(e);f=l.width;f=void 0===f?0:f;var v=l.height;v=void 0===v?0:v;if(n){if(g.distance)var u=k.prototype.getPosition.call({chart:d,distance:c(g.distance,16)},f,v,{plotX:p.x,plotY:p.y,negative:e.negative,ttBelow:e.ttBelow,h:p.height||p.width});else g.positioner?u=g.positioner.call(this):(e={x:h.x,y:h.y,width:0,height:0},u=a.alignedPosition(b(g,{width:f,height:v}),e),"justify"===this.options.overflow&&
(u=a.alignedPosition(a.justifiedOptions(d,l,g,u),e)));g.crop&&(l=u.x-d.plotLeft,g=u.y-d.plotTop,n=d.isInsidePlot(l,g)&&d.isInsidePlot(l+f,g+v))}return n?u:null};a.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};a.shapesWithoutBackground=["connector"];return a}();n.prototype.symbols.connector=function(c,b,e,d,g){var f=g&&g.anchorX;g=g&&g.anchorY;var l=e/2;if(a(f)&&a(g)){var q=[["M",f,g]];var w=b-g;0>w&&(w=-d-w);w<
e&&(l=f<c+e/2?w:e-w);g>b+d?q.push(["L",c+l,b+d]):g<b?q.push(["L",c+l,b]):f<c?q.push(["L",c,b+d/2]):f>c+e&&q.push(["L",c+e,b+d/2])}return q||[]};return h});t(d,"Extensions/Annotations/Controllables/ControllableImage.js",[d["Extensions/Annotations/Controllables/ControllableLabel.js"],d["Extensions/Annotations/Mixins/ControllableMixin.js"]],function(d,h){return function(){function g(d,g,p){this.addControlPoints=h.addControlPoints;this.anchor=h.anchor;this.attr=h.attr;this.attrsFromOptions=h.attrsFromOptions;
this.destroy=h.destroy;this.getPointsOptions=h.getPointsOptions;this.init=h.init;this.linkPoints=h.linkPoints;this.point=h.point;this.rotate=h.rotate;this.scale=h.scale;this.setControlPointsVisibility=h.setControlPointsVisibility;this.shouldBeDrawn=h.shouldBeDrawn;this.transform=h.transform;this.transformPoint=h.transformPoint;this.translatePoint=h.translatePoint;this.translateShape=h.translateShape;this.update=h.update;this.type="image";this.translate=h.translateShape;this.init(d,g,p);this.collection=
"shapes"}g.prototype.render=function(d){var g=this.attrsFromOptions(this.options),p=this.options;this.graphic=this.annotation.chart.renderer.image(p.src,0,-9E9,p.width,p.height).attr(g).add(d);this.graphic.width=p.width;this.graphic.height=p.height;h.render.call(this)};g.prototype.redraw=function(g){var k=this.anchor(this.points[0]);if(k=d.prototype.position.call(this,k))this.graphic[g?"animate":"attr"]({x:k.x,y:k.y});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!k;h.redraw.call(this,
g)};g.attrsMap={width:"width",height:"height",zIndex:"zIndex"};return g}()});t(d,"Extensions/Annotations/Annotations.js",[d["Core/Animation/AnimationUtilities.js"],d["Core/Chart/Chart.js"],d["Extensions/Annotations/Mixins/ControllableMixin.js"],d["Extensions/Annotations/Controllables/ControllableRect.js"],d["Extensions/Annotations/Controllables/ControllableCircle.js"],d["Extensions/Annotations/Controllables/ControllablePath.js"],d["Extensions/Annotations/Controllables/ControllableImage.js"],d["Extensions/Annotations/Controllables/ControllableLabel.js"],
d["Extensions/Annotations/ControlPoint.js"],d["Extensions/Annotations/Mixins/EventEmitterMixin.js"],d["Core/Globals.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Pointer.js"],d["Core/Utilities.js"],d["Core/Color/Palette.js"]],function(d,h,m,n,k,p,e,b,a,c,f,l,q,w,B){var g=d.getDeferredAnimation;d=h.prototype;var A=w.addEvent,z=w.defined,D=w.destroyObjectProperties,v=w.erase,u=w.extend,E=w.find,x=w.fireEvent,r=w.merge,y=w.pick,G=w.splat;w=w.wrap;var F=function(){function f(c,a){this.annotation=
void 0;this.coll="annotations";this.shapesGroup=this.labelsGroup=this.labelCollector=this.group=this.graphic=this.animationConfig=this.collection=void 0;this.chart=c;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=r(this.defaultOptions,a);this.userOptions=a;a=this.getLabelsAndShapesOptions(this.options,a);this.options.labels=a.labels;this.options.shapes=a.shapes;this.init(c,this.options)}f.prototype.init=function(){var c=this.chart,a=this.options.animation;
this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.setLabelCollector();this.animationConfig=g(c,a)};f.prototype.getLabelsAndShapesOptions=function(c,a){var b={};["labels","shapes"].forEach(function(f){c[f]&&(b[f]=G(a[f]).map(function(a,b){return r(c[f][b],a)}))});return b};f.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(a,c){a=this.initShape(a,c);r(!0,this.options.shapes[c],a.options)},this)};f.prototype.addLabels=function(){(this.options.labels||
[]).forEach(function(a,c){a=this.initLabel(a,c);r(!0,this.options.labels[c],a.options)},this)};f.prototype.addClipPaths=function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))};f.prototype.setClipAxes=function(){var a=this.chart.xAxis,c=this.chart.yAxis,b=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(b,f){return[a[f&&f.point&&f.point.xAxis]||b[0],c[f&&f.point&&f.point.yAxis]||b[1]]},[]);this.clipXAxis=
b[0];this.clipYAxis=b[1]};f.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}};f.prototype.setLabelCollector=function(){var a=this;a.labelCollector=function(){return a.labels.reduce(function(a,c){c.options.allowOverlap||a.push(c.graphic);return a},[])};a.chart.labelCollectors.push(a.labelCollector)};f.prototype.setOptions=function(a){this.options=r(this.defaultOptions,a)};f.prototype.redraw=
function(a){this.linkPoints();this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);m.redraw.call(this,a)};f.prototype.redrawItems=function(a,c){for(var b=a.length;b--;)this.redrawItem(a[b],c)};f.prototype.renderItems=function(a){for(var c=a.length;c--;)this.renderItem(a[c])};f.prototype.render=function(){var a=this.chart.renderer;this.graphic=a.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,
visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=a.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip);this.labelsGroup=a.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.addClipPaths();this.clipRect&&this.graphic.clip(this.clipRect);this.renderItems(this.shapes);this.renderItems(this.labels);this.addEvents();m.render.call(this)};f.prototype.setVisibility=function(a){var c=this.options;a=y(a,!c.visible);this.graphic.attr("visibility",
a?"visible":"hidden");a||this.setControlPointsVisibility(!1);c.visible=a};f.prototype.setControlPointsVisibility=function(a){var c=function(c){c.setControlPointsVisibility(a)};m.setControlPointsVisibility.call(this,a);this.shapes.forEach(c);this.labels.forEach(c)};f.prototype.destroy=function(){var a=this.chart,b=function(a){a.destroy()};this.labels.forEach(b);this.shapes.forEach(b);this.clipYAxis=this.clipXAxis=null;v(a.labelCollectors,this.labelCollector);c.destroy.call(this);m.destroy.call(this);
D(this,a)};f.prototype.remove=function(){return this.chart.removeAnnotation(this)};f.prototype.update=function(a,c){var b=this.chart,f=this.getLabelsAndShapesOptions(this.userOptions,a),l=b.annotations.indexOf(this);a=r(!0,this.userOptions,a);a.labels=f.labels;a.shapes=f.shapes;this.destroy();this.constructor(b,a);b.options.annotations[l]=a;this.isUpdating=!0;y(c,!0)&&b.redraw();x(this,"afterUpdate");this.isUpdating=!1};f.prototype.initShape=function(a,c){a=r(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},
a);c=new f.shapesMap[a.type](this,a,c);c.itemType="shape";this.shapes.push(c);return c};f.prototype.initLabel=function(a,c){a=r(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},a);c=new b(this,a,c);c.itemType="label";this.labels.push(c);return c};f.prototype.redrawItem=function(a,c){a.linkPoints();a.shouldBeDrawn()?(a.graphic||this.renderItem(a),a.redraw(y(c,!0)&&a.graphic.placed),a.points.length&&this.adjustVisibility(a)):this.destroyItem(a)};f.prototype.adjustVisibility=
function(a){var c=!1,b=a.graphic;a.points.forEach(function(a){!1!==a.series.visible&&!1!==a.visible&&(c=!0)});c?"hidden"===b.visibility&&b.show():b.hide()};f.prototype.destroyItem=function(a){v(this[a.itemType+"s"],a);a.destroy()};f.prototype.renderItem=function(a){a.render("label"===a.itemType?this.labelsGroup:this.shapesGroup)};f.ControlPoint=a;f.MockPoint=l;f.shapesMap={rect:n,circle:k,path:p,image:e};f.types={};return f}();r(!0,F.prototype,m,c,r(F.prototype,{nonDOMEvents:["add","afterUpdate",
"drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:B.neutralColor100,borderRadius:3,borderWidth:1,className:"",crop:!1,formatter:function(){return z(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",
strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:B.neutralColor100,"stroke-width":2,fill:B.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));f.extendAnnotation=function(a,c,b,f){c=c||F;u(a.prototype,r(c.prototype,b));a.prototype.defaultOptions=r(a.prototype.defaultOptions,f||{})};u(d,{initAnnotation:function(a){a=new (F.types[a.type]||F)(this,a);this.annotations.push(a);return a},addAnnotation:function(a,c){a=this.initAnnotation(a);
this.options.annotations.push(a.options);y(c,!0)&&(a.redraw(),a.graphic.attr({opacity:1}));return a},removeAnnotation:function(a){var c=this.annotations,b="annotations"===a.coll?a:E(c,function(c){return c.options.id===a});b&&(x(b,"remove"),v(this.options.annotations,b.options),v(c,b),b.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);this.annotations.forEach(function(a){a.redraw();a.graphic.animate({opacity:1},a.animationConfig)})}});d.collectionsWithUpdate.push("annotations");
d.collectionsWithInit.annotations=[d.addAnnotation];A(h,"afterInit",function(){this.annotations=[];this.options.annotations||(this.options.annotations=[])});d.callbacks.push(function(a){a.plotBoxClip=this.renderer.clipRect(this.plotBox);a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(c,b){if(!a.annotations.some(function(a){return a.options===c})){var f=a.initAnnotation(c);a.options.annotations[b]=f.options}});a.drawAnnotations();
A(a,"redraw",a.drawAnnotations);A(a,"destroy",function(){a.plotBoxClip.destroy();a.controlPointsGroup.destroy()});A(a,"exportData",function(c){var b=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,f=!c.dataRows[1].xValues,l=a.options.lang&&a.options.lang.exportData&&a.options.lang.exportData.annotationHeader,d=function(a){if(b){var c=b(a);if(!1!==c)return c}c=l+" "+a;return f?{columnTitle:c,topLevelColumnTitle:c}:c},e=c.dataRows[0].length,g=a.options.exporting&&a.options.exporting.csv&&
a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.itemDelimiter,q=a.options.exporting&&a.options.exporting.csv&&a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.join;a.annotations.forEach(function(a){a.options.labelOptions.includeInDataExport&&a.labels.forEach(function(a){if(a.options.text){var b=a.options.text;a.points.forEach(function(a){var f=a.x,l=a.series.xAxis?a.series.xAxis.options.index:-1,d=!1;if(-1===l){a=c.dataRows[0].length;for(var r=Array(a),
y=0;y<a;++y)r[y]="";r.push(b);r.xValues=[];r.xValues[l]=f;c.dataRows.push(r);d=!0}d||c.dataRows.forEach(function(a,c){!d&&a.xValues&&void 0!==l&&f===a.xValues[l]&&(q&&a.length>e?a[a.length-1]+=g+b:a.push(b),d=!0)});if(!d){a=c.dataRows[0].length;r=Array(a);for(y=0;y<a;++y)r[y]="";r[0]=f;r.push(b);r.xValues=[];void 0!==l&&(r.xValues[l]=f);c.dataRows.push(r)}})}})});var r=0;c.dataRows.forEach(function(a){r=Math.max(r,a.length)});for(var x=r-c.dataRows[0].length,y=0;y<x;y++){var u=d(y+1);f?(c.dataRows[0].push(u.topLevelColumnTitle),
c.dataRows[1].push(u.columnTitle)):c.dataRows[0].push(u)}})});w(q.prototype,"onContainerMouseDown",function(a){this.chart.hasDraggedAnnotation||a.apply(this,Array.prototype.slice.call(arguments,1))});return f.Annotation=F});t(d,"Extensions/Annotations/Types/BasicAnnotation.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,h,m){var g=this&&this.__extends||function(){var d=function(e,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(e,b)};return function(e,b){function a(){this.constructor=e}d(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}();m=m.merge;var k=function(k){function e(b,a){return k.call(this,b,a)||this}g(e,k);e.prototype.addControlPoints=function(){var b=this.options,a=e.basicControlPoints,c=this.basicType;(b.labels||b.shapes).forEach(function(b){b.controlPoints=a[c]})};e.prototype.init=
function(){var b=this.options;b.shapes?(delete b.labelOptions,this.basicType="circle"===b.shapes[0].type?"circle":"rectangle"):(delete b.shapes,this.basicType="label");d.prototype.init.apply(this,arguments)};e.basicControlPoints={label:[{symbol:"triangle-down",positioner:function(b){if(!b.graphic.placed)return{x:0,y:-9E7};b=h.pointToPixels(b.points[0]);return{x:b.x-this.graphic.width/2,y:b.y-this.graphic.height/2}},events:{drag:function(b,a){b=this.mouseMoveToTranslation(b);a.translatePoint(b.x,b.y);
a.annotation.userOptions.labels[0].point=a.options.point;a.redraw(!1)}}},{symbol:"square",positioner:function(b){return b.graphic.placed?{x:b.graphic.alignAttr.x-this.graphic.width/2,y:b.graphic.alignAttr.y-this.graphic.height/2}:{x:0,y:-9E7}},events:{drag:function(b,a){b=this.mouseMoveToTranslation(b);a.translate(b.x,b.y);a.annotation.userOptions.labels[0].point=a.options.point;a.redraw(!1)}}}],rectangle:[{positioner:function(b){b=h.pointToPixels(b.points[2]);return{x:b.x-4,y:b.y-4}},events:{drag:function(b,
a){var c=a.annotation,f=this.chart.pointer.getCoordinates(b);b=f.xAxis[0].value;f=f.yAxis[0].value;var l=a.options.points;l[1].x=b;l[2].x=b;l[2].y=f;l[3].y=f;c.userOptions.shapes[0].points=a.options.points;c.redraw(!1)}}}],circle:[{positioner:function(b){var a=h.pointToPixels(b.points[0]);b=b.options.r;return{x:a.x+b*Math.cos(Math.PI/4)-this.graphic.width/2,y:a.y+b*Math.sin(Math.PI/4)-this.graphic.height/2}},events:{drag:function(b,a){var c=a.annotation;b=this.mouseMoveToTranslation(b);a.setRadius(Math.max(a.options.r+
b.y/Math.sin(Math.PI/4),5));c.userOptions.shapes[0].r=a.options.r;c.userOptions.shapes[0].point=a.options.point;a.redraw(!1)}}}]};return e}(d);k.prototype.defaultOptions=m(d.prototype.defaultOptions,{});return d.types.basicAnnotation=k});t(d,"Extensions/Annotations/Types/CrookedLine.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/ControlPoint.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,h,m,n){var g=this&&this.__extends||function(){var d=
function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(b,a)};return function(b,a){function c(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),p=n.merge;n=function(d){function b(a,c){return d.call(this,a,c)||this}g(b,d);b.prototype.setClipAxes=function(){this.clipXAxis=this.chart.xAxis[this.options.typeOptions.xAxis];this.clipYAxis=
this.chart.yAxis[this.options.typeOptions.yAxis]};b.prototype.getPointsOptions=function(){var a=this.options.typeOptions;return(a.points||[]).map(function(c){c.xAxis=a.xAxis;c.yAxis=a.yAxis;return c})};b.prototype.getControlPointsOptions=function(){return this.getPointsOptions()};b.prototype.addControlPoints=function(){this.getControlPointsOptions().forEach(function(a,c){c=new h(this.chart,this,p(this.options.controlPointOptions,a.controlPoint),c);this.controlPoints.push(c);a.controlPoint=c.options},
this)};b.prototype.addShapes=function(){var a=this.options.typeOptions,c=this.initShape(p(a.line,{type:"path",points:this.points.map(function(a,c){return function(a){return a.annotation.points[c]}})}),!1);a.line=c.options};return b}(d);n.prototype.defaultOptions=p(d.prototype.defaultOptions,{typeOptions:{xAxis:0,yAxis:0,line:{fill:"none"}},controlPointOptions:{positioner:function(d){var b=this.graphic;d=m.pointToPixels(d.points[this.index]);return{x:d.x-b.width/2,y:d.y-b.height/2}},events:{drag:function(d,
b){b.chart.isInsidePlot(d.chartX-b.chart.plotLeft,d.chartY-b.chart.plotTop,{visiblePlotOnly:!0})&&(d=this.mouseMoveToTranslation(d),b.translatePoint(d.x,d.y,this.index),b.options.typeOptions.points[this.index].x=b.points[this.index].x,b.options.typeOptions.points[this.index].y=b.points[this.index].y,b.redraw(!1))}}}});return d.types.crookedLine=n});t(d,"Extensions/Annotations/Types/ElliottWave.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/Types/CrookedLine.js"],d["Core/Utilities.js"]],
function(d,h,m){var g=this&&this.__extends||function(){var d=function(e,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(e,b)};return function(e,b){function a(){this.constructor=e}d(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),k=m.merge;m=function(d){function e(b,a){return d.call(this,b,a)||this}g(e,d);e.prototype.addLabels=function(){this.getPointsOptions().forEach(function(b,
a){var c=this.initLabel(k(b.label,{text:this.options.typeOptions.labels[a],point:function(c){return c.annotation.points[a]}}),!1);b.label=c.options},this)};return e}(h);m.prototype.defaultOptions=k(h.prototype.defaultOptions,{typeOptions:{labels:"(0) (A) (B) (C) (D) (E)".split(" "),line:{strokeWidth:1}},labelOptions:{align:"center",allowOverlap:!0,crop:!0,overflow:"none",type:"rect",backgroundColor:"none",borderWidth:0,y:-5}});return d.types.elliottWave=m});t(d,"Extensions/Annotations/Types/Tunnel.js",
[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/ControlPoint.js"],d["Extensions/Annotations/Types/CrookedLine.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,h,m,n,k){var g=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return b(a,c)};return function(a,c){function f(){this.constructor=a}b(a,
c);a.prototype=null===c?Object.create(c):(f.prototype=c.prototype,new f)}}(),e=k.merge;k=function(b){function a(a,f){return b.call(this,a,f)||this}g(a,b);a.prototype.getPointsOptions=function(){var a=m.prototype.getPointsOptions.call(this);a[2]=this.heightPointOptions(a[1]);a[3]=this.heightPointOptions(a[0]);return a};a.prototype.getControlPointsOptions=function(){return this.getPointsOptions().slice(0,2)};a.prototype.heightPointOptions=function(a){a=e(a);a.y+=this.options.typeOptions.height;return a};
a.prototype.addControlPoints=function(){m.prototype.addControlPoints.call(this);var a=this.options,b=a.typeOptions;a=new h(this.chart,this,e(a.controlPointOptions,b.heightControlPoint),2);this.controlPoints.push(a);b.heightControlPoint=a.options};a.prototype.addShapes=function(){this.addLine();this.addBackground()};a.prototype.addLine=function(){var a=this.initShape(e(this.options.typeOptions.line,{type:"path",points:[this.points[0],this.points[1],function(a){a=n.pointToOptions(a.annotation.points[2]);
a.command="M";return a},this.points[3]]}),!1);this.options.typeOptions.line=a.options};a.prototype.addBackground=function(){var a=this.initShape(e(this.options.typeOptions.background,{type:"path",points:this.points.slice()}));this.options.typeOptions.background=a.options};a.prototype.translateSide=function(a,b,d){d=Number(d);var c=0===d?3:2;this.translatePoint(a,b,d);this.translatePoint(a,b,c)};a.prototype.translateHeight=function(a){this.translatePoint(0,a,2);this.translatePoint(0,a,3);this.options.typeOptions.height=
this.points[3].y-this.points[0].y};return a}(m);k.prototype.defaultOptions=e(m.prototype.defaultOptions,{typeOptions:{xAxis:0,yAxis:0,background:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0},line:{strokeWidth:1},height:-2,heightControlPoint:{positioner:function(b){var a=n.pointToPixels(b.points[2]);b=n.pointToPixels(b.points[3]);var c=(a.x+b.x)/2;return{x:c-this.graphic.width/2,y:(b.y-a.y)/(b.x-a.x)*(c-a.x)+a.y-this.graphic.height/2}},events:{drag:function(b,a){a.chart.isInsidePlot(b.chartX-a.chart.plotLeft,
b.chartY-a.chart.plotTop,{visiblePlotOnly:!0})&&(a.translateHeight(this.mouseMoveToTranslation(b).y),a.redraw(!1))}}}},controlPointOptions:{events:{drag:function(b,a){a.chart.isInsidePlot(b.chartX-a.chart.plotLeft,b.chartY-a.chart.plotTop,{visiblePlotOnly:!0})&&(b=this.mouseMoveToTranslation(b),a.translateSide(b.x,b.y,this.index),a.redraw(!1))}}}});return d.types.tunnel=k});t(d,"Extensions/Annotations/Types/InfinityLine.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/Types/CrookedLine.js"],
d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,h,m,n){var g=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(b,a)};return function(b,a){function c(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),p=n.merge;n=function(d){function b(a,c){return d.call(this,a,
c)||this}g(b,d);b.edgePoint=function(a,c){return function(f){f=f.annotation;var d=f.points,e=f.options.typeOptions.type;if("horizontalLine"===e||"verticalLine"===e)d=[d[0],new m(f.chart,d[0].target,{x:d[0].x+ +("horizontalLine"===e),y:d[0].y+ +("verticalLine"===e),xAxis:d[0].options.xAxis,yAxis:d[0].options.yAxis})];return b.findEdgePoint(d[a],d[c])}};b.findEdgeCoordinate=function(a,c,b,d){var f="x"===b?"y":"x";return(c[b]-a[b])*(d-a[f])/(c[f]-a[f])+a[b]};b.findEdgePoint=function(a,c){var f=a.series.chart,
d=a.series.xAxis,e=c.series.yAxis,g=m.pointToPixels(a);c=m.pointToPixels(c);var h=c.x-g.x,C=c.y-g.y,k=d.left,p=k+d.width;d=e.top;e=d+e.height;p=0>h?k:p;var n=0>C?d:e;k={x:0===h?g.x:p,y:0===C?g.y:n};0!==h&&0!==C&&(h=b.findEdgeCoordinate(g,c,"y",p),g=b.findEdgeCoordinate(g,c,"x",n),h>=d&&h<=e?(k.x=p,k.y=h):(k.x=g,k.y=n));k.x-=f.plotLeft;k.y-=f.plotTop;a.series.chart.inverted&&(a=k.x,k.x=k.y,k.y=a);return k};b.prototype.addShapes=function(){var a=this.options.typeOptions,c=[this.points[0],b.endEdgePoint];
a.type.match(/line/gi)&&(c[0]=b.startEdgePoint);c=this.initShape(p(a.line,{type:"path",points:c}),!1);a.line=c.options};b.endEdgePoint=b.edgePoint(0,1);b.startEdgePoint=b.edgePoint(1,0);return b}(h);n.prototype.defaultOptions=p(h.prototype.defaultOptions,{});return d.types.infinityLine=n});t(d,"Extensions/Annotations/Types/Fibonacci.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/MockPoint.js"],d["Extensions/Annotations/Types/Tunnel.js"],d["Core/Utilities.js"],d["Core/Color/Palette.js"]],
function(d,h,m,n,k){var g=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function f(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),e=n.merge,b=function(a,c){return function(){var b=this.annotation,d=this.anchor(b.startRetracements[a]).absolutePosition,e=
this.anchor(b.endRetracements[a]).absolutePosition;d=[["M",Math.round(d.x),Math.round(d.y)],["L",Math.round(e.x),Math.round(e.y)]];c&&(e=this.anchor(b.endRetracements[a-1]).absolutePosition,b=this.anchor(b.startRetracements[a-1]).absolutePosition,d.push(["L",Math.round(e.x),Math.round(e.y)],["L",Math.round(b.x),Math.round(b.y)]));return d}};n=function(a){function c(c,b){return a.call(this,c,b)||this}g(c,a);c.prototype.linkPoints=function(){a.prototype.linkPoints.call(this);this.linkRetracementsPoints()};
c.prototype.linkRetracementsPoints=function(){var a=this.points,b=a[0].y-a[3].y,d=a[1].y-a[2].y,e=a[0].x,g=a[1].x;c.levels.forEach(function(c,f){var l=a[0].y-b*c;c=a[1].y-d*c;this.startRetracements=this.startRetracements||[];this.endRetracements=this.endRetracements||[];this.linkRetracementPoint(f,e,l,this.startRetracements);this.linkRetracementPoint(f,g,c,this.endRetracements)},this)};c.prototype.linkRetracementPoint=function(a,c,b,d){var f=d[a],e=this.options.typeOptions;f?(f.options.x=c,f.options.y=
b,f.refresh()):d[a]=new h(this.chart,this,{x:c,y:b,xAxis:e.xAxis,yAxis:e.yAxis})};c.prototype.addShapes=function(){c.levels.forEach(function(a,c){var d=this.options.typeOptions;a=d.backgroundColors;var f=d.lineColor;d=d.lineColors;this.initShape({type:"path",d:b(c),stroke:d[c]||f},!1);0<c&&this.initShape({type:"path",fill:a[c-1],strokeWidth:0,d:b(c,!0)})},this)};c.prototype.addLabels=function(){c.levels.forEach(function(a,c){var b=this.options.typeOptions;a=this.initLabel(e(b.labels[c],{point:function(a){return h.pointToOptions(a.annotation.startRetracements[c])},
text:a.toString()}));b.labels[c]=a.options},this)};c.levels=[0,.236,.382,.5,.618,.786,1];return c}(m);n.prototype.defaultOptions=e(m.prototype.defaultOptions,{typeOptions:{height:2,backgroundColors:"rgba(130, 170, 255, 0.4);rgba(139, 191, 216, 0.4);rgba(150, 216, 192, 0.4);rgba(156, 229, 161, 0.4);rgba(162, 241, 130, 0.4);rgba(169, 255, 101, 0.4)".split(";"),lineColor:k.neutralColor40,lineColors:[],labels:[]},labelOptions:{allowOverlap:!0,align:"right",backgroundColor:"none",borderWidth:0,crop:!1,
overflow:"none",shape:"rect",style:{color:"grey"},verticalAlign:"middle",y:0}});return d.types.fibonacci=n});t(d,"Extensions/Annotations/Types/Pitchfork.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/Types/InfinityLine.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,h,m,n){var g=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&
(a[c]=b[c])};return d(b,a)};return function(b,a){function c(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),p=n.merge;n=function(d){function b(a,c){return d.call(this,a,c)||this}g(b,d);b.outerLineEdgePoint=function(a){return function(c){var d=c.annotation,e=d.points;return b.findEdgePoint(e[a],e[0],new m(d.chart,c,d.midPointOptions()))}};b.findEdgePoint=function(a,c,b){c=Math.atan2(b.plotY-c.plotY,b.plotX-c.plotX);return{x:a.plotX+1E7*Math.cos(c),
y:a.plotY+1E7*Math.sin(c)}};b.middleLineEdgePoint=function(a){var c=a.annotation;return h.findEdgePoint(c.points[0],new m(c.chart,a,c.midPointOptions()))};b.prototype.midPointOptions=function(){var a=this.points;return{x:(a[1].x+a[2].x)/2,y:(a[1].y+a[2].y)/2,xAxis:a[0].series.xAxis,yAxis:a[0].series.yAxis}};b.prototype.addShapes=function(){this.addLines();this.addBackgrounds()};b.prototype.addLines=function(){this.initShape({type:"path",points:[this.points[0],b.middleLineEdgePoint]},!1);this.initShape({type:"path",
points:[this.points[1],b.topLineEdgePoint]},!1);this.initShape({type:"path",points:[this.points[2],b.bottomLineEdgePoint]},!1)};b.prototype.addBackgrounds=function(){var a=this.shapes,c=this.options.typeOptions,b=this.initShape(p(c.innerBackground,{type:"path",points:[function(a){var c=a.annotation;a=c.points;c=c.midPointOptions();return{x:(a[1].x+c.x)/2,y:(a[1].y+c.y)/2,xAxis:c.xAxis,yAxis:c.yAxis}},a[1].points[1],a[2].points[1],function(a){var c=a.annotation;a=c.points;c=c.midPointOptions();return{x:(c.x+
a[2].x)/2,y:(c.y+a[2].y)/2,xAxis:c.xAxis,yAxis:c.yAxis}}]}));a=this.initShape(p(c.outerBackground,{type:"path",points:[this.points[1],a[1].points[1],a[2].points[1],this.points[2]]}));c.innerBackground=b.options;c.outerBackground=a.options};b.topLineEdgePoint=b.outerLineEdgePoint(1);b.bottomLineEdgePoint=b.outerLineEdgePoint(0);return b}(h);n.prototype.defaultOptions=p(h.prototype.defaultOptions,{typeOptions:{innerBackground:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0},outerBackground:{fill:"rgba(156, 229, 161, 0.4)",
strokeWidth:0}}});return d.types.pitchfork=n});t(d,"Extensions/Annotations/Types/VerticalLine.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/MockPoint.js"],d["Core/Utilities.js"]],function(d,h,m){var g=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(b,a)};return function(b,a){function c(){this.constructor=b}d(b,
a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),k=m.merge,p=m.pick;m=function(d){function b(a,c){return d.call(this,a,c)||this}g(b,d);b.connectorFirstPoint=function(a){var c=a.annotation;a=c.chart;var b=a.inverted,d=c.points[0],e=p(d.series.yAxis&&d.series.yAxis.left,0),g=p(d.series.yAxis&&d.series.yAxis.top,0);c=c.options.typeOptions.label.offset;var k=h.pointToPixels(d,!0)[b?"x":"y"];return{x:d.x,xAxis:d.series.xAxis,y:k+c+(b?e-a.plotLeft:g-a.plotTop)}};b.connectorSecondPoint=
function(a){var c=a.annotation;a=c.chart;var b=a.inverted,d=c.options.typeOptions;c=c.points[0];var e=p(c.series.yAxis&&c.series.yAxis.left,0),g=p(c.series.yAxis&&c.series.yAxis.top,0),k=d.yOffset,m=h.pointToPixels(c,!0)[b?"x":"y"];0>d.label.offset&&(k*=-1);return{x:c.x,xAxis:c.series.xAxis,y:m+k+(b?e-a.plotLeft:g-a.plotTop)}};b.prototype.getPointsOptions=function(){return[this.options.typeOptions.point]};b.prototype.addShapes=function(){var a=this.options.typeOptions,c=this.initShape(k(a.connector,
{type:"path",points:[b.connectorFirstPoint,b.connectorSecondPoint]}),!1);a.connector=c.options};b.prototype.addLabels=function(){var a=this.options.typeOptions,c=a.label,b=0,d=c.offset,e=0>c.offset?"bottom":"top",g="center";this.chart.inverted&&(b=c.offset,d=0,e="middle",g=0>c.offset?"right":"left");c=this.initLabel(k(c,{verticalAlign:e,align:g,x:b,y:d}));a.label=c.options};return b}(d);m.prototype.defaultOptions=k(d.prototype.defaultOptions,{typeOptions:{yOffset:10,label:{offset:-40,point:function(d){return d.annotation.points[0]},
allowOverlap:!0,backgroundColor:"none",borderWidth:0,crop:!0,overflow:"none",shape:"rect",text:"{y:.2f}"},connector:{strokeWidth:1,markerEnd:"arrow"}}});return d.types.verticalLine=m});t(d,"Extensions/Annotations/Types/Measure.js",[d["Extensions/Annotations/Annotations.js"],d["Extensions/Annotations/ControlPoint.js"],d["Core/Utilities.js"]],function(d,h,m){var g=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=
c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),k=m.extend,p=m.isNumber,e=m.merge,b=function(a){function c(c,b){return a.call(this,c,b)||this}g(c,a);c.prototype.init=function(a,b,e){d.prototype.init.call(this,a,b,e);this.resizeY=this.resizeX=this.offsetY=this.offsetX=0;c.calculations.init.call(this);this.addValues();this.addShapes()};
c.prototype.setClipAxes=function(){this.clipXAxis=this.chart.xAxis[this.options.typeOptions.xAxis];this.clipYAxis=this.chart.yAxis[this.options.typeOptions.yAxis]};c.prototype.pointsOptions=function(){return this.options.points};c.prototype.shapePointsOptions=function(){var a=this.options.typeOptions,c=a.xAxis;a=a.yAxis;return[{x:this.xAxisMin,y:this.yAxisMin,xAxis:c,yAxis:a},{x:this.xAxisMax,y:this.yAxisMin,xAxis:c,yAxis:a},{x:this.xAxisMax,y:this.yAxisMax,xAxis:c,yAxis:a},{x:this.xAxisMin,y:this.yAxisMax,
xAxis:c,yAxis:a}]};c.prototype.addControlPoints=function(){var a=this.options.typeOptions.selectType;var c=new h(this.chart,this,this.options.controlPointOptions,0);this.controlPoints.push(c);"xy"!==a&&(c=new h(this.chart,this,this.options.controlPointOptions,1),this.controlPoints.push(c))};c.prototype.addValues=function(a){var b=this.options.typeOptions,d=b.label.formatter;c.calculations.recalculate.call(this,a);b.label.enabled&&(0<this.labels.length?this.labels[0].text=d&&d.call(this)||c.calculations.defaultFormatter.call(this):
this.initLabel(k({shape:"rect",backgroundColor:"none",color:"black",borderWidth:0,dashStyle:"Dash",overflow:"allow",align:"left",vertical:"top",crop:!0,point:function(a){a=a.annotation;var c=a.chart,d=c.inverted,f=c.yAxis[b.yAxis],e=c.plotTop,g=c.plotLeft;return{x:(d?e:10)+c.xAxis[b.xAxis].toPixels(a.xAxisMin,!d),y:(d?-g+10:e)+f.toPixels(a.yAxisMin)}},text:d&&d.call(this)||c.calculations.defaultFormatter.call(this)},b.label),void 0))};c.prototype.addShapes=function(){this.addCrosshairs();this.addBackground()};
c.prototype.addBackground=function(){"undefined"!==typeof this.shapePointsOptions()[0].x&&this.initShape(k({type:"path",points:this.shapePointsOptions()},this.options.typeOptions.background),!1)};c.prototype.addCrosshairs=function(){var a=this.chart,c=this.options.typeOptions,b=this.options.typeOptions.point,d=a.xAxis[c.xAxis],g=a.yAxis[c.yAxis],h=a.inverted;a=d.toPixels(this.xAxisMin);d=d.toPixels(this.xAxisMax);var m=g.toPixels(this.yAxisMin),p=g.toPixels(this.yAxisMax),n={point:b,type:"path"};
b=[];g=[];h&&(h=a,a=m,m=h,h=d,d=p,p=h);c.crosshairX.enabled&&(b=[["M",a,m+(p-m)/2],["L",d,m+(p-m)/2]]);c.crosshairY.enabled&&(g=[["M",a+(d-a)/2,m],["L",a+(d-a)/2,p]]);0<this.shapes.length?(this.shapes[0].options.d=b,this.shapes[1].options.d=g):(a=e(n,c.crosshairX),c=e(n,c.crosshairY),this.initShape(k({d:b},a),!1),this.initShape(k({d:g},c),!1))};c.prototype.onDrag=function(a){var c=this.mouseMoveToTranslation(a),b=this.options.typeOptions.selectType;a="y"===b?0:c.x;c="x"===b?0:c.y;this.translate(a,
c);this.offsetX+=a;this.offsetY+=c;this.redraw(!1,!1,!0)};c.prototype.resize=function(a,b,d,e){var f=this.shapes[2];"x"===e?0===d?(f.translatePoint(a,0,0),f.translatePoint(a,b,3)):(f.translatePoint(a,0,1),f.translatePoint(a,b,2)):"y"===e?0===d?(f.translatePoint(0,b,0),f.translatePoint(0,b,1)):(f.translatePoint(0,b,2),f.translatePoint(0,b,3)):(f.translatePoint(a,0,1),f.translatePoint(a,b,2),f.translatePoint(0,b,3));c.calculations.updateStartPoints.call(this,!1,!0,d,a,b);this.options.typeOptions.background.height=
Math.abs(this.startYMax-this.startYMin);this.options.typeOptions.background.width=Math.abs(this.startXMax-this.startXMin)};c.prototype.redraw=function(a,b,d){this.linkPoints();this.graphic||this.render();d&&c.calculations.updateStartPoints.call(this,!0,!1);this.clipRect&&this.clipRect.animate(this.getClipBox());this.addValues(b);this.addCrosshairs();this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);this.controlPoints.forEach(function(a){a.redraw()})};c.prototype.translate=function(a,
c){this.shapes.forEach(function(b){b.translate(a,c)});this.options.typeOptions.point.x=this.startXMin;this.options.typeOptions.point.y=this.startYMin};c.calculations={init:function(){var a=this.options.typeOptions,b=this.chart,d=c.calculations.getPointPos,e=b.inverted,g=b.xAxis[a.xAxis];b=b.yAxis[a.yAxis];var h=a.background,k=e?h.height:h.width;h=e?h.width:h.height;var m=a.selectType,n=e?g.left:b.top;e=e?b.top:g.left;this.startXMin=a.point.x;this.startYMin=a.point.y;p(k)?this.startXMax=this.startXMin+
k:this.startXMax=d(g,this.startXMin,parseFloat(k));p(h)?this.startYMax=this.startYMin-h:this.startYMax=d(b,this.startYMin,parseFloat(h));"x"===m?(this.startYMin=b.toValue(n),this.startYMax=b.toValue(n+b.len)):"y"===m&&(this.startXMin=g.toValue(e),this.startXMax=g.toValue(e+g.len))},recalculate:function(a){var b=c.calculations,d=this.options.typeOptions,f=this.chart.xAxis[d.xAxis];d=this.chart.yAxis[d.yAxis];var e=c.calculations.getPointPos,g=this.offsetX,h=this.offsetY;this.xAxisMin=e(f,this.startXMin,
g);this.xAxisMax=e(f,this.startXMax,g);this.yAxisMin=e(d,this.startYMin,h);this.yAxisMax=e(d,this.startYMax,h);this.min=b.min.call(this);this.max=b.max.call(this);this.average=b.average.call(this);this.bins=b.bins.call(this);a&&this.resize(0,0)},getPointPos:function(a,c,b){return a.toValue(a.toPixels(c)+b)},updateStartPoints:function(a,b,d,e,g){var f=this.options.typeOptions,h=f.selectType,l=this.chart.xAxis[f.xAxis];f=this.chart.yAxis[f.yAxis];var k=c.calculations.getPointPos,v=this.startXMin,u=
this.startXMax,m=this.startYMin,x=this.startYMax,r=this.offsetX,y=this.offsetY;b&&("x"===h?0===d?this.startXMin=k(l,v,e):this.startXMax=k(l,u,e):"y"===h?0===d?this.startYMin=k(f,m,g):this.startYMax=k(f,x,g):(this.startXMax=k(l,u,e),this.startYMax=k(f,x,g)));a&&(this.startXMin=k(l,v,r),this.startXMax=k(l,u,r),this.startYMin=k(f,m,y),this.startYMax=k(f,x,y),this.offsetY=this.offsetX=0)},defaultFormatter:function(){return"Min: "+this.min+"<br>Max: "+this.max+"<br>Average: "+this.average+"<br>Bins: "+
this.bins},getExtremes:function(a,c,b,d){return{xAxisMin:Math.min(c,a),xAxisMax:Math.max(c,a),yAxisMin:Math.min(d,b),yAxisMax:Math.max(d,b)}},min:function(){var a=Infinity,b=this.chart.series,d=c.calculations.getExtremes(this.xAxisMin,this.xAxisMax,this.yAxisMin,this.yAxisMax),e=!1;b.forEach(function(c){c.visible&&"highcharts-navigator-series"!==c.options.id&&c.points.forEach(function(c){!c.isNull&&c.y<a&&c.x>d.xAxisMin&&c.x<=d.xAxisMax&&c.y>d.yAxisMin&&c.y<=d.yAxisMax&&(a=c.y,e=!0)})});e||(a="");
return a},max:function(){var a=-Infinity,b=this.chart.series,d=c.calculations.getExtremes(this.xAxisMin,this.xAxisMax,this.yAxisMin,this.yAxisMax),e=!1;b.forEach(function(c){c.visible&&"highcharts-navigator-series"!==c.options.id&&c.points.forEach(function(c){!c.isNull&&c.y>a&&c.x>d.xAxisMin&&c.x<=d.xAxisMax&&c.y>d.yAxisMin&&c.y<=d.yAxisMax&&(a=c.y,e=!0)})});e||(a="");return a},average:function(){var a="";""!==this.max&&""!==this.min&&(a=(this.max+this.min)/2);return a},bins:function(){var a=0,b=
this.chart.series,d=c.calculations.getExtremes(this.xAxisMin,this.xAxisMax,this.yAxisMin,this.yAxisMax),e=!1;b.forEach(function(c){c.visible&&"highcharts-navigator-series"!==c.options.id&&c.points.forEach(function(c){!c.isNull&&c.x>d.xAxisMin&&c.x<=d.xAxisMax&&c.y>d.yAxisMin&&c.y<=d.yAxisMax&&(a++,e=!0)})});e||(a="");return a}};return c}(d);b.prototype.defaultOptions=e(d.prototype.defaultOptions,{typeOptions:{selectType:"xy",xAxis:0,yAxis:0,background:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0,
stroke:void 0},crosshairX:{enabled:!0,zIndex:6,dashStyle:"Dash",markerEnd:"arrow"},crosshairY:{enabled:!0,zIndex:6,dashStyle:"Dash",markerEnd:"arrow"},label:{enabled:!0,style:{fontSize:"11px",color:"#666666"},formatter:void 0}},controlPointOptions:{positioner:function(a){var c=this.index,d=a.chart,e=a.options,g=e.typeOptions,h=g.selectType;e=e.controlPointOptions;var k=d.inverted,m=d.xAxis[g.xAxis];d=d.yAxis[g.yAxis];g=a.xAxisMax;var p=a.yAxisMax,n=b.calculations.getExtremes(a.xAxisMin,a.xAxisMax,
a.yAxisMin,a.yAxisMax);"x"===h&&(p=(n.yAxisMax-n.yAxisMin)/2,0===c&&(g=a.xAxisMin));"y"===h&&(g=n.xAxisMin+(n.xAxisMax-n.xAxisMin)/2,0===c&&(p=a.yAxisMin));k?(a=d.toPixels(p),c=m.toPixels(g)):(a=m.toPixels(g),c=d.toPixels(p));return{x:a-e.width/2,y:c-e.height/2}},events:{drag:function(a,c){var b=this.mouseMoveToTranslation(a);a=c.options.typeOptions.selectType;var d="y"===a?0:b.x;b="x"===a?0:b.y;c.resize(d,b,this.index,a);c.resizeX+=d;c.resizeY+=b;c.redraw(!1,!0)}}}});return d.types.measure=b});t(d,
"Mixins/Navigation.js",[],function(){return{initUpdate:function(d){d.navigation||(d.navigation={updates:[],update:function(d,g){this.updates.forEach(function(h){h.update.call(h.context,d,g)})}})},addUpdate:function(d,h){h.navigation||this.initUpdate(h);h.navigation.updates.push({update:d,context:h})}}});t(d,"Extensions/Annotations/NavigationBindings.js",[d["Extensions/Annotations/Annotations.js"],d["Core/Chart/Chart.js"],d["Mixins/Navigation.js"],d["Core/FormatUtilities.js"],d["Core/Globals.js"],
d["Core/Options.js"],d["Core/Utilities.js"]],function(d,h,m,n,k,p,e){function b(a){var c=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click;A(!0,a.prototype.defaultOptions.events,{click:function(a){var b=this,d=b.chart.navigationBindings,e=d.activeAnnotation;c&&c.call(b,a);e!==b?(d.deselectAnnotation(),d.activeAnnotation=b,b.setControlPointsVisibility(!0),g(d,"showPopup",{annotation:b,formType:"annotation-toolbar",options:d.annotationToFields(b),onSubmit:function(a){var c=
{};"remove"===a.actionType?(d.activeAnnotation=!1,d.chart.removeAnnotation(b)):(d.fieldsToOptions(a.fields,c),d.deselectAnnotation(),a=c.typeOptions,"measure"===b.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,a.crosshairX.enabled=0!==a.crosshairX.strokeWidth),b.update(c))}})):g(d,"closePopup");a.activeAnnotation=!0}})}var a=n.format;n=p.setOptions;var c=e.addEvent,f=e.attr,g=e.fireEvent,q=e.isArray,w=e.isFunction,t=e.isNumber,C=e.isObject,A=e.merge,z=e.objectEach,D=e.pick,v=k.doc,
u=k.win,E=function(){function b(a,c){this.selectedButton=this.boundClassNames=void 0;this.chart=a;this.options=c;this.eventsToUnbind=[];this.container=v.getElementsByClassName(this.options.bindingsClassName||"")}b.prototype.initEvents=function(){var a=this,b=a.chart,d=a.container,e=a.options;a.boundClassNames={};z(e.bindings||{},function(c){a.boundClassNames[c.className]=c});[].forEach.call(d,function(b){a.eventsToUnbind.push(c(b,"click",function(c){var d=a.getButtonEvents(b,c);d&&-1===d.button.className.indexOf("highcharts-disabled-btn")&&
a.bindingsButtonClick(d.button,d.events,c)}))});z(e.events||{},function(b,d){w(b)&&a.eventsToUnbind.push(c(a,d,b,{passive:!1}))});a.eventsToUnbind.push(c(b.container,"click",function(c){!b.cancelClick&&b.isInsidePlot(c.chartX-b.plotLeft,c.chartY-b.plotTop,{visiblePlotOnly:!0})&&a.bindingsChartClick(this,c)}));a.eventsToUnbind.push(c(b.container,k.isTouchDevice?"touchmove":"mousemove",function(c){a.bindingsContainerMouseMove(this,c)},k.isTouchDevice?{passive:!1}:void 0))};b.prototype.initUpdate=function(){var a=
this;m.addUpdate(function(c){a.update(c)},this.chart)};b.prototype.bindingsButtonClick=function(a,c,b){var d=this.chart;this.selectedButtonElement&&(g(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&d.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));this.selectedButton=c;this.selectedButtonElement=a;g(this,"selectButton",{button:a});c.init&&c.init.call(this,a,b);(c.start||
c.steps)&&d.renderer.boxWrapper.addClass("highcharts-draw-mode")};b.prototype.bindingsChartClick=function(a,c){a=this.chart;var b=this.selectedButton;a=a.renderer.boxWrapper;var d;if(d=this.activeAnnotation&&!c.activeAnnotation&&c.target.parentNode){a:{d=c.target;var e=u.Element.prototype,f=e.matches||e.msMatchesSelector||e.webkitMatchesSelector,r=null;if(e.closest)r=e.closest.call(d,".highcharts-popup");else{do{if(f.call(d,".highcharts-popup"))break a;d=d.parentElement||d.parentNode}while(null!==
d&&1===d.nodeType)}d=r}d=!d}d&&g(this,"closePopup");b&&b.start&&(this.nextEvent?(this.nextEvent(c,this.currentUserDetails),this.steps&&(this.stepIndex++,b.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=b.steps[this.stepIndex]:(g(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),b.end&&b.end.call(this,c,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=b.start.call(this,c))&&b.steps?
(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=b.steps[this.stepIndex]):(g(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,b.end&&b.end.call(this,c,this.currentUserDetails)))};b.prototype.bindingsContainerMouseMove=function(a,c){this.mouseMoveEvent&&this.mouseMoveEvent(c,this.currentUserDetails)};b.prototype.fieldsToOptions=function(a,c){z(a,function(a,b){var d=parseFloat(a),e=b.split("."),
f=c,g=e.length-1;!t(d)||a.match(/px/g)||b.match(/format/g)||(a=d);""!==a&&"undefined"!==a&&e.forEach(function(c,b){var d=D(e[b+1],"");g===b?f[c]=a:(f[c]||(f[c]=d.match(/\d/g)?[]:{}),f=f[c])})});return c};b.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)};b.prototype.annotationToFields=function(c){function d(b,e,f,h){if(f&&b&&-1===u.indexOf(e)&&(0<=(f.indexOf&&f.indexOf(e))||f[e]||!0===f))if(q(b))h[e]=[],
b.forEach(function(a,c){C(a)?(h[e][c]={},z(a,function(a,b){d(a,b,g[e],h[e][c])})):d(a,0,g[e],h[e])});else if(C(b)){var x={};q(h)?(h.push(x),x[e]={},x=x[e]):h[e]=x;z(b,function(a,c){d(a,c,0===e?f:g[e],x)})}else"format"===e?h[e]=[a(b,c.labels[0].points[0]).toString(),"text"]:q(h)?h.push([b,r(b)]):h[e]=[b,r(b)]}var e=c.options,f=b.annotationsEditable,g=f.nestedOptions,r=this.utils.getFieldType,h=D(e.type,e.shapes&&e.shapes[0]&&e.shapes[0].type,e.labels&&e.labels[0]&&e.labels[0].itemType,"label"),u=b.annotationsNonEditable[e.langKey]||
[],x={langKey:e.langKey,type:h};z(e,function(a,c){"typeOptions"===c?(x[c]={},z(e[c],function(a,b){d(a,b,g,x[c],!0)})):d(a,c,f[h],x)});return x};b.prototype.getClickedClassNames=function(a,c){var b=c.target;c=[];for(var d;b&&((d=f(b,"class"))&&(c=c.concat(d.split(" ").map(function(a){return[a,b]}))),b=b.parentNode,b!==a););return c};b.prototype.getButtonEvents=function(a,c){var b=this,d;this.getClickedClassNames(a,c).forEach(function(a){b.boundClassNames[a[0]]&&!d&&(d={events:b.boundClassNames[a[0]],
button:a[1]})});return d};b.prototype.update=function(a){this.options=A(!0,this.options,a);this.removeEvents();this.initEvents()};b.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(a){a()})};b.prototype.destroy=function(){this.removeEvents()};b.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],
outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],
rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]};b.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]};return b}();E.prototype.utils={getFieldType:function(a){return{string:"text",number:"number","boolean":"checkbox"}[typeof a]},updateRectSize:function(a,c){var b=c.chart,d=c.options.typeOptions,e=b.pointer.getCoordinates(a);a=b.navigationBindings.utils.getAssignedAxis(e.xAxis);e=b.navigationBindings.utils.getAssignedAxis(e.yAxis);a&&e&&(a=a.value-d.point.x,
d=d.point.y-e.value,c.update({typeOptions:{background:{width:b.inverted?d:a,height:b.inverted?a:d}}}))},getAssignedAxis:function(a){return a.filter(function(a){var c=a.axis.min,b=a.axis.max,d=D(a.axis.minPointOffset,0);return t(c)&&t(b)&&a.value>=c-d&&a.value<=b+d&&!a.axis.options.isInternal})[0]}};h.prototype.initNavigationBindings=function(){var a=this.options;a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new E(this,a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())};
c(h,"load",function(){this.initNavigationBindings()});c(h,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});c(E,"deselectButton",function(){this.selectedButtonElement=null});c(d,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});k.Annotation&&(b(d),z(d.types,function(a){b(a)}));n({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",
typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",
start:function(a){var c=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(c.xAxis);c=this.utils.getAssignedAxis(c.yAxis);var b=this.chart.options.navigation;if(a&&c)return this.chart.addAnnotation(A({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:a.value,y:c.value,xAxis:a.axis.options.index,yAxis:c.axis.options.index},r:5}]},b.annotationsOptions,b.bindings.circleAnnotation.annotationsOptions))},steps:[function(a,c){var b=c.options.shapes[0].point,d=this.chart.inverted;
if(t(b.xAxis)&&t(b.yAxis)){var e=this.chart.xAxis[b.xAxis].toPixels(b.x);b=this.chart.yAxis[b.yAxis].toPixels(b.y);e=Math.max(Math.sqrt(Math.pow(d?b-a.chartX:e-a.chartX,2)+Math.pow(d?e-a.chartY:b-a.chartY,2)),5)}c.update({shapes:[{r:e}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var c=this.utils.getAssignedAxis(a.xAxis),b=this.utils.getAssignedAxis(a.yAxis);if(c&&b){a=c.value;var d=b.value;c=c.axis.options.index;b=
b.axis.options.index;var e=this.chart.options.navigation;return this.chart.addAnnotation(A({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:c,yAxis:b,x:a,y:d},{xAxis:c,yAxis:b,x:a,y:d},{xAxis:c,yAxis:b,x:a,y:d},{xAxis:c,yAxis:b,x:a,y:d}]}]},e.annotationsOptions,e.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(a,c){var b=c.options.shapes[0].points,d=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(d.xAxis);d=this.utils.getAssignedAxis(d.yAxis);
a&&d&&(a=a.value,d=d.value,b[1].x=a,b[2].x=a,b[2].y=d,b[3].y=d,c.update({shapes:[{points:b}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(c.xAxis);c=this.utils.getAssignedAxis(c.yAxis);var b=this.chart.options.navigation;if(a&&c)return this.chart.addAnnotation(A({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,
x:a.value,y:c.value},overflow:"none",crop:!0}]},b.annotationsOptions,b.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});c(k.Chart,"render",function(){var a=this,c=a.navigationBindings;if(a&&c){var b=!1;a.series.forEach(function(a){!a.options.isInternal&&a.visible&&(b=!0)});z(c.boundClassNames,function(c,d){a.navigationBindings&&a.navigationBindings.container&&a.navigationBindings.container[0]&&(d=a.navigationBindings.container[0].querySelectorAll("."+
d))&&("normal"===c.noDataState?d.forEach(function(a){-1!==a.className.indexOf("highcharts-disabled-btn")&&a.classList.remove("highcharts-disabled-btn")}):b?d.forEach(function(a){-1!==a.className.indexOf("highcharts-disabled-btn")&&a.classList.remove("highcharts-disabled-btn")}):d.forEach(function(a){-1===a.className.indexOf("highcharts-disabled-btn")&&(a.className+=" highcharts-disabled-btn")}))})}});c(E,"closePopup",function(){this.deselectAnnotation()});return E});t(d,"Extensions/Annotations/Popup.js",
[d["Core/Globals.js"],d["Extensions/Annotations/NavigationBindings.js"],d["Core/Options.js"],d["Core/Pointer.js"],d["Core/Utilities.js"]],function(d,h,m,n,k){var g=d.doc,e=d.isFirefox,b=m.getOptions,a=k.addEvent,c=k.createElement,f=k.defined,l=k.fireEvent,q=k.isArray,t=k.isObject,B=k.isString,C=k.objectEach,A=k.pick,z=k.stableSort;m=k.wrap;var D=/\d/g;m(n.prototype,"onContainerMouseDown",function(a,c){var b=c.target&&c.target.className;B(b)&&0<=b.indexOf("highcharts-popup-field")||a.apply(this,Array.prototype.slice.call(arguments,
1))});d.Popup=function(a,c,b){this.init(a,c,b)};d.Popup.prototype={init:function(a,b,d){this.chart=d;this.container=c("div",{className:"highcharts-popup"},null,a);this.lang=this.getLangpack();this.iconsURL=b;this.addCloseBtn()},addCloseBtn:function(){var b=this;var d=c("div",{className:"highcharts-popup-close"},null,this.container);d.style["background-image"]="url("+this.iconsURL+"close.svg)";["click","touchstart"].forEach(function(c){a(d,c,function(){l(b.chart.navigationBindings,"closePopup")})})},
addColsContainer:function(a){var b=c("div",{className:"highcharts-popup-lhs-col"},null,a);a=c("div",{className:"highcharts-popup-rhs-col"},null,a);c("div",{className:"highcharts-popup-rhs-col-wrapper"},null,a);return{lhsCol:b,rhsCol:a}},addInput:function(a,b,d,e){var f=a.split(".");f=f[f.length-1];var h=this.lang;b="highcharts-"+b+"-"+f;b.match(D)||c("label",{htmlFor:b},void 0,d).appendChild(g.createTextNode(h[f]||f));c("input",{name:b,value:e[0],type:e[1],className:"highcharts-popup-field"},void 0,
d).setAttribute("highcharts-data-name",a)},addButton:function(b,d,e,f,h){var k=this,u=this.closePopup,v=this.getFields;var l=c("button",void 0,void 0,b);l.appendChild(g.createTextNode(d));["click","touchstart"].forEach(function(c){a(l,c,function(){u.call(k);return f(v(h,e))})});return l},getFields:function(a,c){var b=a.querySelectorAll("input"),d=a.querySelectorAll("#highcharts-select-series > option:checked")[0];a=a.querySelectorAll("#highcharts-select-volume > option:checked")[0];var e,f;var g=
{actionType:c,linkedTo:d&&d.getAttribute("value"),fields:{}};[].forEach.call(b,function(a){f=a.getAttribute("highcharts-data-name");(e=a.getAttribute("highcharts-data-series-id"))?g.seriesId=a.value:f?g.fields[f]=a.value:g.type=a.value});a&&(g.fields["params.volumeSeriesID"]=a.getAttribute("value"));return g},showPopup:function(){var a=this.container,c=a.querySelectorAll(".highcharts-popup-close")[0];a.innerHTML="";0<=a.className.indexOf("highcharts-annotation-toolbar")&&(a.classList.remove("highcharts-annotation-toolbar"),
a.removeAttribute("style"));a.appendChild(c);a.style.display="block"},closePopup:function(){this.popup.container.style.display="none"},showForm:function(a,c,b,d){this.popup=c.navigationBindings.popup;this.showPopup();"indicators"===a&&this.indicators.addForm.call(this,c,b,d);"annotation-toolbar"===a&&this.annotations.addToolbar.call(this,c,b,d);"annotation-edit"===a&&this.annotations.addForm.call(this,c,b,d);"flag"===a&&this.annotations.addForm.call(this,c,b,d,!0)},getLangpack:function(){return b().lang.navigation.popup},
annotations:{addToolbar:function(a,b,d){var e=this,f=this.lang,h=this.popup.container,k=this.showForm;-1===h.className.indexOf("highcharts-annotation-toolbar")&&(h.className+=" highcharts-annotation-toolbar");h.style.top=a.plotTop+10+"px";c("span",void 0,void 0,h).appendChild(g.createTextNode(A(f[b.langKey]||b.langKey,b.shapes&&b.shapes[0].type)));var l=this.addButton(h,f.removeButton||"remove","remove",d,h);l.className+=" highcharts-annotation-remove-button";l.style["background-image"]="url("+this.iconsURL+
"destroy.svg)";l=this.addButton(h,f.editButton||"edit","edit",function(){k.call(e,"annotation-edit",a,b,d)},h);l.className+=" highcharts-annotation-edit-button";l.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(a,b,d,e){var f=this.popup.container,h=this.lang;var k=c("h2",{className:"highcharts-popup-main-title"},void 0,f);k.appendChild(g.createTextNode(h[b.langKey]||b.langKey||""));k=c("div",{className:"highcharts-popup-lhs-col highcharts-popup-lhs-full"},null,f);var l=
c("div",{className:"highcharts-popup-bottom-row"},null,f);this.annotations.addFormFields.call(this,k,a,"",b,[],!0);this.addButton(l,e?h.addButton||"add":h.saveButton||"save",e?"add":"save",d,f)},addFormFields:function(a,b,d,f,h,k){var l=this,m=this.annotations.addFormFields,u=this.addInput,v=this.lang,n,p;C(f,function(c,e){n=""!==d?d+"."+e:e;t(c)&&(!q(c)||q(c)&&t(c[0])?(p=v[e]||e,p.match(D)||h.push([!0,p,a]),m.call(l,a,b,n,c,h,!1)):h.push([l,n,"annotation",a,c]))});k&&(z(h,function(a){return a[1].match(/format/g)?
-1:1}),e&&h.reverse(),h.forEach(function(a){!0===a[0]?c("span",{className:"highcharts-annotation-title"},void 0,a[2]).appendChild(g.createTextNode(a[1])):u.apply(a[0],a.splice(1))}))}},indicators:{addForm:function(a,c,b){var d=this.indicators,e=this.lang;this.tabs.init.call(this,a);c=this.popup.container.querySelectorAll(".highcharts-tab-item-content");this.addColsContainer(c[0]);d.addIndicatorList.call(this,a,c[0],"add");var f=c[0].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,
e.addButton||"add","add",b,f);this.addColsContainer(c[1]);d.addIndicatorList.call(this,a,c[1],"edit");f=c[1].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.saveButton||"save","edit",b,f);this.addButton(f,e.removeButton||"remove","remove",b,f)},addIndicatorList:function(b,d,e){var f=this,h=d.querySelectorAll(".highcharts-popup-lhs-col")[0];d=d.querySelectorAll(".highcharts-popup-rhs-col")[0];var k="edit"===e,l=k?b.series:b.options.plotOptions,m=this.indicators.addFormFields,u;
var n=c("ul",{className:"highcharts-indicator-list"},null,h);var p=d.querySelectorAll(".highcharts-popup-rhs-col-wrapper")[0];C(l,function(d,e){var h=d.options;if(d.params||h&&h.params){var v=f.indicators.getNameType(d,e),r=v.type;u=c("li",{className:"highcharts-indicator-list"},void 0,n);u.appendChild(g.createTextNode(v.name));["click","touchstart"].forEach(function(e){a(u,e,function(){m.call(f,b,k?d:l[r],v.type,p);k&&d.options&&c("input",{type:"hidden",name:"highcharts-id-"+r,value:d.options.id},
null,p).setAttribute("highcharts-data-series-id",d.options.id)})})}});0<n.childNodes.length&&n.childNodes[0].click()},getNameType:function(a,c){var b=a.options,e=d.seriesTypes;e=e[c]&&e[c].prototype.nameBase||c.toUpperCase();b&&b.type&&(c=a.options.type,e=a.name);return{name:e,type:c}},listAllSeries:function(a,b,d,e,h){a="highcharts-"+b+"-type-"+a;var k=this.lang,l;c("label",{htmlFor:a},null,e).appendChild(g.createTextNode(k[b]||b));var m=c("select",{name:a,className:"highcharts-popup-field"},null,
e);m.setAttribute("id","highcharts-select-"+b);d.series.forEach(function(a){l=a.options;!l.params&&l.id&&"highcharts-navigator-series"!==l.id&&c("option",{value:l.id},null,m).appendChild(g.createTextNode(l.name||l.id))});f(h)&&(m.value=h)},addFormFields:function(a,b,d,e){var f=b.params||b.options.params,h=this.indicators.getNameType;e.innerHTML="";c("h3",{className:"highcharts-indicator-title"},void 0,e).appendChild(g.createTextNode(h(b,d).name));c("input",{type:"hidden",name:"highcharts-type-"+d,
value:d},null,e);this.indicators.listAllSeries.call(this,d,"series",a,e,b.linkedParent&&f.volumeSeriesID);f.volumeSeriesID&&this.indicators.listAllSeries.call(this,d,"volume",a,e,b.linkedParent&&b.linkedParent.options.id);this.indicators.addParamInputs.call(this,a,"params",f,d,e)},addParamInputs:function(a,b,c,d,e){var f=this,g=this.indicators.addParamInputs,h=this.addInput,k;C(c,function(c,l){k=b+"."+l;void 0!==c&&(t(c)?g.call(f,a,k,c,d,e):"params.volumeSeriesID"!==k&&h.call(f,k,d,e,[c,"text"]))})},
getAmount:function(){var a=0;this.series.forEach(function(c){var b=c.options;(c.params||b&&b.params)&&a++});return a}},tabs:{init:function(a){var c=this.tabs;a=this.indicators.getAmount.call(a);var b=c.addMenuItem.call(this,"add");c.addMenuItem.call(this,"edit",a);c.addContentItem.call(this,"add");c.addContentItem.call(this,"edit");c.switchTabs.call(this,a);c.selectTab.call(this,b,0)},addMenuItem:function(a,b){var d=this.popup.container,e="highcharts-tab-item",f=this.lang;0===b&&(e+=" highcharts-tab-disabled");
b=c("span",{className:e},void 0,d);b.appendChild(g.createTextNode(f[a+"Button"]||a));b.setAttribute("highcharts-data-tab-type",a);return b},addContentItem:function(){return c("div",{className:"highcharts-tab-item-content highcharts-no-mousewheel"},null,this.popup.container)},switchTabs:function(c){var b=this,d;this.popup.container.querySelectorAll(".highcharts-tab-item").forEach(function(e,f){d=e.getAttribute("highcharts-data-tab-type");"edit"===d&&0===c||["click","touchstart"].forEach(function(c){a(e,
c,function(){b.tabs.deselectAll.call(b);b.tabs.selectTab.call(b,this,f)})})})},selectTab:function(a,c){var b=this.popup.container.querySelectorAll(".highcharts-tab-item-content");a.className+=" highcharts-tab-item-active";b[c].className+=" highcharts-tab-item-show"},deselectAll:function(){var a=this.popup.container,c=a.querySelectorAll(".highcharts-tab-item");a=a.querySelectorAll(".highcharts-tab-item-content");var b;for(b=0;b<c.length;b++)c[b].classList.remove("highcharts-tab-item-active"),a[b].classList.remove("highcharts-tab-item-show")}}};
a(h,"showPopup",function(a){this.popup||(this.popup=new d.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.1.0/gfx/stock-icons/",this.chart));this.popup.showForm(a.formType,this.chart,a.options,a.onSubmit)});a(h,"closePopup",function(){this.popup&&this.popup.closePopup()})});t(d,"masters/modules/annotations-advanced.src.js",[],function(){})});
//# sourceMappingURL=annotations-advanced.js.map