<?php

include 'oid.php';

$localhost = "localhost";
$int_val = 1;
$float_val = 2;
$str_val = 3;
$ip_val = 4;

$left=0;
$center=1;

$handle = fopen("/etc/snmp/snmpd.conf", "r");
$info = fscanf($handle, "%s\t%s\n");
list ($name, $read_str) = $info;
$info = fscanf($handle, "%s\t%s\n");
list ($name, $write_str) = $info;
fclose($handle);

$remotehost = "localhost";

$write_str = snmpget($localhost, $read_str, $write_str_oid);
$write_str = preg_replace("/(STRING: )/", "", $write_str);
$write_str = trim($write_str, "\"");

$time = 0;
$rssi_max = array(25);
$rssi_avg = array(25);
for($i=0;$i<20;$i++){
    $rssi_avg[$i] = -90;
    $rssi_max[$i] = -90;
}

function drawChart($oid) {
  global $localhost, $write_str, $read_str, $opmode_oid, $txfreq_oid, $rssi_oid,$rssi_max, $rssi_avg, $time, $odu_duplex_oid, $rf_survey_time_oid;
  $j = 0;
  $counter = 0;
  $rssi_total = array(25);
  
  $ret = snmpget($localhost, $read_str, $oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");
 
  $duration = intval(($trimed*60)/30);
  for($i = 0; $i < 20; $i++){
	  $rssi_total[$i] = 0;
  } 
  
  $ret = snmpget($localhost, $read_str, $txfreq_oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $trimed = trim($ret, "\"");
  $freq_orig = $trimed;
  
  $ret = snmpget($localhost, $read_str, $odu_duplex_oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $trimed = trim($ret, "\"");
  $freq_spacing = $trimed;
  
  $set = snmpset($localhost, $write_str, $odu_duplex_oid, "F", 0, 45000000, 0);
  usleep(500000);
  $set = snmpset($localhost, $write_str, $opmode_oid, "i", 0, 45000000, 0);
  usleep(100000);

  while($counter < $duration){
    for($val = 24055; $val <= 24245; $val=$val+10){
	  $set = snmpset($localhost, $write_str, $txfreq_oid, "F", $val, 45000000, 0);
	  usleep(500000);
	  $ret = snmpget($localhost, $read_str, $rssi_oid);
	  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
      $trimed = trim($ret, "\"");
	  if($rssi_max[$j] < $trimed){
		  $rssi_max[$j] = $trimed;
	  }
	  $rssi_total[$j] += $trimed;
	  $j++;
    }
  $counter++;
  $j = 0;
  }
  for($i = 0; $i < 20; $i++){
	  $rssi_avg[$i] = $rssi_total[$i]/$counter;
  }
  
  /*$myfile = "testfile.txt";
  $fh = fopen($myfile,'w') or die("Can't open file");
  for($i = 0; $i < 20; $i++){
        fwrite($fh, $rssi_avg[$i]);
        fwrite($fh, "\n");
        fwrite($fh, $rssi_max[$i]);
        fwrite($fh, "\n");
  }
  fclose($fh);*/
  $set = snmpset($localhost, $write_str, $txfreq_oid, "F", $freq_orig, 45000000, 0);
  usleep(500000);
  $set = snmpset($localhost, $write_str, $odu_duplex_oid, "F", $freq_spacing, 45000000, 0);
  usleep(500000);
  $set = snmpset($localhost, $write_str, $opmode_oid, "i", 1, 45000000, 0);
  usleep(100000);
 
 display_content_table_no_border();
 echo '<tr height="10"></tr>';
 echo '<tr height="5"><td colspan="42" bgcolor="#b8c0c8"></tr>';
  echo '<tr bgcolor=#b8c0c8><td colspan="24"><div id="left-text"><b>RSL(dBm) vs Frequency(MHz)</b></div></td>';
 echo '<td colspan="2" bgcolor=#FFFF66></td><td bgcolor=#b8c0c8 colspan="7"><div id="left-text">Max RSL</div></td>';
 echo '<td colspan="2" bgcolor=#6699FF></td><td bgcolor=#b8c0c8 colspan="7"><div id="left-text">Avg RSL</div></td></tr>';
 echo '<tr height="5"><td colspan="42" bgcolor="#b8c0c8"></tr>';

   display_none_shaded_row();
   echo '<td bgcolor=#b8c0c8><table cellpadding="0" cellspacing="0" border="0" height="400">';
   for($i=0;$i<17;$i++){
      $val = -20 - ($i*5);
      echo '<tr><td valign="center"><font size="2">'. $val .'</tr>';
   }
   echo '</table></td>';

   for($i=0;$i<20;$i++){
    $avg = intval(((100 - abs($rssi_avg[$i]))/5)*4) + 2;
    $max = intval((($rssi_max[$i] - $rssi_avg[$i])/5)*4);
    $res = 68 - ($max + $avg);
    echo '<td bgcolor=#b8c0c8 height="400"><table cellpadding="0" cellspacing="0" border="0" height="400">';
    for($j=0;$j<17;$j++){
     echo '<tr><td bgcolor=#b8c0c8><font color=#fff>-</td></tr>';
    }
    echo '</table></td>';
    echo '<td valign="bottom" bgcolor=#b8c0c8><table cellpadding="0" cellspacing="0" border="0" height="400">';

    for($j=$res;$j>0;$j--){
        echo '<tr><td bgcolor=#b8c0c8 width="7"><font color=#b8c0c8></td></tr>';
     }

     for($j=$max;$j>0;$j--){
        echo '<tr><td bgcolor=#FFFF66><font color=#FFFF66></td></tr>';
     }

     for($j=$avg;$j>0;$j--){
        echo '<tr><td bgcolor=#6699FF><font color=#6699FF></td></tr>';
     }
     echo '</table></td>';
 }
 echo '<td bgcolor=#b8c0c8 height="400"><table cellpadding="0" cellspacing="0" border="0" height="400">';
 for($j=0;$j<17;$j++){
    echo '<tr><td bgcolor=#b8c0c8><font color=#fff>-</td></tr>';
 }
 echo '</table></td>';

 enclose_content_table_row();
 enclose_content_table();
}

?>
