#! /bin/sh
## $1=initial run

## Done temporarily
[ -e S09nfs-common ] && mv S09nfs-common _S09nfs-common
[ -e S17portmap ] && mv S17portmap _S17portmap
[ -e S18samba ] && mv S18samba _S18samba
[ -e S19freeradius ] && mv S19freeradius _S19freeradius


## Need to create directories on the target  
mkdir -p /root/apps
mkdir -p /tftpboot/DC
mkdir -p /tftpboot/bin
mkdir -p /etc/config
mkdir -p /etc/version
mkdir -p /etc/quagga
mkdir -p /etc/snmp
mkdir -p /etc/cron
mkdir -p /mnt/usrcfg
mkdir -p /mnt/syscfg
mkdir -p /var/www/config
mkdir -p /var/www/settings
mkdir -p /var/www/images
mkdir -p /var/www/cgi-bin
mkdir -p /var/www/fonts
mkdir -p /var/www/html
mkdir -p /var/www/libs
mkdir -p /var/www/libs/highcharts-9.1.0
mkdir -p /var/www/services
mkdir -p /var/www/view/atpc
mkdir -p /var/www/view/dashboard
mkdir -p /var/www/v2-2021
mkdir -p /mnt/usrcfg/bank/current
mkdir -p /mnt/usrcfg/bank/previous
mkdir -p /mnt/usrcfg/bank/stable
mkdir -p /mnt/usrcfg/switch_bank/current
mkdir -p /mnt/usrcfg/switch_bank/previous
mkdir -p /mnt/usrcfg/switch_bank/stable
mkdir -p /mnt/usrcfg/switch_config
mkdir -p /mnt/usrcfg/fpga_bank/current
mkdir -p /mnt/usrcfg/fpga_bank/previous
mkdir -p /mnt/usrcfg/fpga_bank/stable
mkdir -p /mnt/usrcfg/fpga_bank/upgrade
#mkdir -p /mnt/mmcblk0p3/log

#if [ $1 -eq 1 ]; then
    cp -n config/default/profile /etc
    cp -n config/default/shadow /etc
    cp -n config/default/passwd /etc
    cp -n config/default/group /etc
    cp -n config/default/snmpd.conf /etc/snmp
    cp -n config/default/snmpd.local.conf /etc/snmp
    cp -n config/default/zebra.conf /etc/quagga
    cp -n config/default/busybox.conf /etc
    cp -n config/lighttpd/lighttpd.conf /etc/lighttpd
    cp -n config/lighttpd/lighttpd.user /etc/lighttpd
    cp -n config/lighttpd/lighttpd.auth /etc/lighttpd
    ln -sf /etc/init.d/upgrade.sh /etc/rc2.d/S02upgrade.sh
    [ -e /sbin/route ] && mv /sbin/route /bin/route


    ##Update all the drivers
#fi

cp drivers/*.ko /root/drivers/

## Copy the initial file to /etc/init.d
cp  config/init.d/trango_startup.sh /etc/init.d/ 
cp  config/init.d/check_switch_status.exp /etc/init.d/
cp  config/init.d/S18sysklogd /etc/rc2.d/
cp  config/init.d/upgrade.sh /etc/init.d/
cp  config/init.d/snmpd /etc/init.d/ 
cp  config/init.d/lighttpd /etc/init.d/
cp  config/init.d/ssh /etc/init.d/ssh
cp  config/init.d/bootmisc.sh /etc/init.d/bootmisc.sh
cp  config/default/dhcpd.conf /etc/dhcpd/
cp  config/default/profile /etc
[ -e config/default/syslog.conf ] && cp config/default/syslog.conf /etc
chmod +x /etc/init.d/check_switch_status.exp
chmod +x /etc/init.d/bootmisc.sh

## INstall 670 scripts to /root/scripts/
[ -e config/scripts ] && cp config/scripts/* /root/scripts/

## Install application process to /usr/sbin
cp apps/lighttpd /root/apps
cp apps/snmpd /root/apps
cp apps/zebra /root/apps
cp apps/php-cgi /root/apps

## Install application process to /usr/bin
[ -e apps/periodlog ] && cp apps/periodlog /usr/bin
cp apps/syslog /usr/bin
cp apps/ntp_time /usr/bin
cp apps/ncftp /usr/bin
cp apps/ncftpget /usr/bin
cp apps/ncftpput /usr/bin

## Create softlink to busybox for certain application
ln -sf /bin/busybox /usr/sbin/crond
ln -sf /bin/busybox /bin/ping
ln -sf /bin/busybox /usr/bin/telnet
ln -sf /bin/busybox /usr/bin/telnetd
ln -sf /bin/busybox /sbin/vconfig
ln -sf /bin/busybox /bin/passwd
ln -sf /sbin/reboot /bin/reboot
chmod 4755 /bin/busybox
chmod 4755 /etc/profile

chown root:root /usr/sbin/zebra
chmod 4755    /usr/sbin/zebra


## Install utility shell script to /usr/bin
cp config/sbin/cli /usr/bin
cp config/sbin/zebra.sh /usr/sbin
cp config/sbin/auto_config /usr/sbin
cp config/sbin/check_file.sh /usr/sbin
cp config/sbin/check_switch_file.sh /usr/sbin
cp config/sbin/check_fpga_file.sh /usr/sbin
cp config/sbin/spiflasher /usr/sbin

## Install script to /sbin
cp config/sbin/mgmt.config /sbin
cp config/sbin/snmpd.start /sbin
cp config/sbin/snmpd.stop /sbin
cp config/sbin/telnetd.start /sbin
cp config/sbin/telnetd.stop /sbin
cp config/sbin/lighttpd.start /sbin
cp config/sbin/lighttpd.stop /sbin
cp config/sbin/loopback_auto.sh /sbin

## Install IBM script to /sbin
cp config/ibm/ixp_vlan_config /sbin
cp config/ibm/ixp_vlan_rem /sbin
cp config/ibm/ixp_vlan_rem_notag /sbin
cp config/ibm/ibm_setup /sbin


## Install application libraries
cp libs/libzebra.so.0.0.0 /usr/lib
cp libs/libnetsnmpagent.so.15.1.2 /usr/lib
cp libs/libnetsnmphelpers.so.15.1.2 /usr/lib
cp libs/libnetsnmpmibs.so.15.1.2 /usr/lib
cp libs/libnetsnmp.so.15.1.2 /usr/lib
cp libs/libnetsnmphelpers.la /usr/lib
cp libs/libnetsnmphelpers.lai /usr/lib
cp libs/libnetsnmpagent.la /usr/lib
cp libs/libnetsnmpagent.lai /usr/lib
cp libs/libnetsnmpmibs.la /usr/lib
cp libs/libnetsnmpmibs.lai /usr/lib
cp libs/libnetsnmp.la /usr/lib
cp libs/libnetsnmp.lai /usr/lib

## Install support libraries for php
cp libs/libpcre.a /usr/lib
cp libs/libpcre.la /usr/lib
cp libs/libpcre.lai /usr/lib
cp libs/libpcre.so.1.2.4 /usr/lib
cp libs/libpcrecpp.a /usr/lib
cp libs/libpcrecpp.la /usr/lib
cp libs/libpcrecpp.lai /usr/lib
cp libs/libpcrecpp.so.0.0.1 /usr/lib
cp libs/libpcreposix.a /usr/lib
cp libs/libpcreposix.la /usr/lib
cp libs/libpcreposix.lai /usr/lib
cp libs/libpcreposix.so.0.0.3 /usr/lib
cp libs/libpng16.a /usr/lib
cp libs/libpng16.so.16.17.0 /usr/lib

## Install module config files for lighttpd
cp libs/*.so /usr/lib/lighttpd

## Install openssl libraries for snmpv3 encryption support
cp libs/libcrypto.so /usr/lib
cp libs/libssl.so /usr/lib

## Create symbolic link for application
ln -sf /usr/lib/libzebra.so.0.0.0 /usr/lib/libzebra.so
ln -sf /usr/lib/libzebra.so.0.0.0 /usr/lib/libzebra.so.0
ln -sf /usr/lib/libnetsnmpagent.so.15.1.2 /usr/lib/libnetsnmpagent.so
ln -sf /usr/lib/libnetsnmpagent.so.15.1.2 /usr/lib/libnetsnmpagent.so.15
ln -sf /usr/lib/libnetsnmphelpers.so.15.1.2 /usr/lib/libnetsnmphelpers.so
ln -sf /usr/lib/libnetsnmphelpers.so.15.1.2 /usr/lib/libnetsnmphelpers.so.15
ln -sf /usr/lib/libnetsnmpmibs.so.15.1.2 /usr/lib/libnetsnmpmibs.so
ln -sf /usr/lib/libnetsnmpmibs.so.15.1.2 /usr/lib/libnetsnmpmibs.so.15
ln -sf /usr/lib/libnetsnmp.so.15.1.2 /usr/lib/libnetsnmp.so
ln -sf /usr/lib/libnetsnmp.so.15.1.2 /usr/lib/libnetsnmp.so.15
ln -sf /usr/lib/libsnmp.so.15.1.2 /usr/lib/libsnmp.so
ln -sf /usr/lib/libsnmp.so.15.1.2 /usr/lib/libsnmp.so.15

## Create symbolic link for supporting libraries
ln -sf /usr/lib/libpcre.so.1.2.4 /usr/lib/libpcre.so
ln -sf /usr/lib/libpcre.so.1.2.4 /usr/lib/libpcre.so.1
ln -sf /usr/lib/libpcreposix.so.0.0.3 /usr/lib/libpcreposix.so
ln -sf /usr/lib/libpcreposix.so.0.0.3 /usr/lib/libpcreposix.so.0
ln -sf /usr/lib/libpcrecpp.so.0.0.1 /usr/lib/libpcrecpp.so
ln -sf /usr/lib/libpcrecpp.so.0.0.1 /usr/lib/libpcrecpp.so.0
ln -sf /usr/lib/libpng16.so.16.17.0 /usr/lib/libpng16.so
ln -sf /usr/lib/libpng16.so.16.17.0 /usr/lib/libpng16.so.16


## Create soft link for busybox for future upgrade
#rm -rf /usr/sbin/busybox
#cp apps/busybox /usr/sbin/busybox 

## Install configuration files
cp config/xinetd/telnet_enable /etc
cp config/xinetd/telnet_disable /etc
cp config/default/sys_fw.ver /etc/version/
cp config/default/sys_os.ver /etc/version/

## Install crond job
## remove old files
# 1. Remove check_eth.sh from /etc/cron.daily if exists
if [ -f /etc/cron.daily/check_eth.sh ]; then
    rm -f /etc/cron.daily/check_eth.sh
fi

# 2. Remove sysklogd from /etc/cron.weekly if exists
if [ -f /etc/cron.weekly/sysklogd ]; then
    rm -f /etc/cron.weekly/sysklogd
fi

# 3. Remove sysklogd from /etc/cron.daily if exists
if [ -f /etc/cron.daily/sysklogd ]; then
    rm -f /etc/cron.daily/sysklogd
fi

# 4. Remove logsize.sh from /etc/cron if exists (assuming /etc/cron/logsize.sh)
if [ -f /etc/cron/logsize.sh ]; then
    rm -f /etc/cron/logsize.sh
fi

# 5. Remove check_eth.sh from /etc/cron.hourly if exists
if [ -f /etc/cron.hourly/check_eth.sh ]; then
    rm -f /etc/cron.hourly/check_eth.sh
fi

# 6. Remove check_ip.sh from /etc/cron.hourly if exists
if [ -f /etc/cron.hourly/check_ip.sh ]; then
    rm -f /etc/cron.hourly/check_ip.sh
fi

[ -e config/cron/logsize.sh ] &&  cp config/cron/logsize.sh /etc/cron.d/
[ -e config/cron/free.sh ] &&  cp config/cron/free.sh /etc/cron.d/
[ -e config/cron/check_ip.sh ] &&  cp config/cron/check_ip.sh /etc/cron.d/
[ -e config/cron/sysklogd ] &&  cp config/cron/sysklogd /etc/logrotate.d/sysklogd
cp config/cron/crontab /etc/

## Install default configuration file
cp config/default/zebra.conf /etc/config/
cp config/default/snmpd.conf /etc/config/
cp config/default/snmpd_v2.conf /etc/config/
cp config/default/snmpd_v3.conf /etc/config/
cp config/default/snmpd.local.conf /etc/config/
cp config/default/hostname /etc/config/
cp config/default/passwd /etc/config/
cp config/default/shadow /etc/config/
cp config/default/group /etc/config/
cp config/default/profile /etc/config/
cp config/default/vsftpd.conf /etc/
cp config/default/switch_default_config_v1.txt /mnt/usrcfg/switch_config/
cp config/default/switch_default_config_v2.txt /mnt/usrcfg/switch_config/
cp config/lighttpd/lighttpd.conf /etc/config/
cp config/lighttpd/lighttpd.user /etc/config/
cp config/lighttpd/lighttpd.auth /etc/config/
cp config/lighttpd/lighttpd.pem /etc/config/
cp config/lighttpd/php.ini /etc/

#if [ -f /mnt/usrcfg/lighttpd.auth ]; then
#	echo 'Retaining GUI config mode password'
#else
#	cp config/lighttpd/lighttpd.auth /etc/lighttpd/
#fi

## Copy all the modem binaries
cp config/binary/bcm85650.fw /tftpboot
cp config/binary/bcm85670.fw /tftpboot
cp config/binary/bcm85650boot.fw /tftpboot
cp config/binary/bcm85670boot.fw /tftpboot
cp config/binary/tsce_ucode.bin /tftpboot
cp config/binary/*.dc /tftpboot/DC
cp config/binary/*.bin /tftpboot/bin

## Need to remove certain file
rm -rf /etc/motd
rm -rf /etc/motd.tail
rm -rf /home/admin/*   #to remove local environment variable

## Copying php files
cp -rf apps/php/wwwroot/* /var/www/
##cp apps/php/*.php /var/www/
##cp apps/php/*.js /var/www/
##cp apps/php/*.css /var/www/
##cp apps/php/settings/*.php /var/www/settings/
##cp apps/php/settings/*.js /var/www/settings/
##cp apps/php/settings/*.css /var/www/settings/
##cp apps/php/css/* /var/www/view/css/
##cp apps/php/fonts/* /var/www/view/fonts/
##cp apps/php/html/* /var/www/view/html/
##cp apps/php/services/* /var/www/view/services/
##cp apps/php/v2-2021/* /var/www/view/v2-2021/
##cp apps/php/view/atpc/* /var/www/view/atpc
##cp apps/php/view/dashboard/* /var/www/view/dashboard
##cp apps/php/images/*.* /var/www/images/
[ -e apps/php/libs/highcharts-9.1.0 ] && cp -rf apps/php/libs/highcharts-9.1.0/* /var/www/view/libs/highcharts-9.1.0

## Copying cgi scripts to cgi-bin folder
#cp debug/mbx.cgi /var/www/cgi-bin
cp debug/localstat.cgi /var/www/cgi-bin
cp debug/rflink.cgi /var/www/cgi-bin
cp debug/manufacturing.cgi /var/www/cgi-bin
cp debug/ipc_init.cgi /var/www/cgi-bin
chmod 755 /var/www/cgi-bin/*.cgi

## Copy the debug standalone program
cp debug/* /root/dbg/

## update permission on certain file
chmod u=rws,g=rx,o=rx /bin/kill
chmod u=rws,g=rx,o=rx /bin/rm
chmod u=rws,g=rx,o=rx /bin/reboot
chmod u=rws,g=rx,o=rx /usr/bin/cli
[ -e /usr/sbin/busybox_new ] && chmod u=rws,g=rx,o=rx /usr/sbin/busybox_new

#ftp configuration
# Check if the user exists
if grep -q "^ftpuser:" /etc/passwd; then
    echo "User 'ftpuser' already exists."
else
    # Create the user without a home directory
    useradd -M -p $(openssl passwd -1 FQf_23Rtqe) ftpuser
fi

# Check if /home/ftpuser exists
if [ -e "/home/ftpuser" ]; then
    if [ -d "/home/ftpuser" ]; then
        echo "/home/ftpuser already exists as a directory."
    elif [ -f "/home/ftpuser" ]; then
        # Convert the file to a directory
        echo "/home/ftpuser exists as a file. Converting it to a directory."
        rm /home/ftpuser
        mkdir /home/ftpuser
    fi
else
    # Create the home directory
    mkdir /home/ftpuser
fi

chmod 755 /home/ftpuser
# Set the password to be permanent (non-expiring)
chage -m 0 -M -1 -I -1 -E -1 ftpuser

