#!/bin/sh

var=`cat /etc/snmp/snmpd.conf`

count=1;

for input in $var;
do
   if [ $count -eq 2 ]
   then
     READ=$input;
   fi
   if [ $count -eq 4 ]
   then
     WRITE=$input;
   fi
   count=`expr $count + 1`;
done

DUPLEX=`snmpget -v 2c -Ovq -c $READ localhost .1.3.6.1.4.1.5454.1.80.3.1.3.1.0 | busybox awk '{print $1}'`;

snmpset -v 2c -Ovq -c $WRITE localhost .1.3.6.1.4.1.5454.1.80.3.1.3.1.0 F 0 > /tmp/tmp.txt;

echo "   	LINK       RSSI		MSE		BER";

i=1

while [ $i -le $1 ]
do

RSSI=`snmpget -v 2c -Ovq -c $READ localhost .1.3.6.1.4.1.5454.1.80.3.14.3.0 | busybox awk '{print $1}'`;
MSE=`snmpget -v 2c -Ovq -c $READ localhost .1.3.6.1.4.1.5454.1.80.2.4.2.1.0 | busybox awk '{print $1}'`;
LINK=`snmpget -v 2c -Ovq -c $READ localhost .1.3.6.1.4.1.5454.1.80.2.5.1.0 | busybox awk '{print $1}'`;
BER=`snmpget -v 2c -Ovq -c $READ localhost .1.3.6.1.4.1.5454.1.80.2.4.1.2.0 | busybox awk '{print $1}'`;
echo "$i>"  $'\t' $LINK  $'\t'  $RSSI	$'\t' 	$MSE	$'\t' $BER
usleep 500;
i=`expr $i + 1`;
done

snmpset -v 2c -Ovq -c $WRITE localhost .1.3.6.1.4.1.5454.1.80.3.1.3.1.0 F $DUPLEX > /tmp/tmp.txt;

rm /tmp/tmp.txt

