<?php

class CustomUI
{

    public static function hackDisplayRFLinkCGIForLinkPosition($in)
    {
        $out   = explode('</br>', $in);
        $index = count($out) - 4;
        if (intval($out[$index]) === 1) {
            $out[$index] = 'Remote';
        } else {
            $out[$index] = 'Local';
        }

        return implode('<br>', $out);
    }

    public static function formatModemPolarization($in)
    {
        $in = intval($in);
        if ($in == 1) {
            return 'H';
        }

        return 'V';
    }
    public static function formatModemPolarizationAir($in)
    {
        $in = intval($in);
        $result = '-';
         // air  { "Vertical",  "Horizontal", "Vertical-OMC", "Horizontal-OMC", "Warning-OMC not detected" };
        if ($in == 1 || $in == 3) {
            $result ='H';
        }
        else if ($in == 0 || $in == 2) {
            $result ='V';
        }

        return $result;
    }
		public static function formatModemPolarizationForAll($in)
		{
			$in = intval($in);
			if (CustomHardware::isNitroModel()) {
				if ($in == 1)
					return 'Horizontal';
				else
					return 'Vertical';
			}
			else{ // air
				if ($in == 1 || $in == 3)
					return 'Horizontal';
				else
					return 'Vertical';
			}
		}
    public static function formatOMC($in)
    {
        $in = intval($in);
        // air  { "Vertical",  "Horizontal", "Vertical-OMC", "Horizontal-OMC", "Warning-OMC not detected" };

        if ($in == 2 || $in == 3) {
            return 'DETECTED';
        }
        else {
            return 'NOT DETECTED';
        }
    }

    public static function formatPortSpeed($in)
    {
        $in = intval($in);
        if ($in >= 1000) {
            return number_format($in / 1000, 0).' Gbps';
        }

        return $in.' Mbps';
    }

    public static function formatFrequency($in)
    {
        $in = intval($in);
        if ($in >= 1000) {
            return number_format($in / 1000, 3).' GHz';
        }

        return $in.' MHz';
    }

    public static function getChartLiveRSSIAndMSE()
    {
        $number_of_channels = CustomCapabilities::getNumberOfChannels();
        $html               = '';
        $html               .= '<tr><td colspan="4"><div id="js-highcharts-container-live-RSSIMSE"></div>';
        $html               .= '
<script>
var urlServiceLiveRSSIMSE = window.location.origin + \'/services/charts.live_rssimse.php\';
var pollingLiveRSSIMSEInSeconds = 5;
var chartLiveRSSIMSE;
var dataLiveRSSIMSE = [];

function createChartLiveRSSIMSE() {
  return Highcharts.chart(\'js-highcharts-container-live-RSSIMSE\', {
    chart: {
      type: \'spline\'
    },
//    xAxis: {
//        type: \'datetime\',
//        title: {
//            text: \'Time\',
//        }
//    },
    yAxis: {
        minPadding: 0.2,
        maxPadding: 0.2,
        title: {
            text: \'RSSI(dBm) / MSE(dB)\',
            margin: 80
        }
    },
    title: {
      text: \'Live RSSI/MSE\'
    },';
        if ($number_of_channels > 1) {
            $html .= 'series: [{ 
                          name: \'RSSI1\',
                          color: \'#0b0863\'
                        },{ 
                          name: \'MSE1\',
                          color: \'#3796de\'
                        },{
                          name: \'RSSI2\',
                          color: \'#ffa052\'
                        },{
                          name: \'MSE2\',
                          color: \'#d9e314\'
                        }],';
        } else {
            $html .= 'series: [{ 
                          name: \'RSSI\',
                          color: \'#0b0863\'
                        },{
                          name: \'MSE\',
                          color: \'#ffa052\'
                        }],';
        }
        $html .= 'data: {
      csvURL: urlServiceLiveRSSIMSE,
      enablePolling: true,
      dataRefreshRate: pollingLiveRSSIMSEInSeconds,
      beforeParse: function (csv) {
          return CSVInjectLimitEntriesLiveRSSIMSE(csv, 24);
        }
    }
  });
}

function CSVInjectLimitEntriesLiveRSSIMSE(originalCSV, limit) {
    if (dataLiveRSSIMSE.length == 0) {
        let aux = originalCSV.trim().split("\r\n");
        dataLiveRSSIMSE = [];
        dataLiveRSSIMSE.push(aux[1]);
        return originalCSV;
    }
    let tmp = originalCSV.trim().split("\r\n");
    let header = tmp[0];
    
    // Remove header if more than an element
    if (dataLiveRSSIMSE.length > 1) {
        dataLiveRSSIMSE.shift();
    }
    
    // Too many items? Remove the oldest
    dataLiveRSSIMSE.push(tmp[1]);
    if (dataLiveRSSIMSE.length > limit) {
        dataLiveRSSIMSE.shift();
    }
    
    // Re-attach header
    dataLiveRSSIMSE.unshift(header);
    return dataLiveRSSIMSE.join("\r\n");
}

// Create the chart
chartLiveRSSIMSE = createChartLiveRSSIMSE();
</script>
        ';
        $html .= '</td></tr>';

        return $html;
    }

    public static function getChartLiveTraffic()
    {
        $html = '';
        $html .= '<tr><td colspan="4"><div id="js-highcharts-container-live-traffic"></div>';
        $html .= '
<script>
var urlServiceLiveTraffic = window.location.origin + \'/services/charts.live_traffic.php\';
var pollingLiveTrafficInSeconds = 5;
var chartLiveTraffic;
var dataLiveTraffic = [];

function createChartLiveTraffic() {
  return Highcharts.chart(\'js-highcharts-container-live-traffic\', {
    chart: {
      type: \'spline\'
    },
//    xAxis: {
//        type: \'datetime\',
//        title: {
//            text: \'Time\',
//        }
//    },
    yAxis: {
        minPadding: 0.2,
        maxPadding: 0.2,
        title: {
            text: \'Port Rate (Mbps)\',
            margin: 80
        }
    },
    title: {
      text: \'Live Traffic\'
    },
    series: [{ 
      name: \'IN\',
      color: \'#00c735\'
    },{
      name: \'OUT\',
      color: \'#948494\'
    }],
    data: {
      csvURL: urlServiceLiveTraffic,
      enablePolling: true,
      dataRefreshRate: pollingLiveTrafficInSeconds,
      beforeParse: function (csv) {
          return CSVInjectLimitEntriesLiveTraffic(csv, 24);
        }
    }
  });
}

function CSVInjectLimitEntriesLiveTraffic(originalCSV, limit) {
    if (dataLiveTraffic.length == 0) {
        let aux = originalCSV.trim().split("\r\n");
        dataLiveTraffic = [];
        dataLiveTraffic.push(aux[1]);
        return originalCSV;
    }
    let tmp = originalCSV.trim().split("\r\n");
    let header = tmp[0];
    
    // Remove header if more than an element
    if (dataLiveTraffic.length > 1) {
        dataLiveTraffic.shift();
    }
    
    // Too many items? Remove the oldest
    dataLiveTraffic.push(tmp[1]);
    if (dataLiveTraffic.length > limit) {
        dataLiveTraffic.shift();
    }
    
    // Re-attach header
    dataLiveTraffic.unshift(header);
    return dataLiveTraffic.join("\r\n");
}

// Create the chart
chartLiveTraffic = createChartLiveTraffic();
</script>
        ';
        $html .= '</td></tr>';

        return $html;
    }

    public static function getIncludeHighChartsLibraryHTML()
    {
        $html = '';
//        $html .= '<link href="dropdown.css" rel="stylesheet" type="text/css">';
        $html .= '<script src="/libs/highcharts-9.1.0/highcharts.js"></script>';
        $html .= '<script src="/libs/highcharts-9.1.0/modules/data.js"></script>';
        $html .= '<script src="/libs/highcharts-9.1.0/modules/exporting.js"></script>';
        $html .= '<script src="/libs/highcharts-9.1.0/modules/export-data.js"></script>';

        return $html;
    }
}