<?php

class OID_Mappings
{
    // Misc
    public static $system_config = '.1.3.6.1.4.1.5454.1.90.1.11.0';
    public static $system_downtilt = '.1.3.6.1.4.1.5454.1.90.1.19.1.0';

    // V/A/W Currents, voltages, power consumption
    public static $voltage_48 = '.1.3.6.1.4.1.5454.1.90.1.23.1.0';
    public static $current_system = '.1.3.6.1.4.1.5454.1.90.1.24.1.0';
    public static $current_rf1 = '.1.3.6.1.4.1.5454.1.90.4.9.2.0';
    public static $current_rf2 = '.1.3.6.1.4.1.5454.1.90.5.9.2.0';

    // ATPC
    public static $atpc_rf1_enabled = '.1.3.6.1.4.1.5454.1.90.4.7.1.0';
    public static $atpc_rf1_MaxPower_QPSK = '.1.3.6.1.4.1.5454.1.90.4.7.2.1.0';
    public static $atpc_rf1_MaxPower_16Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.2.0';
    public static $atpc_rf1_MaxPower_32Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.3.0';
    public static $atpc_rf1_MaxPower_64Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.4.0';
    public static $atpc_rf1_MaxPower_128Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.5.0';
    public static $atpc_rf1_MaxPower_256Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.6.0';
    public static $atpc_rf1_MaxPower_512Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.7.0';
    public static $atpc_rf1_MaxPower_1024Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.8.0';
    public static $atpc_rf1_MaxPower_2048Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.9.0';
    public static $atpc_rf1_MaxPower_4096Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.10.0';
    public static $atpc_rf1_MaxPower_8192Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.11.0';
    public static $atpc_rf1_MaxPower_16384Q = '.1.3.6.1.4.1.5454.1.90.4.7.2.12.0';
    public static $atpc_rf1_Target_RSSI = '.1.3.6.1.4.1.5454.1.90.4.8.0';
    
    public static $atpc_rf2_enabled = '.1.3.6.1.4.1.5454.1.90.5.7.1.0';
    public static $atpc_rf2_MaxPower_QPSK = '.1.3.6.1.4.1.5454.1.90.5.7.2.1.0';
    public static $atpc_rf2_MaxPower_16Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.2.0';
    public static $atpc_rf2_MaxPower_32Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.3.0';
    public static $atpc_rf2_MaxPower_64Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.4.0';
    public static $atpc_rf2_MaxPower_128Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.5.0';
    public static $atpc_rf2_MaxPower_256Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.6.0';
    public static $atpc_rf2_MaxPower_512Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.7.0';
    public static $atpc_rf2_MaxPower_1024Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.8.0';
    public static $atpc_rf2_MaxPower_2048Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.9.0';
    public static $atpc_rf2_MaxPower_4096Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.10.0';
    public static $atpc_rf2_MaxPower_8192Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.11.0';
    public static $atpc_rf2_MaxPower_16384Q = '.1.3.6.1.4.1.5454.1.90.5.7.2.12.0';
    public static $atpc_rf2_Target_RSSI = '.1.3.6.1.4.1.5454.1.90.5.8.0';

    // ODU 1/2
    public static $odu1_model = ".1.3.6.1.4.1.5454.1.90.1.3.2.1.0";
    public static $odu2_model = ".1.3.6.1.4.1.5454.1.90.1.3.2.2.0";

    public static $odu1_txfreq = ".1.3.6.1.4.1.5454.1.90.4.1.1.0";
    public static $odu1_rxfreq = ".1.3.6.1.4.1.5454.1.90.4.1.2.0";
    public static $odu1_duplex_oid = ".1.3.6.1.4.1.5454.1.90.4.1.3.0";
    public static $odu1_txfreq_high_low_oid = ".1.3.6.1.4.1.5454.1.90.4.1.6.0";
    public static $odu2_txfreq = ".1.3.6.1.4.1.5454.1.90.5.1.1.0";
    public static $odu2_rxfreq = ".1.3.6.1.4.1.5454.1.90.5.1.2.0";
   public static $odu2_duplex_oid = ".1.3.6.1.4.1.5454.1.90.5.1.3.0";
   public static $odu2_txfreq_high_low_oid = ".1.3.6.1.4.1.5454.1.90.5.1.6.0";

    public static $odu1_txpower = ".1.3.6.1.4.1.5454.1.90.4.4.1.0";
    public static $odu2_txpower = ".1.3.6.1.4.1.5454.1.90.5.4.1.0";
  
    public static $odu1_power_min = ".1.3.6.1.4.1.5454.1.90.4.4.2.0";
    public static $odu2_power_min = ".1.3.6.1.4.1.5454.1.90.5.4.2.0";
    public static $odu1_power_max = ".1.3.6.1.4.1.5454.1.90.4.4.3.0";
    public static $odu2_power_max = ".1.3.6.1.4.1.5454.1.90.5.4.3.0";
    

    public static $odu1_rssi = ".1.3.6.1.4.1.5454.1.90.4.10.0";
    public static $odu2_rssi = ".1.3.6.1.4.1.5454.1.90.5.10.0";

    public static $odu1_is_powered = ".1.3.6.1.4.1.5454.1.90.4.2.0";
    public static $odu2_is_powered = ".1.3.6.1.4.1.5454.1.90.5.2.0";

    public static $odu1_rf_mode = ".1.3.6.1.4.1.5454.1.90.4.3.0"; // rf1Opmode	Integer	RW	0(Off), 1(On)	0(Off)
    public static $odu2_rf_mode = ".1.3.6.1.4.1.5454.1.90.5.3.0"; // rf2Opmode	Integer	RW	0(Off), 1(On)	0(Off)

    public static $odu1_ant_pol_oid = ".1.3.6.1.4.1.5454.1.90.4.1.7.0"; // CliHV[5]  = { "Vertical",  "Horizontal", "Vertical-OMC", "Horizontal-OMC", "Warning-OMC not detected" };
    public static $odu2_ant_pol_oid = ".1.3.6.1.4.1.5454.1.90.5.1.7.0"; // CliHV[5]   = { "Vertical",  "Horizontal", "Vertical-OMC", "Horizontal-OMC", "Warning-OMC not detected" };

    // RF Combined
    public static $rf_in_octet_oid = ".1.3.6.1.4.1.5454.1.90.4.12.1.0";
    public static $rf_out_octet_oid = ".1.3.6.1.4.1.5454.1.90.4.13.1.0";
    public static $rf_in_pkt_oid = ".1.3.6.1.4.1.5454.1.90.4.12.2.0";
    public static $rf_out_pkt_oid = ".1.3.6.1.4.1.5454.1.90.4.13.2.0";
    public static $rf_in_port_rate_oid = ".1.3.6.1.4.1.5454.1.90.4.12.4.0";
    public static $rf_out_port_rate_oid = ".1.3.6.1.4.1.5454.1.90.4.13.3.0";
    public static $rf_in_port_util_oid = ".1.3.6.1.4.1.5454.1.90.4.12.5.0";
    public static $rf_out_port_util_oid = ".1.3.6.1.4.1.5454.1.90.4.13.4.0";
    public static $rf_in_drop_packets = ".1.3.6.1.4.1.5454.1.90.4.12.3.0";

    // Remote 1/2
    public static $remote1_lock_status = ".1.3.6.1.4.1.5454.1.90.1.40.1.1.0";
    public static $remote2_lock_status = ".1.3.6.1.4.1.5454.1.90.1.40.1.2.0";
    public static $remote1_rssi = ".1.3.6.1.4.1.5454.1.90.1.40.3.1.0";
    public static $remote2_rssi = ".1.3.6.1.4.1.5454.1.90.1.40.3.2.0";
    public static $remote1_mse = ".1.3.6.1.4.1.5454.1.90.1.40.4.1.0";
    public static $remote2_mse = ".1.3.6.1.4.1.5454.1.90.1.40.4.2.0";
    public static $remote1_rx = ".1.3.6.1.4.1.5454.1.90.1.40.5.1.0";
    //                           .1.3.6.1.4.1.5454.1.40.5.2.0
    public static $remote2_rx = ".1.3.6.1.4.1.5454.1.90.1.40.5.2.0";

    // Modem 1/2
    public static $modem1_lock_status = ".1.3.6.1.4.1.5454.1.90.2.8.1.0"; // modem1LockStatus, 0(No Lock), 1(Lock)
    public static $modem2_lock_status = ".1.3.6.1.4.1.5454.1.90.3.8.1.0"; // modem2LockStatus, 0(No Lock), 1(Lock)
    public static $modem1_mse = ".1.3.6.1.4.1.5454.1.90.2.6.0"; // modem1MSE, float
    public static $modem2_mse = ".1.3.6.1.4.1.5454.1.90.3.6.0"; // modem2MSE, float
    public static $modem1_ber_text = ".1.3.6.1.4.1.5454.1.90.2.5.0";
    public static $modem2_ber_text = ".1.3.6.1.4.1.5454.1.90.3.5.0";
    public static $modem1_freq_hi_low = ".1.3.6.1.4.1.5454.1.90.4.1.6.0";
    public static $modem1_tx_freq_min = ".1.3.6.1.4.1.5454.1.90.4.1.5.0";
    public static $modem1_tx_freq_max = ".1.3.6.1.4.1.5454.1.90.4.1.4.0";
    public static $modem2_freq_hi_low = ".1.3.6.1.4.1.5454.1.90.5.1.6.0";
    public static $modem2_tx_freq_min = ".1.3.6.1.4.1.5454.1.90.5.1.5.0";
    public static $modem2_tx_freq_max = ".1.3.6.1.4.1.5454.1.90.5.1.4.0";
    public static $modem1_rx_freq_min = ".1.3.6.1.4.1.5454.1.90.4.1.9.0";
    public static $modem1_rx_freq_max = ".1.3.6.1.4.1.5454.1.90.4.1.8.0";
  
  public static $modem2_rx_freq_min = ".1.3.6.1.4.1.5454.1.90.5.1.9.0";
  public static $modem2_rx_freq_max = ".1.3.6.1.4.1.5454.1.90.5.1.8.0";
    public static $rf1_modulation_min = ".1.3.6.1.4.1.5454.1.90.4.5.2.0";
    public static $rf1_modulation_max = ".1.3.6.1.4.1.5454.1.90.4.5.3.0";
    public static $rf1_channel_bandwidth = ".1.3.6.1.4.1.5454.1.90.4.5.1.0";
    public static $modem1_ACMRx_profile = ".1.3.6.1.4.1.5454.1.90.2.4.2.0";
    public static $modem2_ACMRx_profile = ".1.3.6.1.4.1.5454.1.90.3.4.2.0";
    public static $rf1_odu_temp = ".1.3.6.1.4.1.5454.1.90.4.9.1.0";
    public static $rf2_odu_temp = ".1.3.6.1.4.1.5454.1.90.5.9.1.0";
    public static $rf1_link_history = ".1.3.6.1.4.1.5454.1.90.1.14.1.0";
    public static $rf2_link_history = ".1.3.6.1.4.1.5454.1.90.1.14.2.0";
    public static $rf1_ldpc_stress_decoder = ".1.3.6.1.4.1.5454.1.90.2.8.5.0";
    public static $rf2_ldpc_stress_decoder = ".1.3.6.1.4.1.5454.1.90.3.8.5.0";
    public static $modem1_XPD = ".1.3.6.1.4.1.5454.1.90.2.10.4.0";
    public static $modem2_XPD = ".1.3.6.1.4.1.5454.1.90.3.10.4.0";
    public static $modem1_RS_out_total_err_bytes = ".1.3.6.1.4.1.5454.1.90.2.11.3.0";
    public static $modem2_RS_out_total_err_bytes = ".1.3.6.1.4.1.5454.1.90.3.11.3.0";
    public static $modem1_FEC_LDPC_uncorrected_blocks = ".1.3.6.1.4.1.5454.1.90.2.11.4.0";
    public static $modem1_RSUncorrectedBlockCounter = ".1.3.6.1.4.1.5454.1.90.2.11.5.0";
    public static $modem1_FEC_RT_uncorrectedBlockCounter = ".1.3.6.1.4.1.5454.1.90.2.11.6.0";
    public static $modem2_FEC_LDPC_uncorrected_blocks = ".1.3.6.1.4.1.5454.1.90.3.11.4.0";
    public static $modem2_RSUncorrectedBlockCounter = ".1.3.6.1.4.1.5454.1.90.3.11.5.0";
    public static $modem2_FEC_RT_uncorrectedBlockCounter = ".1.3.6.1.4.1.5454.1.90.3.11.6.0";
    public static $modem1_dp_model = ".1.3.6.1.4.1.5454.1.90.1.3.2.3.0";
    public static $modem2_dp_model = ".1.3.6.1.4.1.5454.1.90.1.3.2.4.0";

    public static $modem1_dp_sn = ".1.3.6.1.4.1.5454.1.90.1.3.4.3.0";
    public static $modem2_dp_sn= ".1.3.6.1.4.1.5454.1.90.1.3.4.4.0";




    // LX
    public static $l2_flow_count = ".1.3.6.1.4.1.5454.1.90.2.9.2.0";
    public static $l3_flow_count = ".1.3.6.1.4.1.5454.1.90.2.9.3.0";

    // Modem(s) general
    public static $modem_port_rate_IN =   ".1.3.6.1.4.1.5454.1.90.4.12.4.0";
    public static $modem_port_rate_OUT =  ".1.3.6.1.4.1.5454.1.90.4.13.3.0";
    public static $modem_net_compression = ".1.3.6.1.4.1.5454.1.90.2.9.4.0";
    public static $modem_XPIC_enabled = ".1.3.6.1.4.1.5454.1.90.2.10.1.0";
    public static $modem_TX_current_capacity = ".1.3.6.1.4.1.5454.1.90.4.5.6.0";

    // VPol/HPol
    public static $modem1_XPIC_polarization = ".1.3.6.1.4.1.5454.1.90.2.11.2.0"; //	Integer	RW	0(Horizontal), 1(Vertical)	N/A
    public static $modem2_XPIC_polarization = ".1.3.6.1.4.1.5454.1.90.3.11.2.0"; //	Integer	RW	0(Horizontal), 1(Vertical)	N/A

    // GPS
    public static $gps_enabled = ".1.3.6.1.4.1.5454.1.90.1.22.1.0"; // Integer, 0 = off, 1 = on

    // ETHERNET / PORTS
    public static $eth1_enable = ".1.3.6.1.4.1.5454.1.90.6.1.1.3.0";
    public static $eth2_enable = ".1.3.6.1.4.1.5454.1.90.6.2.1.3.0";
    public static $eth3_enable = ".1.3.6.1.4.1.5454.1.90.6.3.1.3.0";
    public static $eth4_enable = ".1.3.6.1.4.1.5454.1.90.6.4.1.3.0";

    public static $eth1_status = ".1.3.6.1.4.1.5454.1.90.6.1.1.8.0";
    public static $eth2_status = ".1.3.6.1.4.1.5454.1.90.6.2.1.8.0";
    public static $eth3_status = ".1.3.6.1.4.1.5454.1.90.6.3.1.8.0";
    public static $eth4_status = ".1.3.6.1.4.1.5454.1.90.6.4.1.8.0";

    public static $eth1_speed = ".1.3.6.1.4.1.5454.1.90.6.1.1.7.0";
    public static $eth2_speed = ".1.3.6.1.4.1.5454.1.90.6.2.1.7.0";
    public static $eth3_speed = ".1.3.6.1.4.1.5454.1.90.6.3.1.7.0";
    public static $eth4_speed = ".1.3.6.1.4.1.5454.1.90.6.4.1.7.0";

    public static $eth1_crc = ".1.3.6.1.4.1.5454.1.90.6.1.2.9.0";
    public static $eth2_crc = ".1.3.6.1.4.1.5454.1.90.6.2.2.9.0";
    public static $eth3_crc = ".1.3.6.1.4.1.5454.1.90.6.3.2.9.0";
    public static $eth4_crc = ".1.3.6.1.4.1.5454.1.90.6.4.2.9.0";

    public static $eth1_discard_in = ".1.3.6.1.4.1.5454.1.90.6.1.2.15.0";
    public static $eth2_discard_in = ".1.3.6.1.4.1.5454.1.90.6.2.2.15.0";
    public static $eth3_discard_in = ".1.3.6.1.4.1.5454.1.90.6.3.2.15.0";
    public static $eth4_discard_in = ".1.3.6.1.4.1.5454.1.90.6.4.2.15.0";

    public static $eth1_discard_out = ".1.3.6.1.4.1.5454.1.90.6.1.2.16.0";
    public static $eth2_discard_out = ".1.3.6.1.4.1.5454.1.90.6.2.2.16.0";
    public static $eth3_discard_out = ".1.3.6.1.4.1.5454.1.90.6.3.2.16.0";
    public static $eth4_discard_out = ".1.3.6.1.4.1.5454.1.90.6.4.2.16.0";

}