<?php

if (!defined('IS_DEV_VERSION')) {
    define('IS_DEV_VERSION', false);
}
//$localhost = "localhost";
//$sec_level 	= "authPriv";
//$v3_en = 0;
//$handle = fopen("/etc/snmp/snmpd.conf", "r");
//if(file_exists("/mnt/usrcfg/snmpv3_en"))
//{
//    $v3_en = 1;
//    $info = fscanf($handle, "%s %s\n");
//    $info = fscanf($handle, "%s %s\n");
//    $info = fscanf($handle, "%s %s %s %s %s %s\n");
//    list($cmd, $user, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass) = $info;
//}
//else{
//    $info = fscanf($handle, "%s\t%s\n");
//    $info = fscanf($handle, "%s\t%s\n");
//    $info = fscanf($handle, "%s\t%s\n");
//    list ($name, $read_str) = $info;
//    $info = fscanf($handle, "%s\t%s\n");
//    list ($name, $write_str) = $info;
//}
//fclose($handle);
//function getSnmpResult($oid)
//{
//    global $user, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $sec_level ;
//    global $read_str, $write_str, $v3_en, $localhost;
//    if($v3_en){
//        return snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $oid);
//    }
//    else
//    {
//        return snmpget($localhost, $read_str, $oid);
//    }
//}


class CustomDataRetrieval
{

    public static function getFirstLastDifference($values, $key)
    {
        if ($values) {
            $tmp = array_values($values);
            $first = isset($tmp[0][$key]) ? $tmp[0][$key] : false;
            $last = isset($tmp[count($tmp) - 1][$key]) ? $tmp[count($tmp) - 1][$key] : false;
            if ($first !== false && $last !== false) {
                if ($last - $first >= 0) {
                    return number_format($last - $first);
                } else {
                    return 'Reset occurred';
                }
            }
        }
        return 'N/A';
    }

    public static function extractFromRawDataForHighCharts($raw_data, $column, $filter = '')
    {
        $js = [];
        if ($raw_data) {
            $last_valid_value = 0;
            $last_key = -1;
            foreach ($raw_data as $k => $v) {
                if (!$filter) {
                    $js[] = "[(new Date(1000 * ".$k.")).getTime(), ".$v[$column].']';
                    $last_valid_value = $v[$column];
                } elseif ($filter == 'modulation_rules_1') {
//                    Hi Sorin - For the bigger than 11 values can you just leave the modulation whatever the last one was.
//                    So if it jumps from 0 to 12 just leave it at 0 for that sample that returned 12.  I do not want N/A on that chart.
//                    This situation will only occur when the link is unlocked and really does not mean anything.
                    if ($v[$column] <= 11) {
                        $js[] = "[(new Date(1000 * ".$k.")).getTime(), ".$v[$column].']';
                        $last_valid_value = $v[$column];
                    } else {
                        $js[] = "[(new Date(1000 * ".$k.")).getTime(), ".$last_valid_value.']';
                    }
                } elseif ($filter == 'rssi_mse_rules_1') {
//                    2) For the RSSI and MSE historical and live parameters, you can throw out any value greater than +/- 150.
//                    I see a false report of -3271 on the chart now which is not real.
//                    Just use the last value if you see anything outside that range.
                    if ($v[$column] >= -150 && $v[$column] <= 150) {
                        $js[] = "[(new Date(1000 * ".$k.")).getTime(), ".$v[$column].']';
                        $last_valid_value = $v[$column];
                    } else {
                        $js[] = "[(new Date(1000 * ".$k.")).getTime(), ".$last_valid_value.']';
                    }
                } elseif ($filter == 'delta_rules_1') {
//                    for the errors you only need to display the delta change from the last measurement,
                    if ($last_key != -1) {
                        $delta = $v[$column] - $raw_data[$last_key][$column];
                        if ($delta < 0) {
                            $delta = 0;
                        }
                        $js[] = "[(new Date(1000 * ".$k.")).getTime(), ".$delta.']';
                        $last_valid_value = $v[$column];
                    }
                }
                $last_key = $k;
            }
        }
        return implode(",", $js);
    }

    public static function extractFromRawDataForHighChartsObject($raw_data, $column)
    {
        $js = [];
        if ($raw_data) {
            foreach ($raw_data as $k => $v) {
                $js[] =
                    '{'.
                    'y:'.$v[$column].','.
                    'x:'.(1000 * $k).','.
                    '}';;
                $data[$k] = $v[$column];
            }
        }
        return implode(",", $js);
    }

    public static function getHistoricalValues($what, $when)
    {
        $reply = [];
        $time_mappings = [
            'last-day' => 'day',
            'last-week' => 'week',
            'last-30-days' => 'month',
        ];
        $data_mappings = [
            'rf-capacity' => [
                'RFin',
                'RFout',
            ],
            'rssi-mse' => [
                'RSSI_1',
                'MSE_1',
                'RSSI_2',
                'MSE_2',
            ],
            'modulation' => [
                'ModTX_1',
                'ModTX_2',
                'ModRX_1',
                'ModRX_2',
            ],
            'errors-packet-drops' => [
                'RXFECerr_1',
                'RXFECerr_2',
                'TXpktdrops',
                'Ingress',
                'CRC',
            ],
        ];
        if (isset($time_mappings[$when])) {
            $target_file = PATH_DWM_LOGS.'/'.$time_mappings[$when].'.log';
//            die($target_file);
            if (file_exists($target_file)) {
                $content = file_get_contents($target_file);
                $reply = self::extractHistoricalValuesFromFile($content, $data_mappings[$what]);
            }
        }
        // Do we need to apply any mappings?
//        $reply = self::applyMappingsOnRawDataForHighCharts($reply, $what, $data_mappings[$what]);
        return $reply;
    }

//    public static function getLock

    public static function getModulationTextFromCode($code)
    {
        $mappings = self::getModulationMappings();
        if (isset($mappings[$code])) {
            return $mappings[$code];
        }
        return '-';
    }

    public static function getChannelBandwidthTextFromCode($code)
    {
        $mappings = self::getChannelBandwidthMappings();
        if (isset($mappings[$code])) {
            return $mappings[$code];
        }
        return '-';
    }

    public static function getChannelBandwidthMappings()
    {
        return [
            0 => '3.5 MHz',
            1 => '5 MHz',
            2 => '7 MHz',
            3 => '8 MHz',
            4 => '10 MHz',
            5 => '12.5 MHz',
            6 => '14 MHz',
            7 => '20 MHz',
            8 => '25 MHz',
            9 => '28 MHz',
            10 => '30 MHz',
            11 => '40 MHz',
            12 => '50 MHz',
            13 => '56 MHz',
            14 => '60 MHz',
            15 => '80 MHz',
            16 => '100 MHz',
            17 => '112 MHz',
            18 => '120 MHz',
        ];
    }

    public static function getModulationMappings()
    {
        return [
            0 => 'QPSK',
            1 => '16QAM',
            2 => '32QAM',
            3 => '64QAM',
            4 => '128QAM',
            5 => '256QAM',
            6 => '512QAM',
            7 => '1024QAM',
            8 => '2048QAM',
            9 => '4096QAM',
            10 => '8KQAM',
            11 => '16KQAM',
        ];
    }

    private static function applyMappingsOnRawDataForHighCharts($data, $what, $what_mappings)
    {
        if (!$data) {
            return $data;
        }
        switch ($what) {
            case 'modulation':
                $mappings = self::getModulationMappings();
                $tmp = [];
                foreach ($data as $row) {
                    $item = $row;
                    foreach ($what_mappings as $k) {
                        $item[$k] = isset($mappings[$row[$k]]) ? $mappings[$row[$k]] : 'N/A';
                    }
                    $tmp[] = $item;
                }
                $data = $tmp;
                break;
            default:
                // Do nothing
        }
        return $data;
    }

    private static function extractHistoricalValuesFromFile($content, $what)
    {
        $tmp = explode("\n", trim($content));
        $data = [];
        if ($tmp) {
            // Get and map header
//            $header = $tmp[0];
//            $header = explode("\t", $header);
            // Simulate header injection
            $header = [
                'Date',
                'RFin',
                'RFout',
                'MSE_1',
                'MSE_2',
                'RSSI_1',
                'RSSI_2',
                'ModTX_1',
                'ModTX_2',
                'ModRX_1',
                'ModRX_2',
                'RXFECerr_1',
                'RXFECerr_2',
                'TXpktdrops',
                'Ingress',
                'CRC',
            ];
            $header = array_flip($header);
//            ddd($header);
            // Extract info based on unix timestamps as a key
            for ($idx = 0; $idx < count($tmp); $idx++) {
                $raw_row = explode("\t", $tmp[$idx]);
                $key = strtotime($raw_row[$header['Date']]);
                if (is_array($what)) {
                    $row = [];
                    foreach ($what as $column) {
                        $row[$column] = $raw_row[$header[$column]];
                    }
                } else {
                    $row = $raw_row[$header[$what]];
                }
                $data[$key] = $row;
            }
        }
//        ddd($data);
        return $data;
    }

    public static function getModemModulationMinMax($modem_number = 1, $raw = true)
    {
        $min = self::pullSysOID(OID_Mappings::${'rf'.$modem_number.'_modulation_min'}, rand(0, 11));
        $max = self::pullSysOID(OID_Mappings::${'rf'.$modem_number.'_modulation_max'}, rand(0, 11));
        if ($raw === false) {
            $mappings = self::getModulationMappings();
            $min = isset($mappings[$min]) ? $mappings[$min] : 'Unknown';
            $max = isset($mappings[$max]) ? $mappings[$max] : 'Unknown';
        }
        return [
            $min,
            $max,
        ];
    }

    public static function getRemoteACMRxProfile($modem_number = 1, $raw = false)
    {
        $value = self::pullSysOID(OID_Mappings::${'remote'.$modem_number.'_rx'}, rand(0, 11));
        if ($raw === false) {
            $mappings = self::getModulationMappings();
            $value = isset($mappings[$value]) ? $mappings[$value] : 'Unknown';
        }
        return $value;
    }

    public static function pullSysXPICEnabled($raw = false)
    {
        $value = self::pullSysOID(OID_Mappings::$modem_XPIC_enabled, rand(0, 1));
        if ($raw) {
            return $value;
        }
        return $value ? 'On' : 'Off';
    }

    public static function getMappings($value, $raw = false)
    {
        if ($raw === false) {
            $mappings = self::getModulationMappings();
            $value = isset($mappings[$value]) ? $mappings[$value] : 'Unknown';
        }
        return $value;
    }
    public static function getModemACMRxProfile($modem_number = 1, $raw = false)
    {
        $value = self::pullSysOID(OID_Mappings::${'modem'.$modem_number.'_ACMRx_profile'}, rand(0, 11));
        if ($raw === false) {
            $mappings = self::getModulationMappings();
            $value = isset($mappings[$value]) ? $mappings[$value] : 'Unknown';
        }
        return $value;
    }

    public static function getModemTXRange($modem_number = 1)
    {
      $min = self::pullSysOID(OID_Mappings::${'modem'.$modem_number.'_tx_freq_min'}, rand(0, 10));
      $max = self::pullSysOID(OID_Mappings::${'modem'.$modem_number.'_tx_freq_max'}, rand(10, 20));
      
      return [
        number_format((float)$min, 1, '.', ''),
        number_format((float)$max, 1, '.', ''),
      ];
    }

    public static function pullSysDPModelNameAnSerialNumber($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'modem'.$index.'_dp_model'}, rand(0, 10));
    }
    public static function pullSysATPCTargetRSSI($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'atpc_rf'.$index.'_Target_RSSI'}, rand(-100, 100));
    }



    public static function pullSysATPCIsEnabled($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'atpc_rf'.$index.'_enabled'}, rand(0, 1));
    }

    public static function pullSysATPCMaxPower($index = 1, $what_for = 'QPSK')
    {
        return self::pullSysOID(OID_Mappings::${'atpc_rf'.$index.'_MaxPower_'.$what_for}, rand(0, 11111));
    }

    public static function pullSysRFOctets($direction = 'in')
    {
        return self::pullSysOID(OID_Mappings::${'rf_'.strtolower($direction).'_octet_oid'}, rand(0, 11111));
    }

    public static function pullSysRFPackets($direction = 'in')
    {
        return self::pullSysOID(OID_Mappings::${'rf_'.strtolower($direction).'_pkt_oid'}, rand(0, 11111));
    }

    public static function pullSysRFPortRate($direction = 'in')
    {
        return self::pullSysOID(OID_Mappings::${'rf_'.strtolower($direction).'_port_rate_oid'}, rand(0, 11111));
    }

    public static function pullSysRFPortUtil($direction = 'in')
    {
        return self::pullSysOID(OID_Mappings::${'rf_'.strtolower($direction).'_port_util_oid'}, rand(0, 11111));
    }

    public static function getAllSNMP()
    {
        global $localhost, $read_str;
        echo "hostname: $localhost<br>";
        echo "community: $read_str<br>";
        echo "<pre>";
        $a = snmp2_real_walk($localhost, $read_str, "", 10000000, 10);
        print_r($a);
        die("</pre>");
    }

    public static function pullSysOID($oid, $dev_default_value = 0)
    {
//        return self::pullSysOIDByObject($oid);

        global $localhost, $read_str;
        if (IS_DEV_VERSION) {
            $cleared_value = $dev_default_value;
        } else {
//            sleep(rand(1, 3));
            //$ret = snmpget($localhost, $read_str, $oid, 1000000, 5);
            $ret = getSnmpResult($oid);
            $ret = self::clearSNMPString($ret);
            $cleared_value = trim($ret, "\"");
            $cleared_value = trim($cleared_value);
        }
        return $cleared_value;
    }

    public static function pullSysOIDByObject($oid)
    {
        global $localhost, $read_str;
        $session = new SNMP(SNMP::VERSION_1, $localhost, $read_str);
        $ret = $session->get($oid);
        $ret = self::clearSNMPString($ret);
        $cleared_value = trim($ret, "\"");
        $cleared_value = trim($cleared_value);
        $error = $session->getError();
        if ($error) {
            die("ERROR SNMP: ".$error);
        }
        $session->close();
        return $cleared_value;
    }

    public static function pullSysVoltage48V()
    {
        return number_format(self::pullSysOID(OID_Mappings::$voltage_48, rand(-50, 50)), 1);
    }

    public static function pullSysDowntilt()
    {
        return self::pullSysOID(OID_Mappings::$system_downtilt, rand(0, 360));
    }

    public static function pullSysGPSIsEnabled()
    {
        return self::pullSysOID(OID_Mappings::$gps_enabled, rand(0, 1));
    }

    public static function pullSysConfigCode()
    {
        return self::pullSysOID(OID_Mappings::$system_config, rand(1, 2));
    }

    public static function pullSysODU1ModelName()
    {
        return self::pullSysOID(OID_Mappings::$odu1_model, 'ModelName1');
    }

    public static function pullSysODU1RXFrequency()
    {
        return self::pullSysOID(OID_Mappings::$odu1_rxfreq, rand(1, 10000));
    }

    public static function pullSysODU1TXFrequency()
    {
        return self::pullSysOID(OID_Mappings::$odu1_txfreq, rand(1, 10000));
    }
    
    public static function pullSysODU1Duplex()
    {
      return self::pullSysOID(OID_Mappings::$odu1_duplex_oid, rand(1, 10000));
    }
    
    public static function pullSysODU1TxFreqHighLow()
    {
      return self::pullSysOID(OID_Mappings::$odu1_txfreq_high_low_oid, rand(1, 10000));
    }

    public static function pullSysODU2RXFrequency()
    {
        return self::pullSysOID(OID_Mappings::$odu2_rxfreq, rand(1, 10000));
    }

    public static function pullSysODU2TXFrequency()
    {
        return self::pullSysOID(OID_Mappings::$odu2_txfreq, rand(1, 10000));
    }
    
    public static function pullSysODU2Duplex()
    {
      return self::pullSysOID(OID_Mappings::$odu2_duplex_oid, rand(1, 10000));
    }
    
    public static function pullSysODU2TxFreqHighLow()
    {
      return self::pullSysOID(OID_Mappings::$odu2_txfreq_high_low_oid, rand(1, 10000));
    }

    public static function pullSysODU2RSSI()
    {
        return self::pullSysOID(OID_Mappings::$odu2_rssi, rand(-150, 0));
    }

    public static function pullSysODU1RSSI()
    {
        return self::pullSysOID(OID_Mappings::$odu1_rssi, rand(-150, 0));
    }

    public static function pullSysODU2TXPower()
    {
        return self::pullSysOID(OID_Mappings::$odu2_txpower, rand(0, 100));
    }

    public static function pullSysNetCompression()
    {
        return self::pullSysOID(OID_Mappings::$modem_net_compression, rand(0, 100));
    }

    public static function pullSysODU1TXPower()
    {
        return self::pullSysOID(OID_Mappings::$odu1_txpower, rand(0, 100));
    }

    public static function pullSysODU2ModelName()
    {
        return self::pullSysOID(OID_Mappings::$odu2_model, 'ModelName2');
    }

    public static function pullSysODURFModuleIsOn($index = 1)
    {
        // If 0 RF module is OFF
        return self::pullSysOID(OID_Mappings::${'odu'.$index.'_rf_mode'}, rand(0, 1));
    }

    public static function pullSysODUIsPowered($index = 1)
    {
        // If 0 power is OFF
        return self::pullSysOID(OID_Mappings::${'odu'.$index.'_is_powered'}, rand(0, 1));
    }

    public static function pullSysODUCurrent($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'current_rf'.$index}, rand(1, 100) / 100);
    }

    public static function pullSysSumCurrentConsumption()
    {
        $current_system = self::pullSysOID(OID_Mappings::$current_system, rand(1, 100) / 100);
        $current_rf1 = self::pullSysODUCurrent(1);
        $current_rf2 = self::pullSysODUCurrent(2);
        return $current_system; 
        //return $current_system + $current_rf1 + $current_rf2;
    }

    public static function pullSysSumEthCRCErrors()
    {
        $total = 0;
        for ($i = 1; $i <= 4; $i++) {
            $total += self::pullSysOID(OID_Mappings::${'eth'.$i.'_crc'}, rand(0, 100));
        }
        return $total;
    }

    public static function pullSysSumEthDiscardedPackets($direction)
    {
        $total = 0;
        for ($i = 1; $i <= 4; $i++) {
            $total += self::pullSysOID(OID_Mappings::${'eth'.$i.'_discard_'.$direction}, rand(0, 100));
        }
        return $total;
    }

    public static function pullSysCombinedINDropPackets()
    {
        return self::pullSysOID(OID_Mappings::$rf_in_drop_packets, rand(0, 10000));
    }

    public static function pullSysEthCRCErrors($index = 1)
    {
        // If 0 all is fine, if > 0 we have CRC errors
        return self::pullSysOID(OID_Mappings::${'eth'.$index.'_crc'}, rand(0, 1));
    }

    public static function pullSysEthSpeed($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'eth'.$index.'_speed'}, rand(1, 10000));
    }

    public static function pullSysModemPolarization($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'odu'.$index.'_ant_pol_oid'}, rand(0, 1));
    }

    public static function pullSysModemLockStatus($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'modem'.$index.'_lock_status'}, rand(0, 1));
    }

    public static function pullSysTXCurrentCapacity()
    {
        return self::pullSysOID(OID_Mappings::$modem_TX_current_capacity, rand(0, 1111));
    }

    public static function pullSysModemXPD($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'modem'.$index.'_XPD'}, rand(0, 1));
    }

    public static function pullSysModemRSOutTotalErrBytes($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'modem'.$index.'_RS_out_total_err_bytes'}, rand(0, 100));
    }

    public static function pullSysModemFECLDPCUncorrectedBlocks($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'modem'.$index.'_FEC_LDPC_uncorrected_blocks'}, rand(0, 100));
    }
    
    public static function pullSysModemRSUncorrectedBlockCounter($index = 1)
    {
      return self::pullSysOID(OID_Mappings::${'modem'.$index.'_RSUncorrectedBlockCounter'}, rand(0, 100));
    }
    
    public static function pullSysModemFECRT_uncorrectedBlockCounter($index = 1)
    {
      return self::pullSysOID(OID_Mappings::${'modem'.$index.'_FEC_RT_uncorrectedBlockCounter'}, rand(0, 100));
    }

    public static function pullRemoteLockStatus($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'remote'.$index.'_lock_status'}, rand(0, 1));
    }

    public static function pullLXFlowCount($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'l'.$index.'_flow_count'}, rand(0, 1));
    }

    public static function pullSysModemBERAsText($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'modem'.$index.'_ber_text'}, rand(0, 1));
    }

    public static function pullRemoteBERAsText($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'remote'.$index.'_ber_text'}, rand(0, 1));
    }

    public static function pullSysModemRSSI($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'odu'.$index.'_rssi'}, rand(-40, 40));
    }

    public static function pullRemoteRSSI($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'remote'.$index.'_rssi'}, rand(-40, 40));
    }

    public static function pullRemoteMSE($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'remote'.$index.'_mse'}, rand(-100, 0));
    }

    public static function pullSysRFODUTemp($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'rf'.$index.'_odu_temp'}, rand(0, 30));
    }

    public static function pullSysModemMSE($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'modem'.$index.'_mse'}, rand(-100, 0));
    }

    public static function pullSysEthIsConnected($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'eth'.$index.'_status'}, rand(0, 1));
    }

    public static function pullSysEthIsEnabled($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'eth'.$index.'_enable'}, rand(0, 1));
    }

    public static function pullSysModemPortRate($direction = 'IN')
    {
        return self::pullSysOID(OID_Mappings::${'modem_port_rate_'.$direction}, rand(0, 2500));
    }

    public static function pullSysChannelBandwidth($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'rf'.$index.'_channel_bandwidth'}, rand(0, 15));
    }

    public static function pullSysLinkHistory($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'rf'.$index.'_link_history'}, rand(0, 99));
    }

    public static function pullSysLDPCStressDecoder($index = 1)
    {
        return self::pullSysOID(OID_Mappings::${'rf'.$index.'_ldpc_stress_decoder'}, rand(0, 99));
    }

		public static function getRFMCount()
		{
			$code = self::pullSysOID(OID_Mappings::$system_config);
			if ($code == 1){   //'1+0'
				return 1;
			}
			else{
				return 2;
			}
		}
    public static function getSysConfigTextFromCode($code)
    {
        $is_nitro = CustomHardware::isNitroModel();
        switch ($code) {
            case 1:
                return '1+0';
            case 2:
                return '2+0';
            case 3:
                return 'XPIC';
            case 4:
                return 'XPIC MIMO';
            case 5:
                return '1+0 SD';
            case 6:
                return $is_nitro?'No Sysconfig':'2+0 SP';
            case 7:
                return $is_nitro?'No Sysconfig':'Half XPIC SP';
            default:
                return 'No Sysconfig';
        }
    }

    public static function clearSNMPString($in)
    {
        $ret = preg_replace("/(INTEGER:)/", "", $in);
        $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
        $ret = preg_replace("/(IpAddress:)/", "", $ret);
        $ret = preg_replace("/(STRING: )/", "", $ret);
        $ret = preg_replace("/(Counter32: )/", "", $ret);
        $ret = preg_replace("/(Timeticks: )/", "", $ret);
        $ret = preg_replace("/(Gauge32: )/", "", $ret);
        return $ret;
    }


    public static function pullLiveRSSIAndMSEData($number_of_channels = null, $filter_in_range = true)
    {
        $range_down = -150;
        $range_up = 150;
        // Get number of channels if needed
        if ($number_of_channels == null) {
            $number_of_channels = CustomCapabilities::getNumberOfChannels();
        }
        $values = [0, 0];
        if ($number_of_channels > 1) {
            $values[] = 0;
            $values[] = 0;
        }
        if (IS_DEV_VERSION) {
            $values[0] = rand(-150, 150);
            $values[1] = rand(-150, 150);
            if ($number_of_channels > 1) {
                $values[2] = rand(-150, 150);
                $values[3] = rand(-150, 150);
            }
        } else {
            $values[0] = self::pullSysODU1RSSI();
            if ($filter_in_range && ($values[0] < $range_down || $values[0] > $range_up)) {
                $values[0] = self::pullSysODU1RSSI();
            }
            $values[1] = self::pullSysModemMSE(1);
            if ($filter_in_range && ($values[1] < $range_down || $values[1] > $range_up)) {
                $values[1] = self::pullSysModemMSE(1);
            }
            if ($number_of_channels > 1) {
                $values[2] = self::pullSysODU2RSSI();
                if ($filter_in_range && ($values[2] < $range_down || $values[2] > $range_up)) {
                    $values[2] = self::pullSysODU2RSSI();
                }
                $values[3] = self::pullSysModemMSE(2);
                if ($filter_in_range && ($values[3] < $range_down || $values[3] > $range_up)) {
                    $values[3] = self::pullSysModemMSE(2);
                }
            }
            for ($i = 0; $i < count($values); $i++) {
                if (!$values[$i]) {
                    $values[$i] = 0;
                }
            }
        }
        if ($filter_in_range) {
            $filtered = [];
            foreach ($values as $value) {
                if ($value >= $range_down && $value <= $range_up) {
                    $filtered[] = $value;
                } else {
                    $filtered[] = 0;
                }
            }
            $values = $filtered;
        }
        return $values;
    }

    public static function pullLiveTrafficData()
    {
        $in_rate = self::pullSysModemPortRate('IN');
        $out_rate = self::pullSysModemPortRate('OUT');
        return [$in_rate, $out_rate];
    }
}
