<?php
// @used
flush();

include 'common.php';

  if($v3_en == 1)
  {
	$ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $link_lock_oid);
  	$llink = preg_replace("/(INTEGER:)/", "", $ret);

  	$ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_link_oid);
  	$rlink = preg_replace("/(INTEGER:)/", "", $ret);   

  	$ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_config_oid);
  	$rconfig = preg_replace("/(INTEGER:)/", "", $ret);   
  }
  else
  {
  	$ret = snmpget($localhost, $read_str, $link_lock_oid);
  	$llink = preg_replace("/(INTEGER:)/", "", $ret);

  	$ret = snmpget($localhost, $read_str, $remote_link_oid);
  	$rlink = preg_replace("/(INTEGER:)/", "", $ret);   

  	$ret = snmpget($localhost, $read_str, $remote_config_oid);
  	$rconfig = preg_replace("/(INTEGER:)/", "", $ret);   
  }

  import_page_header();
  echo '<meta http-equiv="refresh" content="300;url=../radio_info.php">';
  display_logo_banner();
  echo '<body class="upgradenav" onload="getRemoteLocalStatistics()">';
  echo '<div id="loading">
  <img id="loading-image" src="../images/loading.gif" alt="Loading..." /></div>';

  display_test_menu_advanced();
  display_view_config_menu(0, ['view' => true]);
  
  display_content_table_no_border();
  echo '<tr height="10"></tr>';  

  display_none_shaded_row();
  display_subtitle("ADVANCED > SWITCH SW UPGRADE");
  enclose_content_table_row();  
  echo '<tr height="10">';

  display_content_table_no_border();
  display_none_shaded_row();
  display_subtitle("SWITCH SOFTWARE VERSIONS");
  enclose_content_table_row();

  display_block_row();

  display_none_shaded_row();
  echo '<td colspan="2"><div id="left-text"> Set current switch firmware as a stable version</div></td>';
  echo '<form method="post" action="switch_upgrade_option.php?name=switch_upgrade.php&oid=' . $switch_image_stable_oid . '">';
  echo '<td><div align="left" id="left-text"> <input type ="submit" name="auto_config_submit" class="submit_button" value="Set"></div></td>';
  echo '</form></tr>';

  display_none_shaded_row();
  display_parameter_name("Current version:");
  display_switch_firmware_version(0);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Previous version:");
  display_switch_firmware_version(1);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Stable version:");
  display_switch_firmware_version(2);
  enclose_content_table_row();

  display_block_row();

  display_none_shaded_row();
  display_subtitle("SWITCH SOFTWARE UPGRADE");
  enclose_content_table_row();

  display_block_row();
  echo '<form method="post" name="upload_local" id="upload_local" action="switch_upload_file.php" enctype="multipart/form-data">';
  display_none_shaded_row();
  echo '<td bgcolor=#f2f2f2 colspan="2"><input type="file" name="file" id="file" accept=".tar.gz" onchange="validateFileSelection(this)"></td>';
  echo '<td><div align="center"><input type="submit" class="submit_button" name="submit" value="Load" onClick="return confirmImport()"></div></td>';
  echo '<td ><div id="left-text"> Load switch software file from local machine to radio.</div></td>';
  enclose_content_table_row();
    echo '</form>';
    echo '<script>
        function validateFileSelection(input) {
    const selectedFile = input.files[0];
    if (selectedFile) {
        const fileName = selectedFile.name;
        const pattern = /^PXG2_switch_hw.*\.tar\.gz$/; // Regular expression pattern
        if (!pattern.test(fileName)) {
            alert("Please select a file with the name pattern PXG2_switch_hw*.tar.gz.");
            input.value = ""; // Clear the selection
        }
    }
}

    </script>';

  if(file_exists('/tmp/switch_upload_flag.txt'))
  {
    display_none_shaded_row();

    $files = glob("/tmp/PXG2_switch_hw*.tar.gz");
    $fw = strstr($files[0], "PXG2_switch_hw");

    echo '<td colspan="4"><div id="left-text" style="color:#2F712F; font-size:14px;"><b>';
    echo 'New switch software file ' . $fw . ' loaded on the radio.</b>';
    echo '</td>';
    enclose_content_table_row();
  }

  echo '<form method="post" name="upgrade" action="switch_upgrade_option.php?name=switch_upgrade.php&oid=' . $switch_image_upgrade_oid . '"> ';
  display_none_shaded_row();
  display_parameter_name("Switch Software version:");
  echo '<td width="100" bgcolor="f2f2f2"> <div id="left-text"">
        <select name="upgrade" id="upgrade">
           <option id="upgrade_1" value="0">New</option>
           <option id="upgrade_2" value="1">Previous</option>
           <option id="upgrade_3" value="2">Stable</option>';
  echo '</select>';
  display_selection_result($switch_image_upgrade_oid, "UpgradeOption");
  echo '</td>';

  echo '<td height="25">
        <div align="center"> <input type ="submit" name="radio_submit" class="submit_button" value="Select"> </div></td>';
  echo '<td><div id="left-text"> Select switch software version to upgrade/downgrade.</div></td>';
  echo '</tr></form>';
		
  if(file_exists('/mnt/usrcfg/switch_upgrade.txt'))
  {
    display_none_shaded_row();
    echo '<td colspan="2"><div id="left-text" style="color:#2F712F; font-size:14px;"><b>';
    echo 'Radio ready to upgrade the switch software.</b>';
    echo '</td>';
    echo '<td></td><td><form method="post" name="upgrade_cancel" action="submit_option.php?name=switch_upgrade.php&option=3&oid=' . $switch_image_upgrade_oid . '"> ';
    echo '<div align="center">
          <input type ="submit" name="cancel_upgrade" class="submit_button" value="Cancel upgrade" onClick="return confirmUpgradeCancel()"></div>
          </form></td></tr>';
  }

  display_block_row();

  display_none_shaded_row();
  echo '<td colspan="2"><div id="left-text">Upgrade local side switch</div></td>';
  echo '<td>';
  echo '<form method="post" name="reboot" action="submit_option.php?name=switch_upgrade.php&option=1&oid=' . $switch_image_flash_oid . '"> ';
  echo '<div align="center">';
  echo '<input type ="submit" name="reboot_submit" class="submit_button" style="box-shadow:1px 1px 1px 0px #ff0000;" value="Reboot" onClick="return confirmReboot()"></div>';
  echo '</form></td></tr>';

  display_block_row();
  enclose_content_table();
	display_content_table_no_border();
	display_none_shaded_row();
	display_note_section("<strong>Important: To upgrade switch to a new firmware version, make sure to load the firmware file on the radio first.</strong>");
	enclose_content_table();
	
    display_content_table_no_border();
    display_none_shaded_row();
    display_subtitle("SWITCH CONFIG MGMT");
    enclose_content_table_row();
	// File Upload
	display_block_row();
	echo '<form method="post" name="upload_local_config" id="upload_local_config" action="switch_upload_config_file.php" enctype="multipart/form-data">';
	display_none_shaded_row();
	echo '<td bgcolor=#f2f2f2 colspan="2"><input type="file" name="file" id="file" accept=".txt" onchange="validateFileSelectionConfig(this)"></td>';
	echo '<td><div align="center"><input type="submit" class="submit_button" name="submit" value="Load" onClick="return confirmImportConfig()"></div></td>';
	echo '<td colspan="2"><div id="left-text"> Load switch config file from local machine to radio.</div></td>';
	enclose_content_table_row();
	echo '</form>';
	echo '<script>
        function validateFileSelectionConfig(input) {
    const selectedFile = input.files[0];
    if (selectedFile) {
        const fileName = selectedFile.name;
        const pattern = /\.txt$/; // Regular expression pattern to match .txt extension
        if (!pattern.test(fileName)) {
            alert("Please select a file with the name pattern *.txt.");
            input.value = ""; // Clear the selection
        }
    }
}

    </script>';
	
    // Show The txt Files as List
	$configDir = '/mnt/usrcfg/switch_config';
	
	// Function to list all *.txt files in the directory
	function listTxtFiles($directory) {
		$files = glob($directory . '/*.txt');
		return $files;
	}
	echo '<form method="post" name="upgrade_config" action="switch_upgrade_option.php?name=switch_upgrade.php&oid=' . $switch_config_update_oid . '"> ';
	display_none_shaded_row();
	display_parameter_name("Switch Config Files:");
	echo '<td width="100" bgcolor="f2f2f2"> <div id="left-text""> <select name="upgrade" id="upgradeConfig">';
    $txtFiles = listTxtFiles($configDir);
	foreach ($txtFiles as $txtFile) {
		echo '<option value="' . basename($txtFile) . '">' . basename($txtFile) . '</option>';
	}
	echo '</select>';
	
	echo '</td>';
	echo '<td height="25">
        <div align="center"> <input type ="submit" name="radio_submit" class="submit_button" value="Upgrade" onClick="return confirmImportUpdate()"> </div></td>';
    echo '<td height="25">
        <div align="center"> <input type ="submit" name="radio_submit" class="submit_button" value="Delete" onClick="return confirmImportDelete()"> </div></td>';
	echo '</form>';
	
echo '<script>
function updateViewFormAction() {
    // Get the selected value from the select element
    var selectElement = document.getElementById("upgradeConfig");
    // Get the selected option
    var selectedOption = selectElement.options[selectElement.selectedIndex];
    // Get the text of the selected option
    var selectedText = selectedOption.text;
    // Update the action attribute of the "View" form
    var viewForm = document.forms["view_config"];
    viewForm.action = "config_view.php?option=3&filename=" + encodeURIComponent(selectedText);
    return true; // Allow the form to be submitted
}
</script>';

	
	
	echo '<td height="25"><div align="center"><form name="view_config" method="post" target="_blank" action="config_view.php?option=3&filename=XXX"><input type="submit" name="config_view" class="submit_button" value="View" onClick="return updateViewFormAction()"></div></form></td>';
	enclose_content_table_row();
    
    enclose_content_table();
  
  

  display_footer();
?>
<script language="JavaScript">
function confirmImport(){
  return confirm("System will import new switch software from local machine. Would you like to continue?");
}
function confirmImportConfig(){
    return confirm("System will import new switch config from local machine. Would you like to continue?");
}

function confirmImportUpdate(){
    return confirm("System will update the switch config file. Would you like to continue?");
}
function confirmImportDelete(){
    return confirm("System will delete the switch config file. Would you like to continue?");
}
</script>
<script language="javascript" type="text/javascript">
     $(window).load(function() {
     $('#loading').hide();
  });
</script>
<script language="javascript" type="text/javascript">
     window.onbeforeunload = function() {
     $('#loading').show();
  };
</script>
