<?php flush();

  include 'common.php';

  global $read_str, $failover_opt;

  import_page_header();
  display_logo_banner();
  echo '<body class="statusnav" onload="getRemoteLocalStatistics()">';

  display_test_menu_status();
  display_list_status();

  display_content_table_no_border();
  echo '<tr height="10">';
  
  echo '<form method="post" action="' .  $_SERVER['PHP_SELF'] . '">';
  display_none_shaded_row();
  display_subtitle("SYSTEM STATUS");
  echo '<td width="1%"></td>';
  display_subtitle("PORT STATUS");
  echo '<td width="20%"></td>';
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Current RSSI(dBm):");
  display_text($rssi_oid);
  echo '<td> </td>';
  display_parameter_name_width("GE1(RJ45):", "20%");
  display_eth_status_image($eth1_status_oid);
  enclose_content_table_row();
  
  display_none_shaded_row();
  display_parameter_name("Current MSE(dB):");
  display_text($mse_oid);
  echo '<td></td>';
  display_parameter_name_width("GE2(SFP):", "20%");
  display_eth_status_image($eth2_status_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Current BER:");
  display_text($ber_oid);
  echo '<td></td><td style="padding:0;" colspan="2" bgcolor=#ffffff>';
  echo '<table width="100%" height="25%" cellpadding="0" cellspacing="0" border="0">';
  echo '<tr height="5"<td><div id="menu-border"></div></td></tr></table>';
  //display_parameter_name("PLA:");
  //display_eth_status_image($pla_status_oid);
  enclose_content_table_row();
  
  display_none_shaded_row();
  display_parameter_name("Current FER:");
  display_text($fer_oid);
  //echo '<td></td><td colspan="2" rowspan="7" bgcolor=#ffffff></td>';
  echo '<td></td>';
  display_subtitle("HEADER COMP STATS");
  enclose_content_table_row();
  
  display_none_shaded_row();
  display_parameter_name("LDPC Stress:");
  $ret = getSnmpResult($ldpc_stress_oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $trimed = trim($ret, "\"");
  echo '<td bgcolor="#ffffff" nowrap="nowrap"> <div id="input-text"><font size="2">';
  echo sprintf("%.2e", $trimed);
  echo '</font></div></td>';
  echo '<td></td>';
  display_parameter_name("HC Enable:");
  display_text_left($hc_enable_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("System Temp(deg C):");
  display_text($idu_temp_oid);
  echo '<td></td>';
  display_parameter_name("L2 Flow Count:");
  display_text_left($hc_eng1_flow_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Current Tx Modulation:");
  display_text_center($remote_rx_oid);
  echo '<td></td>';
  display_parameter_name("L3 Flow Count:");
  display_text_left($hc_eng2_flow_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Current Tx Capacity(Mbps): ");
  display_text($speed_current_oid);
  echo '<td></td>';
  display_parameter_name("Net Compression %:");
  display_text_left($hc_net_comp_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Tx Capacity(SM/LG)(Mbps):");
  echo '<td width="20%" bgcolor="#ffffff" nowrap="nowrap"> <div id="input-text"><font size="2">';
  $ret = getSnmpResult($speed_small_oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $txcap_s = trim($ret, "\"");
  $ret = getSnmpResult($speed_oid);
  $ret = preg_replace("/(INTEGER:)/", "", $ret);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $txcap_l = trim($ret, "\"");
  echo $txcap_s . '/' . $txcap_l;
  echo '<td></td>';
  display_parameter_name("Gross Compression %:");
  display_text_left($hc_gross_comp_oid);
  enclose_content_table_row();
  
  display_none_shaded_row();
  display_parameter_name("Rx Capacity(SM/LG)(Mbps):");
  echo '<td width="20%" bgcolor="#ffffff" nowrap="nowrap"> <div id="input-text"><font size="2">';
  $ret = getSnmpResult($rx_speed_s_oid);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $rxcap_s = trim($ret, "\"");
  $ret = getSnmpResult($rx_speed_l_oid);
  $ret = preg_replace("/(Opaque: Float:)/", "", $ret);
  $rxcap_l = trim($ret, "\"");
  echo $rxcap_s . '/' . $rxcap_l;
  echo '<td></td><td bgcolor=#ffffff colspan="2"></td>';
  enclose_content_table_row();  

  echo '<tr><td style="height: 5px;" colspan="5"><div id="menu-border"></div></td></tr>';

  display_none_shaded_row();
  display_subtitle("LINK/PLL STATUS");
  echo '<td colspan="3" bgcolor="#ffffff"></td>';
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Link:");
  display_status_image($link_lock_oid);
  echo '<td bgcolor=#ffffff></td>';
  display_parameter_name("Tx Pll:");
  display_status_image($txpll_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Timing:");
  display_status_image($timing_lock_oid);
  echo '<td bgcolor=#ffffff></td>';
  display_parameter_name("Rx Pll:");
  display_status_image($rxpll_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Preamble:");
  display_status_image($preamble_lock_oid);
  echo '<td bgcolor=#ffffff colspan="3"></td>';
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("LDPC:");
  display_status_image($ldpc_lock_oid);
  echo '<td bgcolor=#ffffff colspan="3"></td>';
  enclose_content_table_row();
  
  echo '</form>';
  enclose_content_table();
  display_footer();

?>
