<?php global $speed1_mod_max_oid, $sysconfig_oid, $rx1_retransmission_oid, $isSubscriptonLicenseEnabled, $config_option_oid, $write_str, $freq_license_oid, $dual_license_oid, $v3_en, $localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $link_lock_oid, $remote_link_oid, $remote_config_oid, $omu_model_oid, $read_str, $odu1_category_oid, $odu2_category_oid, $odupower1_oid, $odupower2_oid, $int_val, $txfreq2_oid, $txfreq1_oid, $odu1_duplex_oid, $odu2_duplex_oid, $float_val, $power1_oid, $power2_oid, $rxfreq1_oid, $opmode1_oid, $opmode2_oid, $left, $rxfreq2_oid;
  flush();
  
  include 'common.php';
  function parseRfmDpFiles($filePath)
  {
    $config_values = array(); // Initialize an empty dictionary
    
    try {
      if (!file_exists($filePath)) {
        //echo "File not found: $filePath\n";
        return null;
      }
      
      $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
      foreach ($lines as $line) {
        list($key, $value) = explode(' ', $line, 2);
        $config_values[$key] = intval($value);
      }
      return $config_values;
    } catch (Exception $e) {
      echo "An exception is occurred while reading the file: $filePath\n";
      return null;
    }
  }
  
  import_page_header();
  echo '<meta http-equiv="refresh" content="300;url=../radio_info.php">';
  display_logo_banner();
  echo '<body class="linknav" onload="getRemoteLocalStatistics()">';
  echo '<div id="loading">
  <img id="loading-image" src="../images/loading.gif" alt="Loading..." /></div>';
  
  display_test_menu_basic(1);
  display_list_basic(1);
  
  $llink = CustomDataRetrieval::pullSysOID($link_lock_oid);
  $rlink = CustomDataRetrieval::pullSysOID($remote_link_oid);
  $rconfig = CustomDataRetrieval::pullSysOID($remote_config_oid);
  
  $is_nitro = CustomHardware::isNitroModel();
  $rfmCount = CustomDataRetrieval::getRFMCount();
  $sysconfig = CustomDataRetrieval::pullSysOID($sysconfig_oid);
  
  $is_tx_freq_same = ($rfmCount == 2) && ($sysconfig == 3 || $sysconfig == 4);  // xpic, xpic mimo
  $is_tr_space_same = ($rfmCount == 2) && ($sysconfig == 3 || $sysconfig == 4 || $sysconfig == 6 || $sysconfig == 7);  // xpic, xpic mimo, 2+0 sp, half xpic sp
  $is_tx_pwr_same = ($rfmCount == 2) && ($sysconfig == 3 || $sysconfig == 4);  // xpic, xpic mimo
  $is_rf2_virtual = ($rfmCount == 2) && ($sysconfig == 6 || $sysconfig == 7);  // 2+0 sp, half xpic sp
  
  $channel_bandwidth_code = CustomDataRetrieval::pullSysChannelBandwidth();
  $bandwidthArray = [
    3.5,
    5,
    7,
    8,
    10,
    12.5,
    14,
    20,
    25,
    28,
    30,
    40,
    50,
    56,
    60,
    80,
    100,
    112,
    120
  ];
  if (array_key_exists($channel_bandwidth_code, $bandwidthArray)) {
    $bandwidthValue = $bandwidthArray[$channel_bandwidth_code];
  } else {
    $bandwidthValue = 0;
  }
  
  $freq1DuplexMin = 2.2250738585072e-50;
  $freq1DuplexMax = 1.7976931348623e+50;
  $power1Min = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu1_power_min);
  $power1Max = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu1_power_max);
  if ($is_rf2_virtual){
    $power1Max = $power1Max - 3.0;    // must be 3dB less than defined limit
  }
  $freq1Min = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem1_tx_freq_min);
  $freq1MinSuggested = $freq1Min + $bandwidthValue / 2;
  $freq1Min = number_format($freq1Min, 2, '.', '');
  $freq1MinSuggested = number_format($freq1MinSuggested, 2, '.', '');
  
  $freq1Max = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem1_tx_freq_max);
  $freq1MaxSuggested = $freq1Max - $bandwidthValue / 2;
  $freq1Max = number_format($freq1Max, 2, '.', '');
  $freq1MaxSuggested = number_format($freq1MaxSuggested, 2, '.', '');
  
  $freqRx1Min = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem1_rx_freq_min);
  $freqRx1Min = number_format($freqRx1Min, 2, '.', '');
  $freqRx1Max = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem1_rx_freq_max);
  $freqRx1Max = number_format($freqRx1Max, 2, '.', '');
  
  $current_tx_frequency1 = 0;
  $current_tx_frequency2 = 0;
  $current_tx_frequency1 = CustomDataRetrieval::pullSysODU1TXFrequency();
  $freq1 = 0;
  $duplex1 = 0;
  $isDuplexEnabled1 = true;
  if ($is_nitro) {
    $odu1_category = CustomDataRetrieval::pullSysOID($odu1_category_oid);
    if (!($odu1_category == 0x00 || $odu1_category == 0x0B || $odu1_category == 0x0C)) {
      $isDuplexEnabled1 = false;
    }
  }
  
  $power2Min = 2.2250738585072e-50;
  $power2Max = 1.7976931348623e+50;
  $freq2Min = 2.2250738585072e-50;
  $freq2Max = 1.7976931348623e+50;
  $freqRx2Min = 2.2250738585072e-50;
  $freqRx2Max = 1.7976931348623e+50;
  $freq2MinSuggested = 2.2250738585072e-50;
  $freq2MaxSuggested = 1.7976931348623e+50;
  $freq2DuplexMin = 2.2250738585072e-50;
  $freq2DuplexMax = 1.7976931348623e+50;
  $freq2 = 0;
  $duplex2 = 0;
  
  
  $odu1_is_powered = CustomDataRetrieval::pullSysODUIsPowered(1);
  $odu1_model_name = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu1_model);
  $odu1_is_detected = true;
  $odu2_is_detected = true;
  $odu1_check_message = "";
  $odu2_check_message = "";
  
  
  if (!$odu1_is_powered){
    $odu1_check_message = 'ODU 1 power is not enabled- enable ODU power and re-issue command';
    $odu1_is_detected = false;
  }
  else if (empty($odu1_model_name) || $odu1_model_name === "N/A") {
    $odu1_is_detected = false;
    if ($is_nitro)
      $odu1_check_message = 'No ODU detected. Please check that ODU is connected to IDU port 1 via coax cable';
    else
      $odu1_check_message = 'No RFM detected. Please check that RFM is seated properly in slot 1';
  }
  
  $isDuplexEnabled2 = true;
  if ($rfmCount == 2) {
    
    if ($is_nitro) {
      $odu2_category = CustomDataRetrieval::pullSysOID($odu2_category_oid);
      if (!($odu2_category == 0x00 || $odu2_category == 0x0B || $odu2_category == 0x0C)) {
        $isDuplexEnabled2 = false;
      }
    }
    $current_tx_frequency2 = CustomDataRetrieval::pullSysODU2TXFrequency();
    if ($is_rf2_virtual) {
      // power limits are adjusted at below
      $freq2Min = $freq1Min;
      $freq2Max = $freq1Max;
      $freqRx2Min = $freqRx1Min;
      $freqRx2Max = $freqRx1Max;
      $freq2MinSuggested = $freq1MinSuggested;
      $freq2MaxSuggested = $freq1MaxSuggested;
      $odu2_is_powered = $odu1_is_powered;
      $odu2_model_name = $odu1_model_name;
      $odu2_is_detected = $odu1_is_detected;
    } else {
      $power2Min = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu2_power_min);
      $power2Max = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu2_power_max);
      $freq2Min = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem2_tx_freq_min);
      $freq2MinSuggested = $freq2Min + $bandwidthValue / 2;
      $freq2Min = number_format($freq2Min, 2, '.', '');
      $freq2MinSuggested = number_format($freq2MinSuggested, 2, '.', '');
      $freq2Max = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem2_tx_freq_max);
      $freq2MaxSuggested = $freq2Max - $bandwidthValue / 2;
      $freq2Max = number_format($freq2Max, 2, '.', '');
      $freq2MaxSuggested = number_format($freq2MaxSuggested, 2, '.', '');
      
      $freqRx2Min = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem2_rx_freq_min);
      $freqRx2Min = number_format($freqRx2Min, 2, '.', '');
      $freqRx2Max = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem2_rx_freq_max);
      $freqRx2Max = number_format($freqRx2Max, 2, '.', '');
      $odu2_is_powered = CustomDataRetrieval::pullSysODUIsPowered(2);
      $odu2_model_name = CustomDataRetrieval::pullSysODU2ModelName();
      
      if(!$odu2_is_powered){
        $odu2_check_message = 'ODU 2 power is not enabled- enable ODU power and re-issue command';
        $odu2_is_detected = false;
      }
      else if (empty($odu2_model_name) || $odu2_model_name === "N/A") {
        $odu2_is_detected = false;
        if ($is_nitro)
          $odu2_check_message = 'No ODU detected. Please check that ODU is connected to IDU port 2 via coax cable';
        else
          $odu2_check_message = 'No RFM detected. Please check that RFM is seated properly in slot 2';
      }
    }
    
  }
  
  // atpc
  if ($v3_en == 0) {
    $atpc = snmpget($localhost, $read_str, $atpc1_oid);
  } else {
    $atpc = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $atpc1_oid);
  }
  
  $atpc = preg_replace("/(INTEGER: )/", "", $atpc);
  $atpc = trim($atpc, "\"");
  
  
  
  $capacityLicence = CustomDataRetrieval::pullSysOID($freq_license_oid);
  $dualcoreLicence = CustomDataRetrieval::pullSysOID($dual_license_oid);
  $isCapacityMax = $capacityLicence == 2;
  
  
  display_content_table_no_border();
  echo '<tr height="10"></tr>';
  display_none_shaded_row();
  display_note_section("<strong>Important: This page will reload itself when new settings are applied.</strong>");
  enclose_content_table_row();
  enclose_content_table();
  
  display_content_table_no_border();
  echo '<tr height="10">';
  
  display_none_shaded_row();
  display_subtitle("LINK > LINK SETUP");
  
  enclose_content_table_row();
  echo '<tr height="10">';
  
  display_none_shaded_row();
  display_subtitle("RF LINK");
  enclose_content_table_row();
  
  echo '<td width="10%"></td>';
  enclose_content_table_row();
  echo '<form name="linksetup1" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return confirmSysConfig()">';
  display_none_shaded_row();
  display_parameter_name_width("Sysconfig:", "10%");
  echo '<td bgcolor=#f2f2f2><div id="left-text">';
  echo '<select id="Sysconfig" name="Sysconfig" width="30">';
  if ($is_nitro) {
    echo '<option id="Sysconfig_1" value="1"> 1+0 </option>';
    if ($dualcoreLicence == 1 || $isSubscriptonLicenseEnabled) {
      echo '<option id="Sysconfig_2" value="2"> 2+0 </option>
           <option id="Sysconfig_3" value="3"> XPIC </option>
           <option id="Sysconfig_4" value="4"> XPIC MIMO </option>';
      
    }
    echo '<option id="Sysconfig_5" value="5"> 1+0 SD </option>';
  } else { // air
    echo ' <option id="Sysconfig_1" value="1"> 1+0 </option>';
    if ($dualcoreLicence == 1 || $isSubscriptonLicenseEnabled) {
      echo '<option id="Sysconfig_2" value="2"> 2+0 </option>
           <option id="Sysconfig_3" value="3"> XPIC </option>
           <option id="Sysconfig_4" value="4"> XPIC MIMO </option>';
    }
    if ($dualcoreLicence == 1 || $isSubscriptonLicenseEnabled) {
      echo '<option id="Sysconfig_6" value="6"> 2+0 SP </option>
           <option id="Sysconfig_7" value="7"> Half XPIC SP </option>
           ';
    }
  }
  
  echo '</select>';
  display_speed_result($sysconfig_oid, "Sysconfig");
  enclose_content_table_row();
  display_parameter_name_width("Channel Bandwidth:", "10%");
  echo '<td bgcolor=#f2f2f2><div id="left-text">';
  echo '<select id="Bandwidth" name="Bandwidth" width="30">';
  echo '<option id="Bandwidth_0" value="0"> 3.5 MHz </option>
           <option id="Bandwidth_1" value="1"> 5 MHz </option>
           <option id="Bandwidth_2" value="2"> 7 MHz </option>
           <option id="Bandwidth_3" value="3"> 8 MHz </option>
           <option id="Bandwidth_4" value="4"> 10 MHz </option>
           <option id="Bandwidth_5" value="5"> 12.5 MHz </option>
           <option id="Bandwidth_6" value="6"> 14 MHz </option>
           <option id="Bandwidth_7" value="7"> 20 MHz </option>
           <option id="Bandwidth_8" value="8"> 25 MHz </option>
           <option id="Bandwidth_9" value="9"> 28 MHz </option>
           <option id="Bandwidth_10" value="10"> 30 MHz </option>
           <option id="Bandwidth_11" value="11"> 40 MHz </option>
           <option id="Bandwidth_12" value="12"> 50 MHz </option>
           <option id="Bandwidth_13" value="13"> 56 MHz </option>
           <option id="Bandwidth_14" value="14"> 60 MHz </option>
           <option id="Bandwidth_15" value="15"> 80 MHz </option>
           <option id="Bandwidth_16" value="16"> 100 MHz </option>
           <option id="Bandwidth_17" value="17"> 112 MHz </option>
           <option id="Bandwidth_18" value="18"> 120 MHz </option>';
  echo '</select>';
  
  display_speed_result($speed1_chwidth_oid, "Bandwidth");
  
  display_none_shaded_row();
  display_parameter_name_width("Min Modulation:", "10%");
  echo '<td bgcolor="#f2f2f2"> <div id="left-text"> 
         <select id="Modulation_Min" name="Modulation_Min">
           <option id="Modulation_Min_0" value="0">QPSK</option>
           <option id="Modulation_Min_1" value="1">QAM16</option>
           <option id="Modulation_Min_2" value="2">QAM32</option>
           <option id="Modulation_Min_3" value="3">QAM64</option>
           <option id="Modulation_Min_4" value="4">QAM128</option>
           <option id="Modulation_Min_5" value="5">QAM256</option>
   	       <option id="Modulation_Min_6" value="6">QAM512</option>
   	       <option id="Modulation_Min_7" value="7">QAM1024</option>
           <option id="Modulation_Min_9" value="9">QAM4096</option>';
  if ($isCapacityMax == 1 || $isSubscriptonLicenseEnabled == 2) echo '<option id="Modulation_Min_10" value="10">QAM8K</option>
	                                                      <option id="Modulation_Min_11" value="11">QAM16K</option>';
  echo '</select></div>';
  
  display_speed_result($speed1_mod_min_oid, "Modulation_Min");
  
  display_none_shaded_row();
  display_parameter_name_width("Max Modulation:", "10%");
  echo '<td bgcolor="#f2f2f2"> <div id="left-text">
         <select id="Modulation_Max" name="Modulation_Max">
           <option id="Modulation_Max_0" value="0">QPSK</option>
           <option id="Modulation_Max_1" value="1">QAM16</option>
           <option id="Modulation_Max_2" value="2">QAM32</option>
           <option id="Modulation_Max_3" value="3">QAM64</option>
           <option id="Modulation_Max_4" value="4">QAM128</option>
           <option id="Modulation_Max_5" value="5">QAM256</option>
           <option id="Modulation_Max_6" value="6">QAM512</option>
           <option id="Modulation_Max_7" value="7">QAM1024</option>
           <option id="Modulation_Max_8" value="8">QAM2048</option>
           <option id="Modulation_Max_9" value="9">QAM4096</option>';
  if ($isCapacityMax == 1 || $isSubscriptonLicenseEnabled == 2) echo '<option id="Modulation_Max_10" value="10">QAM8K</option>
	                                                      <option id="Modulation_Max_11" value="11">QAM16K</option>';
  echo '</select></div>';
  
  display_speed_result($speed1_mod_max_oid, "Modulation_Max");
  enclose_content_table_row();
  
  if ($isSubscriptonLicenseEnabled != 1) {
    display_none_shaded_row();
    display_parameter_name_width("Retransmission:", "10%");
    display_radio_on_off_left("Retransmisson_1", $rx1_retransmission_oid);
    enclose_content_table_row();
  }
  
  display_none_shaded_row();
  
  display_center_parameter_name("");
  echo '<td width="60%" height="20">
        <div style="display: flex; gap: 10px; align-items: center;">';
  // Apply Changes button
  echo '<input type="hidden"  name="config_option" value=4>';
  // Save Changes button
  echo '<input type="submit" name="save_submit" class="submit_button" value="Save Changes"">';
  echo '</form>';
  // Reboot button
  echo '<form method="post" name="reboot" action="submit_option.php?name=upgrade.php&option=1&oid=' . $reboot_oid . '">';
  echo '<input type="submit" name="reboot_submit" class="submit_button" style="border-color:#ff0000;" value="Reboot" onClick="return confirmReboot()">';
  echo '</form>';
  echo '</div></td>';
  enclose_content_table_row();
  set_config($config_option_oid, "config_option");
  echo '<td colspan="4">--------------------------------------------------------------------------------------------------------------</td>';
  
  display_none_shaded_row();
  echo '<td nowrap="nowrap" width="15%" bgcolor=#f2f2f2 align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#00478F>RF1</td>';
  display_page_subtitle("");
  
  // RF 1 & RF 2 Settings
  // RFM - ODU Model
  display_none_shaded_row();
  display_parameter_name_width("Model:", "10%");
  $odu1_is_powered ? display_text_position(OID_Mappings::$odu1_model, $left) : display_left_label("-");
  enclose_content_table_row();
  
  // Radio power
  display_none_shaded_row();
  display_parameter_name_width("Radio Power:", "10%");
  
  echo '<form name="linksetup_power_rf1" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return true">';
  display_radio_on_off_left_submit("LOduPower1", $odupower1_oid);
  if ($is_rf2_virtual) {
    set_snmp_param("LOduPower1", $odupower2_oid, $int_val);  //set same value to rf2 power
  }
  echo '</form>';
  
  enclose_content_table_row();
  
  // T/R Spacing (MHz):
  display_none_shaded_row();
  display_parameter_name_width("T/R Spacing (MHz):", "10%");
  if ($odu1_is_detected && $isDuplexEnabled1 && $odu1_is_powered) {
    //find min/max
    if (!$is_nitro) {
      // limits
      $configFlashPath = '/mnt/usrcfg/rfm1_flash.txt';
      $parsedValues = parseRfmDpFiles($configFlashPath);
      // Assign the parsed values to individual variables with error handling
      $freq1DuplexMin = isset($parsedValues['FREQ_DUPLEX_MIN']) ? $parsedValues['FREQ_DUPLEX_MIN'] / 1000 : 2.2250738585072e-50;
      $freq1DuplexMax = isset($parsedValues['FREQ_DUPLEX_MAX']) ? $parsedValues['FREQ_DUPLEX_MAX'] / 1000 : 1.7976931348623e+50;
    }
    else{
      //$isUpperFreq = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem1_freq_hi_low);
      $freq1 = CustomDataRetrieval::pullSysODU1TXFrequency();
      if ($freq1 > $freqRx1Max) {
        $freq1DuplexMin = $freq1 - $freqRx1Max;
        $freq1DuplexMax = $freq1 - $freqRx1Min;
      }
      else{
        $freq1DuplexMin = $freqRx1Min - $freq1;
        $freq1DuplexMax = $freqRx1Max - $freq1;
      }
    }
    $freq1DuplexMin = number_format($freq1DuplexMin, 2, '.', '');
    $freq1DuplexMax = number_format($freq1DuplexMax, 2, '.', '');
    $validRangeTRSpacing1 = "T/R Spacing (MHz) range is [" . $freq1DuplexMin . " - " . $freq1DuplexMax . "]";
    echo '<form name="linksetup_spacing_rf1" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return checkSpaceDuplexRF1();">';
    echo '<div style="display: flex; align-items: center; gap: 10px;">';
    set_radio_param($odu1_duplex_oid, "FreqDuplex1", $float_val, $left, "inputtext", $validRangeTRSpacing1);
    if ($is_tr_space_same){
      set_snmp_param("FreqDuplex1", $odu2_duplex_oid, $float_val);  //set same value to rf2 tr spacing
    }
    echo '<input type="submit" name="radio_submit" class="submit_button_small" value="Apply Changes" style="margin-left: 15px;">';
    echo '</div>';
    echo '</form>';
  } else if ($odu1_is_powered){
    $duplex1 = CustomDataRetrieval::pullSysODU1Duplex();
    display_parameter_name($duplex1);
  }
  else{
    display_left_label("-");
  }
  enclose_content_table_row();
  
  // TX Frequency
  display_none_shaded_row();
  display_parameter_name_width("Tx Frequency (MHz):", "10%");
  
  if ($odu1_is_detected && $odu1_is_powered) {
    $validRangeTx1 = "Valid Tx Frequency (MHz) range is [" . $freq1Min . " - " . $freq1Max . "]";
    echo '<form name="linksetup_freq_rf1" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return checkFrequencyRF1();">';
    echo '<div id = "test" style="display: flex; align-items: start; gap: 10px;">';
    set_radio_param($txfreq1_oid, "TxFrequency1", $float_val, $left, "inputtext", $validRangeTx1);
    if ($is_tx_freq_same){
      set_snmp_param("TxFrequency1", $txfreq2_oid, $float_val);  //set same value to rf2 tx freq
    }
    echo '<input type="submit" name="radio_submit" class="submit_button_small" value="Apply Changes" style="margin-left: 15px;">';
    echo '</div>';
    echo '</form>';
  } else if ($odu1_is_powered){
    $freq1 = CustomDataRetrieval::pullSysODU1TXFrequency();
    display_parameter_name($freq1);
  }
  else{
    display_left_label("-");
  }
  enclose_content_table_row();
  

  
  //Rx Frequency
  display_none_shaded_row();
  display_parameter_name_width("Rx Frequency (MHz):", "10%");
  $odu1_is_powered ? display_text_position($rxfreq1_oid, $left):display_left_label("-");
  enclose_content_table_row();
  
  // TX Power
  display_none_shaded_row();
  display_parameter_name_width("Tx Power (dBm):", "10%");
  if ($atpc == 0 && $odu1_is_detected && $odu1_is_powered) {
    $validTxPower1 = "Valid Tx Power (dBm) range is [" . $power1Min . " - " . $power1Max . "]";
    echo '<form name="linksetup_tx_power_rf1" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return checkTxPowerRF1();">';
    echo '<div style="display: flex; align-items: center; gap: 10px;">';
    set_radio_param($power1_oid, "TxPower1", $float_val, $left, "inputtext", $validTxPower1);
    if ($is_tx_pwr_same){
      set_snmp_param("TxPower1", $power2_oid, $float_val);  //set same value to rf2 tx power
    } else if ($is_rf2_virtual){
        $current_tx_power1 = CustomDataRetrieval::pullSysODU1TXPower();
        $current_tx_power2 = CustomDataRetrieval::pullSysODU2TXPower();
        $power2Min = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu2_power_min);
        $power2Min = max($current_tx_power1 - 8.0, $power2Min);
        $power2Max = $current_tx_power1;
        if ($current_tx_power2 > $power2Max) {
          set_snmp_param("TxPower1", $power2_oid, $float_val, $power2Max);  //set same value to rf2 tx power
        }
        else if ($current_tx_power2 < $power2Min) {
          set_snmp_param("TxPower1", $power2_oid, $float_val, $power2Min);  //set same value to rf2 tx power
        }
    }
    echo '<input type="submit" name="radio_submit" class="submit_button_small" value="Apply Changes" style="margin-left: 15px;">';
    echo '</div>';
    echo '</form>';
  } else if ($odu1_is_powered) {
    display_parameter_name(CustomDataRetrieval::pullSysODU1TXPower());
  }
  else{
    display_left_label("-");
  }
  enclose_content_table_row();
  
  // Transmitter
  display_none_shaded_row();
  display_parameter_name_width("Transmitter:", "10%");
  if ($odu1_is_detected && $odu1_is_powered) {
    echo '<form name="linksetup_transmitter_rf1" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return true">';
    display_radio_on_off_left_submit("LOpmode1", $opmode1_oid);
    if ($is_rf2_virtual){
      set_snmp_param("LOpmode1", $opmode2_oid, $int_val);  //set same value to rf2 tx power
    }
    echo '</form>';
  } else if ($odu1_is_powered){
    display_parameter_name((CustomDataRetrieval::pullSysODURFModuleIsOn(1) == 0) ? 'Off' : 'On');
  }
  else{
    display_left_label("-");
  }
  enclose_content_table_row();
  
  // Polarization
  display_none_shaded_row();
  display_parameter_name_width("Polarization:", "10%");
  if (CustomHardware::isNitroModel() && $odu1_is_detected && $odu1_is_powered) {
    echo '<form name="linksetup_polarization_rf1" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return false">';
    display_radio_polarization_left_submit("odu1_ant_pol", OID_Mappings::$odu1_ant_pol_oid);
    echo '</form>';
    
  } else if ($odu1_is_powered) {
    display_parameter_name(CustomUI::formatModemPolarizationForAll(CustomDataRetrieval::pullSysModemPolarization(1)));
  }
  else{
    display_left_label("-");
  }
  enclose_content_table_row();
  
  
  if ($rfmCount == 2) {
    display_none_shaded_row();
    enclose_content_table_row();
    
    display_none_shaded_row();
    echo '<td nowrap="nowrap" width="15%" bgcolor="#f2f2f2" align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color="#00478F">RF2</font></td>';
    display_page_subtitle("");
    enclose_content_table_row();
    
    display_none_shaded_row();
    display_parameter_name_width("Model:", "10%");
    if ($is_rf2_virtual) {
      if ($odu1_is_powered){
        display_text_position(OID_Mappings::$odu1_model, $left);
      }
      else {
        display_left_label("-");
      }
    } else {
      if ($odu2_is_powered){
        display_text_position(OID_Mappings::$odu2_model, $left);
      }
      else{
        display_left_label("-");
      }
    }
    enclose_content_table_row();
    
    // Radio Power
    display_none_shaded_row();
    display_parameter_name_width("Radio Power:", "10%");
    if ($is_rf2_virtual) {
      display_parameter_name((CustomDataRetrieval::pullSysOID($odupower1_oid) == 0) ? 'Off' : 'On');
    }
    else{
      echo '<form name="linksetup_power_rf2" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return true">';
      display_radio_on_off_left_submit("LOduPower2", $odupower2_oid);
      echo '</form>';
    }
    enclose_content_table_row();
    
    // T/R Spacing (MHz)
    display_none_shaded_row();
    display_parameter_name_width("T/R Spacing (MHz):", "10%");
    if ($odu2_is_detected && $isDuplexEnabled2 && !$is_tr_space_same && $odu2_is_powered) {
      if (!$is_nitro) {
        // limits
        $configFlashPath = '/mnt/usrcfg/rfm2_flash.txt';
        $parsedValues = parseRfmDpFiles($configFlashPath);
        // Assign the parsed values to individual variables with error handling
        $freq2DuplexMin = isset($parsedValues['FREQ_DUPLEX_MIN']) ? $parsedValues['FREQ_DUPLEX_MIN'] / 1000 : 2.2250738585072e-50;
        $freq2DuplexMax = isset($parsedValues['FREQ_DUPLEX_MAX']) ? $parsedValues['FREQ_DUPLEX_MAX'] / 1000 : 1.7976931348623e+50;
      }
      else{
        //$isUpperFreq = CustomDataRetrieval::pullSysOID(OID_Mappings::$modem2_freq_hi_low);
        $freq2 = CustomDataRetrieval::pullSysODU2TXFrequency();
        if ($freq2 > $freqRx2Max) {
          $freq2DuplexMin = $freq2 - $freqRx2Max;
          $freq2DuplexMax = $freq2 - $freqRx2Min;
        }
        else{
          $freq2DuplexMin = $freqRx2Min - $freq2;
          $freq2DuplexMax = $freqRx2Max - $freq2;
        }
      }
      $freq2DuplexMin = number_format($freq2DuplexMin, 2, '.', '');
      $freq2DuplexMax = number_format($freq2DuplexMax, 2, '.', '');
      $validRangeTRSpacing2 = "T/R Spacing (MHz) range is [" . $freq2DuplexMin . " - " . $freq2DuplexMax . "]";
      echo '<form name="linksetup_spacing_rf2" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return checkSpaceDuplexRF2();">';
      echo '<div style="display: flex; align-items: center; gap: 10px;">';
      set_radio_param($odu2_duplex_oid, "FreqDuplex2", $float_val, $left, "inputtext", $validRangeTRSpacing2);
      echo '<input type="submit" name="radio_submit" class="submit_button_small" value="Apply Changes" style="margin-left: 15px;">';
      echo '</div>';
      echo '</form>';
    } else if ($odu2_is_powered) {
      $duplex2 = CustomDataRetrieval::pullSysODU2Duplex();
      display_parameter_name($duplex2);
    }
    else{
      display_left_label("-");
    }
    enclose_content_table_row();
    
    // Tx Frequency (MHz)
    display_none_shaded_row();
    display_parameter_name_width("Tx Frequency (MHz):", "10%");
    
    if ($odu2_is_detected && !$is_tx_freq_same && $odu2_is_powered) {
      echo '<form name="linksetup_freq_rf2" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return checkFrequencyRF2();">';
      $validRangeTx2 = "Valid Tx Frequency (MHz) range is [" . $freq2Min . " - " . $freq2Max . "]";
      echo '<div style="display: flex; align-items: center; gap: 10px;">';
      set_radio_param($txfreq2_oid, "TxFrequency2", $float_val, $left, "inputtext", $validRangeTx2);
      echo '<input type="submit" name="radio_submit" class="submit_button_small" value="Apply Changes" style="margin-left: 15px;">';
      echo '</div>';
      echo '</form>';
    } else if ($odu2_is_powered) {
      $freq2 = CustomDataRetrieval::pullSysODU2TXFrequency();
      display_parameter_name($freq2);
    }
    else{
      display_left_label("-");
    }
    enclose_content_table_row();
    
    
    // Rx Frequency (MHz)
    display_none_shaded_row();
    display_parameter_name_width("Rx Frequency (MHz):", "10%");
    $odu2_is_powered?display_text_position($rxfreq2_oid, $left):display_left_label("-");
    enclose_content_table_row();
    
    // Tx Power (dBm)
    display_none_shaded_row();
    display_parameter_name_width("Tx Power (dBm):", "10%");
    
    if ($atpc == 0 && $odu2_is_detected && !$is_tx_pwr_same && $odu2_is_powered) {
      if ($is_rf2_virtual) {
        $power2Min = CustomDataRetrieval::pullSysOID(OID_Mappings::$odu2_power_min);
        $current_tx_power1 = CustomDataRetrieval::pullSysODU1TXPower();
        $power2Min = max($current_tx_power1 - 8.0, $power2Min);
        $power2Max = $current_tx_power1;
      }
      
      $validTxPower2 = "Valid Tx Power (dBm) range is [" . $power2Min . " - " . $power2Max . "]";
      echo '<form name="linksetup_tx_power_rf2" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return checkTxPowerRF2();">';
      echo '<div style="display: flex; align-items: center; gap: 10px;">';
      set_radio_param($power2_oid, "TxPower2", $float_val, $left, "inputtext", $validTxPower2);
      echo '<input type="submit" name="radio_submit" class="submit_button_small" value="Apply Changes" style="margin-left: 15px;">';
      echo '</div>';
      echo '</form>';
    } else if ($odu2_is_powered) {
      display_parameter_name(CustomDataRetrieval::pullSysODU2TXPower());
    }
    else{
      display_left_label("-");
    }
    enclose_content_table_row();
    
    // Transmitter
    display_none_shaded_row();
    display_parameter_name_width("Transmitter:", "10%");
    if ($odu2_is_detected && !$is_rf2_virtual && $odu2_is_powered) {
      echo '<form name="linksetup_transmitter_rf2" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return true">';
      display_radio_on_off_left_submit("LOpmode2", $opmode2_oid);
      echo '</form>';
    } else if ($odu2_is_powered) {
        display_parameter_name((CustomDataRetrieval::pullSysODURFModuleIsOn(2) == 0) ? 'Off' : 'On');
    }
    else{
      display_left_label("-");
    }
    enclose_content_table_row();
    
    // Polarization (if NitroModel)
    display_none_shaded_row();
    display_parameter_name_width("Polarization:", "10%");
    if ($odu2_is_powered){
      if (CustomHardware::isNitroModel()) {
        echo '<form name="linksetup_polarization_rf2" method="post" action="' . $_SERVER['PHP_SELF'] . '" onsubmit="return true;">';
        display_radio_polarization_left_submit("odu2_ant_pol", OID_Mappings::$odu2_ant_pol_oid);
        echo '</form>';
      } else {
        display_parameter_name(CustomUI::formatModemPolarizationForAll(CustomDataRetrieval::pullSysModemPolarization(2)));
      }
    } else{
      display_left_label("-");
    }
    
    enclose_content_table_row();
    
  } else {
    //display_none_shaded_row();
    echo '<td nowrap="nowrap" width="15%" bgcolor=#f2f2f2 align="left"><font face="Trebuchet MS, Arial, Helvetica" size="2" color=#00478F></td>';
    display_page_subtitle("");
    //echo '<td width="10%"></td>';
    //enclose_content_table_row();
  }
  display_none_shaded_row();
  
  echo '<td colspan="4">--------------------------------------------------------------------------------------------------------------</td>';
  display_block_row();
  
  enclose_content_table();
  display_content_table_no_border();
  
  echo '<tr><td colspan="18" height="25">';
  
  // Flex container with slight right alignment
  echo '<div style="display: flex; justify-content: flex-start; gap: 10px; padding-left: 25%; ">'; // Adjust padding-left as needed
  
  // Save Changes button
  echo '<form method="post" name="config_save" action="submit_option.php?name=' . $_SERVER["PHP_SELF"] . '&option=4&oid=' . $config_option_oid . '">';
  echo '<input type="submit" name="save_submit" class="submit_button" value="Save Changes" onclick="return confirmChanges()" style="font-size: 12px; padding: 4px 8px;">';
  echo '</form>';
  
  // Reboot button with conditional
  echo '<form method="post" name="reboot" action="submit_option.php?name=upgrade.php&option=1&oid=' . $reboot_oid . '">';
  echo '<input type="submit" name="reboot_submit" class="submit_button" style="border-color:#ff0000; font-size: 12px; padding: 4px 8px;" value="Reboot" onClick="return confirmReboot()">';
  echo '</form>';
  
  // Help button
  echo '<form method="post" name="help" target="_blank" action="freq_limits.php">';
  echo '<input type="submit" name="help_submit" class="submit_button" value="Help" style="font-size: 12px; padding: 4px 8px;">';
  echo '</form>';
  
  // Close the flex container
  echo '</div>';
  
  echo '</td></tr>';
  
  echo '<p>';
  echo '<div id="input-text">';
  $config_info = "/mnt/usrcfg/config.bin";
  enclose_content_table_row();
  enclose_content_table();
  
  display_content_table_no_border();
  echo '<tr height="10"></tr>';
  
  display_none_shaded_row();
  display_note_section("<strong>The display will revert back to View Mode after 5 mins of inactivity.</strong>");
  enclose_content_table_row();
  
  display_footer();
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo '<script>window.location.href = window.location.href;</script>';
    exit();
  }
  
  // Display alert if either message is not empty
  if (!empty($odu1_check_message) || !empty($odu2_check_message)) {
    echo '<script language="JavaScript">';
    echo 'alert("' . addslashes($odu1_check_message) . ' ' . addslashes($odu2_check_message) . '");';
    echo '</script>';
  }

?>

<script src="jquerymin.js"></script>
<script language="JavaScript">

  function alertPolarization() {
    var sysconfig_value = <?php echo $sysconfig; ?>;
    var is_xpic = sysconfig_value == 3;
    var is_mimo = sysconfig_value == 4;
    if (is_xpic || is_mimo) {
      alert("For XPIC/MIMO operation make sure RF1 is V pol and RF2 is H pol on both ends of link.");
    }
    return true;
  }

  function alertFreqMismatch($radio) {
    var sysconfig_value = <?php echo $sysconfig; ?>;
    var bw_value = <?php echo $bandwidthValue; ?>;
    var is_2_0 = sysconfig_value == 2;
    var is_2_0_sp = sysconfig_value == 6;
    var is_half_xpic_sp = sysconfig_value == 7;
    if (is_half_xpic_sp || is_2_0_sp || is_2_0) {
      var freq1_val = document.getElementById("TxFrequency1") ? document.getElementById("TxFrequency1").value : <?php echo $current_tx_frequency1; ?>;
      var freq2_val = document.getElementById("TxFrequency2") ? document.getElementById("TxFrequency2").value : <?php echo $current_tx_frequency2; ?>;
      if ((is_half_xpic_sp || is_2_0_sp) && (freq2_val - freq1_val) < bw_value) {
        alert("For 2+0 SP and Half XPIC SP, the RF2 TX frequency must be at least one channel bandwidth higher.");
        return false;
      }
      else if (is_2_0 && Math.abs(freq1_val - freq2_val) < 0.01){
        alert("For 2+0, the RF1 and RF2 TX frequencies must not overlap.");
        return false;
      }
    }
    
    if ($radio === 1){
      var freq1_val = document.getElementById("TxFrequency1") ? document.getElementById("TxFrequency1").value : <?php echo $current_tx_frequency1; ?>;
      var freq1_max_val_suggested = <?php echo $freq1MaxSuggested; ?>;
      var freq1_min_val_suggested = <?php echo $freq1MinSuggested; ?>;
      if (freq1_val < freq1_min_val_suggested || freq1_val > freq1_max_val_suggested){
        alert("Caution: Channel edge is at or exceeds the range of the radio section and performance may be affected.");
      }
    }
    else if ($radio === 2){
      var freq2_val = document.getElementById("TxFrequency2") ? document.getElementById("TxFrequency2").value : <?php echo $current_tx_frequency2; ?>;
      var freq2_max_val_suggested = <?php echo $freq2MaxSuggested; ?>;
      var freq2_min_val_suggested = <?php echo $freq2MinSuggested; ?>;
      if (freq2_val < freq2_min_val_suggested || freq2_val > freq2_max_val_suggested){
        alert("Caution: Channel edge is at or exceeds the range of the radio section and performance may be affected.");
      }
    }
    return true;
  }

  function validateParameterRange(parameterName, value, minValue, maxValue) {
    if (value < minValue || value > maxValue) {
      alert(parameterName + " must be in the range [" + minValue + ", " + maxValue + "]");
      return false;
    }
    return true;
  }

  function checkParameter(parameterName, elementId, minValue, maxValue, confirmMessage) {
    if (confirm(confirmMessage)) {
      var value = document.getElementById(elementId).value;
      if (!validateParameterRange(parameterName, value, minValue, maxValue)) {
        return false;
      }
      return true;
    } else {
      return false;
    }
  }

  function checkFrequencyRF1() {
    return checkParameter(
      "Tx Frequency for RF1",
      "TxFrequency1",
      <?php echo $freq1Min; ?>,
      <?php echo $freq1Max; ?>,
      "New RF1 TX Frequency setting applied. Check remote end of link to make sure TX freq matches the local RX freq shown here. Click 'Save Changes' button below to make change effective after reboot."
    ) && alertFreqMismatch(1);
  }

  function checkFrequencyRF2() {
    return checkParameter(
      "Tx Frequency for RF2",
      "TxFrequency2",
      <?php echo $freq2Min; ?>,
      <?php echo $freq2Max; ?>,
      "New RF2 TX Frequency setting applied. Check remote end of link to make sure TX freq matches the local RX freq shown here. Click 'Save Changes' button below to make change effective after reboot."
    ) && alertFreqMismatch(2);
  }

  function checkSpaceDuplexRF1() {
    return checkParameter(
      "T/R Spacing for RF1",
      "FreqDuplex1",
      <?php echo $freq1DuplexMin; ?>,
      <?php echo $freq1DuplexMax; ?>,
      "New RF1 T/R Spacing(Freq Duplex) setting applied. Click 'Save Changes' button below to make change effective after reboot."
    );
  }

  function checkSpaceDuplexRF2() {
    return checkParameter(
      "T/R Spacing for RF2",
      "FreqDuplex2",
      <?php echo $freq2DuplexMin; ?>,
      <?php echo $freq2DuplexMax; ?>,
      "New RF2 T/R Spacing(Freq Duplex) setting applied. Click 'Save Changes' button below to make change effective after reboot."
    );
  }

  function checkTxPowerRF1() {
    return checkParameter(
      "TX Power for RF1",
      "TxPower1",
      <?php echo $power1Min; ?>,
      <?php echo $power1Max; ?>,
      "New RF1 TX Power setting applied. Click 'Save Changes' button below to make change effective after reboot."
    );
  }

  function checkTxPowerRF2() {
    return checkParameter(
      "TX Power for RF2",
      "TxPower2",
      <?php echo $power2Min; ?>,
      <?php echo $power2Max; ?>,
      "New RF2 TX Power setting applied. Click 'Save Changes' button below to make change effective after reboot."
    );
  }

  function confirmSysConfig() {
    return confirm("New system configuration and speed require rebooting to become active.");
  }

  $(window).load(function () {
    $('#loading').hide();
  });

  window.onbeforeunload = function () {
    $('#loading').show();
  };

</script>
