<?php
$show_bad_header_js = false;
require_once(dirname(__FILE__)."/../config.php");
require_once(dirname(__FILE__)."/../v2-2021/data-retrieval.php");
$number_of_channels = CustomCapabilities::getNumberOfChannels();
if ($number_of_channels == 1){
    $oids = [
        OID_Mappings::$modem1_lock_status,
        OID_Mappings::$odu1_rssi,
        OID_Mappings::$modem1_mse,
        OID_Mappings::$modem1_ACMRx_profile,
        OID_Mappings::$remote1_lock_status,
        OID_Mappings::$remote1_rssi,
        OID_Mappings::$remote1_mse,
        OID_Mappings::$remote1_rx,
    ];
}
else{
    $oids = [
        OID_Mappings::$modem1_lock_status,
        OID_Mappings::$odu1_rssi,
        OID_Mappings::$modem1_mse,
        OID_Mappings::$modem1_ACMRx_profile,
        OID_Mappings::$remote1_lock_status,
        OID_Mappings::$remote1_rssi,
        OID_Mappings::$remote1_mse,
        OID_Mappings::$remote1_rx,
        OID_Mappings::$modem2_lock_status,
        OID_Mappings::$odu2_rssi,
        OID_Mappings::$modem2_mse,
        OID_Mappings::$modem2_ACMRx_profile,
        OID_Mappings::$remote2_lock_status,
        OID_Mappings::$remote2_rssi,
        OID_Mappings::$remote2_mse,
        OID_Mappings::$remote2_rx
    ];
}
$result = getSnmpBulkResult($oids);

?>
<style>
    #table-clr-stats td {
        font-family: Trebuchet MS, Arial, Helvetica, serif;
        font-size: 12px;
        font-weight: bold;
        color: #99ccff;
    }
    .table-link-ok {
        color: rgb(51, 204, 51) !important;
    }
    .table-link-ko {
        color: rgb(202, 91, 91) !important;
    }
</style>
<table id="table-clr-stats">
    <?php if ($number_of_channels == 1): ?>
        <tr>
            <td>Local Link: <?php echo $result[0]== 1 ? '<span class="table-link-ok">Locked</span>': '<span class="table-link-ko">No lock</span>'; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;RSSI: <?php echo $result[1]; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;MSE: <?php echo $result[2]; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;Rx: <?php echo CustomDataRetrieval::getMappings($result[3]); ?></td>
        </tr>
        <tr>
            <td>Remote Link: <?php echo $result[0]== 1 && $result[4] == 1 ? '<span class="table-link-ok">Locked</span>': '<span class="table-link-ko">No lock</span>'; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;RSSI: <?php echo $result[0]== 1 && $result[4] == 1 ? $result[5]:"0.00"; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;MSE: <?php echo $result[0]== 1 && $result[4] == 1 ? $result[6]:"0.00"; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;Rx: <?php echo $result[0]== 1 && $result[4] == 1 ? CustomDataRetrieval::getMappings($result[7]):"QPSK"; ?></td>
        </tr>
    <?php else: ?>
        <tr>
            <td>Local Link 1: <?php echo $result[0]== 1 ? '<span class="table-link-ok">Locked</span>': '<span class="table-link-ko">No lock</span>'; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;RSSI: <?php echo $result[1]; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;MSE: <?php echo $result[2]; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;Rx: <?php echo CustomDataRetrieval::getMappings($result[3]);  ?></td>
        </tr>
      <tr>
        <td>Remote Link: <?php echo $result[0]== 1 && $result[4] == 1 ? '<span class="table-link-ok">Locked</span>': '<span class="table-link-ko">No lock</span>'; ?></td>
        <td>&nbsp;&nbsp;&nbsp;&nbsp;RSSI: <?php echo $result[0]== 1 && $result[4] == 1 ? $result[5]:"0.00"; ?></td>
        <td>&nbsp;&nbsp;&nbsp;&nbsp;MSE: <?php echo $result[0]== 1 && $result[4] == 1 ? $result[6]:"0.00"; ?></td>
        <td>&nbsp;&nbsp;&nbsp;&nbsp;Rx: <?php echo $result[0]== 1 && $result[4] == 1 ? CustomDataRetrieval::getMappings($result[7]):"QPSK"; ?></td>
      </tr>
        <tr>
            <td>Local Link 2: <?php echo $result[8]== 1 ? '<span class="table-link-ok">Locked</span>': '<span class="table-link-ko">No lock</span>'; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;RSSI: <?php echo $result[9]; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;MSE: <?php echo $result[10]; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;Rx: <?php echo CustomDataRetrieval::getMappings($result[11]); ?></td>
        </tr>
        <tr>
            <td>Remote Link 2: <?php echo $result[8]== 1 && $result[12]== 1 ? '<span class="table-link-ok">Locked</span>': '<span class="table-link-ko">No lock</span>'; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;RSSI: <?php echo $result[8]== 1 && $result[12]== 1 ? $result[13]:"0.00"; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;MSE: <?php echo $result[8]== 1 && $result[12]== 1 ? $result[14]: "0.00"; ?></td>
            <td>&nbsp;&nbsp;&nbsp;&nbsp;Rx: <?php echo $result[8]== 1 && $result[12]== 1 ? CustomDataRetrieval::getMappings($result[15]):"QPSK"; ?></td>
        </tr>
    <?php endif; ?>
</table>