<?php
 require_once 'phplot.php';

 $option = $_POST["rssi_plot"];

 if($option == 1)
   $filename = '/mnt/mmcblk0p3/tmp/day_periodic.log';
 elseif(($option == 2) || ($option == 3))
   $filename = '/mnt/mmcblk0p3/tmp/week_periodic.log';
 else
   $filename = '/mnt/mmcblk0p3/tmp/month_periodic.log';

 $file = '/mnt/syscfg/omu_model.conf';
 $fp = fopen($file, "r");
 $model = fgets($fp);
 fclose($fp);
  
 $flag = 0;
 if((strcmp($model, "SP24-SI") == NULL) || (strcmp($model, "SP24-SI-N") == NULL))
 {
   if($option == 1)
   {
     if($handle = fopen($filename, "r")) 
     {
       $data = array();
       $count=0;

       while($info = fscanf($handle, "%d %f %f\n"))
       {
	 list($counter, $rssi, $mse) = $info;
	 $val = ($count*30)/3600;
	 array_push($data, array('', $val, $rssi, $mse));
	 $count++;
       } 
     }
     else
     {
       echo '</br><b>Unable to open statistics file!</b>';
       return;
     } 
   }
   elseif(($option == 2) || ($option == 4))
   {
     $rssi_max = -90.00;
     $rssi_min = 0;
     $rssi_avg = 0;
     $inc = 0;	
     if($handle = fopen($filename, "r")) 
     {
       $data = array();
       $count=0;

       while($info = fscanf($handle, "%d %f %f\n"))
       {
	  list($counter, $rssi, $mse) = $info;
	  if($count < 120)
	  {
		if($rssi_max < $rssi)
		  $rssi_max = $rssi;
		if($rssi_min > $rssi)
		  $rssi_min = $rssi;
		$rssi_avg += $rssi;
		$count++;	   
	  }
	  else
	  {
		$rssi_avg = $rssi_avg/120;
		array_push($data, array('', (int)$inc/24, $rssi_max, $rssi_min, $rssi_avg ));
		$count = 0;
		$rssi_max = -90;
		$rssi_min = 0;
		$rssi_avg = 0;
		$inc++;
	  }
     	} 
      }
      else
      {
        echo '</br><b>Unable to open statistics file!</b>';
        return;
      }
   }
   elseif(($option == 3) || ($option == 5))
   {
     $mse_max = -90.00;
     $mse_min = 0;
     $mse_avg = 0;
     $inc = 0;	
     if($handle = fopen($filename, "r")) 
     {
       $data = array();
       $count=0;
       while($info = fscanf($handle, "%d %f %f\n"))
       {
	 list($counter, $rssi, $mse) = $info;
	 if($count < 120)
	 {
		if($mse_max < $mse)
		  $mse_max = $mse;
		if($mse_min > $mse)
		  $mse_min = $mse;
		$mse_avg += $mse;
		$count++;	   
	 }
	 else
	 {
		$mse_avg = $mse_avg/120;
		array_push($data, array('', (int)$inc/24, $mse_max, $mse_min, $mse_avg ));
		$count = 0;
		$mse_max = -90;
		$mse_min = 0;
		$mse_avg = 0;
		$inc++;
	 }
       } 
     }
     else
     {
       echo '</br><b>Unable to open statistics file!</b>';
       return;
     }
   }
 }
 else
 {
   $flag = 1;
   if($option == 1)
   {
     if($handle = fopen($filename, "r")) 
     {
       $data = array();
       $count=0;

       while($info = fscanf($handle, "%d %f %f %f %f\n"))
       {
	 list($counter, $rssi0, $rssi1, $mse0, $mse1) = $info;
	 $val = ($count*30)/3600;
	 array_push($data, array('', $val, $rssi0, $rssi1, $mse0, $mse1));
	 $count++;
       }
     }
     else
     {
       echo '</br><b>Unable to open statistics file!</b>';
       return;
     } 
   }
   elseif(($option == 2) || ($option == 6))
   {
     $rssi_max = -90.00;
     $rssi_min = 0;
     $rssi_avg = 0;
     $inc = 0;	
     if($handle = fopen($filename, "r")) 
     {
       $data = array();
       $count=0;

       while($info = fscanf($handle, "%d %f %f %f %f\n"))
       {
	  list($counter, $rssi0, $rssi1, $mse0, $mse1) = $info;
	  if($count < 120)
	  {
		if($rssi_max < $rssi0)
		  $rssi_max = $rssi0;
		if($rssi_min > $rssi0)
		  $rssi_min = $rssi0;
		$rssi_avg += $rssi0;
		$count++;	   
	  }
	  else
	  {
		$rssi_avg = $rssi_avg/120;
		array_push($data, array('', (int)$inc/24, $rssi_max, $rssi_min, $rssi_avg ));
		$count = 0;
		$rssi_max = -90;
		$rssi_min = 0;
		$rssi_avg = 0;
		$inc++;
	  }
     	}
     } 	
     else
     {
       echo '</br><b>Unable to open statistics file!</b>';
       return;
     }
   }
   elseif(($option == 3) || ($option == 7))
   {
     $rssi_max = -90.00;
     $rssi_min = 0;
     $rssi_avg = 0;
     $inc = 0;	
     if($handle = fopen($filename, "r")) 
     {
       $data = array();
       $count=0;

       while($info = fscanf($handle, "%d %f %f %f %f\n"))
       {
	  list($counter, $rssi0, $rssi1, $mse0, $mse1) = $info;
	  if($count < 120)
	  {
		if($rssi_max < $rssi1)
		  $rssi_max = $rssi1;
		if($rssi_min > $rssi1)
		  $rssi_min = $rssi1;
		$rssi_avg += $rssi1;
		$count++;	   
	  }
	  else
	  {
		$rssi_avg = $rssi_avg/120;
		array_push($data, array('', (int)$inc/24, $rssi_max, $rssi_min, $rssi_avg ));
		$count = 0;
		$rssi_max = -90;
		$rssi_min = 0;
		$rssi_avg = 0;
		$inc++;
	  }
     	}
     } 	
     else
     {
       echo '</br><b>Unable to open statistics file!</b>';
       return;
     }
   }
   elseif(($option == 4) || ($option == 8))
   {
     $mse_max = -90.00;
     $mse_min = 0;
     $mse_avg = 0;
     $inc = 0;	
     if($handle = fopen($filename, "r")) 
     {
       $data = array();
       $count=0;
       while($info = fscanf($handle, "%d %f %f %f %f\n"))
       {
	 list($counter, $rssi0, $rssi1, $mse0, $mse1) = $info;
	 if($count < 120)
	 {
		if($mse_max < $mse0)
		  $mse_max = $mse0;
		if($mse_min > $mse0)
		  $mse_min = $mse0;
		$mse_avg += $mse0;
		$count++;	   
	 }
	 else
	 {
		$mse_avg = $mse_avg/120;
		array_push($data, array('', (int)$inc/24, $mse_max, $mse_min, $mse_avg ));
		$count = 0;
		$mse_max = -90;
		$mse_min = 0;
		$mse_avg = 0;
		$inc++;
	 }
       } 
     }
     else
     {
       echo '</br><b>Unable to open statistics file!</b>';
       return;
     }
   }
   elseif(($option == 5) || ($option == 9))
   {
     $mse_max = -90.00;
     $mse_min = 0;
     $mse_avg = 0;
     $inc = 0;	
     if($handle = fopen($filename, "r")) 
     {
       $data = array();
       $count=0;
       while($info = fscanf($handle, "%d %f %f %f %f\n"))
       {
	 list($counter, $rssi0, $rssi1, $mse0, $mse1) = $info;
	 if($count < 120)
	 {
		if($mse_max < $mse1)
		  $mse_max = $mse1;
		if($mse_min > $mse1)
		  $mse_min = $mse1;
		$mse_avg += $mse1;
		$count++;	   
	 }
	 else
	 {
		$mse_avg = $mse_avg/120;
		array_push($data, array('', (int)$inc/24, $mse_max, $mse_min, $mse_avg ));
		$count = 0;
		$mse_max = -90;
		$mse_min = 0;
		$mse_avg = 0;
		$inc++;
	 }
       } 
     }
     else
     {
       echo '</br><b>Unable to open statistics file!</b>';
       return;
     }
   }
 }

  //Define the object
  $plot = new PHPlot(900,600);
  $plot->SetDataType('data-data');
  $plot->SetPlotType('lines');
  //$plot->SetPrintImage(False);

  $plot->SetDataValues($data);
  //Turn off X axis ticks and labels because they get in the way:
  //$plot->SetXTickLabelPos('none');
  //$plot->SetXTickPos('plotdown');
  //$plot->SetPlotAreaWorld(NULL, -90);
  $plot->TuneYAutoRange(0,'T',0.05);

 if($flag == 0)
 {
  if($option == 1)
  {
    $names = array('RSSI', 'MSE');
    $plot->SetDataColors(array('green','blue'));
    $plot->SetTitle('RSSI/MSE statistics every 24hrs');
    $plot->SetYTitle('RSSI(dBm)/MSE(dB)');
    $plot->SetXTitle('Time(hrs)');
  }
  elseif($option == 2)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('RSSI statistics for one week');
    $plot->SetYTitle('RSSI(dBm)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 3)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('MSE statistics for one week');
    $plot->SetYTitle('MSE(dB)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 4)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('RSSI statistics for 30 days');
    $plot->SetYTitle('RSSI(dBm)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 5)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('MSE statistics for 30 days');
    $plot->SetYTitle('MSE(dB)');
    $plot->SetXTitle('Days');
  }
 }
 else
 {
  if($option == 1)
  {
    $names = array('RSSI', 'MSE');
    $plot->SetDataColors(array('green','blue'));
    $plot->SetTitle('RSSI/MSE statistics every 24hrs');
    $plot->SetYTitle('RSSI(dBm)/MSE(dB)');
    $plot->SetXTitle('Time(hrs)');
  }
  elseif($option == 2)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('RSSI0 statistics for one week');
    $plot->SetYTitle('RSSI(dBm)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 3)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('RSSI1 statistics for one week');
    $plot->SetYTitle('RSSI(dBm)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 4)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('MSE0 statistics for one week');
    $plot->SetYTitle('MSE(dB)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 5)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('MSE1 statistics for one week');
    $plot->SetYTitle('MSE(dB)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 6)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('RSSI0 statistics for 30 days');
    $plot->SetYTitle('RSSI(dBm)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 7)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('RSSI1 statistics for 30 days');
    $plot->SetYTitle('RSSI(dBm)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 8)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('MSE0 statistics for 30 days');
    $plot->SetYTitle('MSE(dB)');
    $plot->SetXTitle('Days');
  }
  elseif($option == 9)
  {
    $names = array('max', 'min', 'avg');
    $plot->SetDataColors(array('red', 'green', 'blue'));
    $plot->SetTitle('MSE1 statistics for 30 days');
    $plot->SetYTitle('MSE(dB)');
    $plot->SetXTitle('Days');
  }
 } 

  $plot->SetLegend($names);
  $plot->SetMarginsPixels(100);
  $plot->SetDrawXGrid('True');

  //Draw it
  $plot->DrawGraph();

?>		  
