/*
 Highstock JS v9.1.0 (2021-05-03)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(I){b(I);b.Highcharts=I;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function I(b,w,m,x){b.hasOwnProperty(w)||(b[w]=x.apply(null,m))}b=b?b._modules:{};I(b,"Core/Axis/NavigatorAxis.js",[b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,w){var m=b.isTouchDevice,x=w.addEvent,t=w.correctFloat,
F=w.defined,B=w.isNumber,D=w.pick,g=function(){function a(a){this.axis=a}a.prototype.destroy=function(){this.axis=void 0};a.prototype.toFixedRange=function(a,g,c,y){var p=this.axis,n=p.chart;n=n&&n.fixedRange;var O=(p.pointRange||0)/2;a=D(c,p.translate(a,!0,!p.horiz));g=D(y,p.translate(g,!0,!p.horiz));p=n&&(g-a)/n;F(c)||(a=t(a+O));F(y)||(g=t(g-O));.7<p&&1.3>p&&(y?a=g-n:g=a+n);B(a)&&B(g)||(a=g=void 0);return{min:a,max:g}};return a}();return function(){function a(){}a.compose=function(a){a.keepProps.push("navigatorAxis");
x(a,"init",function(){this.navigatorAxis||(this.navigatorAxis=new g(this))});x(a,"zoom",function(a){var c=this.chart.options,g=c.navigator,p=this.navigatorAxis,n=c.chart.pinchType,O=c.rangeSelector;c=c.chart.zoomType;this.isXAxis&&(g&&g.enabled||O&&O.enabled)&&("y"===c?a.zoomed=!1:(!m&&"xy"===c||m&&"xy"===n)&&this.options.range&&(g=p.previousZoom,F(a.newMin)?p.previousZoom=[this.min,this.max]:g&&(a.newMin=g[0],a.newMax=g[1],p.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()})};
a.AdditionsClass=g;return a}()});I(b,"Core/Axis/ScrollbarAxis.js",[b["Core/Utilities.js"]],function(b){var w=b.addEvent,m=b.defined,x=b.pick;return function(){function b(){}b.compose=function(b,B){var D=function(g){var a=x(g.options&&g.options.min,g.min),b=x(g.options&&g.options.max,g.max);return{axisMin:a,axisMax:b,scrollMin:m(g.dataMin)?Math.min(a,g.min,g.dataMin,x(g.threshold,Infinity)):a,scrollMax:m(g.dataMax)?Math.max(b,g.max,g.dataMax,x(g.threshold,-Infinity)):b}};w(b,"afterInit",function(){var g=
this;g.options&&g.options.scrollbar&&g.options.scrollbar.enabled&&(g.options.scrollbar.vertical=!g.horiz,g.options.startOnTick=g.options.endOnTick=!1,g.scrollbar=new B(g.chart.renderer,g.options.scrollbar,g.chart),w(g.scrollbar,"changed",function(a){var b=D(g),r=b.axisMax,c=b.scrollMin,y=b.scrollMax-c;m(b.axisMin)&&m(r)&&(g.horiz&&!g.reversed||!g.horiz&&g.reversed?(b=c+y*this.to,c+=y*this.from):(b=c+y*(1-this.from),c+=y*(1-this.to)),this.shouldUpdateExtremes(a.DOMType)?g.setExtremes(c,b,!0,"mousemove"!==
a.DOMType&&"touchmove"!==a.DOMType,a):this.setRange(this.from,this.to))}))});w(b,"afterRender",function(){var g=D(this),a=g.scrollMin,b=g.scrollMax;g=this.scrollbar;var r=this.axisTitleMargin+(this.titleOffset||0),c=this.chart.scrollbarsOffsets,y=this.options.margin||0;g&&(this.horiz?(this.opposite||(c[1]+=r),g.position(this.left,this.top+this.height+2+c[1]-(this.opposite?y:0),this.width,this.height),this.opposite||(c[1]+=y),r=1):(this.opposite&&(c[0]+=r),g.position(this.left+this.width+2+c[0]-(this.opposite?
0:y),this.top,this.width,this.height),this.opposite&&(c[0]+=y),r=0),c[r]+=g.size+g.options.margin,isNaN(a)||isNaN(b)||!m(this.min)||!m(this.max)||this.min===this.max?g.setRange(0,1):(c=(this.min-a)/(b-a),a=(this.max-a)/(b-a),this.horiz&&!this.reversed||!this.horiz&&this.reversed?g.setRange(c,a):g.setRange(1-a,1-c)))});w(b,"afterGetOffset",function(){var g=this.horiz?2:1,a=this.scrollbar;a&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[g]+=a.size+a.options.margin)})};return b}()});I(b,
"Core/Scrollbar.js",[b["Core/Axis/Axis.js"],b["Core/Globals.js"],b["Core/Color/Palette.js"],b["Core/Axis/ScrollbarAxis.js"],b["Core/Utilities.js"],b["Core/Options.js"]],function(b,w,m,x,t,F){var B=t.addEvent,D=t.correctFloat,g=t.defined,a=t.destroyObjectProperties,v=t.fireEvent,r=t.merge,c=t.pick,y=t.removeEvent;t=F.defaultOptions;var p=w.isTouchDevice,n=w.swapXY=function(a,e){e&&a.forEach(function(e){for(var l=e.length,q,a=0;a<l;a+=2)q=e[a+1],"number"===typeof q&&(e[a+1]=e[a+2],e[a+2]=q)});return a};
F=function(){function b(e,q,l){this._events=[];this.from=this.chartY=this.chartX=0;this.scrollbar=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions={};this.y=this.x=0;this.chart=l;this.options=q;this.renderer=l.renderer;this.init(e,q,l)}b.prototype.addEvents=function(){var e=this.options.inverted?[1,0]:[0,
1],q=this.scrollbarButtons,l=this.scrollbarGroup.element,a=this.track.element,n=this.mouseDownHandler.bind(this),b=this.mouseMoveHandler.bind(this),c=this.mouseUpHandler.bind(this);e=[[q[e[0]].element,"click",this.buttonToMinClick.bind(this)],[q[e[1]].element,"click",this.buttonToMaxClick.bind(this)],[a,"click",this.trackClick.bind(this)],[l,"mousedown",n],[l.ownerDocument,"mousemove",b],[l.ownerDocument,"mouseup",c]];w.hasTouch&&e.push([l,"touchstart",n],[l.ownerDocument,"touchmove",b],[l.ownerDocument,
"touchend",c]);e.forEach(function(e){B.apply(null,e)});this._events=e};b.prototype.buttonToMaxClick=function(e){var q=(this.to-this.from)*c(this.options.step,.2);this.updatePosition(this.from+q,this.to+q);v(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:e})};b.prototype.buttonToMinClick=function(e){var q=D(this.to-this.from)*c(this.options.step,.2);this.updatePosition(D(this.from-q),D(this.to-q));v(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:e})};
b.prototype.cursorToScrollbarPosition=function(e){var q=this.options;q=q.minWidth>this.calculatedWidth?q.minWidth:0;return{chartX:(e.chartX-this.x-this.xOffset)/(this.barWidth-q),chartY:(e.chartY-this.y-this.yOffset)/(this.barWidth-q)}};b.prototype.destroy=function(){var e=this.chart.scroller;this.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(e){this[e]&&this[e].destroy&&(this[e]=this[e].destroy())},this);e&&this===e.scrollbar&&(e.scrollbar=null,
a(e.scrollbarButtons))};b.prototype.drawScrollbarButton=function(e){var a=this.renderer,l=this.scrollbarButtons,G=this.options,b=this.size;var c=a.g().add(this.group);l.push(c);c=a.rect().addClass("highcharts-scrollbar-button").add(c);this.chart.styledMode||c.attr({stroke:G.buttonBorderColor,"stroke-width":G.buttonBorderWidth,fill:G.buttonBackgroundColor});c.attr(c.crisp({x:-.5,y:-.5,width:b+1,height:b+1,r:G.buttonBorderRadius},c.strokeWidth()));c=a.path(n([["M",b/2+(e?-1:1),b/2-3],["L",b/2+(e?-1:
1),b/2+3],["L",b/2+(e?2:-2),b/2]],G.vertical)).addClass("highcharts-scrollbar-arrow").add(l[e]);this.chart.styledMode||c.attr({fill:G.buttonArrowColor})};b.prototype.init=function(e,a,l){this.scrollbarButtons=[];this.renderer=e;this.userOptions=a;this.options=r(b.defaultOptions,a);this.chart=l;this.size=c(this.options.size,this.options.height);a.enabled&&(this.render(),this.addEvents())};b.prototype.mouseDownHandler=function(e){e=this.chart.pointer.normalize(e);e=this.cursorToScrollbarPosition(e);
this.chartX=e.chartX;this.chartY=e.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};b.prototype.mouseMoveHandler=function(e){var a=this.chart.pointer.normalize(e),l=this.options.vertical?"chartY":"chartX",b=this.initPositions||[];!this.grabbedCenter||e.touches&&0===e.touches[0][l]||(a=this.cursorToScrollbarPosition(a)[l],l=this[l],l=a-l,this.hasDragged=!0,this.updatePosition(b[0]+l,b[1]+l),this.hasDragged&&v(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:e.type,
DOMEvent:e}))};b.prototype.mouseUpHandler=function(e){this.hasDragged&&v(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:e.type,DOMEvent:e});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};b.prototype.position=function(e,a,l,b){var q=this.options.vertical,n=0,c=this.rendered?"animate":"attr";this.x=e;this.y=a+this.trackBorderWidth;this.width=l;this.xOffset=this.height=b;this.yOffset=n;q?(this.width=this.yOffset=l=n=this.size,this.xOffset=a=0,this.barWidth=b-
2*l,this.x=e+=this.options.margin):(this.height=this.xOffset=b=a=this.size,this.barWidth=l-2*b,this.y+=this.options.margin);this.group[c]({translateX:e,translateY:this.y});this.track[c]({width:l,height:b});this.scrollbarButtons[1][c]({translateX:q?0:l-a,translateY:q?b-n:0})};b.prototype.removeEvents=function(){this._events.forEach(function(e){y.apply(null,e)});this._events.length=0};b.prototype.render=function(){var e=this.renderer,a=this.options,l=this.size,b=this.chart.styledMode,c;this.group=c=
e.g("scrollbar").attr({zIndex:a.zIndex,translateY:-99999}).add();this.track=e.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:a.trackBorderRadius||0,height:l,width:l}).add(c);b||this.track.attr({fill:a.trackBackgroundColor,stroke:a.trackBorderColor,"stroke-width":a.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=e.g().add(c);this.scrollbar=e.rect().addClass("highcharts-scrollbar-thumb").attr({height:l,
width:l,r:a.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=e.path(n([["M",-3,l/4],["L",-3,2*l/3],["M",0,l/4],["L",0,2*l/3],["M",3,l/4],["L",3,2*l/3]],a.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);b||(this.scrollbar.attr({fill:a.barBackgroundColor,stroke:a.barBorderColor,"stroke-width":a.barBorderWidth}),this.scrollbarRifles.attr({stroke:a.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%
2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};b.prototype.setRange=function(e,a){var l=this.options,b=l.vertical,c=l.minWidth,n=this.barWidth,q,p=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(g(n)){e=Math.max(e,0);var y=Math.ceil(n*e);this.calculatedWidth=q=D(n*Math.min(a,1)-y);q<c&&(y=(n-c+q)*e,q=c);c=Math.floor(y+this.xOffset+this.yOffset);n=q/2-.5;this.from=e;this.to=a;b?(this.scrollbarGroup[p]({translateY:c}),
this.scrollbar[p]({height:q}),this.scrollbarRifles[p]({translateY:n}),this.scrollbarTop=c,this.scrollbarLeft=0):(this.scrollbarGroup[p]({translateX:c}),this.scrollbar[p]({width:q}),this.scrollbarRifles[p]({translateX:n}),this.scrollbarLeft=c,this.scrollbarTop=0);12>=q?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===l.showFull&&(0>=e&&1<=a?this.group.hide():this.group.show());this.rendered=!0}};b.prototype.shouldUpdateExtremes=function(e){return c(this.options.liveRedraw,w.svg&&!w.isTouchDevice&&
!this.chart.isBoosting)||"mouseup"===e||"touchend"===e||!g(e)};b.prototype.trackClick=function(e){var a=this.chart.pointer.normalize(e),l=this.to-this.from,b=this.y+this.scrollbarTop,c=this.x+this.scrollbarLeft;this.options.vertical&&a.chartY>b||!this.options.vertical&&a.chartX>c?this.updatePosition(this.from+l,this.to+l):this.updatePosition(this.from-l,this.to-l);v(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:e})};b.prototype.update=function(e){this.destroy();this.init(this.chart.renderer,
r(!0,this.options,e),this.chart)};b.prototype.updatePosition=function(e,a){1<a&&(e=D(1-D(a-e)),a=1);0>e&&(a=D(a-e),e=0);this.from=e;this.to=a};b.defaultOptions={height:p?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:m.neutralColor20,barBorderWidth:1,barBorderColor:m.neutralColor20,buttonArrowColor:m.neutralColor80,buttonBackgroundColor:m.neutralColor10,buttonBorderColor:m.neutralColor20,buttonBorderWidth:1,rifleColor:m.neutralColor80,
trackBackgroundColor:m.neutralColor5,trackBorderColor:m.neutralColor5,trackBorderWidth:1};return b}();w.Scrollbar||(t.scrollbar=r(!0,F.defaultOptions,t.scrollbar),w.Scrollbar=F,x.compose(b,F));return w.Scrollbar});I(b,"Core/Navigator.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/Color/Color.js"],b["Core/Globals.js"],b["Core/Axis/NavigatorAxis.js"],b["Core/Options.js"],b["Core/Color/Palette.js"],b["Core/Scrollbar.js"],b["Core/Series/Series.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],
function(b,w,m,x,t,F,B,D,g,a,v){m=m.parse;var r=x.hasTouch,c=x.isTouchDevice,y=F.defaultOptions,p=v.addEvent,n=v.clamp,O=v.correctFloat,e=v.defined,q=v.destroyObjectProperties,l=v.erase,G=v.extend,M=v.find,K=v.isArray,H=v.isNumber,L=v.merge,E=v.pick,P=v.removeEvent,A=v.splat,u=function(h){for(var d=[],f=1;f<arguments.length;f++)d[f-1]=arguments[f];d=[].filter.call(d,H);if(d.length)return Math[h].apply(0,d)};F="undefined"===typeof a.seriesTypes.areaspline?"line":"areaspline";G(y,{navigator:{height:40,
margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:B.neutralColor5,borderColor:B.neutralColor40},maskFill:m(B.highlightColor60).setOpacity(.3).get(),outlineColor:B.neutralColor20,outlineWidth:1,series:{type:F,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,
25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:B.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",
style:{color:B.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});x.Renderer.prototype.symbols["navigator-handle"]=function(h,d,f,z,k){h=(k&&k.width||0)/2;d=Math.round(h/3)+.5;k=k&&k.height||0;return[["M",-h-1,.5],["L",h,.5],["L",h,k+.5],["L",-h-1,k+.5],["L",-h-1,.5],["M",-d,4],["L",-d,k-3],["M",d-1,4],["L",d-1,k-
3]]};var k=function(){function h(d){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(d)}h.prototype.drawHandle=function(d,f,z,h){var k=this.navigatorOptions.handles.height;this.handles[f][h](z?{translateX:Math.round(this.left+
this.height/2),translateY:Math.round(this.top+parseInt(d,10)+.5-k)}:{translateX:Math.round(this.left+parseInt(d,10)),translateY:Math.round(this.top+this.height/2-k/2-1)})};h.prototype.drawOutline=function(d,f,z,h){var k=this.navigatorOptions.maskInside,C=this.outline.strokeWidth(),e=C/2,a=C%2/2;C=this.outlineHeight;var u=this.scrollbarHeight||0,l=this.size,b=this.left-u,c=this.top;z?(b-=e,z=c+f+a,f=c+d+a,a=[["M",b+C,c-u-a],["L",b+C,z],["L",b,z],["L",b,f],["L",b+C,f],["L",b+C,c+l+u]],k&&a.push(["M",
b+C,z-e],["L",b+C,f+e])):(d+=b+u-a,f+=b+u-a,c+=e,a=[["M",b,c],["L",d,c],["L",d,c+C],["L",f,c+C],["L",f,c],["L",b+l+2*u,c]],k&&a.push(["M",d-e,c],["L",f+e,c]));this.outline[h]({d:a})};h.prototype.drawMasks=function(d,f,z,h){var k=this.left,C=this.top,a=this.height;if(z){var e=[k,k,k];var u=[C,C+d,C+f];var b=[a,a,a];var l=[d,f-d,this.size-f]}else e=[k,k+d,k+f],u=[C,C,C],b=[d,f-d,this.size-f],l=[a,a,a];this.shades.forEach(function(d,f){d[h]({x:e[f],y:u[f],width:b[f],height:l[f]})})};h.prototype.renderElements=
function(){var d=this,f=d.navigatorOptions,z=f.maskInside,h=d.chart,k=h.renderer,a,e={cursor:h.inverted?"ns-resize":"ew-resize"};d.navigatorGroup=a=k.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!z,z,!z].forEach(function(z,C){d.shades[C]=k.rect().addClass("highcharts-navigator-mask"+(1===C?"-inside":"-outside")).add(a);h.styledMode||d.shades[C].attr({fill:z?f.maskFill:"rgba(0,0,0,0)"}).css(1===C&&e)});d.outline=k.path().addClass("highcharts-navigator-outline").add(a);h.styledMode||d.outline.attr({"stroke-width":f.outlineWidth,
stroke:f.outlineColor});f.handles.enabled&&[0,1].forEach(function(z){f.handles.inverted=h.inverted;d.handles[z]=k.symbol(f.handles.symbols[z],-f.handles.width/2-1,0,f.handles.width,f.handles.height,f.handles);d.handles[z].attr({zIndex:7-z}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][z]).add(a);if(!h.styledMode){var C=f.handles;d.handles[z].attr({fill:C.backgroundColor,stroke:C.borderColor,"stroke-width":C.lineWidth}).css(e)}})};h.prototype.update=function(d){(this.series||
[]).forEach(function(d){d.baseSeries&&delete d.baseSeries.navigatorSeries});this.destroy();L(!0,this.chart.options.navigator,this.options,d);this.init(this.chart)};h.prototype.render=function(d,f,z,h){var k=this.chart,C=this.scrollbarHeight,a,u=this.xAxis,b=u.pointRange||0;var l=u.navigatorAxis.fake?k.xAxis[0]:u;var c=this.navigatorEnabled,q,A=this.rendered;var g=k.inverted;var p=k.xAxis[0].minRange,G=k.xAxis[0].options.maxRange;if(!this.hasDragged||e(z)){d=O(d-b/2);f=O(f+b/2);if(!H(d)||!H(f))if(A)z=
0,h=E(u.width,l.width);else return;this.left=E(u.left,k.plotLeft+C+(g?k.plotWidth:0));this.size=q=a=E(u.len,(g?k.plotHeight:k.plotWidth)-2*C);k=g?C:a+2*C;z=E(z,u.toPixels(d,!0));h=E(h,u.toPixels(f,!0));H(z)&&Infinity!==Math.abs(z)||(z=0,h=k);d=u.toValue(z,!0);f=u.toValue(h,!0);var y=Math.abs(O(f-d));y<p?this.grabbedLeft?z=u.toPixels(f-p-b,!0):this.grabbedRight&&(h=u.toPixels(d+p+b,!0)):e(G)&&O(y-b)>G&&(this.grabbedLeft?z=u.toPixels(f-G-b,!0):this.grabbedRight&&(h=u.toPixels(d+G+b,!0)));this.zoomedMax=
n(Math.max(z,h),0,q);this.zoomedMin=n(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(z,h),0,q);this.range=this.zoomedMax-this.zoomedMin;q=Math.round(this.zoomedMax);z=Math.round(this.zoomedMin);c&&(this.navigatorGroup.attr({visibility:"visible"}),A=A&&!this.hasDragged?"animate":"attr",this.drawMasks(z,q,g,A),this.drawOutline(z,q,g,A),this.navigatorOptions.handles.enabled&&(this.drawHandle(z,0,g,A),this.drawHandle(q,1,g,A)));this.scrollbar&&(g?(g=this.top-C,l=this.left-C+(c||!l.opposite?0:
(l.titleOffset||0)+l.axisTitleMargin),C=a+2*C):(g=this.top+(c?this.height:-C),l=this.left-C),this.scrollbar.position(l,g,k,C),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1)));this.rendered=!0}};h.prototype.addMouseEvents=function(){var d=this,f=d.chart,h=f.container,k=[],a,e;d.mouseMoveHandler=a=function(f){d.onMouseMove(f)};d.mouseUpHandler=e=function(f){d.onMouseUp(f)};k=d.getPartsEvents("mousedown");k.push(p(f.renderTo,"mousemove",a),p(h.ownerDocument,"mouseup",e));r&&(k.push(p(f.renderTo,
"touchmove",a),p(h.ownerDocument,"touchend",e)),k.concat(d.getPartsEvents("touchstart")));d.eventsToUnbind=k;d.series&&d.series[0]&&k.push(p(d.series[0].xAxis,"foundExtremes",function(){f.navigator.modifyNavigatorAxisExtremes()}))};h.prototype.getPartsEvents=function(d){var f=this,h=[];["shades","handles"].forEach(function(z){f[z].forEach(function(k,C){h.push(p(k.element,d,function(d){f[z+"Mousedown"](d,C)}))})});return h};h.prototype.shadesMousedown=function(d,f){d=this.chart.pointer.normalize(d);
var h=this.chart,k=this.xAxis,a=this.zoomedMin,u=this.left,b=this.size,l=this.range,c=d.chartX;h.inverted&&(c=d.chartY,u=this.top);if(1===f)this.grabbedCenter=c,this.fixedWidth=l,this.dragOffset=c-a;else{d=c-u-l/2;if(0===f)d=Math.max(0,d);else if(2===f&&d+l>=b)if(d=b-l,this.reversedExtremes){d-=l;var n=this.getUnionExtremes().dataMin}else var q=this.getUnionExtremes().dataMax;d!==a&&(this.fixedWidth=l,f=k.navigatorAxis.toFixedRange(d,d+l,n,q),e(f.min)&&h.xAxis[0].setExtremes(Math.min(f.min,f.max),
Math.max(f.min,f.max),!0,null,{trigger:"navigator"}))}};h.prototype.handlesMousedown=function(d,f){this.chart.pointer.normalize(d);d=this.chart;var h=d.xAxis[0],k=this.reversedExtremes;0===f?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=k?h.min:h.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=k?h.max:h.min);d.fixedRange=null};h.prototype.onMouseMove=function(d){var f=this,h=f.chart,k=f.left,a=f.navigatorSize,e=f.range,u=f.dragOffset,l=h.inverted;
d.touches&&0===d.touches[0].pageX||(d=h.pointer.normalize(d),h=d.chartX,l&&(k=f.top,h=d.chartY),f.grabbedLeft?(f.hasDragged=!0,f.render(0,0,h-k,f.otherHandlePos)):f.grabbedRight?(f.hasDragged=!0,f.render(0,0,f.otherHandlePos,h-k)):f.grabbedCenter&&(f.hasDragged=!0,h<u?h=u:h>a+u-e&&(h=a+u-e),f.render(0,0,h-u,h-u+e)),f.hasDragged&&f.scrollbar&&E(f.scrollbar.options.liveRedraw,x.svg&&!c&&!this.chart.isBoosting)&&(d.DOMType=d.type,setTimeout(function(){f.onMouseUp(d)},0)))};h.prototype.onMouseUp=function(d){var f=
this.chart,h=this.xAxis,k=this.scrollbar,a=d.DOMEvent||d,u=f.inverted,l=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!k||!k.hasDragged)||"scrollbar"===d.trigger){k=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var b=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var c=this.fixedExtreme;this.zoomedMax===this.size&&(c=this.reversedExtremes?k.dataMin:k.dataMax);0===this.zoomedMin&&(b=this.reversedExtremes?k.dataMax:k.dataMin);h=h.navigatorAxis.toFixedRange(this.zoomedMin,
this.zoomedMax,b,c);e(h.min)&&f.xAxis[0].setExtremes(Math.min(h.min,h.max),Math.max(h.min,h.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:a})}"mousemove"!==d.DOMType&&"touchmove"!==d.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&H(this.zoomedMin)&&H(this.zoomedMax)&&(f=Math.round(this.zoomedMin),d=Math.round(this.zoomedMax),
this.shades&&this.drawMasks(f,d,u,l),this.outline&&this.drawOutline(f,d,u,l),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(f,0,u,l),this.drawHandle(d,1,u,l)))};h.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(d){d()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};h.prototype.removeBaseSeriesEvents=function(){var d=this.baseSeries||[];this.navigatorEnabled&&d[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&
d.forEach(function(d){P(d,"updatedData",this.updatedDataHandler)},this),d[0].xAxis&&P(d[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};h.prototype.init=function(d){var f=d.options,h=f.navigator,k=h.enabled,a=f.scrollbar,e=a.enabled;f=k?h.height:0;var l=e?a.height:0;this.handles=[];this.shades=[];this.chart=d;this.setBaseSeries();this.height=f;this.scrollbarHeight=l;this.scrollbarEnabled=e;this.navigatorEnabled=k;this.navigatorOptions=h;this.scrollbarOptions=a;this.outlineHeight=f+l;this.opposite=
E(h.opposite,!(k||!d.inverted));var c=this;k=c.baseSeries;a=d.xAxis.length;e=d.yAxis.length;var n=k&&k[0]&&k[0].xAxis||d.xAxis[0]||{options:{}};d.isDirtyBox=!0;c.navigatorEnabled?(c.xAxis=new b(d,L({breaks:n.options.breaks,ordinal:n.options.ordinal},h.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:a,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},d.inverted?{offsets:[l,0,-l,0],width:f}:{offsets:[0,
-l,0,l],height:f})),c.yAxis=new b(d,L(h.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:e,isInternal:!0,reversed:E(h.yAxis&&h.yAxis.reversed,d.yAxis[0]&&d.yAxis[0].reversed,!1),zoomEnabled:!1},d.inverted?{width:f}:{height:f})),k||h.series.data?c.updateNavigatorSeries(!1):0===d.series.length&&(c.unbindRedraw=p(d,"beforeRedraw",function(){0<d.series.length&&!c.series&&(c.setBaseSeries(),c.unbindRedraw())})),c.reversedExtremes=d.inverted&&!c.xAxis.reversed||!d.inverted&&c.xAxis.reversed,c.renderElements(),
c.addMouseEvents()):(c.xAxis={chart:d,navigatorAxis:{fake:!0},translate:function(f,h){var k=d.xAxis[0],z=k.getExtremes(),a=k.len-2*l,e=u("min",k.options.min,z.dataMin);k=u("max",k.options.max,z.dataMax)-e;return h?f*k/a+e:a*(f-e)/k},toPixels:function(d){return this.translate(d)},toValue:function(d){return this.translate(d,!0)}},c.xAxis.navigatorAxis.axis=c.xAxis,c.xAxis.navigatorAxis.toFixedRange=t.AdditionsClass.prototype.toFixedRange.bind(c.xAxis.navigatorAxis));d.options.scrollbar.enabled&&(d.scrollbar=
c.scrollbar=new D(d.renderer,L(d.options.scrollbar,{margin:c.navigatorEnabled?0:10,vertical:d.inverted}),d),p(c.scrollbar,"changed",function(d){var f=c.size,h=f*this.to;f*=this.from;c.hasDragged=c.scrollbar.hasDragged;c.render(0,0,f,h);this.shouldUpdateExtremes(d.DOMType)&&setTimeout(function(){c.onMouseUp(d)})}));c.addBaseSeriesEvents();c.addChartEvents()};h.prototype.getUnionExtremes=function(d){var f=this.chart.xAxis[0],h=this.xAxis,k=h.options,a=f.options,e;d&&null===f.dataMin||(e={dataMin:E(k&&
k.min,u("min",a.min,f.dataMin,h.dataMin,h.min)),dataMax:E(k&&k.max,u("max",a.max,f.dataMax,h.dataMax,h.max))});return e};h.prototype.setBaseSeries=function(d,f){var h=this.chart,k=this.baseSeries=[];d=d||h.options&&h.options.navigator.baseSeries||(h.series.length?M(h.series,function(d){return!d.options.isInternal}).index:0);(h.series||[]).forEach(function(f,h){f.options.isInternal||!f.options.showInNavigator&&(h!==d&&f.options.id!==d||!1===f.options.showInNavigator)||k.push(f)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&
this.updateNavigatorSeries(!0,f)};h.prototype.updateNavigatorSeries=function(d,f){var h=this,k=h.chart,a=h.baseSeries,e,u,c=h.navigatorOptions.series,l,b={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},n=h.series=(h.series||[]).filter(function(d){var f=d.baseSeries;return 0>a.indexOf(f)?(f&&(P(f,"updatedData",h.updatedDataHandler),delete f.navigatorSeries),
d.chart&&d.destroy(),!1):!0});a&&a.length&&a.forEach(function(d){var z=d.navigatorSeries,C=G({color:d.color,visible:d.visible},K(c)?y.navigator.series:c);z&&!1===h.navigatorOptions.adaptToUpdatedData||(b.name="Navigator "+a.length,e=d.options||{},l=e.navigatorOptions||{},C.dataLabels=A(C.dataLabels),u=L(e,b,C,l),u.pointRange=E(C.pointRange,l.pointRange,y.plotOptions[u.type||"line"].pointRange),C=l.data||C.data,h.hasNavigatorData=h.hasNavigatorData||!!C,u.data=C||e.data&&e.data.slice(0),z&&z.options?
z.update(u,f):(d.navigatorSeries=k.initSeries(u),d.navigatorSeries.baseSeries=d,n.push(d.navigatorSeries)))});if(c.data&&(!a||!a.length)||K(c))h.hasNavigatorData=!1,c=A(c),c.forEach(function(d,f){b.name="Navigator "+(n.length+1);u=L(y.navigator.series,{color:k.series[f]&&!k.series[f].options.isInternal&&k.series[f].color||k.options.colors[f]||k.options.colors[0]},b,d);u.data=d.data;u.data&&(h.hasNavigatorData=!0,n.push(k.initSeries(u)))});d&&this.addBaseSeriesEvents()};h.prototype.addBaseSeriesEvents=
function(){var d=this,f=d.baseSeries||[];f[0]&&f[0].xAxis&&f[0].eventsToUnbind.push(p(f[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));f.forEach(function(f){f.eventsToUnbind.push(p(f,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));f.eventsToUnbind.push(p(f,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)}));!1!==this.navigatorOptions.adaptToUpdatedData&&f.xAxis&&f.eventsToUnbind.push(p(f,"updatedData",this.updatedDataHandler));
f.eventsToUnbind.push(p(f,"remove",function(){this.navigatorSeries&&(l(d.series,this.navigatorSeries),e(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)};h.prototype.getBaseSeriesMin=function(d){return this.baseSeries.reduce(function(d,h){return Math.min(d,h.xData?h.xData[0]:d)},d)};h.prototype.modifyNavigatorAxisExtremes=function(){var d=this.xAxis,f;"undefined"!==typeof d.getExtremes&&(!(f=this.getUnionExtremes(!0))||f.dataMin===d.min&&f.dataMax===
d.max||(d.min=f.dataMin,d.max=f.dataMax))};h.prototype.modifyBaseAxisExtremes=function(){var d=this.chart.navigator,f=this.getExtremes(),h=f.dataMin,k=f.dataMax;f=f.max-f.min;var a=d.stickToMin,e=d.stickToMax,u=E(this.options.overscroll,0),c=d.series&&d.series[0],l=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(a){var b=h;var n=b+f}e&&(n=k+u,a||(b=Math.max(h,n-f,d.getBaseSeriesMin(c&&c.xData?c.xData[0]:-Number.MAX_VALUE))));l&&(a||e)&&H(b)&&(this.min=this.userMin=
b,this.max=this.userMax=n)}d.stickToMin=d.stickToMax=null};h.prototype.updatedDataHandler=function(){var d=this.chart.navigator,f=this.navigatorSeries,h=d.getBaseSeriesMin(this.xData[0]);d.stickToMax=d.reversedExtremes?0===Math.round(d.zoomedMin):Math.round(d.zoomedMax)>=Math.round(d.size);d.stickToMin=H(this.xAxis.min)&&this.xAxis.min<=h&&(!this.chart.fixedRange||!d.stickToMax);f&&!d.hasNavigatorData&&(f.options.pointStart=this.xData[0],f.setData(this.options.data,!1,null,!1))};h.prototype.addChartEvents=
function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(p(this.chart,"redraw",function(){var d=this.navigator,f=d&&(d.baseSeries&&d.baseSeries[0]&&d.baseSeries[0].xAxis||this.xAxis[0]);f&&d.render(f.min,f.max)}),p(this.chart,"getMargins",function(){var d=this.navigator,f=d.opposite?"plotTop":"marginBottom";this.inverted&&(f=d.opposite?"marginRight":"plotLeft");this[f]=(this[f]||0)+(d.navigatorEnabled||!this.inverted?d.outlineHeight:0)+d.navigatorOptions.margin}))};h.prototype.destroy=
function(){this.removeEvents();this.xAxis&&(l(this.chart.xAxis,this.xAxis),l(this.chart.axes,this.xAxis));this.yAxis&&(l(this.chart.yAxis,this.yAxis),l(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(d){d.destroy&&d.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(d){this[d]&&this[d].destroy&&this[d].destroy();this[d]=null},this);[this.handles].forEach(function(d){q(d)},this)};
return h}();x.Navigator||(x.Navigator=k,t.compose(b),p(w,"beforeShowResetZoom",function(){var h=this.options,d=h.navigator,f=h.rangeSelector;if((d&&d.enabled||f&&f.enabled)&&(!c&&"x"===h.chart.zoomType||c&&"x"===h.chart.pinchType))return!1}),p(w,"beforeRender",function(){var h=this.options;if(h.navigator.enabled||h.scrollbar.enabled)this.scroller=this.navigator=new k(this)}),p(w,"afterSetChartSize",function(){var h=this.legend,d=this.navigator;if(d){var f=h&&h.options;var k=d.xAxis;var a=d.yAxis;
var e=d.scrollbarHeight;this.inverted?(d.left=d.opposite?this.chartWidth-e-d.height:this.spacing[3]+e,d.top=this.plotTop+e):(d.left=this.plotLeft+e,d.top=d.navigatorOptions.top||this.chartHeight-d.height-e-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(f&&"bottom"===f.verticalAlign&&"proximate"!==f.layout&&f.enabled&&!f.floating?h.legendHeight+E(f.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));k&&a&&(this.inverted?k.options.left=a.options.left=
d.left:k.options.top=a.options.top=d.top,k.setAxisSize(),a.setAxisSize())}}),p(w,"update",function(h){var d=h.options.navigator||{},f=h.options.scrollbar||{};this.navigator||this.scroller||!d.enabled&&!f.enabled||(L(!0,this.options.navigator,d),L(!0,this.options.scrollbar,f),delete h.options.navigator,delete h.options.scrollbar)}),p(w,"afterUpdate",function(h){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new k(this),
E(h.redraw,!0)&&this.redraw(h.animation))}),p(w,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),p(g,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),w.prototype.callbacks.push(function(h){var d=h.navigator;d&&h.xAxis[0]&&(h=h.xAxis[0].getExtremes(),d.render(h.min,h.max))}));x.Navigator=k;return x.Navigator});I(b,"Core/Axis/OrdinalAxis.js",[b["Core/Axis/Axis.js"],b["Core/Globals.js"],b["Core/Series/Series.js"],
b["Core/Utilities.js"],b["Core/Chart/Chart.js"]],function(b,w,m,x,t){var F=x.addEvent,B=x.css,D=x.defined,g=x.error,a=x.pick,v=x.timeUnits,r;(function(c){var b=function(){function c(a){this.index={};this.axis=a}c.prototype.beforeSetTickPositions=function(){var c=this.axis,b=c.ordinal,e=[],q,l=!1,g=c.getExtremes(),p=g.min,y=g.max,r,v=c.isXAxis&&!!c.options.breaks;g=c.options.ordinal;var E=Number.MAX_VALUE,B=c.chart.options.chart.ignoreHiddenSeries,A;if(g||v){c.series.forEach(function(h,d){q=[];if(!(B&&
!1===h.visible||!1===h.takeOrdinalPosition&&!v)&&(e=e.concat(h.processedXData),u=e.length,e.sort(function(d,h){return d-h}),E=Math.min(E,a(h.closestPointRange,E)),u)){for(d=0;d<u-1;)e[d]!==e[d+1]&&q.push(e[d+1]),d++;q[0]!==e[0]&&q.unshift(e[0]);e=q}h.isSeriesBoosting&&(A=!0)});A&&(e.length=0);var u=e.length;if(2<u){var k=e[1]-e[0];for(r=u-1;r--&&!l;)e[r+1]-e[r]!==k&&(l=!0);!c.options.keepOrdinalPadding&&(e[0]-p>k||y-e[e.length-1]>k)&&(l=!0)}else c.options.overscroll&&(2===u?E=e[1]-e[0]:1===u?(E=c.options.overscroll,
e=[e[0],e[0]+E]):E=b.overscrollPointsRange);l||c.forceOrdinal?(c.options.overscroll&&(b.overscrollPointsRange=E,e=e.concat(b.getOverscrollPositions())),b.positions=e,k=c.ordinal2lin(Math.max(p,e[0]),!0),r=Math.max(c.ordinal2lin(Math.min(y,e[e.length-1]),!0),1),b.slope=y=(y-p)/(r-k),b.offset=p-k*y):(b.overscrollPointsRange=a(c.closestPointRange,b.overscrollPointsRange),b.positions=c.ordinal.slope=b.offset=void 0)}c.isOrdinal=g&&l;b.groupIntervalFactor=null};c.prototype.getExtendedPositions=function(){var a=
this,c=a.axis,e=c.constructor.prototype,b=c.chart,l=c.series[0].currentDataGrouping,g=a.index,p=l?l.count+l.unitName:"raw",y=c.options.overscroll,r=c.getExtremes(),v;g||(g=a.index={});if(!g[p]){var E={series:[],chart:b,forceOrdinal:!1,getExtremes:function(){return{min:r.dataMin,max:r.dataMax+y}},getGroupPixelWidth:e.getGroupPixelWidth,getTimeTicks:e.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:e.ordinal2lin,val2lin:e.val2lin};E.ordinal.axis=
E;c.series.forEach(function(c){v={xAxis:E,xData:c.xData.slice(),chart:b,destroyGroupedData:w.noop,getProcessedData:m.prototype.getProcessedData};v.xData=v.xData.concat(a.getOverscrollPositions());v.options={dataGrouping:l?{enabled:!0,forced:!0,approximation:"open",units:[[l.unitName,[l.count]]]}:{enabled:!1}};E.series.push(v);c.processData.apply(v);v.closestPointRange!==v.basePointRange&&v.currentDataGrouping&&(E.forceOrdinal=!0)});c.ordinal.beforeSetTickPositions.apply({axis:E});g[p]=E.ordinal.positions}return g[p]};
c.prototype.getGroupIntervalFactor=function(a,c,e){e=e.processedXData;var b=e.length,l=[];var g=this.groupIntervalFactor;if(!g){for(g=0;g<b-1;g++)l[g]=e[g+1]-e[g];l.sort(function(a,c){return a-c});l=l[Math.floor(b/2)];a=Math.max(a,e[0]);c=Math.min(c,e[b-1]);this.groupIntervalFactor=g=b*l/(c-a)}return g};c.prototype.getOverscrollPositions=function(){var a=this.axis,c=a.options.overscroll,e=this.overscrollPointsRange,b=[],l=a.dataMax;if(D(e))for(b.push(l);l<=a.dataMax+c;)l+=e,b.push(l);return b};c.prototype.postProcessTickInterval=
function(a){var c=this.axis,e=this.slope;return e?c.options.breaks?c.closestPointRange||a:a/(e/c.closestPointRange):a};return c}();c.Composition=b;c.compose=function(a,b,y){a.keepProps.push("ordinal");var e=a.prototype;a.prototype.getTimeTicks=function(a,c,e,b,n,p,y){void 0===n&&(n=[]);void 0===p&&(p=0);var l=0,q,A,u={},k=[],h=-Number.MAX_VALUE,d=this.options.tickPixelInterval,f=this.chart.time,z=[];if(!this.options.ordinal&&!this.options.breaks||!n||3>n.length||"undefined"===typeof c)return f.getTimeTicks.apply(f,
arguments);var C=n.length;for(q=0;q<C;q++){var G=q&&n[q-1]>e;n[q]<c&&(l=q);if(q===C-1||n[q+1]-n[q]>5*p||G){if(n[q]>h){for(A=f.getTimeTicks(a,n[l],n[q],b);A.length&&A[0]<=h;)A.shift();A.length&&(h=A[A.length-1]);z.push(k.length);k=k.concat(A)}l=q+1}if(G)break}if(A){A=A.info;if(y&&A.unitRange<=v.hour){q=k.length-1;for(l=1;l<q;l++)if(f.dateFormat("%d",k[l])!==f.dateFormat("%d",k[l-1])){u[k[l]]="day";var r=!0}r&&(u[k[0]]="day");A.higherRanks=u}A.segmentStarts=z;k.info=A}else g(12,!1,this.chart);if(y&&
D(d)){l=A=k.length;r=[];f=void 0;for(z=[];l--;)q=this.translate(k[l]),f&&(z[l]=f-q),r[l]=f=q;z.sort();z=z[Math.floor(z.length/2)];z<.6*d&&(z=null);l=k[A-1]>e?A-1:A;for(f=void 0;l--;)q=r[l],A=Math.abs(f-q),f&&A<.8*d&&(null===z||A<.8*z)?(u[k[l]]&&!u[k[l+1]]?(A=l+1,f=q):A=l,k.splice(A,1)):f=q}return k};e.lin2val=function(a,c){var e=this.ordinal,b=e.positions;if(b){var l=e.slope,g=e.offset;e=b.length-1;var n=void 0;if(c)0>a?a=b[0]:a>e?a=b[e]:(e=Math.floor(a),n=a-e);else for(;e--;)if(c=l*e+g,a>=c){l=l*
(e+1)+g;n=(a-c)/(l-c);break}return"undefined"!==typeof n&&"undefined"!==typeof b[e]?b[e]+(n?n*(b[e+1]-b[e]):0):a}return a};e.val2lin=function(a,c){var e=this.ordinal,b=e.positions;if(b){var l=b.length,g,n=void 0;for(g=l;g--;)if(b[g]===a){n=g;break}for(g=l-1;g--;)if(a>b[g]||0===g){a=(a-b[g])/(b[g+1]-b[g]);n=g+a;break}c=c?n:e.slope*(n||0)+e.offset}else c=a;return c};e.ordinal2lin=e.val2lin;F(a,"afterInit",function(){this.ordinal||(this.ordinal=new c.Composition(this))});F(a,"foundExtremes",function(){this.isXAxis&&
D(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&D(this.userMin)&&(this.min+=this.options.overscroll))});F(a,"afterSetScale",function(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)});F(a,"initialAxisTranslation",function(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),
this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))});F(b,"pan",function(a){var c=this.xAxis[0],e=c.options.overscroll,b=a.originalEvent.chartX,g=this.options.chart.panning,n=!1;if(g&&"y"!==g.type&&c.options.ordinal&&c.series.length){var q=this.mouseDownX,p=c.getExtremes(),y=p.dataMax,A=p.min,u=p.max,k=void 0;k=this.hoverPoints;var h=c.closestPointRange||c.ordinal&&c.ordinal.overscrollPointsRange;q=(q-b)/(c.translationSlope*(c.ordinal.slope||h));h={ordinal:{positions:c.ordinal.getExtendedPositions()}};
var d=void 0,f=void 0,z=c.lin2val,C=c.val2lin,r=void 0;h.ordinal.positions?1<Math.abs(q)&&(k&&k.forEach(function(d){d.setState()}),0>q?(f=h,r=c.ordinal.positions?c:h):(f=c.ordinal.positions?c:h,r=h),d=r.ordinal.positions,y>d[d.length-1]&&d.push(y),this.fixedRange=u-A,k=c.navigatorAxis.toFixedRange(null,null,z.apply(f,[C.apply(f,[A,!0])+q,!0]),z.apply(r,[C.apply(r,[u,!0])+q,!0])),k.min>=Math.min(p.dataMin,A)&&k.max<=Math.max(y,u)+e&&c.setExtremes(k.min,k.max,!0,!1,{trigger:"pan"}),this.mouseDownX=
b,B(this.container,{cursor:"move"})):n=!0}else n=!0;n||g&&/y/.test(g.type)?e&&(c.max=c.dataMax+e):a.preventDefault()});F(y,"updatedData",function(){var a=this.xAxis;a&&a.options.ordinal&&delete a.ordinal.index})}})(r||(r={}));r.compose(b,t,m);return r});I(b,"Core/Axis/BrokenAxis.js",[b["Core/Axis/Axis.js"],b["Core/Series/Series.js"],b["Extensions/Stacking.js"],b["Core/Utilities.js"]],function(b,w,m,x){var t=x.addEvent,F=x.find,B=x.fireEvent,D=x.isArray,g=x.isNumber,a=x.pick,v=function(){function r(a){this.hasBreaks=
!1;this.axis=a}r.isInBreak=function(a,b){var c=a.repeat||Infinity,g=a.from,r=a.to-a.from;b=b>=g?(b-g)%c:c-(g-b)%c;return a.inclusive?b<=r:b<r&&0!==b};r.lin2Val=function(a){var c=this.brokenAxis;c=c&&c.breakArray;if(!c||!g(a))return a;var b;for(b=0;b<c.length;b++){var n=c[b];if(n.from>=a)break;else n.to<a?a+=n.len:r.isInBreak(n,a)&&(a+=n.len)}return a};r.val2Lin=function(a){var c=this.brokenAxis;c=c&&c.breakArray;if(!c||!g(a))return a;var b=a,n;for(n=0;n<c.length;n++){var v=c[n];if(v.to<=a)b-=v.len;
else if(v.from>=a)break;else if(r.isInBreak(v,a)){b-=a-v.from;break}}return b};r.prototype.findBreakAt=function(a,b){return F(b,function(c){return c.from<a&&a<c.to})};r.prototype.isInAnyBreak=function(c,b){var p=this.axis,n=p.options.breaks||[],y=n.length,e;if(y&&g(c)){for(;y--;)if(r.isInBreak(n[y],c)){var q=!0;e||(e=a(n[y].showPoints,!p.isXAxis))}var l=q&&b?q&&!e:q}return l};r.prototype.setBreaks=function(c,y){var p=this,n=p.axis,v=D(c)&&!!c.length;n.isDirty=p.hasBreaks!==v;p.hasBreaks=v;n.options.breaks=
n.userOptions.breaks=c;n.forceRedraw=!0;n.series.forEach(function(a){a.isDirty=!0});v||n.val2lin!==r.val2Lin||(delete n.val2lin,delete n.lin2val);v&&(n.userOptions.ordinal=!1,n.lin2val=r.lin2Val,n.val2lin=r.val2Lin,n.setExtremes=function(a,c,l,g,n){if(p.hasBreaks){for(var e,q=this.options.breaks;e=p.findBreakAt(a,q);)a=e.to;for(;e=p.findBreakAt(c,q);)c=e.from;c<a&&(c=a)}b.prototype.setExtremes.call(this,a,c,l,g,n)},n.setAxisTranslation=function(){b.prototype.setAxisTranslation.call(this);p.unitLength=
void 0;if(p.hasBreaks){var c=n.options.breaks||[],q=[],l=[],y=0,v,D=n.userMin||n.min,m=n.userMax||n.max,x=a(n.pointRangePadding,0),E;c.forEach(function(a){v=a.repeat||Infinity;g(D)&&g(m)&&(r.isInBreak(a,D)&&(D+=a.to%v-D%v),r.isInBreak(a,m)&&(m-=m%v-a.from%v))});c.forEach(function(a){A=a.from;v=a.repeat||Infinity;if(g(D)&&g(m)){for(;A-v>D;)A-=v;for(;A<D;)A+=v;for(E=A;E<m;E+=v)q.push({value:E,move:"in"}),q.push({value:E+a.to-a.from,move:"out",size:a.breakSize})}});q.sort(function(a,k){return a.value===
k.value?("in"===a.move?0:1)-("in"===k.move?0:1):a.value-k.value});var t=0;var A=D;q.forEach(function(a){t+="in"===a.move?1:-1;1===t&&"in"===a.move&&(A=a.value);0===t&&g(A)&&(l.push({from:A,to:a.value,len:a.value-A-(a.size||0)}),y+=a.value-A-(a.size||0))});p.breakArray=l;g(D)&&g(m)&&g(n.min)&&(p.unitLength=m-D-y+x,B(n,"afterBreaks"),n.staticScale?n.transA=n.staticScale:p.unitLength&&(n.transA*=(m-n.min+x)/p.unitLength),x&&(n.minPixelPadding=n.transA*(n.minPointOffset||0)),n.min=D,n.max=m)}});a(y,!0)&&
n.chart.redraw()};return r}();x=function(){function b(){}b.compose=function(c,b){c.keepProps.push("brokenAxis");var p=w.prototype;p.drawBreaks=function(c,b){var e=this,n=e.points,l,p,r,v;if(c&&c.brokenAxis&&c.brokenAxis.hasBreaks){var y=c.brokenAxis;b.forEach(function(b){l=y&&y.breakArray||[];p=c.isXAxis?c.min:a(e.options.threshold,c.min);n.forEach(function(e){v=a(e["stack"+b.toUpperCase()],e[b]);l.forEach(function(a){if(g(p)&&g(v)){r=!1;if(p<a.from&&v>a.to||p>a.from&&v<a.from)r="pointBreak";else if(p<
a.from&&v>a.from&&v<a.to||p>a.from&&v>a.to&&v<a.from)r="pointInBreak";r&&B(c,r,{point:e,brk:a})}})})})}};p.gappedPath=function(){var a=this.currentDataGrouping,c=a&&a.gapSize;a=this.options.gapSize;var b=this.points.slice(),g=b.length-1,l=this.yAxis,p;if(a&&0<g)for("value"!==this.options.gapUnit&&(a*=this.basePointRange),c&&c>a&&c>=this.basePointRange&&(a=c),p=void 0;g--;)p&&!1!==p.visible||(p=b[g+1]),c=b[g],!1!==p.visible&&!1!==c.visible&&(p.x-c.x>a&&(p=(c.x+p.x)/2,b.splice(g+1,0,{isNull:!0,x:p}),
l.stacking&&this.options.stacking&&(p=l.stacking.stacks[this.stackKey][p]=new m(l,l.options.stackLabels,!1,p,this.stack),p.total=0)),p=c);return this.getGraphPath(b)};t(c,"init",function(){this.brokenAxis||(this.brokenAxis=new v(this))});t(c,"afterInit",function(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)});t(c,"afterSetTickPositions",function(){var a=this.brokenAxis;if(a&&a.hasBreaks){var c=this.tickPositions,b=this.tickPositions.info,g=[],l;for(l=0;l<
c.length;l++)a.isInAnyBreak(c[l])||g.push(c[l]);this.tickPositions=g;this.tickPositions.info=b}});t(c,"afterSetOptions",function(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)});t(b,"afterGeneratePoints",function(){var a=this.options.connectNulls,c=this.points,b=this.xAxis,g=this.yAxis;if(this.isDirty)for(var l=c.length;l--;){var p=c[l],v=!(null===p.y&&!1===a)&&(b&&b.brokenAxis&&b.brokenAxis.isInAnyBreak(p.x,!0)||g&&g.brokenAxis&&g.brokenAxis.isInAnyBreak(p.y,!0));p.visible=
v?!1:!1!==p.options.visible}});t(b,"afterRender",function(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,a(this.pointArrayMap,["y"]))})};return b}();x.compose(b,w);return x});I(b,"masters/modules/broken-axis.src.js",[],function(){});I(b,"Extensions/DataGrouping.js",[b["Core/Axis/Axis.js"],b["Core/Axis/DateTimeAxis.js"],b["Core/FormatUtilities.js"],b["Core/Globals.js"],b["Core/Series/Point.js"],b["Core/Series/Series.js"],b["Core/Tooltip.js"],b["Core/Options.js"],b["Core/Utilities.js"]],
function(b,w,m,x,t,F,B,D,g){var a=m.format,v=F.prototype;m=g.addEvent;var r=g.arrayMax,c=g.arrayMin,y=g.correctFloat,p=g.defined,n=g.error,N=g.extend,e=g.isNumber,q=g.merge,l=g.pick;"";var G=x.approximations={sum:function(a){var c=a.length;if(!c&&a.hasNulls)var k=null;else if(c)for(k=0;c--;)k+=a[c];return k},average:function(a){var c=a.length;a=G.sum(a);e(a)&&c&&(a=y(a/c));return a},averages:function(){var a=[];[].forEach.call(arguments,function(c){a.push(G.average(c))});return"undefined"===typeof a[0]?
void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},high:function(a){return a.length?r(a):a.hasNulls?null:void 0},low:function(a){return a.length?c(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},ohlc:function(a,c,k,h){a=G.open(a);c=G.high(c);k=G.low(k);h=G.close(h);if(e(a)||e(c)||e(k)||e(h))return[a,c,k,h]},range:function(a,c){a=G.low(a);c=G.high(c);if(e(a)||e(c))return[a,c];if(null===a&&null===c)return null}};g=function(a,c,
k,h){var d=this,f=d.data,b=d.options&&d.options.data,l=[],g=[],u=[],n=a.length,v=!!c,r=[],y=d.pointArrayMap,A=y&&y.length,D=["x"].concat(y||["y"]),B=this.options.dataGrouping&&this.options.dataGrouping.groupAll,m=0,x=0,t;h="function"===typeof h?h:G[h]?G[h]:G[d.getDGApproximation&&d.getDGApproximation()||"average"];A?y.forEach(function(){r.push([])}):r.push([]);var E=A||1;for(t=0;t<=n&&!(a[t]>=k[0]);t++);for(t;t<=n;t++){for(;"undefined"!==typeof k[m+1]&&a[t]>=k[m+1]||t===n;){var w=k[m];d.dataGroupInfo=
{start:B?x:d.cropStart+x,length:r[0].length};var F=h.apply(d,r);d.pointClass&&!p(d.dataGroupInfo.options)&&(d.dataGroupInfo.options=q(d.pointClass.prototype.optionsToObject.call({series:d},d.options.data[d.cropStart+x])),D.forEach(function(a){delete d.dataGroupInfo.options[a]}));"undefined"!==typeof F&&(l.push(w),g.push(F),u.push(d.dataGroupInfo));x=t;for(w=0;w<E;w++)r[w].length=0,r[w].hasNulls=!1;m+=1;if(t===n)break}if(t===n)break;if(y){w=d.options.dataGrouping&&d.options.dataGrouping.groupAll?t:
d.cropStart+t;F=f&&f[w]||d.pointClass.prototype.applyOptions.apply({series:d},[b[w]]);var H=void 0;for(w=0;w<A;w++)H=F[y[w]],e(H)?r[w].push(H):null===H&&(r[w].hasNulls=!0)}else w=v?c[t]:null,e(w)?r[0].push(w):null===w&&(r[0].hasNulls=!0)}return{groupedXData:l,groupedYData:g,groupMap:u}};var M={approximations:G,groupData:g},K=v.processData,H=v.generatePoints,L={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S",
"%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},E={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},I=x.defaultDataGroupingUnits=
[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];v.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};v.groupData=g;v.processData=function(){var a=this.chart,c=this.options.dataGrouping,k=!1!==this.allowDG&&c&&l(c.enabled,a.options.isStock),h=this.visible||!a.options.chart.ignoreHiddenSeries,
d,f=this.currentDataGrouping,b=!1;this.forceCrop=k;this.groupPixelWidth=null;this.hasProcessed=!0;k&&!this.requireSorting&&(this.requireSorting=b=!0);k=!1===K.apply(this,arguments)||!k;b&&(this.requireSorting=!1);if(!k){this.destroyGroupedData();var g=c.groupAll?this.xData:this.processedXData,r=c.groupAll?this.yData:this.processedYData;k=a.plotSizeX;b=this.xAxis;var q=b.options.ordinal,y=this.groupPixelWidth=b.getGroupPixelWidth&&b.getGroupPixelWidth();if(y&&g&&g.length){this.isDirty=d=!0;this.points=
null;var J=b.getExtremes();var m=J.min;J=J.max;q=q&&b.ordinal&&b.ordinal.getGroupIntervalFactor(m,J,this)||1;k=b.getTimeTicks(w.AdditionsClass.prototype.normalizeTimeTickInterval(y*(J-m)/k*q,c.units||I),Math.min(m,g[0]),Math.max(J,g[g.length-1]),b.options.startOfWeek,g,this.closestPointRange);y=v.groupData.apply(this,[g,r,k,c.approximation]);g=y.groupedXData;r=y.groupedYData;q=0;c&&c.smoothed&&g.length&&(c.firstAnchor="firstPoint",c.anchor="middle",c.lastAnchor="lastPoint",n(32,!1,a,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));
a=g;var D=this.options.dataGrouping;m=this.currentDataGrouping&&this.currentDataGrouping.gapSize;if(D&&this.xData&&m&&this.groupMap){var B=a.length-1;var t=D.anchor;var x=l(D.firstAnchor,t);D=l(D.lastAnchor,t);if(t&&"start"!==t){var G=m*{middle:.5,end:1}[t];for(t=a.length-1;t--&&0<t;)a[t]+=G}if(x&&"start"!==x&&this.xData[0]>=a[0]){t=this.groupMap[0].start;G=this.groupMap[0].length;var E=void 0;e(t)&&e(G)&&(E=t+(G-1));a[0]={middle:a[0]+.5*m,end:a[0]+m,firstPoint:this.xData[0],lastPoint:E&&this.xData[E]}[x]}D&&
"start"!==D&&m&&a[B]>=J-m&&(J=this.groupMap[this.groupMap.length-1].start,a[B]={middle:a[B]+.5*m,end:a[B]+m,firstPoint:J&&this.xData[J],lastPoint:this.xData[this.xData.length-1]}[D])}for(J=1;J<k.length;J++)k.info.segmentStarts&&-1!==k.info.segmentStarts.indexOf(J)||(q=Math.max(k[J]-k[J-1],q));J=k.info;J.gapSize=q;this.closestPointRange=k.info.totalRange;this.groupMap=y.groupMap;if(h){h=g;if(p(h[0])&&e(b.min)&&e(b.dataMin)&&h[0]<b.min){if(!p(b.options.min)&&b.min<=b.dataMin||b.min===b.dataMin)b.min=
Math.min(h[0],b.min);b.dataMin=Math.min(h[0],b.dataMin)}if(p(h[h.length-1])&&e(b.max)&&e(b.dataMax)&&h[h.length-1]>b.max){if(!p(b.options.max)&&e(b.dataMax)&&b.max>=b.dataMax||b.max===b.dataMax)b.max=Math.max(h[h.length-1],b.max);b.dataMax=Math.max(h[h.length-1],b.dataMax)}}c.groupAll&&(c=this.cropData(g,r,b.min,b.max,1),g=c.xData,r=c.yData,this.cropStart=c.start);this.processedXData=g;this.processedYData=r}else this.groupMap=null;this.hasGroupedData=d;this.currentDataGrouping=J;this.preventGraphAnimation=
(f&&f.totalRange)!==(J&&J.totalRange)}};v.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(a,c){a&&(this.groupedData[c]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)};v.generatePoints=function(){H.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};m(t,"update",function(){if(this.dataGroup)return n(24,!1,this.series.chart),!1});m(B,"headerFormatter",function(c){var b=this.chart,k=b.time,h=c.labelConfig,d=h.series,
f=d.tooltipOptions,z=d.options.dataGrouping,g=f.xDateFormat,l=d.xAxis,p=f[(c.isFooter?"footer":"header")+"Format"];if(l&&"datetime"===l.options.type&&z&&e(h.key)){var n=d.currentDataGrouping;z=z.dateTimeLabelFormats||L.dateTimeLabelFormats;if(n)if(f=z[n.unitName],1===n.count)g=f[0];else{g=f[1];var r=f[2]}else!g&&z&&(g=this.getXDateFormat(h,f,l));g=k.dateFormat(g,h.key);r&&(g+=k.dateFormat(r,h.key+n.totalRange-1));d.chart.styledMode&&(p=this.styledModeFormat(p));c.text=a(p,{point:N(h.point,{key:g}),
series:d},b);c.preventDefault()}});m(F,"destroy",v.destroyGroupedData);m(F,"afterSetOptions",function(a){a=a.options;var c=this.type,k=this.chart.options.plotOptions,h=D.defaultOptions.plotOptions[c].dataGrouping,d=this.useCommonDataGrouping&&L;if(E[c]||d){h||(h=q(L,E[c]));var f=this.chart.rangeSelector;a.dataGrouping=q(d,h,k.series&&k.series.dataGrouping,k[c].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&f&&e(f.selected)&&f.buttonOptions[f.selected].dataGrouping)}});m(b,"afterSetScale",
function(){this.series.forEach(function(a){a.hasProcessed=!1})});b.prototype.getGroupPixelWidth=function(){var a=this.series,c=a.length,k,h=0,d=!1,f;for(k=c;k--;)(f=a[k].options.dataGrouping)&&(h=Math.max(h,l(f.groupPixelWidth,L.groupPixelWidth)));for(k=c;k--;)(f=a[k].options.dataGrouping)&&a[k].hasProcessed&&(c=(a[k].processedXData||a[k].data).length,a[k].groupPixelWidth||c>this.chart.plotSizeX/h||c&&f.forced)&&(d=!0);return d?h:0};b.prototype.setDataGrouping=function(a,c){var k;c=l(c,!0);a||(a=
{forced:!1,units:null});if(this instanceof b)for(k=this.series.length;k--;)this.series[k].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(h){h.dataGrouping=a},!1);this.ordinal&&(this.ordinal.slope=void 0);c&&this.chart.redraw()};x.dataGrouping=M;"";return M});I(b,"Series/OHLC/OHLCPoint.js",[b["Core/Series/SeriesRegistry.js"]],function(b){var w=this&&this.__extends||function(){var b=function(m,t){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,t){b.__proto__=
t}||function(b,t){for(var m in t)t.hasOwnProperty(m)&&(b[m]=t[m])};return b(m,t)};return function(m,t){function w(){this.constructor=m}b(m,t);m.prototype=null===t?Object.create(t):(w.prototype=t.prototype,new w)}}();return function(b){function m(){var m=null!==b&&b.apply(this,arguments)||this;m.close=void 0;m.high=void 0;m.low=void 0;m.open=void 0;m.options=void 0;m.plotClose=void 0;m.plotOpen=void 0;m.series=void 0;return m}w(m,b);m.prototype.getClassName=function(){return b.prototype.getClassName.call(this)+
(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};m.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};m.prototype.resolveColor=function(){b.prototype.resolveColor.call(this);this.resolveUpColor()};m.prototype.getZone=function(){var m=b.prototype.getZone.call(this);this.resolveUpColor();return m};return m}(b.seriesTypes.column.prototype.pointClass)});I(b,"Series/OHLC/OHLCSeries.js",
[b["Series/OHLC/OHLCPoint.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,w,m){var x=this&&this.__extends||function(){var b=function(g,a){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return b(g,a)};return function(g,a){function v(){this.constructor=g}b(g,a);g.prototype=null===a?Object.create(a):(v.prototype=a.prototype,new v)}}(),t=w.seriesTypes.column,F=m.extend,B=m.merge;
m=function(b){function g(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.yData=void 0;return a}x(g,b);g.prototype.drawPoints=function(){var a=this,b=a.chart,g=function(a,b,g){var c=a[0];a=a[1];"number"===typeof c[2]&&(c[2]=Math.max(g+b,c[2]));"number"===typeof a[2]&&(a[2]=Math.min(g-b,a[2]))};a.points.forEach(function(c){var r=c.graphic,p=!r;if("undefined"!==typeof c.plotY){r||(c.graphic=r=b.renderer.path().add(a.group));b.styledMode||r.attr(a.pointAttribs(c,
c.selected&&"select"));var n=r.strokeWidth();var v=n%2/2;var e=Math.round(c.plotX)-v;var q=Math.round(c.shapeArgs.width/2);var l=[["M",e,Math.round(c.yBottom)],["L",e,Math.round(c.plotHigh)]];if(null!==c.open){var m=Math.round(c.plotOpen)+v;l.push(["M",e,m],["L",e-q,m]);g(l,n/2,m)}null!==c.close&&(m=Math.round(c.plotClose)+v,l.push(["M",e,m],["L",e+q,m]),g(l,n/2,m));r[p?"attr":"animate"]({d:l}).addClass(c.getClassName(),!0)}})};g.prototype.init=function(){b.prototype.init.apply(this,arguments);this.options.stacking=
void 0};g.prototype.pointAttribs=function(a,g){g=b.prototype.pointAttribs.call(this,a,g);var r=this.options;delete g.fill;!a.options.color&&r.upColor&&a.open<a.close&&(g.stroke=r.upColor);return g};g.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]};g.prototype.translate=function(){var a=this,g=a.yAxis,r=!!a.modifyValue,c=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];b.prototype.translate.apply(a);a.points.forEach(function(b){[b.open,b.high,b.low,b.close,b.low].forEach(function(p,
n){null!==p&&(r&&(p=a.modifyValue(p)),b[c[n]]=g.toPixels(p,!0))});b.tooltipPos[1]=b.plotHigh+g.pos-a.chart.plotTop})};g.defaultOptions=B(t.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0});return g}(t);F(m.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high",
"low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});m.prototype.pointClass=b;w.registerSeriesType("ohlc",m);"";return m});I(b,"Series/Candlestick/CandlestickSeries.js",[b["Core/Options.js"],b["Core/Color/Palette.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,w,m,x){var t=this&&this.__extends||function(){var a=function(b,g){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&
(a[c]=b[c])};return a(b,g)};return function(b,g){function c(){this.constructor=b}a(b,g);b.prototype=null===g?Object.create(g):(c.prototype=g.prototype,new c)}}(),F=b.defaultOptions;b=m.seriesTypes;var B=b.column,D=b.ohlc,g=x.merge;x=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}t(b,a);b.prototype.pointAttribs=function(a,b){var c=B.prototype.pointAttribs.call(this,a,b),g=this.options,n=a.open<a.close,r=g.lineColor||this.color,
e=a.color||this.color;c["stroke-width"]=g.lineWidth;c.fill=a.options.color||(n?g.upColor||e:e);c.stroke=a.options.lineColor||(n?g.upLineColor||r:r);b&&(a=g.states[b],c.fill=a.color||c.fill,c.stroke=a.lineColor||c.stroke,c["stroke-width"]=a.lineWidth||c["stroke-width"]);return c};b.prototype.drawPoints=function(){var a=this,b=a.chart,g=a.yAxis.reversed;a.points.forEach(function(c){var n=c.graphic,p=!n;if("undefined"!==typeof c.plotY){n||(c.graphic=n=b.renderer.path().add(a.group));a.chart.styledMode||
n.attr(a.pointAttribs(c,c.selected&&"select")).shadow(a.options.shadow);var e=n.strokeWidth()%2/2;var q=Math.round(c.plotX)-e;var l=c.plotOpen;var m=c.plotClose;var r=Math.min(l,m);l=Math.max(l,m);var v=Math.round(c.shapeArgs.width/2);m=g?l!==c.yBottom:Math.round(r)!==Math.round(c.plotHigh);var t=g?Math.round(r)!==Math.round(c.plotHigh):l!==c.yBottom;r=Math.round(r)+e;l=Math.round(l)+e;e=[];e.push(["M",q-v,l],["L",q-v,r],["L",q+v,r],["L",q+v,l],["Z"],["M",q,r],["L",q,m?Math.round(g?c.yBottom:c.plotHigh):
r],["M",q,l],["L",q,t?Math.round(g?c.plotHigh:c.yBottom):l]);n[p?"attr":"animate"]({d:e}).addClass(c.getClassName(),!0)}})};b.defaultOptions=g(D.defaultOptions,F.plotOptions,{states:{hover:{lineWidth:2}},tooltip:F.plotOptions.ohlc.tooltip,threshold:null,lineColor:w.neutralColor100,lineWidth:1,upColor:w.backgroundColor,stickyTracking:!0});return b}(D);m.registerSeriesType("candlestick",x);"";return x});I(b,"Series/Flags/FlagsPoint.js",[b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,
w){var m=this&&this.__extends||function(){var b=function(m,t){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,g){b.__proto__=g}||function(b,g){for(var a in g)g.hasOwnProperty(a)&&(b[a]=g[a])};return b(m,t)};return function(m,t){function w(){this.constructor=m}b(m,t);m.prototype=null===t?Object.create(t):(w.prototype=t.prototype,new w)}}(),x=w.isNumber;return function(b){function t(){var m=null!==b&&b.apply(this,arguments)||this;m.options=void 0;m.series=void 0;return m}m(t,b);
t.prototype.isValid=function(){return x(this.y)||"undefined"===typeof this.y};t.prototype.hasNewShapeType=function(){var b=this.options.shape||this.series.options.shape;return this.graphic&&b&&b!==this.graphic.symbolKey};return t}(b.seriesTypes.column.prototype.pointClass)});I(b,"Mixins/OnSeries.js",[b["Series/Column/ColumnSeries.js"],b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,w,m){var x=b.prototype,t=w.prototype,F=m.defined,B=m.stableSort;return{getPlotBox:function(){return t.getPlotBox.call(this.options.onSeries&&
this.chart.get(this.options.onSeries)||this)},translate:function(){x.translate.apply(this);var b=this,g=b.options,a=b.chart,m=b.points,r=m.length-1,c,t=g.onSeries;t=t&&a.get(t);g=g.onKey||"y";var p=t&&t.options.step,n=t&&t.points,w=n&&n.length,e=a.inverted,q=b.xAxis,l=b.yAxis,G=0,M;if(t&&t.visible&&w){G=(t.pointXOffset||0)+(t.barW||0)/2;a=t.currentDataGrouping;var K=n[w-1].x+(a?a.totalRange:0);B(m,function(a,b){return a.x-b.x});for(g="plot"+g[0].toUpperCase()+g.substr(1);w--&&m[r];){var H=n[w];a=
m[r];a.y=H.y;if(H.x<=a.x&&"undefined"!==typeof H[g]){if(a.x<=K&&(a.plotY=H[g],H.x<a.x&&!p&&(M=n[w+1])&&"undefined"!==typeof M[g])){var N=(a.x-H.x)/(M.x-H.x);a.plotY+=N*(M[g]-H[g]);a.y+=N*(M.y-H.y)}r--;w++;if(0>r)break}}}m.forEach(function(a,g){a.plotX+=G;if("undefined"===typeof a.plotY||e)0<=a.plotX&&a.plotX<=q.len?e?(a.plotY=q.translate(a.x,0,1,0,1),a.plotX=F(a.y)?l.translate(a.y,0,0,0,1):0):a.plotY=(q.opposite?0:b.yAxis.len)+q.offset:a.shapeArgs={};if((c=m[g-1])&&c.plotX===a.plotX){"undefined"===
typeof c.stackIndex&&(c.stackIndex=0);var n=c.stackIndex+1}a.stackIndex=n});this.onSeries=t}}});I(b,"Series/Flags/FlagsSymbols.js",[b["Core/Globals.js"],b["Core/Renderer/SVG/SVGRenderer.js"]],function(b,w){function m(b){F[b+"pin"]=function(m,g,a,t,r){var c=r&&r.anchorX;r=r&&r.anchorY;"circle"===b&&t>a&&(m-=Math.round((t-a)/2),a=t);var v=F[b](m,g,a,t);if(c&&r){var p=c;"circle"===b?p=m+a/2:(m=v[0],a=v[1],"M"===m[0]&&"L"===a[0]&&(p=(m[1]+a[1])/2));v.push(["M",p,g>r?g:g+t],["L",c,r]);v=v.concat(F.circle(c-
1,r-1,2,2))}return v}}var x=b.Renderer,t=b.VMLRenderer,F=w.prototype.symbols;F.flag=function(b,m,g,a,t){var r=t&&t.anchorX||b;t=t&&t.anchorY||m;var c=F.circle(r-1,t-1,2,2);c.push(["M",r,t],["L",b,m+a],["L",b,m],["L",b+g,m],["L",b+g,m+a],["L",b,m+a],["Z"]);return c};m("circle");m("square");x===t&&["circlepin","flag","squarepin"].forEach(function(b){t.prototype.symbols[b]=F[b]});return F});I(b,"Series/Flags/FlagsSeries.js",[b["Series/Flags/FlagsPoint.js"],b["Core/Globals.js"],b["Mixins/OnSeries.js"],
b["Core/Color/Palette.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Core/Utilities.js"]],function(b,w,m,x,t,F,B){var D=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),
g=w.noop,a=t.series,v=t.seriesTypes.column,r=B.addEvent,c=B.defined,y=B.extend,p=B.merge,n=B.objectEach,N=B.wrap;B=function(b){function e(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}D(e,b);e.prototype.animate=function(a){a&&this.setClip()};e.prototype.drawPoints=function(){var a=this.points,b=this.chart,e=b.renderer,g=b.inverted,m=this.options,r=m.y,q,t=this.yAxis,v={},u=[];for(q=a.length;q--;){var k=a[q];var h=(g?k.plotY:k.plotX)>this.xAxis.len;
var d=k.plotX;var f=k.stackIndex;var z=k.options.shape||m.shape;var C=k.plotY;"undefined"!==typeof C&&(C=k.plotY+r-("undefined"!==typeof f&&f*m.stackDistance));k.anchorX=f?void 0:k.plotX;var Q=f?void 0:k.plotY;var y="flag"!==z;f=k.graphic;"undefined"!==typeof C&&0<=d&&!h?(f&&k.hasNewShapeType()&&(f=f.destroy()),f||(f=k.graphic=e.label("",null,null,z,null,null,m.useHTML).addClass("highcharts-point").add(this.markerGroup),k.graphic.div&&(k.graphic.div.point=k),f.isNew=!0),f.attr({align:y?"center":"left",
width:m.width,height:m.height,"text-align":m.textAlign}),b.styledMode||f.attr(this.pointAttribs(k)).css(p(m.style,k.style)).shadow(m.shadow),0<d&&(d-=f.strokeWidth()%2),z={y:C,anchorY:Q},m.allowOverlapX&&(z.x=d,z.anchorX=k.anchorX),f.attr({text:k.options.title||m.title||"A"})[f.isNew?"attr":"animate"](z),m.allowOverlapX||(v[k.plotX]?v[k.plotX].size=Math.max(v[k.plotX].size,f.width):v[k.plotX]={align:y?.5:0,size:f.width,target:d,anchorX:d}),k.tooltipPos=[d,C+t.pos-b.plotTop]):f&&(k.graphic=f.destroy())}m.allowOverlapX||
(n(v,function(a){a.plotX=a.anchorX;u.push(a)}),w.distribute(u,g?t.len:this.xAxis.len,100),a.forEach(function(a){var b=a.graphic&&v[a.plotX];b&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:b.pos+b.align*b.size,anchorX:a.anchorX}),c(b.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));m.useHTML&&N(this.markerGroup,"on",function(a){return F.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};e.prototype.drawTracker=function(){var a=
this.points;b.prototype.drawTracker.call(this);a.forEach(function(b){var c=b.graphic;c&&(b.unbindMouseOver&&b.unbindMouseOver(),b.unbindMouseOver=r(c.element,"mouseover",function(){0<b.stackIndex&&!b.raised&&(b._y=c.y,c.attr({y:b._y-8}),b.raised=!0);a.forEach(function(a){a!==b&&a.raised&&a.graphic&&(a.graphic.attr({y:a._y}),a.raised=!1)})}))})};e.prototype.pointAttribs=function(a,b){var c=this.options,e=a&&a.color||this.color,g=c.lineColor,l=a&&a.lineWidth;a=a&&a.fillColor||c.fillColor;b&&(a=c.states[b].fillColor,
g=c.states[b].lineColor,l=c.states[b].lineWidth);return{fill:a||e,stroke:g||e,"stroke-width":l||c.lineWidth||0}};e.prototype.setClip=function(){a.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};e.defaultOptions=p(v.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:x.backgroundColor,
lineWidth:1,states:{hover:{lineColor:x.neutralColor100,fillColor:x.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}});return e}(v);y(B.prototype,{allowDG:!1,buildKDTree:g,forceCrop:!0,getPlotBox:m.getPlotBox,init:a.prototype.init,invertGroups:g,invertible:!1,noSharedTooltip:!0,pointClass:b,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:m.translate});t.registerSeriesType("flags",B);"";"";return B});I(b,"Extensions/RangeSelector.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],
b["Core/Globals.js"],b["Core/Options.js"],b["Core/Color/Palette.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Core/Utilities.js"]],function(b,w,m,x,t,F,B){function D(a){if(-1!==a.indexOf("%L"))return"text";var b="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),c="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return b&&c?"datetime-local":b?"date":c?"time":"text"}var g=x.defaultOptions,a=B.addEvent,v=B.createElement,r=B.css,c=B.defined,y=B.destroyObjectProperties,
p=B.discardElement,n=B.extend,N=B.find,e=B.fireEvent,q=B.isNumber,l=B.merge,G=B.objectEach,I=B.pad,K=B.pick,H=B.pInt,L=B.splat;n(g,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,
inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:t.highlightColor80,cursor:"pointer"},labelStyle:{color:t.neutralColor60}}});n(g.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"});var E=function(){function u(a){this.buttons=void 0;this.buttonOptions=u.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}u.prototype.clickButton=function(k,h){var d=
this.chart,f=this.buttonOptions[k],g=d.xAxis[0],l=d.scroller&&d.scroller.getUnionExtremes()||g||{},m=l.dataMin,u=l.dataMax,n=g&&Math.round(Math.min(g.max,K(u,g.max))),p=f.type;l=f._range;var r,t=f.dataGrouping;if(null!==m&&null!==u){d.fixedRange=l;this.setSelected(k);t&&(this.forcedDataGrouping=!0,b.prototype.setDataGrouping.call(g||{chart:this.chart},t,!1),this.frozenStates=f.preserveDataGrouping);if("month"===p||"year"===p)if(g){p={range:f,max:n,chart:d,dataMin:m,dataMax:u};var v=g.minFromRange.call(p);
q(p.newMax)&&(n=p.newMax)}else l=f;else if(l)v=Math.max(n-l,m),n=Math.min(v+l,u);else if("ytd"===p)if(g)"undefined"===typeof u&&(m=Number.MAX_VALUE,u=Number.MIN_VALUE,d.series.forEach(function(a){a=a.xData;m=Math.min(a[0],m);u=Math.max(a[a.length-1],u)}),h=!1),n=this.getYTDExtremes(u,m,d.time.useUTC),v=r=n.min,n=n.max;else{this.deferredYTDClick=k;return}else"all"===p&&g&&(v=m,n=u);c(v)&&(v+=f._offsetMin);c(n)&&(n+=f._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=k+1);if(g)g.setExtremes(v,
n,K(h,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:f});else{var w=L(d.options.xAxis)[0];var y=w.range;w.range=l;var x=w.min;w.min=r;a(d,"load",function(){w.range=y;w.min=x})}e(this,"afterBtnClick")}};u.prototype.setSelected=function(a){this.selected=this.options.selected=a};u.prototype.init=function(b){var c=this,d=b.options.rangeSelector,f=d.buttons||c.defaultButtons.slice(),k=d.selected,g=function(){var a=c.minInput,b=c.maxInput;a&&a.blur&&e(a,"blur");b&&b.blur&&e(b,"blur")};c.chart=
b;c.options=d;c.buttons=[];c.buttonOptions=f;this.eventsToUnbind=[];this.eventsToUnbind.push(a(b.container,"mousedown",g));this.eventsToUnbind.push(a(b,"resize",g));f.forEach(c.computeButtonRange);"undefined"!==typeof k&&f[k]&&this.clickButton(k,!1);this.eventsToUnbind.push(a(b,"load",function(){b.xAxis&&b.xAxis[0]&&a(b.xAxis[0],"setExtremes",function(a){this.max-this.min!==b.fixedRange&&"rangeSelectorButton"!==a.trigger&&"updatedData"!==a.trigger&&c.forcedDataGrouping&&!c.frozenStates&&this.setDataGrouping(!1,
!1)})}))};u.prototype.updateButtonStates=function(){var a=this,b=this.chart,d=this.dropdown,f=b.xAxis[0],c=Math.round(f.max-f.min),g=!f.hasVisibleSeries,e=b.scroller&&b.scroller.getUnionExtremes()||f,l=e.dataMin,m=e.dataMax;b=a.getYTDExtremes(m,l,b.time.useUTC);var u=b.min,n=b.max,p=a.selected,r=q(p),t=a.options.allButtonsEnabled,v=a.buttons;a.buttonOptions.forEach(function(b,h){var k=b._range,e=b.type,z=b.count||1,C=v[h],q=0,w=b._offsetMax-b._offsetMin;b=h===p;var J=k>m-l,Q=k<f.minRange,y=!1,x=!1;
k=k===c;("month"===e||"year"===e)&&c+36E5>=864E5*{month:28,year:365}[e]*z-w&&c-36E5<=864E5*{month:31,year:366}[e]*z+w?k=!0:"ytd"===e?(k=n-u+w===c,y=!b):"all"===e&&(k=f.max-f.min>=m-l,x=!b&&r&&k);e=!t&&(J||Q||x||g);z=b&&k||k&&!r&&!y||b&&a.frozenStates;e?q=3:z&&(r=!0,q=2);C.state!==q&&(C.setState(q),d&&(d.options[h+1].disabled=e,2===q&&(d.selectedIndex=h+1)),0===q&&p===h&&a.setSelected())})};u.prototype.computeButtonRange=function(a){var b=a.type,d=a.count||1,c={millisecond:1,second:1E3,minute:6E4,
hour:36E5,day:864E5,week:6048E5};if(c[b])a._range=c[b]*d;else if("month"===b||"year"===b)a._range=864E5*{month:30,year:365}[b]*d;a._offsetMin=K(a.offsetMin,0);a._offsetMax=K(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};u.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var b=this.chart.options.rangeSelector,d=this.chart.time;return a?("text"===a.type&&b.inputDateParser||this.defaultInputDateParser)(a.value,d.useUTC,d):0};u.prototype.setInputValue=function(a,b){var d=
this.options,f=this.chart.time,h="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(h){var k=h.getAttribute("data-hc-time");k=c(k)?Number(k):void 0;c(b)&&(c(k)&&h.setAttribute("data-hc-time-previous",k),h.setAttribute("data-hc-time",b),k=b);h.value=f.dateFormat(this.inputTypeFormats[h.type]||d.inputEditDateFormat,k);a&&a.attr({text:f.dateFormat(d.inputDateFormat,k)})}};u.prototype.setInputExtremes=function(a,b,d){if(a="min"===a?this.minInput:this.maxInput){var c=
this.inputTypeFormats[a.type],h=this.chart.time;c&&(b=h.dateFormat(c,b),a.min!==b&&(a.min=b),d=h.dateFormat(c,d),a.max!==d&&(a.max=d))}};u.prototype.showInput=function(a){var b="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&b&&this.inputGroup){var d="text"===a.type,c=this.inputGroup,k=c.translateX;c=c.translateY;var e=this.options.inputBoxWidth;r(a,{width:d?b.width+(e?-2:20)+"px":"auto",height:d?b.height-2+"px":"auto",border:"2px solid silver"});d&&e?r(a,{left:k+
b.x+"px",top:c+"px"}):r(a,{left:Math.min(Math.round(b.x+k-(a.offsetWidth-b.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:c-1-(a.offsetHeight-b.height)/2+"px"})}};u.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&r(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};u.prototype.defaultInputDateParser=function(a,b,d){var c=a.split("/").join("-").split(" ").join("T");-1===c.indexOf("T")&&(c+="T00:00");if(b)c+="Z";else{var h;if(h=m.isSafari)h=c,h=!(6<h.length&&(h.lastIndexOf("-")===
h.length-6||h.lastIndexOf("+")===h.length-6));h&&(h=(new Date(c)).getTimezoneOffset()/60,c+=0>=h?"+"+I(-h)+":00":"-"+I(h)+":00")}c=Date.parse(c);q(c)||(a=a.split("-"),c=Date.UTC(H(a[0]),H(a[1])-1,H(a[2])));d&&b&&q(c)&&(c+=d.getTimezoneOffset(c));return c};u.prototype.drawInput=function(a){function b(){var b=e.getInputValue(a),d=c.xAxis[0],f=c.scroller&&c.scroller.xAxis?c.scroller.xAxis:d,h=f.dataMin;f=f.dataMax;var k=e.maxInput,g=e.minInput;b!==Number(x.getAttribute("data-hc-time-previous"))&&q(b)&&
(x.setAttribute("data-hc-time-previous",b),J&&k&&q(h)?b>Number(k.getAttribute("data-hc-time"))?b=void 0:b<h&&(b=h):g&&q(f)&&(b<Number(g.getAttribute("data-hc-time"))?b=void 0:b>f&&(b=f)),"undefined"!==typeof b&&d.setExtremes(J?b:d.min,J?d.max:b,void 0,void 0,{trigger:"rangeSelectorInput"}))}var c=this.chart,f=this.div,k=this.inputGroup,e=this,u=c.renderer.style||{},p=c.renderer,w=c.options.rangeSelector,J="min"===a,y=g.lang[J?"rangeSelectorFrom":"rangeSelectorTo"];y=p.label(y,0).addClass("highcharts-range-label").attr({padding:y?
2:0}).add(k);p=p.label("",0).addClass("highcharts-range-input").attr({padding:2,width:w.inputBoxWidth,height:w.inputBoxHeight,"text-align":"center"}).on("click",function(){e.showInput(a);e[a+"Input"].focus()});c.styledMode||p.attr({stroke:w.inputBoxBorderColor,"stroke-width":1});p.add(k);var x=v("input",{name:a,className:"highcharts-range-selector"},void 0,f);x.setAttribute("type",D(w.inputDateFormat||"%b %e, %Y"));c.styledMode||(y.css(l(u,w.labelStyle)),p.css(l({color:t.neutralColor80},u,w.inputStyle)),
r(x,n({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:u.fontSize,fontFamily:u.fontFamily,top:"-9999em"},w.inputStyle)));x.onfocus=function(){e.showInput(a)};x.onblur=function(){x===m.doc.activeElement&&b();e.hideInput(a);e.setInputValue(a);x.blur()};var A=!1;x.onchange=function(){A||(b(),e.hideInput(a),x.blur())};x.onkeypress=function(a){13===a.keyCode&&b()};x.onkeydown=function(a){A=!0;38!==a.keyCode&&40!==a.keyCode||
b()};x.onkeyup=function(){A=!1};return{dateBox:p,input:x,label:y}};u.prototype.getPosition=function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};u.prototype.getYTDExtremes=function(a,b,c){var d=this.chart.time,h=new d.Date(a),k=d.get("FullYear",h);c=c?d.Date.UTC(k,0,1):+new d.Date(k,0,1);b=Math.max(b,c);h=h.getTime();return{max:Math.min(a||h,h),min:b}};u.prototype.render=function(a,
b){var d=this.chart,f=d.renderer,h=d.container,k=d.options,e=k.rangeSelector,g=K(k.chart.style&&k.chart.style.zIndex,0)+1;k=e.inputEnabled;if(!1!==e.enabled){this.rendered||(this.group=f.g("range-selector-group").attr({zIndex:7}).add(),this.div=v("div",void 0,{position:"relative",height:0,zIndex:g}),this.buttonOptions.length&&this.renderButtons(),h.parentNode&&h.parentNode.insertBefore(this.div,h),k&&(this.inputGroup=f.g("input-group").add(this.group),f=this.drawInput("min"),this.minDateBox=f.dateBox,
this.minLabel=f.label,this.minInput=f.input,f=this.drawInput("max"),this.maxDateBox=f.dateBox,this.maxLabel=f.label,this.maxInput=f.input));if(k&&(this.setInputValue("min",a),this.setInputValue("max",b),a=d.scroller&&d.scroller.getUnionExtremes()||d.xAxis[0]||{},c(a.dataMin)&&c(a.dataMax)&&(d=d.xAxis[0].minRange||0,this.setInputExtremes("min",a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-d),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+d,a.dataMax)),this.inputGroup)){var l=
0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:l}),l+=b+e.inputSpacing)}})}this.alignElements();this.rendered=!0}};u.prototype.renderButtons=function(){var b=this,c=this.buttons,d=this.options,f=g.lang,z=this.chart.renderer,u=l(d.buttonTheme),n=u&&u.states,p=u.width||28;delete u.width;delete u.states;this.buttonGroup=z.g("range-selector-buttons").add(this.group);var r=this.dropdown=v("select",void 0,{position:"absolute",
width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);a(r,"touchstart",function(){r.style.fontSize="16px"});[[m.isMS?"mouseover":"mouseenter"],[m.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(d){var f=d[0],h=d[1];a(r,f,function(){var a=c[b.currentButtonIndex()];a&&e(a.element,h||f)})});this.zoomText=z.text(f.rangeSelectorZoom,0,15).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(d.labelStyle),u["stroke-width"]=K(u["stroke-width"],
0));v("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,r);this.buttonOptions.forEach(function(a,d){v("option",{textContent:a.title||a.text},void 0,r);c[d]=z.button(a.text,0,0,function(c){var f=a.events&&a.events.click,h;f&&(h=f.call(a,c));!1!==h&&b.clickButton(d);b.isActive=!0},u,n&&n.hover,n&&n.select,n&&n.disabled).attr({"text-align":"center",width:p}).add(b.buttonGroup);a.title&&c[d].attr("title",a.title)})};u.prototype.alignElements=function(){var a=this,b=this.buttonGroup,c=this.buttons,
f=this.chart,e=this.group,g=this.inputGroup,l=this.options,u=this.zoomText,m=f.options,n=m.exporting&&!1!==m.exporting.enabled&&m.navigation&&m.navigation.buttonOptions;m=l.buttonPosition;var p=l.inputPosition,r=l.verticalAlign,q=function(b,c){return n&&a.titleCollision(f)&&"top"===r&&"right"===c.align&&c.y-b.getBBox().height-12<(n.y||0)+(n.height||0)+f.spacing[0]?-40:0},t=f.plotLeft;if(e&&m&&p){var v=m.x-f.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var w=0;u&&(w+=u.getBBox().width+
5);c.forEach(function(a,b){w+=a.width;b!==c.length-1&&(w+=l.buttonSpacing)});this.initialButtonGroupWidth=w}t-=f.spacing[3];this.updateButtonStates();u=q(b,m);this.alignButtonGroup(u);e.placed=b.placed=f.hasLoaded}b=0;g&&(b=q(g,p),"left"===p.align?v=t:"right"===p.align&&(v=-Math.max(f.axisOffset[1],-b)),g.align({y:p.y,width:g.getBBox().width,align:p.align,x:p.x+v-2},!0,f.spacingBox),g.placed=f.hasLoaded);this.handleCollision(b);e.align({verticalAlign:r},!0,f.spacingBox);g=e.alignAttr.translateY;b=
e.getBBox().height+20;q=0;"bottom"===r&&(q=(q=f.legend&&f.legend.options)&&"bottom"===q.verticalAlign&&q.enabled&&!q.floating?f.legend.legendHeight+K(q.margin,10):0,b=b+q-20,q=g-b-(l.floating?0:l.y)-(f.titleOffset?f.titleOffset[2]:0)-10);if("top"===r)l.floating&&(q=0),f.titleOffset&&f.titleOffset[0]&&(q=f.titleOffset[0]),q+=f.margin[0]-f.spacing[0]||0;else if("middle"===r)if(p.y===m.y)q=g;else if(p.y||m.y)q=0>p.y||0>m.y?q-Math.min(p.y,m.y):g-b;e.translate(l.x,l.y+Math.floor(q));m=this.minInput;p=
this.maxInput;g=this.dropdown;l.inputEnabled&&m&&p&&(m.style.marginTop=e.translateY+"px",p.style.marginTop=e.translateY+"px");g&&(g.style.marginTop=e.translateY+"px")}};u.prototype.alignButtonGroup=function(a,b){var c=this.chart,f=this.buttonGroup,h=this.options.buttonPosition,k=c.plotLeft-c.spacing[3],e=h.x-c.spacing[3];"right"===h.align?e+=a-k:"center"===h.align&&(e-=k/2);f&&f.align({y:h.y,width:K(b,this.initialButtonGroupWidth),align:h.align,x:e},!0,c.spacingBox)};u.prototype.positionButtons=function(){var a=
this.buttons,b=this.chart,c=this.options,f=this.zoomText,e=b.hasLoaded?"animate":"attr",g=c.buttonPosition,l=b.plotLeft,m=l;f&&"hidden"!==f.visibility&&(f[e]({x:K(l+g.x,l)}),m+=g.x+f.getBBox().width+5);this.buttonOptions.forEach(function(b,d){if("hidden"!==a[d].visibility)a[d][e]({x:m}),m+=a[d].width+c.buttonSpacing;else a[d][e]({x:l})})};u.prototype.handleCollision=function(a){var b=this,c=this.chart,f=this.buttonGroup,e=this.inputGroup,k=this.options,g=k.buttonPosition,l=k.dropdown,m=k.inputPosition;
k=function(){var a=0;b.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var u=function(b){if(e&&f){var c=e.alignAttr.translateX+e.alignOptions.x-a+e.getBBox().x+2,d=e.alignOptions.width,h=f.alignAttr.translateX+f.getBBox().x;return h+b>c&&c+d>h&&g.y<m.y+e.getBBox().height}return!1},n=function(){e&&f&&e.attr({translateX:e.alignAttr.translateX+(c.axisOffset[1]>=-a?0:-a),translateY:e.alignAttr.translateY+f.getBBox().height+10})};if(f){if("always"===l){this.collapseButtons(a);
u(k())&&n();return}"never"===l&&this.expandButtons()}e&&f?m.align===g.align||u(this.initialButtonGroupWidth+20)?"responsive"===l?(this.collapseButtons(a),u(k())&&n()):n():"responsive"===l&&this.expandButtons():f&&"responsive"===l&&(this.initialButtonGroupWidth>c.plotWidth?this.collapseButtons(a):this.expandButtons())};u.prototype.collapseButtons=function(a){var b=this.buttons,c=this.buttonOptions,f=this.dropdown,e=this.options,k=this.zoomText,g=function(a){return{text:a?a+" \u25be":"\u25be",width:"auto",
paddingLeft:8,paddingRight:8}};k&&k.hide();var l=!1;c.forEach(function(a,c){c=b[c];2!==c.state?c.hide():(c.show(),c.attr(g(a.text)),l=!0)});l||(f&&(f.selectedIndex=0),b[0].show(),b[0].attr(g(this.zoomText&&this.zoomText.textStr)));c=e.buttonPosition.align;this.positionButtons();"right"!==c&&"center"!==c||this.alignButtonGroup(a,b[this.currentButtonIndex()].getBBox().width);this.showDropdown()};u.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,c=this.options,f=this.zoomText;
this.hideDropdown();f&&f.show();b.forEach(function(b,d){d=a[d];d.show();d.attr({text:b.text,width:c.buttonTheme.width||28,paddingLeft:"unset",paddingRight:"unset"});2>d.state&&d.setState(0)});this.positionButtons()};u.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};u.prototype.showDropdown=function(){var a=this.buttonGroup,b=this.buttons,c=this.chart,f=this.dropdown;if(a&&f){var e=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();
r(f,{left:c.plotLeft+e+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};u.prototype.hideDropdown=function(){var a=this.dropdown;a&&(r(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};u.prototype.getHeight=function(){var a=this.options,b=this.group,c=a.y,f=a.buttonPosition.y,e=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+c:0;b=Math.min(e,f);if(0>e&&0>f||0<e&&0<f)a+=Math.abs(b);return a};
u.prototype.titleCollision=function(a){return!(a.options.title.text||a.options.subtitle.text)};u.prototype.update=function(a){var b=this.chart;l(!0,b.options.rangeSelector,a);this.destroy();this.init(b);this.render()};u.prototype.destroy=function(){var a=this,b=a.minInput,c=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),a.eventsToUnbind=void 0);y(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);c&&(c.onfocus=c.onblur=c.onchange=null);G(a,function(b,c){b&&"chart"!==
c&&(b instanceof F?b.destroy():b instanceof window.HTMLElement&&p(b));b!==u.prototype[c]&&(a[c]=null)},this)};return u}();E.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];E.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",
date:"%Y-%m-%d",time:"%H:%M:%S"};b.prototype.minFromRange=function(){var a=this.range,b=a.type,c=this.max,d=this.chart.time,f=function(a,c){var f="year"===b?"FullYear":"Month",h=new d.Date(a),e=d.get(f,h);d.set(f,h,e+c);e===d.get(f,h)&&d.set("Date",h,0);return h.getTime()-a};if(q(a)){var e=c-a;var g=a}else e=c+f(c,-a.count),this.chart&&(this.chart.fixedRange=c-e);var l=K(this.dataMin,Number.MIN_VALUE);q(e)||(e=l);e<=l&&(e=l,"undefined"===typeof g&&(g=f(e,a.count)),this.newMax=Math.min(e+g,this.dataMax));
q(c)||(e=void 0);return e};if(!m.RangeSelector){var P=[],A=function(b){function c(){d&&(h=b.xAxis[0].getExtremes(),f=b.legend,g=d&&d.options.verticalAlign,q(h.min)&&d.render(h.min,h.max),f.display&&"top"===g&&g===f.options.verticalAlign&&(e=l(b.spacingBox),e.y="vertical"===f.options.layout?b.plotTop:e.y+d.getHeight(),f.group.placed=!1,f.align(e)))}var h,d=b.rangeSelector,f,e,g;d&&(N(P,function(a){return a[0]===b})||P.push([b,[a(b.xAxis[0],"afterSetExtremes",function(a){d&&d.render(a.min,a.max)}),
a(b,"redraw",c)]]),c())};a(w,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new E(this))});a(w,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(q(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&
(this.extraTopMargin=!0)))});a(w,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var h=this.extraBottomMargin,d=this.extraTopMargin;b&&b.enabled&&!c(a)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=a=new E(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(A(this),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==
h||this.extraTopMargin!==d)&&(this.isDirtyBox=!0)});a(w,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))});a(w,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))});w.prototype.callbacks.push(A);a(w,"destroy",function(){for(var a=0;a<P.length;a++){var b=P[a];if(b[0]===
this){b[1].forEach(function(a){return a()});P.splice(a,1);break}}});m.RangeSelector=E}return m.RangeSelector});I(b,"Core/Chart/StockChart.js",[b["Core/Animation/AnimationUtilities.js"],b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/FormatUtilities.js"],b["Core/Options.js"],b["Core/Color/Palette.js"],b["Core/Series/Point.js"],b["Core/Series/Series.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Core/Utilities.js"]],function(b,w,m,x,t,F,B,D,g,a){function v(a,b){return"xAxis"===a?{minPadding:0,
maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:u(b.opposite,!0),showLastLabel:!(!b.categories&&"category"!==b.type),title:{text:null}}:{}}function r(a,b){if("xAxis"===a){a=n();var c={type:"datetime",categories:void 0};u(b.navigator&&b.navigator.enabled,a.navigator.enabled,!0)&&(c.startOnTick=!1,c.endOnTick=!1);return c}return{}}var c=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),y=b.animObject,p=x.format,n=t.getOptions,I=B.prototype.tooltipFormatter;b=D.prototype;var e=b.init,q=b.processData;b=a.addEvent;var l=a.arrayMax,G=a.arrayMin,M=a.clamp,K=a.defined,H=a.extend,L=a.find,E=a.isNumber,N=a.isString,A=
a.merge,u=a.pick,k=a.splat;a=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}c(b,a);b.prototype.init=function(b,c){var d=n(),f=b.xAxis,e=b.yAxis,h=u(b.navigator&&b.navigator.enabled,d.navigator.enabled,!0);b.xAxis=b.yAxis=void 0;h=A({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:h},scrollbar:{enabled:u(d.scrollbar.enabled,!0)},rangeSelector:{enabled:u(d.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:u(d.tooltip.split,!0),crosshairs:!0},
legend:{enabled:!1}},b,{isStock:!0});b.xAxis=f;b.yAxis=e;h.xAxis=k(b.xAxis||{}).map(function(a,c){return A(v("xAxis",a),d.xAxis,d.xAxis&&d.xAxis[c],a,r("xAxis",b))});h.yAxis=k(b.yAxis||{}).map(function(a,b){return A(v("yAxis",a),d.yAxis,d.yAxis&&d.yAxis[b],a)});a.prototype.init.call(this,h,c)};b.prototype.createAxis=function(b,c){c.axis=A(v(b,c.axis),c.axis,r(b,this.userOptions));return a.prototype.createAxis.call(this,b,c)};return b}(m);(function(a){a.stockChart=function(b,c,e){return new a(b,c,
e)}})(a||(a={}));b(D,"setOptions",function(a){var b;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=A(a.plotOptions[this.type],b)))});b(w,"autoLabelAlign",function(a){var b=this.chart,c=this.options;b=b._labelPanes=b._labelPanes||{};var e=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(c=c.top+","+c.height,!b[c]&&e.enabled&&(15===
e.x&&(e.x=0),"undefined"===typeof e.align&&(e.align="right"),b[c]=this,a.align="right",a.preventDefault()))});b(w,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});b(w,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=c.options[b];return E(a)?[h[b][a]]:N(a)?[h.get(a)]:e.map(function(a){return a[b]})}var c=this,e=this.isLinked&&!this.series?this.linkedParent.series:
this.series,h=c.chart,g=h.renderer,k=c.left,l=c.top,m,n,p,q,r=[],t=[],v=a.translatedValue,w=a.value,x=a.force;if(h.options.isStock&&!1!==a.acrossPanes&&"xAxis"===c.coll||"yAxis"===c.coll){a.preventDefault();t=b(c.coll);var y=c.isXAxis?h.yAxis:h.xAxis;y.forEach(function(a){if(K(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=K(a.options[b])?h[b][a.options[b]]:h[b][0];c===b&&t.push(a)}});var A=t.length?[]:[c.isXAxis?h.yAxis[0]:h.xAxis[0]];t.forEach(function(a){-1!==
A.indexOf(a)||L(A,function(b){return b.pos===a.pos&&b.len===a.len})||A.push(a)});var B=u(v,c.translate(w,null,null,a.old));E(B)&&(c.horiz?A.forEach(function(a){var b;n=a.pos;q=n+a.len;m=p=Math.round(B+c.transB);"pass"!==x&&(m<k||m>k+c.width)&&(x?m=p=M(m,k,k+c.width):b=!0);b||r.push(["M",m,n],["L",p,q])}):A.forEach(function(a){var b;m=a.pos;p=m+a.len;n=q=Math.round(l+c.height-B);"pass"!==x&&(n<l||n>l+c.height)&&(x?n=q=M(n,l,l+c.height):b=!0);b||r.push(["M",m,n],["L",p,q])}));a.path=0<r.length?g.crispPolyLine(r,
a.lineWidth||1):null}});g.prototype.crispPolyLine=function(a,b){for(var c=0;c<a.length;c+=2){var d=a[c],e=a[c+1];d[1]===e[1]&&(d[1]=e[1]=Math.round(d[1])-b%2/2);d[2]===e[2]&&(d[2]=e[2]=Math.round(d[2])+b%2/2)}return a};b(w,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});b(w,"afterDrawCrosshair",function(a){var b,c;if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&E(this.min)&&E(this.max)){var e=this.chart,h=this.logarithmic,
g=this.crosshair.label,k=this.horiz,l=this.opposite,m=this.left,n=this.top,q=this.crossLabel,r=g.format,t="",v="inside"===this.options.tickPosition,w=!1!==this.crosshair.snap,x=0,y=a.e||this.cross&&this.cross.e;a=a.point;var A=this.min,B=this.max;h&&(A=h.lin2log(A),B=h.lin2log(B));h=k?"center":l?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";q||(q=this.crossLabel=e.renderer.label("",0,void 0,g.shape||"callout").addClass("highcharts-crosshair-label"+(this.series[0]&&
" highcharts-color-"+this.series[0].colorIndex)).attr({align:g.align||h,padding:u(g.padding,8),r:u(g.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||q.attr({fill:g.backgroundColor||a&&a.series&&a.series.color||F.neutralColor60,stroke:g.borderColor||"","stroke-width":g.borderWidth||0}).css(H({color:F.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},g.style||{})));k?(h=w?(a.plotX||0)+m:y.chartX,n+=l?0:this.height):(h=l?this.width+m:0,n=w?(a.plotY||0)+n:y.chartY);
r||g.formatter||(this.dateTime&&(t="%b %d, %Y"),r="{value"+(t?":"+t:"")+"}");t=w?this.isXAxis?a.x:a.y:this.toValue(k?y.chartX:y.chartY);w=a?a.series.isPointInside(a):E(t)&&t>A&&t<B;y="";r?y=p(r,{value:t},e):g.formatter&&E(t)&&(y=g.formatter.call(this,t));q.attr({text:y,x:h,y:n,visibility:w?"visible":"hidden"});g=q.getBBox();if(E(q.y))if(k){if(v&&!l||!v&&l)n=q.y-g.height}else n=q.y-g.height/2;k?(b=m-g.x,c=m+this.width-g.x):(b="left"===this.labelAlign?m:0,c="right"===this.labelAlign?m+this.width:e.chartWidth);
q.translateX<b&&(x=b-q.translateX);q.translateX+g.width>=c&&(x=-(q.translateX+g.width-c));q.attr({x:h+x,y:n,anchorX:k?h:this.opposite?0:e.chartWidth,anchorY:k?this.opposite?e.chartHeight:0:n+g.height/2})}});D.prototype.init=function(){e.apply(this,arguments);this.initCompare(this.options.compare)};D.prototype.setCompare=function(a){this.initCompare(a);this.userOptions.compare=a};D.prototype.initCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(b,c){var d=this.compareValue;return"undefined"!==
typeof b&&"undefined"!==typeof d?(b="value"===a?b-d:b/d*100-(100===this.options.compareBase?0:100),c&&(c.change=b),b):0}:null;this.chart.hasRendered&&(this.isDirty=!0)};D.prototype.processData=function(a){var b,c=-1,e=!0===this.options.compareStart?0:1;q.apply(this,arguments);if(this.xAxis&&this.processedYData){var g=this.processedXData;var h=this.processedYData;var k=h.length;this.pointArrayMap&&(c=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(b=0;b<k-e;b++){var l=
h[b]&&-1<c?h[b][c]:h[b];if(E(l)&&g[b+e]>=this.xAxis.min&&0!==l){this.compareValue=l;break}}}};b(D,"afterGetExtremes",function(a){a=a.dataExtremes;if(this.modifyValue&&a){var b=[this.modifyValue(a.dataMin),this.modifyValue(a.dataMax)];a.dataMin=G(b);a.dataMax=l(b)}});w.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),u(b,!0)&&this.chart.redraw())};B.prototype.tooltipFormatter=function(a){var b=this.series.chart.numberFormatter;a=a.replace("{point.change}",
(0<this.change?"+":"")+b(this.change,u(this.series.tooltipOptions.changeDecimals,2)));return I.apply(this,[a])};b(D,"render",function(){var a=this.chart;if(!(a.is3d&&a.is3d()||a.polar)&&this.xAxis&&!this.xAxis.isRadial&&!1!==this.options.clip){var b=this.yAxis.len;if(this.xAxis.axisLine){var c=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,e=Math.floor(this.xAxis.axisLine.strokeWidth()/2);0<=c&&(b-=Math.max(e-c,0))}if(!a.hasRendered||!this.clipBox&&this.isDirty&&!this.isDirtyData)this.clipBox=
this.clipBox||A(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=b;a.hasRendered&&(c=y(this.options.animation),c=this.getSharedClipKey(c),e=a.sharedClips[c])&&(e.animate({width:this.xAxis.len,height:b}),(a=a.sharedClips[c+"m"])&&a.animate({width:this.xAxis.len}))}});b(m,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(A(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)});"";return a});I(b,"masters/modules/stock.src.js",[b["Core/Globals.js"],
b["Core/Chart/StockChart.js"]],function(b,w){b.StockChart=b.stockChart=w.stockChart})});
//# sourceMappingURL=stock.js.map