/*
 Highcharts Gantt JS v9.1.0 (2021-05-03)

 Pathfinder

 (c) 2016-2021 ystein Moseng

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/pathfinder",["highcharts"],function(q){a(q);a.Highcharts=q;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function q(a,r,m,t){a.hasOwnProperty(r)||(a[r]=t.apply(null,m))}a=a?a._modules:{};q(a,"Extensions/ArrowSymbols.js",[a["Core/Renderer/SVG/SVGRenderer.js"]],function(a){a.prototype.symbols.arrow=function(a,m,t,n){return[["M",
a,m+n/2],["L",a+t,m],["L",a,m+n/2],["L",a+t,m+n]]};a.prototype.symbols["arrow-half"]=function(r,m,t,n){return a.prototype.symbols.arrow(r,m,t/2,n)};a.prototype.symbols["triangle-left"]=function(a,m,t,n){return[["M",a+t,m],["L",a,m+n/2],["L",a+t,m+n],["Z"]]};a.prototype.symbols["arrow-filled"]=a.prototype.symbols["triangle-left"];a.prototype.symbols["triangle-left-half"]=function(r,m,t,n){return a.prototype.symbols["triangle-left"](r,m,t/2,n)};a.prototype.symbols["arrow-filled-half"]=a.prototype.symbols["triangle-left-half"]});
q(a,"Gantt/Connection.js",[a["Core/Globals.js"],a["Core/Options.js"],a["Core/Series/Point.js"],a["Core/Utilities.js"]],function(a,r,m,t){function n(b){var e=b.shapeArgs;return e?{xMin:e.x||0,xMax:(e.x||0)+(e.width||0),yMin:e.y||0,yMax:(e.y||0)+(e.height||0)}:(e=b.graphic&&b.graphic.getBBox())?{xMin:b.plotX-e.width/2,xMax:b.plotX+e.width/2,yMin:b.plotY-e.height/2,yMax:b.plotY+e.height/2}:null}"";var E=t.defined,A=t.error,z=t.extend,y=t.merge,q=t.objectEach,h=a.deg2rad,c=Math.max,l=Math.min;z(r.defaultOptions,
{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});r=function(){function b(e,v,g){this.toPoint=this.pathfinder=this.graphics=this.fromPoint=this.chart=void 0;this.init(e,v,g)}b.prototype.init=function(e,v,g){this.fromPoint=e;this.toPoint=v;this.options=g;this.chart=e.series.chart;this.pathfinder=this.chart.pathfinder};b.prototype.renderPath=function(e,v,g){var b=
this.chart,h=b.styledMode,c=b.pathfinder,d=!b.options.chart.forExport&&!1!==g,f=this.graphics&&this.graphics.path;c.group||(c.group=b.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(b.seriesGroup));c.group.translate(b.plotLeft,b.plotTop);f&&f.renderer||(f=b.renderer.path().add(c.group),h||f.attr({opacity:0}));f.attr(v);e={d:e};h||(e.opacity=1);f[d?"animate":"attr"](e,g);this.graphics=this.graphics||{};this.graphics.path=f};b.prototype.addMarker=function(e,b,g){var c=this.fromPoint.series.chart,
v=c.pathfinder;c=c.renderer;var a="start"===e?this.fromPoint:this.toPoint,d=a.getPathfinderAnchorPoint(b);if(b.enabled&&((g="start"===e?g[1]:g[g.length-2])&&"M"===g[0]||"L"===g[0])){g={x:g[1],y:g[2]};g=a.getRadiansToVector(g,d);d=a.getMarkerVector(g,b.radius,d);g=-g/h;if(b.width&&b.height){var f=b.width;var x=b.height}else f=x=2*b.radius;this.graphics=this.graphics||{};d={x:d.x-f/2,y:d.y-x/2,width:f,height:x,rotation:g,rotationOriginX:d.x,rotationOriginY:d.y};this.graphics[e]?this.graphics[e].animate(d):
(this.graphics[e]=c.symbol(b.symbol).addClass("highcharts-point-connecting-path-"+e+"-marker").attr(d).add(v.group),c.styledMode||this.graphics[e].attr({fill:b.color||this.fromPoint.color,stroke:b.lineColor,"stroke-width":b.lineWidth,opacity:0}).animate({opacity:1},a.series.options.animation))}};b.prototype.getPath=function(b){var e=this.pathfinder,c=this.chart,h=e.algorithms[b.type],a=e.chartObstacles;if("function"!==typeof h)return A('"'+b.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]};
h.requiresObstacles&&!a&&(a=e.chartObstacles=e.getChartObstacles(b),c.options.connectors.algorithmMargin=b.algorithmMargin,e.chartObstacleMetrics=e.getObstacleMetrics(a));return h(this.fromPoint.getPathfinderAnchorPoint(b.startMarker),this.toPoint.getPathfinderAnchorPoint(b.endMarker),y({chartObstacles:a,lineObstacles:e.lineObstacles||[],obstacleMetrics:e.chartObstacleMetrics,hardBounds:{xMin:0,xMax:c.plotWidth,yMin:0,yMax:c.plotHeight},obstacleOptions:{margin:b.algorithmMargin},startDirectionX:e.getAlgorithmStartDirection(b.startMarker)},
b))};b.prototype.render=function(){var b=this.fromPoint,a=b.series,h=a.chart,F=h.pathfinder,p=y(h.options.connectors,a.options.connectors,b.options.connectors,this.options),m={};h.styledMode||(m.stroke=p.lineColor||b.color,m["stroke-width"]=p.lineWidth,p.dashStyle&&(m.dashstyle=p.dashStyle));m["class"]="highcharts-point-connecting-path highcharts-color-"+b.colorIndex;p=y(m,p);E(p.marker.radius)||(p.marker.radius=l(c(Math.ceil((p.algorithmMargin||8)/2)-1,1),5));b=this.getPath(p);h=b.path;b.obstacles&&
(F.lineObstacles=F.lineObstacles||[],F.lineObstacles=F.lineObstacles.concat(b.obstacles));this.renderPath(h,m,a.options.animation);this.addMarker("start",y(p.marker,p.startMarker),h);this.addMarker("end",y(p.marker,p.endMarker),h)};b.prototype.destroy=function(){this.graphics&&(q(this.graphics,function(b){b.destroy()}),delete this.graphics)};return b}();a.Connection=r;z(m.prototype,{getPathfinderAnchorPoint:function(b){var h=n(this);switch(b.align){case "right":var c="xMax";break;case "left":c="xMin"}switch(b.verticalAlign){case "top":var a=
"yMin";break;case "bottom":a="yMax"}return{x:c?h[c]:(h.xMin+h.xMax)/2,y:a?h[a]:(h.yMin+h.yMax)/2}},getRadiansToVector:function(b,h){var c;E(h)||(c=n(this))&&(h={x:(c.xMin+c.xMax)/2,y:(c.yMin+c.yMax)/2});return Math.atan2(h.y-b.y,b.x-h.x)},getMarkerVector:function(b,h,c){var a=2*Math.PI,e=n(this),l=e.xMax-e.xMin,m=e.yMax-e.yMin,d=Math.atan2(m,l),f=!1;l/=2;var x=m/2,J=e.xMin+l;e=e.yMin+x;for(var G=J,H=e,k=1,u=1;b<-Math.PI;)b+=a;for(;b>Math.PI;)b-=a;a=Math.tan(b);b>-d&&b<=d?(u=-1,f=!0):b>d&&b<=Math.PI-
d?u=-1:b>Math.PI-d||b<=-(Math.PI-d)?(k=-1,f=!0):k=-1;f?(G+=k*l,H+=u*l*a):(G+=m/(2*a)*k,H+=u*x);c.x!==J&&(G=c.x);c.y!==e&&(H=c.y);return{x:G+h*Math.cos(b),y:H-h*Math.sin(b)}}});return r});q(a,"Gantt/PathfinderAlgorithms.js",[a["Core/Utilities.js"]],function(a){function r(h,c,a){a=a||0;var b=h.length-1;c-=1e-7;for(var e,l;a<=b;)if(e=b+a>>1,l=c-h[e].xMin,0<l)a=e+1;else if(0>l)b=e-1;else return e;return 0<a?a-1:0}function m(a,c){for(var h=r(a,c.x+1)+1;h--;){var b;if(b=a[h].xMax>=c.x)b=a[h],b=c.x<=b.xMax&&
c.x>=b.xMin&&c.y<=b.yMax&&c.y>=b.yMin;if(b)return h}return-1}function t(a){var c=[];if(a.length){c.push(["M",a[0].start.x,a[0].start.y]);for(var h=0;h<a.length;++h)c.push(["L",a[h].end.x,a[h].end.y])}return c}function n(a,c){a.yMin=z(a.yMin,c.yMin);a.yMax=A(a.yMax,c.yMax);a.xMin=z(a.xMin,c.xMin);a.xMax=A(a.xMax,c.xMax)}var E=a.pick,A=Math.min,z=Math.max,y=Math.abs;a=function(a,c,l){function b(a,b,c,d,h){a={x:a.x,y:a.y};a[b]=c[d||b]+(h||0);return a}function h(a,c,d){var f=y(c[d]-a[d+"Min"])>y(c[d]-
a[d+"Max"]);return b(c,d,a,d+(f?"Max":"Min"),f?1:-1)}var v=[],g=E(l.startDirectionX,y(c.x-a.x)>y(c.y-a.y))?"x":"y",n=l.chartObstacles,p=m(n,a);l=m(n,c);if(-1<l){var r=n[l];l=h(r,c,g);r={start:l,end:c};var d=l}else d=c;-1<p&&(n=n[p],l=h(n,a,g),v.push({start:a,end:l}),l[g]>=a[g]===l[g]>=d[g]&&(g="y"===g?"x":"y",c=a[g]<c[g],v.push({start:l,end:b(l,g,n,g+(c?"Max":"Min"),c?1:-1)}),g="y"===g?"x":"y"));a=v.length?v[v.length-1].end:a;l=b(a,g,d);v.push({start:a,end:l});g=b(l,"y"===g?"x":"y",d);v.push({start:l,
end:g});v.push(r);return{path:t(v),obstacles:v}};a.requiresObstacles=!0;var q=function(a,c,l){function b(a,b,c){var d,f=a.x<b.x?1:-1;if(a.x<b.x){var x=a;var e=b}else x=b,e=a;if(a.y<b.y){var h=a;var w=b}else h=b,w=a;for(d=0>f?A(r(k,e.x),k.length-1):0;k[d]&&(0<f&&k[d].xMin<=e.x||0>f&&k[d].xMax>=x.x);){if(k[d].xMin<=e.x&&k[d].xMax>=x.x&&k[d].yMin<=w.y&&k[d].yMax>=h.y)return c?{y:a.y,x:a.x<b.x?k[d].xMin-1:k[d].xMax+1,obstacle:k[d]}:{x:a.x,y:a.y<b.y?k[d].yMin-1:k[d].yMax+1,obstacle:k[d]};d+=f}return b}
function e(a,d,c,f,e){var x=e.soft,h=e.hard,k=f?"x":"y",w={x:d.x,y:d.y},I={x:d.x,y:d.y};e=a[k+"Max"]>=x[k+"Max"];x=a[k+"Min"]<=x[k+"Min"];var g=a[k+"Max"]>=h[k+"Max"];h=a[k+"Min"]<=h[k+"Min"];var K=y(a[k+"Min"]-d[k]),l=y(a[k+"Max"]-d[k]);c=10>y(K-l)?d[k]<c[k]:l<K;I[k]=a[k+"Min"];w[k]=a[k+"Max"];a=b(d,I,f)[k]!==I[k];d=b(d,w,f)[k]!==w[k];c=a?d?c:!0:d?!1:c;c=x?e?c:!0:e?!1:c;return h?g?c:!0:g?!1:c}function h(a,c,f){if(a.x===c.x&&a.y===c.y)return[];var g=f?"x":"y",I=l.obstacleOptions.margin;var u={soft:{xMin:x,
xMax:J,yMin:G,yMax:H},hard:l.hardBounds};var w=m(k,a);if(-1<w){w=k[w];u=e(w,a,c,f,u);n(w,l.hardBounds);var B=f?{y:a.y,x:w[u?"xMax":"xMin"]+(u?1:-1)}:{x:a.x,y:w[u?"yMax":"yMin"]+(u?1:-1)};var D=m(k,B);-1<D&&(D=k[D],n(D,l.hardBounds),B[g]=u?z(w[g+"Max"]-I+1,(D[g+"Min"]+w[g+"Max"])/2):A(w[g+"Min"]+I-1,(D[g+"Max"]+w[g+"Min"])/2),a.x===B.x&&a.y===B.y?(d&&(B[g]=u?z(w[g+"Max"],D[g+"Max"])+1:A(w[g+"Min"],D[g+"Min"])-1),d=!d):d=!1);a=[{start:a,end:B}]}else g=b(a,{x:f?c.x:a.x,y:f?a.y:c.y},f),a=[{start:a,end:{x:g.x,
y:g.y}}],g[f?"x":"y"]!==c[f?"x":"y"]&&(u=e(g.obstacle,g,c,!f,u),n(g.obstacle,l.hardBounds),u={x:f?g.x:g.obstacle[u?"xMax":"xMin"]+(u?1:-1),y:f?g.obstacle[u?"yMax":"yMin"]+(u?1:-1):g.y},f=!f,a=a.concat(h({x:g.x,y:g.y},u,f)));return a=a.concat(h(a[a.length-1].end,c,!f))}function g(a,b,d){var c=A(a.xMax-b.x,b.x-a.xMin)<A(a.yMax-b.y,b.y-a.yMin);d=e(a,b,d,c,{soft:l.hardBounds,hard:l.hardBounds});return c?{y:b.y,x:a[d?"xMax":"xMin"]+(d?1:-1)}:{x:b.x,y:a[d?"yMax":"yMin"]+(d?1:-1)}}var q=E(l.startDirectionX,
y(c.x-a.x)>y(c.y-a.y)),p=q?"x":"y",C=[],d=!1,f=l.obstacleMetrics,x=A(a.x,c.x)-f.maxWidth-10,J=z(a.x,c.x)+f.maxWidth+10,G=A(a.y,c.y)-f.maxHeight-10,H=z(a.y,c.y)+f.maxHeight+10,k=l.chartObstacles;var u=r(k,x);f=r(k,J);k=k.slice(u,f+1);if(-1<(f=m(k,c))){var B=g(k[f],c,a);C.push({end:c,start:B});c=B}for(;-1<(f=m(k,c));)u=0>c[p]-a[p],B={x:c.x,y:c.y},B[p]=k[f][u?p+"Max":p+"Min"]+(u?1:-1),C.push({end:c,start:B}),c=B;a=h(a,c,q);a=a.concat(C.reverse());return{path:t(a),obstacles:a}};q.requiresObstacles=!0;
return{fastAvoid:q,straight:function(a,c){return{path:[["M",a.x,a.y],["L",c.x,c.y]],obstacles:[{start:a,end:c}]}},simpleConnect:a}});q(a,"Gantt/Pathfinder.js",[a["Gantt/Connection.js"],a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Options.js"],a["Core/Series/Point.js"],a["Core/Utilities.js"],a["Gantt/PathfinderAlgorithms.js"]],function(a,r,m,t,n,q,A){function z(a){var b=a.shapeArgs;return b?{xMin:b.x||0,xMax:(b.x||0)+(b.width||0),yMin:b.y||0,yMax:(b.y||0)+(b.height||0)}:(b=a.graphic&&a.graphic.getBBox())?
{xMin:a.plotX-b.width/2,xMax:a.plotX+b.width/2,yMin:a.plotY-b.height/2,yMax:a.plotY+b.height/2}:null}function y(a){for(var b=a.length,c=0,d,e,g=[],k=function(a,b,c){c=v(c,10);var d=a.yMax+c>b.yMin-c&&a.yMin-c<b.yMax+c,f=a.xMax+c>b.xMin-c&&a.xMin-c<b.xMax+c,g=d?a.xMin>b.xMax?a.xMin-b.xMax:b.xMin-a.xMax:Infinity,e=f?a.yMin>b.yMax?a.yMin-b.yMax:b.yMin-a.yMax:Infinity;return f&&d?c?k(a,b,Math.floor(c/2)):Infinity:p(g,e)};c<b;++c)for(d=c+1;d<b;++d)e=k(a[c],a[d]),80>e&&g.push(e);g.push(80);return F(Math.floor(g.sort(function(a,
b){return a-b})[Math.floor(g.length/10)]/2-1),1)}function E(a){if(a.options.pathfinder||a.series.reduce(function(a,b){b.options&&e(!0,b.options.connectors=b.options.connectors||{},b.options.pathfinder);return a||b.options&&b.options.pathfinder},!1))e(!0,a.options.connectors=a.options.connectors||{},a.options.pathfinder),l('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')}"";var h=q.addEvent,c=q.defined,l=q.error,b=q.extend,e=q.merge,v=q.pick,
g=q.splat,F=Math.max,p=Math.min;b(t.defaultOptions,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});var C=function(){function b(a){this.lineObstacles=this.group=this.connections=this.chartObstacleMetrics=this.chartObstacles=this.chart=void 0;this.init(a)}b.prototype.init=function(a){this.chart=a;this.connections=[];h(a,"redraw",function(){this.pathfinder.update()})};
b.prototype.update=function(b){var c=this.chart,d=this,f=d.connections;d.connections=[];c.series.forEach(function(b){b.visible&&!b.options.isInternal&&b.points.forEach(function(b){var f=b.options;f&&f.dependency&&(f.connect=f.dependency);var e;f=b.options&&b.options.connect&&g(b.options.connect);b.visible&&!1!==b.isInside&&f&&f.forEach(function(f){e=c.get("string"===typeof f?f:f.to);e instanceof n&&e.series.visible&&e.visible&&!1!==e.isInside&&d.connections.push(new a(b,e,"string"===typeof f?{}:f))})})});
for(var e=0,k=void 0,h=void 0,l=f.length,m=d.connections.length;e<l;++e){h=!1;for(k=0;k<m;++k)if(f[e].fromPoint===d.connections[k].fromPoint&&f[e].toPoint===d.connections[k].toPoint){d.connections[k].graphics=f[e].graphics;h=!0;break}h||f[e].destroy()}delete this.chartObstacles;delete this.lineObstacles;d.renderConnections(b)};b.prototype.renderConnections=function(a){a?this.chart.series.forEach(function(a){var b=function(){var b=a.chart.pathfinder;(b&&b.connections||[]).forEach(function(b){b.fromPoint&&
b.fromPoint.series===a&&b.render()});a.pathfinderRemoveRenderEvent&&(a.pathfinderRemoveRenderEvent(),delete a.pathfinderRemoveRenderEvent)};!1===a.options.animation?b():a.pathfinderRemoveRenderEvent=h(a,"afterAnimate",b)}):this.connections.forEach(function(a){a.render()})};b.prototype.getChartObstacles=function(a){for(var b=[],d=this.chart.series,f=v(a.algorithmMargin,0),e,k=0,g=d.length;k<g;++k)if(d[k].visible&&!d[k].options.isInternal){var h=0,l=d[k].points.length,m=void 0;for(m=void 0;h<l;++h)m=
d[k].points[h],m.visible&&(m=z(m))&&b.push({xMin:m.xMin-f,xMax:m.xMax+f,yMin:m.yMin-f,yMax:m.yMax+f})}b=b.sort(function(a,b){return a.xMin-b.xMin});c(a.algorithmMargin)||(e=a.algorithmMargin=y(b),b.forEach(function(a){a.xMin-=e;a.xMax+=e;a.yMin-=e;a.yMax+=e}));return b};b.prototype.getObstacleMetrics=function(a){for(var b=0,c=0,d,f,e=a.length;e--;)d=a[e].xMax-a[e].xMin,f=a[e].yMax-a[e].yMin,b<d&&(b=d),c<f&&(c=f);return{maxHeight:c,maxWidth:b}};b.prototype.getAlgorithmStartDirection=function(a){var b=
"top"!==a.verticalAlign&&"bottom"!==a.verticalAlign;return"left"!==a.align&&"right"!==a.align?b?void 0:!1:b?!0:void 0};return b}();C.prototype.algorithms=A;m.Pathfinder=C;b(n.prototype,{getPathfinderAnchorPoint:function(a){var b=z(this);switch(a.align){case "right":var c="xMax";break;case "left":c="xMin"}switch(a.verticalAlign){case "top":var d="yMin";break;case "bottom":d="yMax"}return{x:c?b[c]:(b.xMin+b.xMax)/2,y:d?b[d]:(b.yMin+b.yMax)/2}},getRadiansToVector:function(a,b){var d;c(b)||(d=z(this))&&
(b={x:(d.xMin+d.xMax)/2,y:(d.yMin+d.yMax)/2});return Math.atan2(b.y-a.y,a.x-b.x)},getMarkerVector:function(a,b,c){var d=2*Math.PI,e=z(this),f=e.xMax-e.xMin,g=e.yMax-e.yMin,h=Math.atan2(g,f),l=!1;f/=2;var m=g/2,n=e.xMin+f;e=e.yMin+m;for(var p=n,q=e,r=1,t=1;a<-Math.PI;)a+=d;for(;a>Math.PI;)a-=d;d=Math.tan(a);a>-h&&a<=h?(t=-1,l=!0):a>h&&a<=Math.PI-h?t=-1:a>Math.PI-h||a<=-(Math.PI-h)?(r=-1,l=!0):r=-1;l?(p+=r*f,q+=t*f*d):(p+=g/(2*d)*r,q+=t*m);c.x!==n&&(p=c.x);c.y!==e&&(q=c.y);return{x:p+b*Math.cos(a),
y:q-b*Math.sin(a)}}});r.prototype.callbacks.push(function(a){!1!==a.options.connectors.enabled&&(E(a),this.pathfinder=new C(this),this.pathfinder.update(!0))});return C});q(a,"masters/modules/pathfinder.src.js",[],function(){})});
//# sourceMappingURL=pathfinder.js.map