<?php
// @used
flush();
	
include 'common.php';

  if($v3_en == 1)
  {
  	$ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $link_lock_oid);
  	$local_link = preg_replace("/(INTEGER:)/", "", $ret);

  	$ret = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_link_oid);
  	$remote_link = preg_replace("/(INTEGER:)/", "", $ret);

  	/*if(($local_link == 1) && ($remote_link == 1))
  	{
      	  $set = snmp3_set($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_req_oid, "i", 4, 5000000, 0);
      	  usleep(1000000);
      	  $set = snmp3_set($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $remote_req_oid, "i", 12, 5000000, 0);
      	  usleep(1000000);
  	}*/
  }
  else
  {
  	$ret = snmpget($localhost, $read_str, $link_lock_oid);
  	$local_link = preg_replace("/(INTEGER:)/", "", $ret);

  	$ret = snmpget($localhost, $read_str, $remote_link_oid);
  	$remote_link = preg_replace("/(INTEGER:)/", "", $ret);

  	/*if(($local_link == 1) && ($remote_link == 1))
  	{
      	  $set = snmpset($localhost, $write_str, $remote_req_oid, "i", 4, 5000000, 0);
      	  usleep(1000000);
      	  $set = snmpset($localhost, $write_str, $remote_req_oid, "i", 12, 5000000, 0);
      	  usleep(1000000);
  	}*/
  }

  import_page_header();
// Add the Leaflet CSS file
echo '<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css"
       integrity="sha256-kLaT2GOSpHechhsozzB+flnD+zUyjE2LlfWPgU04xyI="
       crossorigin=""/>';

// Add the Leaflet JavaScript file
echo '<script src="https://unpkg.com/leaflet@1.9.3/dist/leaflet.js"
         integrity="sha256-WBkoXOwTeyKclOHuWtc+i2uENFpDZ9YPdf5Hf+D7ewM="
         crossorigin=""></script>';
  display_logo_banner();
  echo '<body class="generalnav" onload="getRemoteLocalStatistics()">';
  echo '<div id="loading">
  <img id="loading-image" src="images/loading.gif" alt="Loading..." /></div>';

  display_test_menu_basic(3);
display_view_config_menu('general_info.config');

  display_content_table_no_border();
  echo '<tr height="10">';
  display_none_shaded_row();
  display_subtitle("LINK > GENERAL");
  enclose_content_table_row();
  echo '<tr height="10">';

  display_none_shaded_row();
  echo '<td width="30%"></td>';
  display_page_subtitle("Local Side");
  display_page_subtitle("Remote Side");
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Unit ID:");
  display_text_position($remark_oid, $left);
  $remoteLat = "";
  $remoteLon = "";
  $remoteBearing = "0";
  echo '<td rowspan="14"><div class="data-cgi">';
    if(($local_link == 1) && ($remote_link == 1)) {
      $remoteLinkText = exec("/var/www/cgi-bin/rflink.cgi 4");

      echo $remoteLinkText;

      // Extract the bearing
      $remoteLinkArray = explode('</br>', $remoteLinkText);
      if (isset($remoteLinkArray[2])) {
        $remoteLat = trim($remoteLinkArray[2]);
      }
      if (isset($remoteLinkArray[3])) {
        $remoteLon = trim($remoteLinkArray[3]);
      }
      if (isset($remoteLinkArray[5])) {
        $remoteBearing = trim($remoteLinkArray[5]);
      }

    }
    else
      echo '<b>No remote link!</b>';
  echo '</div></td>';
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("GPS Enable:");
  display_on_off($gps_enable_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("GPS Latitude:");
  $localLat = display_text_position($gps_lat_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("GPS Longitude:");
  $localLon = display_text_position($gps_long_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("GPS Elevation (meters):");
  display_text_position($gps_elevation_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("GPS Bearing to Remote (deg):");
  $localBearing=display_text_position($gps_bearing_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("GPS Distance to Remote (km):");
  $localDistance = display_text_position($gps_sat_dist_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("GPS Satellites Locked:");
  display_text_position($gps_sat_num_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Front Panel Light:");
  display_on_off($panel_led_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("NTP Enable:");
  display_on_off($ntpenable_oid, $left);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("DNS IP:");
  display_text_left($ntpdnsip_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("NTP Server IP:");
  display_text_left($ntpserverip_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("NTP Server Name:");
  display_text_left($ntpservername_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_parameter_name("Timezone (Offset to GMT):");
  display_text_left($ntptimezone_oid);
  enclose_content_table_row();

  display_none_shaded_row();
  display_page_subtitle("Map:");
  enclose_content_table_row();

  display_none_shaded_row();
echo '<td nowrap="nowrap" colspan="3"> <div id="map" style="height: 600px; width: 600px;"></div></td>';
  enclose_content_table_row();
  enclose_content_table();

display_footer();

$inRate = CustomDataRetrieval::pullSysRFPortRate('in');
$outRate = CustomDataRetrieval::pullSysRFPortRate('out');
$isLocalLocked = (CustomDataRetrieval::pullSysModemLockStatus(1) == 1) && (CustomDataRetrieval::pullSysModemLockStatus(2) == 1);
$localIconUrl = $isLocalLocked ? "images/local_antenna_green.png" : "images/local_antenna_red.png";

// Add a script to initialize the map with the latitude and longitude coordinates
echo '<script>
function convertToDegreeFormat(data) {
  // Extract the direction and value from the input data
  const matches = data.match(/([NSWE])\s*(\d+)\s+(\d+\.\d+)/i);
  if (matches) {
    const dir = matches[1].toUpperCase();
    const deg = parseInt(matches[2]);
    const min = parseFloat(matches[3]);

    let sign = 1;
    if (dir === "S" || dir === "W") {
      sign = -1;
    }

    // Calculate the degree value
    return sign * (deg + min / 60.0);
  } else {
    return 0;
  }
}

const lat1 =  convertToDegreeFormat("' . $localLat . '");
const lng1 =  convertToDegreeFormat("' . $localLon . '");
const lat2 =  convertToDegreeFormat("' . $remoteLat . '");
const lng2 =  convertToDegreeFormat("' . $remoteLon . '");
var distance = '.$localDistance.';
var localBearing = '.$localBearing.';
var remoteBearing = '.$remoteBearing.';
var inRate = '.$inRate.';
var outRate = '.$outRate.';

var map = L.map("map").setView([lat1, lng1], 13);

L.tileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", {
    attribution: "Map data &copy; <a href=\"https://www.openstreetmap.org/\">OpenStreetMap</a> contributors, " +
        "<a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>, Imagery © <a href=\"https://www.mapbox.com/\">Mapbox</a>",
    maxZoom: 18
}).addTo(map);
var localIcon = L.icon({
    iconUrl: "' . $localIconUrl . '",
    iconSize:     [32, 32], // size of the icon
});
var remoteIcon = L.icon({
    iconUrl: "images/remote_antenna.png",
    iconSize:     [32, 32], // size of the icon
});
//// locale

L.marker([lat1, lng1], { title: "Local Link", icon: localIcon}).addTo(map).bindPopup("Local Link <br>Latitude: " + lat1 + "<br>Longitude: " + lng1+ "<br>Bearing: " + localBearing+ "<br>In Port Rate: " + inRate+ "<br>Out Port Rate: " + outRate);
L.marker([lat2, lng2], { title: "Remote Link", icon: remoteIcon}).addTo(map).bindPopup("Remote Link <br>Latitude: " + lat2 + "<br>Longitude: " + lng2+ "<br>Bearing: " + remoteBearing+ "<br>In Port Rate: " + outRate+ "<br>Out Port Rate: " + inRate);
var polygon = L.polygon([
    [lat1, lng1],
    [lat2, lng2]
]).addTo(map).bindPopup("GPS Distance to Remote (km):" + distance);

map.fitBounds(polygon.getBounds());
</script>';

?>

<script language="javascript" type="text/javascript">
     $(window).load(function() {
     $('#loading').hide();
  });
</script>
<script language="javascript" type="text/javascript">
     window.onbeforeunload = function() {
     $('#loading').show();
  };
</script>
