<?php
  // file_compare.php
  // This script allows users to upload a .txt file, compare with existing ones, and apply changes if accepted
  
  // Directory where files are stored
  $uploadDir = __DIR__ . '/files';
  if (!is_dir($uploadDir)) mkdir($uploadDir);
  
  // Handle form submission
  if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $filename = basename($_FILES['file']['name']);
    $tmpFile = $_FILES['file']['tmp_name'];
    $uploadPath = "$uploadDir/$filename";
    $existingPath = "$uploadDir/original.txt";
    
    // Check file extension
    if (pathinfo($filename, PATHINFO_EXTENSION) !== 'txt') {
      echo "<p style='color:red;'>Only .txt files are allowed.</p>";
    } else {
      $uploadedContent = file_get_contents($tmpFile);
      
      if (file_exists($existingPath)) {
        $existingContent = file_get_contents($existingPath);
        echo "<h3>Comparison:</h3><pre>";
        echo htmlspecialchars("--- Existing File ---\n$existingContent\n\n--- Uploaded File ---\n$uploadedContent");
        echo "</pre>";
        
        // Store uploaded file temporarily
        file_put_contents("$uploadDir/temp_$filename", $uploadedContent);
        
        echo "<form method='post'>
                <input type='hidden' name='apply' value='1'>
                <input type='hidden' name='filename' value='$filename'>
                <button type='submit'>Apply Changes</button>
            </form>";
      } else {
        echo "<p style='color:orange;'>Original file not found. Uploading this as the original.</p>";
        move_uploaded_file($tmpFile, $existingPath);
      }
    }
  }
  
  // Handle apply confirmation
  if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['apply'], $_POST['filename'])) {
    $tempPath = "$uploadDir/temp_" . basename($_POST['filename']);
    $targetPath = "$uploadDir/original.txt";
    
    if (file_exists($tempPath)) {
      rename($tempPath, $targetPath);
      echo "<p style='color:green;'>File updated successfully.</p>";
    } else {
      echo "<p style='color:red;'>Temporary file not found.</p>";
    }
  }
?>

<!DOCTYPE html>
<html>
<head><title>Text File Compare and Update</title></head>
<body>
<h2>Upload a Text File</h2>
<form method="post" enctype="multipart/form-data">
  <input type="file" name="file" accept=".txt" required>
  <button type="submit">Upload</button>
</form>
</body>
</html>