<?php

require_once(dirname(__FILE__).'/oid.php');

$LOGIN_INFORMATION = array(
    'trangoeng' => 'Maroon141'
);

define('USE_USERNAME', true);
define('TIMEOUT_MINUTES', 0);
define('TIMEOUT_CHECK_ACTIVITY', true);

if (file_exists("/etc/lighttpd/lighttpd.user")) {
    if ($fp = fopen("/etc/lighttpd/lighttpd.user", "r")) {
        $pwd = fgets($fp);
        $pwd = trim($pwd, "\"");
        $LOGIN_INFORMATION['admin'] = $pwd;
    }
    fclose($fp);
} else {
    $LOGIN_INFORMATION['admin'] = 'trango';
}

$timeout = (TIMEOUT_MINUTES == 0 ? 0 : time() + TIMEOUT_MINUTES * 60);

if (!function_exists('JS_redirect')) {
    function JS_redirect($url)
    {
        return '<script>window.location = "'.$url.'";</script>';
    }
}

if (isset($_GET['logout'])) {
    setcookie("verify", '', -1, '/');
    echo JS_redirect("/index.php");
    exit();
}

if (isset($_POST['access_password']) && strlen(trim($_POST['access_login'])) > 0) {
    $login = isset($_POST['access_login']) ? $_POST['access_login'] : '';
    $pass = $_POST['access_password'];
    if (!USE_USERNAME && !in_array($pass, $LOGIN_INFORMATION) || (USE_USERNAME && (!array_key_exists($login, $LOGIN_INFORMATION) || $LOGIN_INFORMATION[$login] != $pass))
    ) {
        // Deferred auth error below
        // showLoginPasswordProtect("Incorrect login.");
    } else {
        setcookie("verify", md5($login.'%'.$pass), $timeout, '/');
        unset($_POST['access_login']);
        unset($_POST['access_password']);
        unset($_POST['Submit']);
        // The login is ok at this point .. redirect to dashboard.php
        echo JS_redirect('/dashboard.php');
        exit();
    }
}

require_once('common.php');


if ($v3_en == 0) {
    $ip = snmpget($localhost, $read_str, $ip_oid);
} else {
    $ip = snmp3_get($localhost, $user, $sec_level, $auth_protocol, $auth_pass, $priv_protocol, $priv_pass, $ip_oid);
}

$ip = preg_replace("/(IpAddress:)/", "", $ip);
$ip_trimed = trim($ip, "\"");

define('LOGOUT_URL', $ip_trimed);


if (!function_exists('showLoginPasswordProtect')) {

    function showLoginPasswordProtect($error_msg)
    {
        ?>
        <html>
        <head>
            <title>PXG2</title>
            <META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">
            <META HTTP-EQUIV="PRAGMA" CONTENT="NO-CACHE">
            <link href="form.css" rel="stylesheet" type="text/css"/>
        </head>
        <body background="images/blue-abstract.jpg">
        <style>
            input {
                border: 1px solid black;
            }
        </style>
        <div style="width:500px; margin-left:auto; margin-right:auto; text-align:center; font-family:Trebuchet MS, Arial, Helvetica; color:#99ccff">
            <form method="post" action="">
                <br><br><br><br>
                <!-- <hr>Trango Systems Integrated Testing</h3> -->
                <h3><img src="images/logo_white.png"/></h3></br>
                <font color="white"><?php echo '<b>'.$error_msg.'</b>'; ?></font><br/><br/>
                <?php if (USE_USERNAME) {
                    echo '<b>Username: <input type="input" name="access_login" /><br /><br />Password: </b>';
                } ?>
                <input type="password" name="access_password"/>
                <p></p><input type="submit" class="submit_button1" name="Submit" value="Login"/>
            </form>
        </div>
        </body>
        </html>

        <?php
        die();
    }
}

if (isset($_POST['access_password'])) {
    if (!USE_USERNAME && !in_array($pass, $LOGIN_INFORMATION)
        || (USE_USERNAME && (!array_key_exists($login, $LOGIN_INFORMATION) || $LOGIN_INFORMATION[$login] != $pass))
    ) {
        showLoginPasswordProtect("Incorrect login.");
    }
    // Deffered code above
} else {
    if (!isset($_COOKIE['verify'])) {
        showLoginPasswordProtect("");
    }

    $found = false;
    foreach ($LOGIN_INFORMATION as $key => $val) {
        $lp = (USE_USERNAME ? $key : '').'%'.$val;
        if ($_COOKIE['verify'] == md5($lp)) {
            $found = true;
            if (TIMEOUT_CHECK_ACTIVITY) {
                setcookie("verify", md5($lp), $timeout, '/');
            }
            break;
        }
    }
    if (!$found) {
        showLoginPasswordProtect("");
    }
}